/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.file.FileClient;
import com.tydic.dyc.base.bo.BaseExtendFieldBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.model.common.qrybo.UocConfSupplierBo;
import com.tydic.dyc.oc.model.common.qrybo.UocQryMateriaOrderNoBo;
import com.tydic.dyc.oc.model.common.qrybo.UocQryOrderStateChngLogBo;
import com.tydic.dyc.oc.model.common.qrybo.UocQrySaleOrderStageBO;
import com.tydic.dyc.oc.model.common.qrybo.UocQryStateCalculatorBo;
import com.tydic.dyc.oc.model.common.sub.UocCfcParamConfigDo;
import com.tydic.dyc.oc.model.common.sub.UocCfcParamConfigItemDo;
import com.tydic.dyc.oc.model.common.sub.UocConfSupplierDO;
import com.tydic.dyc.oc.model.common.sub.UocFile;
import com.tydic.dyc.oc.model.common.sub.UocOutLogSaveDo;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.model.order.sub.UocOrderBusiOperRecord;
import com.tydic.dyc.oc.model.order.sub.UocOrderProcInst;
import com.tydic.dyc.oc.model.order.sub.UocOrderQueryIndex;
import com.tydic.dyc.oc.model.order.sub.UocOrderStateChgLog;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskDeal;
import com.tydic.dyc.oc.model.order.sub.UocOrderTaskInst;
import com.tydic.dyc.oc.model.order.sub.UocTodo;
import com.tydic.dyc.oc.repository.UocCommonRepository;
import com.tydic.dyc.oc.repository.dao.CfcParamConfigItemMapper;
import com.tydic.dyc.oc.repository.dao.CfcParamConfigMapper;
import com.tydic.dyc.oc.repository.dao.ConfSupplierMapper;
import com.tydic.dyc.oc.repository.dao.SystemBusiLogMapper;
import com.tydic.dyc.oc.repository.dao.UocAlertInfoMapper;
import com.tydic.dyc.oc.repository.dao.UocConfSupplierMapper;
import com.tydic.dyc.oc.repository.dao.UocConfTabOrdStateMapper;
import com.tydic.dyc.oc.repository.dao.UocInspOrderItemMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderAccessoryMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderAgreementMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderBusiOperRecordMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderMsgPoolMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderProcInstMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderQueryIndexMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderStateChgLogMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderTaskDealMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderTaskInstLogMapper;
import com.tydic.dyc.oc.repository.dao.UocOrderTaskInstMapper;
import com.tydic.dyc.oc.repository.dao.UocSaleItemMapMapper;
import com.tydic.dyc.oc.repository.dao.UocSaleOrderItemMapper;
import com.tydic.dyc.oc.repository.dao.UocSaleOrderMapMapper;
import com.tydic.dyc.oc.repository.dao.UocSaleOrderMapper;
import com.tydic.dyc.oc.repository.dao.UocSaleOrderStateToStageConfigMapper;
import com.tydic.dyc.oc.repository.dao.UocStateCalculatorConfMapper;
import com.tydic.dyc.oc.repository.dao.UocTodoMapper;
import com.tydic.dyc.oc.repository.po.CfcParamConfigItemPo;
import com.tydic.dyc.oc.repository.po.CfcParamConfigPo;
import com.tydic.dyc.oc.repository.po.SystemBusiLogPO;
import com.tydic.dyc.oc.repository.po.UocAlertInfoPO;
import com.tydic.dyc.oc.repository.po.UocConfSupplierPo;
import com.tydic.dyc.oc.repository.po.UocInspOrderItemPo;
import com.tydic.dyc.oc.repository.po.UocOrderAccessoryPo;
import com.tydic.dyc.oc.repository.po.UocOrderAgreementPo;
import com.tydic.dyc.oc.repository.po.UocOrderBusiOperRecordPo;
import com.tydic.dyc.oc.repository.po.UocOrderProcInstPo;
import com.tydic.dyc.oc.repository.po.UocOrderQueryIndexPo;
import com.tydic.dyc.oc.repository.po.UocOrderStateChgLogPo;
import com.tydic.dyc.oc.repository.po.UocOrderTaskDealPo;
import com.tydic.dyc.oc.repository.po.UocOrderTaskInstLogPo;
import com.tydic.dyc.oc.repository.po.UocOrderTaskInstPo;
import com.tydic.dyc.oc.repository.po.UocSaleItemMapPo;
import com.tydic.dyc.oc.repository.po.UocSaleOrderItemPo;
import com.tydic.dyc.oc.repository.po.UocSaleOrderMapPo;
import com.tydic.dyc.oc.repository.po.UocSaleOrderPo;
import com.tydic.dyc.oc.repository.po.UocStateCalculatorConfPO;
import com.tydic.dyc.oc.repository.po.UocTodoPo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryInspItemsServiceInspRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryInspItemsServiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryInspItemsServiceRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryInspItemsServiceSaleOrderItemRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQryInspItemsServiceSaleOrderRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocQueryAlertStatisticsReqBO;
import com.tydic.dyc.oc.service.domainservice.bo.UocQueryAlertStatisticsRspBO;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspAgreementInfoBo;
import com.tydic.dyc.oc.utils.UocRu;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import com.tydic.plugin.encoded.service.CfcRedisSerialService;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceReqBO;
import com.tydic.plugin.encoded.service.bo.CfcEncodedSerialGetServiceRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocCommonRepositoryImpl
implements UocCommonRepository {
    private static final Logger log = LoggerFactory.getLogger(UocCommonRepositoryImpl.class);
    @Autowired
    private UocOrderAccessoryMapper uocOrderAccessoryMapper;
    @Autowired
    private UocOrderTaskInstMapper uocOrderTaskInstMapper;
    @Autowired
    private UocOrderProcInstMapper uocOrderProcInstMapper;
    @Autowired
    private UocOrderTaskDealMapper uocOrderTaskDealMapper;
    @Autowired
    private UocOrderStateChgLogMapper uocOrderStateChgLogMapper;
    @Autowired
    private UocOrderBusiOperRecordMapper uocOrderBusiOperRecordMapper;
    @Autowired
    private UocConfTabOrdStateMapper uocConfTabOrdStateMapper;
    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;
    @Autowired
    private UocConfSupplierMapper uocConfSupplierMapper;
    @Autowired
    private ConfSupplierMapper confSupplierMapper;
    @Autowired
    private UocOrderMsgPoolMapper uocOrderMsgPoolMapper;
    @Autowired
    private UocOrderQueryIndexMapper uocOrderQueryIndexMapper;
    @Autowired
    private UocOrderTaskInstLogMapper uocOrderTaskInstLogMapper;
    @Autowired
    private CfcRedisSerialService cfcRedisSerialService;
    @Autowired
    private UocTodoMapper uocTodoMapper;
    @Autowired
    private CfcParamConfigMapper cfcParamConfigMapper;
    @Autowired
    private CfcParamConfigItemMapper cfcParamConfigItemMapper;
    @Autowired
    private UocSaleItemMapMapper uocSaleItemMapMapper;
    @Autowired
    private UocSaleOrderStateToStageConfigMapper uocSaleOrderStateToStageConfigMapper;
    @Autowired
    private UocInspOrderItemMapper uocInspOrderItemMapper;
    @Autowired
    private UocSaleOrderMapMapper uocSaleOrderMapMapper;
    @Autowired
    private UocSaleOrderItemMapper uocSaleOrderItemMapper;
    @Autowired
    private UocSaleOrderMapper uocSaleOrderMapper;
    @Autowired
    private UocOrderAgreementMapper uocOrderAgreementMapper;
    @Autowired
    private UocAlertInfoMapper uocAlertInfoMapper;
    @Value(value="${obs.fileUrl:}")
    private String obsFileUrl;
    @Autowired
    private FileClient fileClient;
    public static final String FILE_TYPE_OSS = "OSS";
    public static final String FILE_TYPE_FASTDFS = "FASTDFS";
    public static final String FILE_TYPE_OBS = "OBS";
    @Autowired
    private UocStateCalculatorConfMapper uocStateCalculatorConfMapper;
    @Autowired
    private SystemBusiLogMapper systemBusiLogMapper;
    @Value(value="${uoc.qryInspItems.qryMaxCount:1000}")
    private int qryInspItemsQryMaxCount;

    public void addBatchOrderAccessory(List<UocOrderAccessory> uocOrderAccessoryList) {
        if (!CollectionUtils.isEmpty(uocOrderAccessoryList)) {
            this.uocOrderAccessoryMapper.insertBatch(UocRu.jsl(uocOrderAccessoryList, UocOrderAccessoryPo.class));
        }
    }

    public void updateToFinished(List<UocOrderTaskInst> uocOrderTaskInstList) {
        for (UocOrderTaskInst uocOrderTaskInst : uocOrderTaskInstList) {
            UocOrderTaskInstPo updateSetPo = new UocOrderTaskInstPo();
            updateSetPo.setFinishTag(UocDicConstant.PROC_TASK_FINISHED.FINISHED);
            updateSetPo.setFinishTime(new Date());
            updateSetPo.setDealOperId(uocOrderTaskInst.getDealOperId());
            updateSetPo.setDealOperName(uocOrderTaskInst.getDealOperName());
            updateSetPo.setDealResult(uocOrderTaskInst.getDealResult());
            updateSetPo.setDealRemark(uocOrderTaskInst.getDealRemark());
            UocOrderTaskInstPo updateWherePo = new UocOrderTaskInstPo();
            updateWherePo.setOrderId(uocOrderTaskInst.getOrderId());
            updateWherePo.setTaskInstId(uocOrderTaskInst.getTaskInstId());
            updateWherePo.setProcInstId(uocOrderTaskInst.getProcInstId());
            this.uocOrderTaskInstMapper.updateBy(updateSetPo, updateWherePo);
        }
    }

    public void saveProcTaskInst(List<UocOrderTaskInst> saveTaskList) {
        if (ObjectUtil.isNotEmpty(saveTaskList)) {
            this.uocOrderTaskInstMapper.insertBatch(UocRu.jsl(saveTaskList, UocOrderTaskInstPo.class));
        }
    }

    public UocOrderProcInst createProInst(UocOrderProcInst inst) {
        this.uocOrderProcInstMapper.insert((UocOrderProcInstPo)UocRu.js((Object)inst, UocOrderProcInstPo.class));
        return inst;
    }

    public List<UocOrderProcInst> qryProcInsList(UocOrderProcInst inst) {
        return UocRu.jsl(this.uocOrderProcInstMapper.getList((UocOrderProcInstPo)UocRu.js((Object)inst, UocOrderProcInstPo.class)), UocOrderProcInst.class);
    }

    public void saveOrderTaskDealList(List<UocOrderTaskDeal> dealList) {
        if (ObjectUtil.isNotEmpty(dealList)) {
            this.uocOrderTaskDealMapper.insertBatch(UocRu.jsl(dealList, UocOrderTaskDealPo.class));
        }
    }

    public UocOrderStateChgLog createOrderStateChangeLog(UocOrderStateChgLog uocOrderStateChgLog) {
        if (ObjectUtil.isNotEmpty((Object)uocOrderStateChgLog)) {
            this.uocOrderStateChgLogMapper.insert((UocOrderStateChgLogPo)UocRu.js((Object)uocOrderStateChgLog, UocOrderStateChgLogPo.class));
        }
        return uocOrderStateChgLog;
    }

    public List<UocOrderTaskInst> qryTaskInstList(UocOrderTaskInst taskInst) {
        if (ObjectUtil.isNotEmpty((Object)taskInst)) {
            return UocRu.jsl(this.uocOrderTaskInstMapper.getList((UocOrderTaskInstPo)UocRu.js((Object)taskInst, UocOrderTaskInstPo.class)), UocOrderTaskInst.class);
        }
        return new ArrayList<UocOrderTaskInst>();
    }

    public UocOrderProcInst updateProInst(UocOrderProcInst inst) {
        UocOrderProcInstPo set = (UocOrderProcInstPo)UocRu.js((Object)inst, UocOrderProcInstPo.class);
        UocOrderProcInstPo where = new UocOrderProcInstPo();
        where.setOrderId(inst.getOrderId());
        where.setObjId(inst.getObjId());
        where.setObjType(inst.getObjType());
        where.setProcInstId(inst.getProcInstId());
        this.uocOrderProcInstMapper.updateBy(set, where);
        return inst;
    }

    public void saveOperRecord(List<UocOrderBusiOperRecord> recordList) {
        List recordPoList = UocRu.jsl(recordList, UocOrderBusiOperRecordPo.class);
        this.uocOrderBusiOperRecordMapper.insertBatch(recordPoList);
    }

    public String getOrderNoSingle(String code) {
        CfcEncodedSerialGetServiceReqBO getBo = new CfcEncodedSerialGetServiceReqBO();
        getBo.setCenter("UOC");
        getBo.setEncodedRuleCode(code);
        getBo.setOrgType("-1");
        CfcEncodedSerialGetServiceRspBO encodedSerial = this.cfcRedisSerialService.getSerial(getBo);
        if (CollectionUtils.isEmpty((Collection)encodedSerial.getSerialNoList()) || StringUtils.isBlank((CharSequence)((CharSequence)encodedSerial.getSerialNoList().get(0)))) {
            throw new BaseBusinessException("101006", "\u83b7\u53d6\u5355\u636e\u7f16\u53f7\u4e3a\u7a7a");
        }
        return (String)encodedSerial.getSerialNoList().get(0);
    }

    public void updateTaskInst(UocOrderTaskInst inst) {
        UocOrderTaskInstPo set = (UocOrderTaskInstPo)UocRu.js((Object)inst, UocOrderTaskInstPo.class);
        UocOrderTaskInstPo where = new UocOrderTaskInstPo();
        where.setTaskInstId(inst.getTaskInstId());
        where.setOrderId(inst.getOrderId());
        where.setObjId(inst.getObjId());
        where.setObjType(inst.getObjType());
        where.setId(inst.getId());
        where.setProcState(inst.getProcState());
        this.uocOrderTaskInstMapper.updateBy(set, where);
    }

    public UocFile uploadFile(UocFile uocFile) {
        String path;
        String fileUrl = path = this.fileClient.uploadFileByInputStream(uocFile.getPath() + "/" + UUID.randomUUID().toString().replace("-", ""), uocFile.getFilename(), uocFile.getInputStream());
        UocFile uocF = new UocFile();
        uocF.setUrl(fileUrl);
        return uocF;
    }

    public int saveOrderQueryIndex(UocOrderQueryIndex index) {
        return this.uocOrderQueryIndexMapper.insert((UocOrderQueryIndexPo)JUtil.js((Object)index, UocOrderQueryIndexPo.class));
    }

    public void deleteTaskInstByStepIdAndFinshTag(UocOrderTaskInst taskInst) {
        UocOrderTaskInstPo where = new UocOrderTaskInstPo();
        where.setOrderId(taskInst.getOrderId());
        where.setProcState(taskInst.getProcState());
        this.uocOrderTaskInstMapper.deleteTaskInstByStepIdAndFinshTag(where);
    }

    public void saveProcTaskInstLog(List<UocOrderTaskInst> saveTaskList) {
        List uocOrderTaskInstLogPos = UocRu.jsl(saveTaskList, UocOrderTaskInstLogPo.class);
        if (!CollectionUtils.isEmpty((Collection)uocOrderTaskInstLogPos)) {
            this.uocOrderTaskInstLogMapper.insertBatch(uocOrderTaskInstLogPos);
        }
    }

    public void deleteProcTaskInstByIds(UocOrderTaskInst taskInst) {
        UocOrderTaskInstPo where = new UocOrderTaskInstPo();
        where.setOrderId(taskInst.getOrderId());
        where.setIds(taskInst.getIds());
        this.uocOrderTaskInstMapper.deleteProcTaskInstByIds(where);
    }

    public void deleteTaskInstByTaskId(UocOrderTaskInst taskInst) {
        UocOrderTaskInstPo where = new UocOrderTaskInstPo();
        where.setTaskInstId(taskInst.getTaskInstId());
        this.uocOrderTaskInstMapper.deleteTaskInstByTaskId(where);
    }

    public UocQueryAlertStatisticsRspBO queryAlertStatistics(UocQueryAlertStatisticsReqBO reqBO) {
        UocQueryAlertStatisticsRspBO rspBO = new UocQueryAlertStatisticsRspBO();
        UocAlertInfoPO alertInfoPO = new UocAlertInfoPO();
        alertInfoPO.setCreateCompanyId(reqBO.getCompanyId());
        List<UocAlertInfoPO> uocAlertInfoPOS = this.uocAlertInfoMapper.qryActAlertInfoCountList(alertInfoPO);
        if (CollectionUtils.isEmpty(uocAlertInfoPOS)) {
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a");
            return rspBO;
        }
        for (UocAlertInfoPO uocAlertInfoPO : uocAlertInfoPOS) {
            int objType = uocAlertInfoPO.getObjType();
            int alertType = uocAlertInfoPO.getAlertType();
            int alertCount = uocAlertInfoPO.getAlertCount();
            block0 : switch (objType) {
                case 2: {
                    switch (alertType) {
                        case 1: {
                            rspBO.setAgrOrderTimeoutUnshippedWarningCount(Integer.valueOf(alertCount));
                            break block0;
                        }
                        case 2: {
                            rspBO.setAgrOrderTimeoutUnreceivedWarningCount(Integer.valueOf(alertCount));
                            break block0;
                        }
                        case 3: {
                            rspBO.setAgrOrderTimeoutUnacceptedWarningCount(Integer.valueOf(alertCount));
                            break block0;
                        }
                        case 4: {
                            rspBO.setEcOrderTimeoutUnshippedWarningCount(Integer.valueOf(alertCount));
                            break block0;
                        }
                        case 5: {
                            rspBO.setEcOrderTimeoutUnreceivedWarningCount(Integer.valueOf(alertCount));
                            break block0;
                        }
                        case 6: {
                            rspBO.setEcOrderTimeoutUnacceptedWarningCount(Integer.valueOf(alertCount));
                        }
                    }
                    break;
                }
                case 20: {
                    switch (alertType) {
                        case 21: {
                            rspBO.setEcAfterSalesTimeoutUnconfirmedWarningCount(Integer.valueOf(alertCount));
                            break block0;
                        }
                        case 22: {
                            rspBO.setEcAfterSalesTimeoutUnfinishedWarningCount(Integer.valueOf(alertCount));
                            break block0;
                        }
                        case 23: {
                            rspBO.setAgrAfterSalesTimeoutUnconfirmedWarningCount(Integer.valueOf(alertCount));
                            break block0;
                        }
                        case 24: {
                            rspBO.setAgrAfterSalesTimeoutUnfinishedWarningCount(Integer.valueOf(alertCount));
                        }
                    }
                }
            }
        }
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    public void updateTaskDeal(UocOrderTaskDeal taskDeal) {
        UocOrderTaskDealPo set = new UocOrderTaskDealPo();
        set.setDealId(taskDeal.getDealId());
        set.setDealName(taskDeal.getDealName());
        UocOrderTaskDealPo where = new UocOrderTaskDealPo();
        where.setTaskInstId(taskDeal.getTaskInstId());
        this.uocOrderTaskDealMapper.updateBy(set, where);
    }

    public int saveTodoInfo(UocTodo uocTodo) {
        return this.uocTodoMapper.insert((UocTodoPo)UocRu.js((Object)uocTodo, UocTodoPo.class));
    }

    public int updateTodoById(UocTodo uocTodo) {
        return this.uocTodoMapper.updateById((UocTodoPo)UocRu.js((Object)uocTodo, UocTodoPo.class));
    }

    public UocTodo getTodoInfo(UocTodo uocTodo) {
        UocTodoPo modelBy = this.uocTodoMapper.getModelBy((UocTodoPo)UocRu.js((Object)uocTodo, UocTodoPo.class));
        return ObjectUtil.isNotEmpty((Object)modelBy) ? (UocTodo)UocRu.js((Object)modelBy, UocTodo.class) : new UocTodo();
    }

    public List<UocTodo> getTodoListInfo(UocTodo uocTodo) {
        List<UocTodoPo> todoPoList = this.uocTodoMapper.getList((UocTodoPo)UocRu.js((Object)uocTodo, UocTodoPo.class));
        return CollectionUtils.isEmpty(todoPoList) ? new ArrayList() : UocRu.jsl(todoPoList, UocTodo.class);
    }

    public void insertBatchTodo(List<UocTodo> list) {
        List recordPoList = UocRu.jsl(list, UocTodoPo.class);
        this.uocTodoMapper.insertBatch(recordPoList);
    }

    public UocCfcParamConfigDo qryCfcParamByCode(String paramCode) {
        UocCfcParamConfigDo retDo = new UocCfcParamConfigDo();
        CfcParamConfigPo qryPo = new CfcParamConfigPo();
        qryPo.setParamConfigCode(paramCode);
        CfcParamConfigPo qryRspPo = this.cfcParamConfigMapper.getModelBy(qryPo);
        if (ObjectUtil.isNotEmpty((Object)qryRspPo)) {
            BeanUtils.copyProperties((Object)qryRspPo, (Object)retDo);
            CfcParamConfigItemPo qryItemPo = new CfcParamConfigItemPo();
            qryItemPo.setParamConfigCode(paramCode);
            List<CfcParamConfigItemPo> itemListPo = this.cfcParamConfigItemMapper.getList(qryItemPo);
            if (ObjectUtil.isNotEmpty(itemListPo)) {
                retDo.setItemList(JUtil.jsl(itemListPo, UocCfcParamConfigItemDo.class));
            }
        }
        return retDo;
    }

    public UocCfcParamConfigItemDo updateCfcItemValue(UocCfcParamConfigItemDo reqDo) {
        CfcParamConfigItemPo where = new CfcParamConfigItemPo();
        CfcParamConfigItemPo set = new CfcParamConfigItemPo();
        where.setItemId(reqDo.getItemId());
        set.setItemValue(reqDo.getItemValue());
        set.setCreateTime(reqDo.getCreateTime());
        set.setCreateId(reqDo.getCreateId());
        set.setCreateName(reqDo.getCreateName());
        this.cfcParamConfigItemMapper.updateBy(set, where);
        return reqDo;
    }

    public UocQryMateriaOrderNoBo qryMateriaBySkuIdAndUserId(UocQryMateriaOrderNoBo qryBo) {
        return this.uocSaleItemMapMapper.qryMateriaBySkuIdAndUserId(qryBo);
    }

    public UocQrySaleOrderStageBO qrySaleOrderStageByOrderStateAndprocState(UocQrySaleOrderStageBO qryBo) {
        return this.uocSaleOrderStateToStageConfigMapper.getOrderStageByOrderStateAndProcState(qryBo);
    }

    public UocConfSupplierBo qryConfSupplier(String goodsSupplierNo) {
        UocConfSupplierPo uocConfSupplierPo = new UocConfSupplierPo();
        uocConfSupplierPo.setSupNo(goodsSupplierNo);
        uocConfSupplierPo = this.uocConfSupplierMapper.getModelBy(uocConfSupplierPo);
        return ObjectUtil.isNotEmpty((Object)uocConfSupplierPo) ? (UocConfSupplierBo)UocRu.js((Object)uocConfSupplierPo, UocConfSupplierBo.class) : new UocConfSupplierBo();
    }

    public List<UocConfSupplierDO> qryConfSupplierList(UocConfSupplierDO uocConfSupplierDO) {
        UocConfSupplierPo qrySupConfPo = new UocConfSupplierPo();
        qrySupConfPo.setSupplierNos(uocConfSupplierDO.getSupplierNos());
        qrySupConfPo.setLimitStatus(uocConfSupplierDO.getLimitStatus());
        qrySupConfPo.setSupNo(uocConfSupplierDO.getSupNo());
        qrySupConfPo.setBusinessTypeCode(uocConfSupplierDO.getBusinessTypeCode());
        List<UocConfSupplierPo> confSupplierList = this.uocConfSupplierMapper.getList(qrySupConfPo);
        return ObjectUtil.isNotEmpty(confSupplierList) ? UocRu.jsl(confSupplierList, UocConfSupplierDO.class) : new ArrayList();
    }

    public UocQryStateCalculatorBo qryUocStateCalculatorServerConfig(String callServerClassName) {
        UocStateCalculatorConfPO qryPo = new UocStateCalculatorConfPO();
        UocQryStateCalculatorBo retBo = new UocQryStateCalculatorBo();
        qryPo.setCallService(callServerClassName);
        UocStateCalculatorConfPO modelBy = this.uocStateCalculatorConfMapper.getModelBy(qryPo);
        if (ObjectUtil.isNotEmpty((Object)modelBy)) {
            retBo.setCalculatorService(modelBy.getCalculatorService());
            return retBo;
        }
        return retBo;
    }

    public UocQryOrderStateChngLogBo qryUocLastChngStateByObjId(UocQryOrderStateChngLogBo qryBo) {
        UocQryOrderStateChngLogBo retBo = new UocQryOrderStateChngLogBo();
        UocOrderStateChgLogPo qryPo = new UocOrderStateChgLogPo();
        qryPo.setObjId(qryBo.getObjId());
        qryPo.setOrderId(qryBo.getOrderId());
        qryPo.setObjType(qryBo.getObjType());
        UocOrderStateChgLogPo lastModelBy = this.uocOrderStateChgLogMapper.getLastModelBy(qryPo);
        if (ObjectUtil.isNotEmpty((Object)lastModelBy)) {
            retBo.setNewState(lastModelBy.getNewState());
            return retBo;
        }
        return retBo;
    }

    public UocOutLogSaveDo saveOutLog(UocOutLogSaveDo reqDo) {
        SystemBusiLogPO savePo = new SystemBusiLogPO();
        BeanUtils.copyProperties((Object)reqDo, (Object)savePo);
        this.systemBusiLogMapper.insert(savePo);
        return reqDo;
    }

    public UocQryInspItemsServiceRspBo qryInspItems(UocQryInspItemsServiceReqBo reqBo) {
        this.validateArg(reqBo);
        UocQryInspItemsServiceRspBo rspBo = (UocQryInspItemsServiceRspBo)UocRu.success(UocQryInspItemsServiceRspBo.class);
        UocInspOrderItemPo qryInspItemPo = new UocInspOrderItemPo();
        qryInspItemPo.setInspOrderItemIdList(reqBo.getInspItemIdList());
        List<UocInspOrderItemPo> inspItemList = this.uocInspOrderItemMapper.getItemList(qryInspItemPo);
        List<Long> saleOrderIdList = inspItemList.stream().map(UocInspOrderItemPo::getSaleOrderId).distinct().collect(Collectors.toList());
        List<Long> saleOrderItemIdList = inspItemList.stream().map(UocInspOrderItemPo::getSaleOrderItemId).distinct().collect(Collectors.toList());
        UocSaleOrderMapPo qrySaleMapPo = new UocSaleOrderMapPo();
        qrySaleMapPo.setSaleOrderIdList(saleOrderIdList);
        List<UocSaleOrderMapPo> saleOrderMapPoList = this.uocSaleOrderMapMapper.getList(qrySaleMapPo);
        Map<Long, List<UocSaleOrderMapPo>> saleOrderExtMap = saleOrderMapPoList.stream().collect(Collectors.groupingBy(UocSaleOrderMapPo::getSaleOrderId));
        UocSaleOrderItemPo qrySaleItemPo = new UocSaleOrderItemPo();
        qrySaleItemPo.setSaleOrderItemIdList(saleOrderItemIdList);
        List<UocSaleOrderItemPo> saleOrderItemPoList = this.uocSaleOrderItemMapper.getList(qrySaleItemPo);
        Map<Long, UocSaleOrderItemPo> saleOrderItemMap = saleOrderItemPoList.stream().collect(Collectors.toMap(UocSaleOrderItemPo::getSaleOrderItemId, item -> item));
        UocSaleItemMapPo qrySaleItemMapPo = new UocSaleItemMapPo();
        qrySaleItemMapPo.setSaleOrderItemIdList(saleOrderItemIdList);
        List<UocSaleItemMapPo> saleOrderItemMapPoList = this.uocSaleItemMapMapper.getList(qrySaleItemMapPo);
        Map<Long, List<UocSaleItemMapPo>> saleOrderItemExtMap = saleOrderItemMapPoList.stream().collect(Collectors.groupingBy(UocSaleItemMapPo::getSaleOrderItemId));
        UocSaleOrderPo uocSaleOrderPo = new UocSaleOrderPo();
        uocSaleOrderPo.setSaleOrderIdList(saleOrderIdList);
        List<UocSaleOrderPo> querySaleOrderResultPo = this.uocSaleOrderMapper.getList(uocSaleOrderPo);
        Map<Long, UocSaleOrderPo> saleOrderMap = querySaleOrderResultPo.stream().collect(Collectors.toMap(UocSaleOrderPo::getSaleOrderId, item -> item));
        HashMap<Long, UocOrderAgreementPo> agreementPoMap = new HashMap<Long, UocOrderAgreementPo>();
        for (UocSaleOrderPo saleOrderPo : querySaleOrderResultPo) {
            if (!UocDicConstant.ORDER_SOURCE.AGR_GENERATE.equals(saleOrderPo.getOrderSource())) continue;
            UocOrderAgreementPo uocOrderAgreementPo = new UocOrderAgreementPo();
            uocOrderAgreementPo.setId(saleOrderPo.getAgrDataId());
            uocOrderAgreementPo.setOrderId(saleOrderPo.getOrderId());
            UocOrderAgreementPo uocOrderAgreementResultPo = this.uocOrderAgreementMapper.getModelBy(uocOrderAgreementPo);
            if (!ObjectUtil.isNotEmpty((Object)uocOrderAgreementResultPo)) continue;
            agreementPoMap.put(saleOrderPo.getSaleOrderId(), uocOrderAgreementResultPo);
        }
        for (UocInspOrderItemPo uocInspOrderItemPo : inspItemList) {
            List<UocSaleItemMapPo> uocSaleItemMapPos;
            Long inspOrderItemId = uocInspOrderItemPo.getInspOrderItemId();
            Long saleOrderId = uocInspOrderItemPo.getSaleOrderId();
            Long saleOrderItemId = uocInspOrderItemPo.getSaleOrderItemId();
            UocQryInspItemsServiceInspRspBo rspInspItemBo = new UocQryInspItemsServiceInspRspBo();
            rspBo.getInspItemList().add(rspInspItemBo);
            rspInspItemBo.setInspOrderItemId(inspOrderItemId);
            if (ObjectUtil.isNotEmpty((Object)saleOrderItemMap.get(saleOrderItemId))) {
                rspInspItemBo.setSupplierId(saleOrderItemMap.get(saleOrderItemId).getSupplierId());
            }
            if (ObjectUtil.isNotEmpty((Object)saleOrderItemMap.get(saleOrderItemId)) && ObjectUtil.isNotEmpty((Object)saleOrderItemMap.get(saleOrderItemId).getSalePrice()) && ObjectUtil.isNotEmpty((Object)uocInspOrderItemPo.getInspItemCount())) {
                rspInspItemBo.setInspFee(uocInspOrderItemPo.getInspItemCount().multiply(saleOrderItemMap.get(saleOrderItemId).getSalePrice()));
            }
            UocQryInspItemsServiceSaleOrderItemRspBo rspSaleOrderItemBo = new UocQryInspItemsServiceSaleOrderItemRspBo();
            rspInspItemBo.setSaleOrderItemRspBo(rspSaleOrderItemBo);
            rspSaleOrderItemBo.setSaleOrderItemId(saleOrderItemId);
            rspSaleOrderItemBo.setExtFields(new ArrayList());
            if (ObjectUtil.isNotEmpty((Object)saleOrderItemMap.get(saleOrderItemId))) {
                UocSaleOrderItemPo uocSaleOrderItemPo = saleOrderItemMap.get(saleOrderItemId);
                log.debug("\u9a8c\u6536\u660e\u7ec6\u67e5\u8be2\uff0c\u8bbe\u7f6e\u7a0e\u7387\uff1asaleOrderItemId:{},tax\uff1a{}", (Object)saleOrderItemId, (Object)uocSaleOrderItemPo.getTax());
                rspSaleOrderItemBo.setTax(uocSaleOrderItemPo.getTax());
            }
            if (ObjectUtil.isNotEmpty(uocSaleItemMapPos = saleOrderItemExtMap.get(saleOrderItemId))) {
                for (UocSaleItemMapPo uocSaleItemMapPo : uocSaleItemMapPos) {
                    BaseExtendFieldBo rspSaleItemMapTmpBo = new BaseExtendFieldBo();
                    rspSaleOrderItemBo.getExtFields().add(rspSaleItemMapTmpBo);
                    rspSaleItemMapTmpBo.setFieldCode(uocSaleItemMapPo.getFieldCode());
                    rspSaleItemMapTmpBo.setFieldValue(uocSaleItemMapPo.getFieldValue());
                }
            }
            UocQryInspItemsServiceSaleOrderRspBo rspSaleOrderBo = new UocQryInspItemsServiceSaleOrderRspBo();
            rspInspItemBo.setSaleOrderRspBo(rspSaleOrderBo);
            rspSaleOrderBo.setSaleOrderId(saleOrderId);
            rspSaleOrderBo.setAgreementInfo((UocGetSaleOrderDetailServiceRspAgreementInfoBo)UocRu.js(agreementPoMap.get(saleOrderId), UocGetSaleOrderDetailServiceRspAgreementInfoBo.class));
            rspSaleOrderBo.setRemark(saleOrderMap.get(saleOrderId).getRemark());
            rspSaleOrderBo.setExtFields(new ArrayList());
            List<UocSaleOrderMapPo> tmpSaleOrderMapPoList = saleOrderExtMap.get(saleOrderId);
            if (!ObjectUtil.isNotEmpty(tmpSaleOrderMapPoList)) continue;
            for (UocSaleOrderMapPo uocSaleOrderMapPo : tmpSaleOrderMapPoList) {
                BaseExtendFieldBo rspSaleMapTmpBo = new BaseExtendFieldBo();
                rspSaleOrderBo.getExtFields().add(rspSaleMapTmpBo);
                rspSaleMapTmpBo.setFieldCode(uocSaleOrderMapPo.getFieldCode());
                rspSaleMapTmpBo.setFieldValue(uocSaleOrderMapPo.getFieldValue());
            }
        }
        return rspBo;
    }

    private void validateArg(UocQryInspItemsServiceReqBo reqBo) {
        if (reqBo == null) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getInspItemIdList())) {
            throw new BaseBusinessException("100001", "\u5165\u53c2\u5c5e\u6027[inspItemList]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBo.getInspItemIdList().size() > this.qryInspItemsQryMaxCount) {
            throw new BaseBusinessException("100001", "\u5355\u6b21\u6700\u5927\u67e5\u8be2\u6570\u91cf\u4e0d\u80fd\u8d85\u8fc7\uff1a" + this.qryInspItemsQryMaxCount);
        }
    }
}

