package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocInspTempAfProcessTaskPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：临时验收售后处理任务表
 **/
@Mapper
@Repository
public interface UocInspTempAfProcessTaskMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocInspTempAfProcessTaskPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocInspTempAfProcessTaskPO uocInspTempAfProcessTaskPo);

	/**
	 * 根据条件删除数据
	 *
	 * @param uocInspTempAfProcessTaskPo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(UocInspTempAfProcessTaskPO uocInspTempAfProcessTaskPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocInspTempAfProcessTaskPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用(如要使用请自行检查并修正sql语句)
	 */
	@Deprecated
	int updateById(UocInspTempAfProcessTaskPO uocInspTempAfProcessTaskPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocInspTempAfProcessTaskPO set, @Param("where") UocInspTempAfProcessTaskPO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocInspTempAfProcessTaskPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocInspTempAfProcessTaskPO uocInspTempAfProcessTaskPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocInspTempAfProcessTaskPo 参数对象
	 * @return UocInspTempAfProcessTaskPO 结果对象
	 */
	UocInspTempAfProcessTaskPO getModelBy(UocInspTempAfProcessTaskPO uocInspTempAfProcessTaskPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocInspTempAfProcessTaskPo 参数对象
	 * @return List<UocInspTempAfProcessTaskPO> 结果对象
	 */
	List<UocInspTempAfProcessTaskPO> getList(UocInspTempAfProcessTaskPO uocInspTempAfProcessTaskPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocInspTempAfProcessTaskPo 参数对象
	 * @param page 分页参数
	 * @return List<UocInspTempAfProcessTaskPO> 结果对象
	 */
	List<UocInspTempAfProcessTaskPO> getListPage(UocInspTempAfProcessTaskPO uocInspTempAfProcessTaskPo, Page<UocInspTempAfProcessTaskPO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocInspTempAfProcessTaskPO> list);

}
