package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.model.snaporder.UocSnapOrderDo;
import com.tydic.dyc.oc.model.snaporder.qrybo.*;
import com.tydic.dyc.oc.model.snaporder.sub.UocSnapSaleOrderItem;
import com.tydic.dyc.oc.model.snaporder.sub.UocSnapSaleOrderItemSame;
import com.tydic.dyc.oc.repository.UocSnapOrderRepository;
import com.tydic.dyc.oc.repository.dao.UocSnapSaleOrderItemMapper;
import com.tydic.dyc.oc.repository.dao.UocSnapSaleOrderItemSameMapper;
import com.tydic.dyc.oc.repository.dao.UocSnapSaleOrderMapper;
import com.tydic.dyc.oc.repository.po.UocSnapSaleOrderItemPO;
import com.tydic.dyc.oc.repository.po.UocSnapSaleOrderItemSamePO;
import com.tydic.dyc.oc.repository.po.UocSnapSaleOrderPO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.List;

@Slf4j
@Service
public class UocSnapOrderRepositoryImpl implements UocSnapOrderRepository {

    /**
     * 快照销售订单表Mapper
     */
    @Autowired
    private UocSnapSaleOrderMapper uocSnapSaleOrderMapper;

    /**
     * 快照销售订单明细表Mapper
     */
    @Autowired
    private UocSnapSaleOrderItemMapper uocSnapSaleOrderItemMapper;

    /**
     * 快照销售订单明细同款表Mapper
     */
    @Autowired
    private UocSnapSaleOrderItemSameMapper uocSnapSaleOrderItemSameMapper;

    /**
     * 创建快照单
     */
    @Override
    public void createSnapOrder(UocSnapOrderDo uocSnapOrderDo) {
        //调用新增快照销售订单方法
        UocSnapSaleOrderPO uocSnapSaleOrderPO = this.addUocSnapSaleOrder(uocSnapOrderDo);

        //遍历快照销售订单明细集合
        for (UocSnapSaleOrderItem uocSnapSaleOrderItem : uocSnapOrderDo.getUocSnapSaleOrderItemList()) {
            //调用新增快照销售订单明细
            UocSnapSaleOrderItemPO uocSnapSaleOrderItemPO = this.addUocSnapSaleOrderItem(uocSnapSaleOrderItem, uocSnapSaleOrderPO);

            //调用新增快照销售订单明细同款
            this.addUocSnapSaleOrderItemSame(uocSnapSaleOrderItem.getUocSnapSaleOrderItemSameList(), uocSnapSaleOrderItemPO);
        }
    }

    /**
     * 新增快照销售订单
     */
    private UocSnapSaleOrderPO addUocSnapSaleOrder(UocSnapOrderDo uocSnapOrderDo) {
        //定义查询快照销售订单PO
        UocSnapSaleOrderPO qryUocSnapSaleOrder = new UocSnapSaleOrderPO();
        //设置订单ID
        qryUocSnapSaleOrder.setOrderId(uocSnapOrderDo.getOrderId());
        //设置销售订单ID
        qryUocSnapSaleOrder.setSaleOrderId(uocSnapOrderDo.getSaleOrderId());
        //调用快照销售订单Mapper，查询单条数据
        UocSnapSaleOrderPO uocSnapSaleOrderPO = this.uocSnapSaleOrderMapper.getModelBy(qryUocSnapSaleOrder);

        //判断快照销售订单是否存在
        if (ObjectUtil.isNotEmpty(uocSnapSaleOrderPO)) {
            return uocSnapSaleOrderPO;
        }

        //定义快照销售订单PO，参数转换
        UocSnapSaleOrderPO addUocSnapSaleOrder = UocRu.js(uocSnapOrderDo, UocSnapSaleOrderPO.class);
        //设置快照单ID
        addUocSnapSaleOrder.setSnapshotId(IdUtil.nextId());
        //调用快照销售订单Mapper，插入单条数据
        this.uocSnapSaleOrderMapper.insert(addUocSnapSaleOrder);

        return addUocSnapSaleOrder;
    }

    /**
     * 新增快照销售订单明细
     */
    private UocSnapSaleOrderItemPO addUocSnapSaleOrderItem(UocSnapSaleOrderItem uocSnapSaleOrderItem, UocSnapSaleOrderPO uocSnapSaleOrderPO) {
        //定义查询快照销售订单明细PO
        UocSnapSaleOrderItemPO qryUocSnapSaleOrderItem = new UocSnapSaleOrderItemPO();
        //设置快照ID
        qryUocSnapSaleOrderItem.setSnapshotId(uocSnapSaleOrderPO.getSnapshotId());
        //设置单品ID
        qryUocSnapSaleOrderItem.setSkuId(uocSnapSaleOrderItem.getSkuId());
        //调用快照销售订单明细表Mapper，查询单条数据
        UocSnapSaleOrderItemPO uocSnapSaleOrderItemPO = this.uocSnapSaleOrderItemMapper.getModelBy(qryUocSnapSaleOrderItem);

        //判断快照销售订单是否存在
        if (ObjectUtil.isNotEmpty(uocSnapSaleOrderItemPO)) {
            return uocSnapSaleOrderItemPO;
        }

        //定义快照销售订单明细PO，参数转换
        UocSnapSaleOrderItemPO addUocSnapSaleOrderItemPO = UocRu.js(uocSnapSaleOrderItem, UocSnapSaleOrderItemPO.class);
        //设置快照销售订单明细ID
        addUocSnapSaleOrderItemPO.setSnapshotItemId(IdUtil.nextId());
        //设置快照单ID
        addUocSnapSaleOrderItemPO.setSnapshotId(uocSnapSaleOrderPO.getSnapshotId());
        //调用快照销售订单明细Mapper，批量插入数据
        this.uocSnapSaleOrderItemMapper.insert(addUocSnapSaleOrderItemPO);

        return addUocSnapSaleOrderItemPO;
    }

    /**
     * 新增快照销售订单明细同款
     */
    private void addUocSnapSaleOrderItemSame(List<UocSnapSaleOrderItemSame> uocSnapSaleOrderItemSameList, UocSnapSaleOrderItemPO uocSnapSaleOrderItemPO) {
        //判单断快照销售订单明细同款集合是否为空
        if (!CollectionUtils.isEmpty(uocSnapSaleOrderItemSameList)) {
            //定义快照销售订单明细同款PO集合，参数转换
            List<UocSnapSaleOrderItemSamePO> addUocSnapSaleOrderItemSameList = UocRu.jsl(uocSnapSaleOrderItemSameList, UocSnapSaleOrderItemSamePO.class);

            //遍历设置字段参数
            for (UocSnapSaleOrderItemSamePO addUocSnapSaleOrderItemSame : addUocSnapSaleOrderItemSameList) {
                //设置快照销售订单明细同款ID
                addUocSnapSaleOrderItemSame.setSameId(IdUtil.nextId());
                //设置快照销售订单明细ID
                addUocSnapSaleOrderItemSame.setSnapshotItemId(uocSnapSaleOrderItemPO.getSnapshotItemId());
            }

            //调用快照销售订单明细同款Mapper，批量插入数据
            this.uocSnapSaleOrderItemSameMapper.insertBatch(addUocSnapSaleOrderItemSameList);
        }
    }

    /**
     * 订单快照列表分页查询
     */
    @Override
    public UocSnapshotOrderQryListRspBo qryUocSnapshotOrderList(UocSnapshotOrderQryListReqBo reqBo) {
        //定义出参对象
        UocSnapshotOrderQryListRspBo rspBo = new UocSnapshotOrderQryListRspBo();

        //设置分页参数
        Page<UocSnapSaleOrderItemPO> page = new Page<>(reqBo.getPageNo(), reqBo.getPageSize());
        //入参条件参数转换
        UocSnapSaleOrderItemPO uocSnapSaleOrderItemPO = UocRu.js(reqBo, UocSnapSaleOrderItemPO.class);
        //设置排序
        uocSnapSaleOrderItemPO.setOrderBy("usso.create_time DESC, ussoi.sku_code DESC");

        //调用根据条件分页查询订单快照列表数据
        List<UocSnapSaleOrderItemPO> listPage = this.uocSnapSaleOrderItemMapper.getSnapshotOrderListPage(uocSnapSaleOrderItemPO, page);

        if (CollectionUtils.isEmpty(listPage)) {
            rspBo.setPageNo(reqBo.getPageNo());
            rspBo.setRecordsTotal(0);
            rspBo.setTotal(0);
            rspBo.setRows(new ArrayList<>());
            return rspBo;
        }

        //订单快照列表数据转换
        List<UocSnapshotOrderQryListBo> uocSnapshotOrderQryListBoList = UocRu.jsl(listPage, UocSnapshotOrderQryListBo.class);

        //出参
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRows(uocSnapshotOrderQryListBoList);

        return rspBo;
    }

    /**
     * 订单快照明细同款列表查询
     */
    @Override
    public UocSnapshotOrderItemSameQryListRspBo qryUocSnapshotOrderItemSameList(UocSnapshotOrderItemSameQryListReqBo reqBo) {
        //定义出参对象
        UocSnapshotOrderItemSameQryListRspBo rspBo = new UocSnapshotOrderItemSameQryListRspBo();

        //设置分页参数
        Page<UocSnapSaleOrderItemSamePO> page = new Page<>(reqBo.getPageNo(), reqBo.getPageSize());
        //入参条件参数转换
        UocSnapSaleOrderItemSamePO uocSnapSaleOrderItemSamePO = UocRu.js(reqBo, UocSnapSaleOrderItemSamePO.class);
        //设置排序
        uocSnapSaleOrderItemSamePO.setOrderBy("sale_price DESC");

        //调用根据条件分页查询列表数据
        List<UocSnapSaleOrderItemSamePO> listPage = this.uocSnapSaleOrderItemSameMapper.getListPage(uocSnapSaleOrderItemSamePO, page);

        if (CollectionUtils.isEmpty(listPage)) {
            rspBo.setPageNo(reqBo.getPageNo());
            rspBo.setRecordsTotal(0);
            rspBo.setTotal(0);
            rspBo.setRows(new ArrayList<>());
            return rspBo;
        }

        //订单快照明细同款列表数据转换
        List<UocSnapshotOrderItemSameQryListBo> uocSnapshotOrderItemSameQryListBoList = UocRu.jsl(listPage, UocSnapshotOrderItemSameQryListBo.class);

        //出参
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRows(uocSnapshotOrderItemSameQryListBoList);

        return rspBo;
    }
}
