package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.model.aforder.UocAfOrderDo;
import com.tydic.dyc.oc.model.aforder.UocInspTempAfProcessTaskDo;
import com.tydic.dyc.oc.model.aforder.qrybo.*;
import com.tydic.dyc.oc.model.aforder.sub.*;
import com.tydic.dyc.oc.model.order.sub.UocOrdLogisticsRela;
import com.tydic.dyc.oc.model.order.sub.UocOrderAccessory;
import com.tydic.dyc.oc.repository.UocAfOrderRepository;
import com.tydic.dyc.oc.repository.dao.*;
import com.tydic.dyc.oc.repository.po.*;
import com.tydic.dyc.oc.service.order.bo.UocEarlyWarnECNotConfirmListRspBo;
import com.tydic.dyc.oc.service.order.bo.UocEarlyWarnECNotConfirmReqBo;
import com.tydic.dyc.oc.service.order.bo.UocEarlyWarnECNotConfirmRspBo;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import com.tydic.plugin.encoded.service.CfcEncodedSerialGetService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 标题:UocAfOrderRepositoryImpl
 * 说明:售后单
 * 时间:2022/2/21 18:54
 * 作者:罗有
 */

@Service
@Slf4j
public class UocAfOrderRepositoryImpl implements UocAfOrderRepository {

    @Autowired
    private UocAfOrderMapper uocAfOrderMapper;
    @Autowired
    private UocAfOrderMapMapper uocAfOrderMapMapper;
    @Autowired
    private UocAfOrderObjMapper uocAfOrderObjMapper;
    @Autowired
    private UocAfOrderItemMapper uocAfOrderItemMapper;
    @Autowired
    private UocAfItemMapMapper uocAfItemMapMapper;
    @Autowired
    private UocAfOrderWaybillMapper uocAfOrderWaybillMapper;
    @Autowired
    private UocOrderAccessoryMapper uocOrderAccessoryMapper;
    @Autowired
    private UocOrdLogisticsRelaMapper uocOrdLogisticsRelaMapper;
    @Autowired
    private UocAlertInfoMapper uocAlertInfoMapper;

    @Autowired
    private CfcEncodedSerialGetService encodedSerialGetService;

    /**
     * 临时验收售后处理任务表Mapper
     */
    @Autowired
    private UocInspTempAfProcessTaskMapper uocInspTempAfProcessTaskMapper;

    @Override
    public List<UocAfOrderItem> getAfOrderItemList(UocAfOrderItemQryBo uocAfOrderItemQryBo) {
        List<UocAfOrderItemPo> list = uocAfOrderItemMapper.getList(UocRu.js(uocAfOrderItemQryBo, UocAfOrderItemPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfOrderItem.class) : new ArrayList<>();
    }

    @Override
    public UocAfOrder getAfOrderById(UocAfOrderQryBo uocAfOrderQryBo) {
        UocAfOrderPo uocAfOrderPo = new UocAfOrderPo();
        uocAfOrderPo.setAfOrderId(uocAfOrderQryBo.getAfOrderId());
        if (ObjectUtil.isNotNull(uocAfOrderQryBo.getOrderId())) {
            uocAfOrderPo.setOrderId(uocAfOrderQryBo.getOrderId());
        }
        uocAfOrderPo.setDataAchiveTabSuffix(uocAfOrderQryBo.getDataAchiveTabSuffix());
        uocAfOrderPo = uocAfOrderMapper.getModelBy(uocAfOrderPo);
        return null != uocAfOrderPo ? UocRu.js(uocAfOrderPo, UocAfOrder.class) : null;
    }

    @Override
    public List<UocAfOrder> getAfOrderList(UocAfOrderQryBo uocAfOrderQryBo) {
        List<UocAfOrderPo> list = uocAfOrderMapper.getList(UocRu.js(uocAfOrderQryBo, UocAfOrderPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfOrder.class) : new ArrayList<>();
    }

    @Override
    public List<UocAfOrderObj> getAfOrderObjList(UocAfOrderObjQryBo uocAfOrderObjQryBo) {
        List<UocAfOrderObjPo> list = uocAfOrderObjMapper.getList(UocRu.js(uocAfOrderObjQryBo, UocAfOrderObjPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfOrderObj.class) : new ArrayList<>();
    }

    @Override
    public List<UocAfOrderMap> getAfOrderMapList(UocAfOrderMapQryBo uocAfOrderMapQryBo) {
        List<UocAfOrderMapPo> list = uocAfOrderMapMapper.getList(UocRu.js(uocAfOrderMapQryBo, UocAfOrderMapPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfOrderMap.class) : new ArrayList<>();
    }

    @Override
    public List<UocAfOrderWaybill> getAfOrderWayBillList(UocAfOrderWaybillQryBo uocAfOrderWaybillQryBo) {
        List<UocAfOrderWaybillPo> list = uocAfOrderWaybillMapper.getList(UocRu.js(uocAfOrderWaybillQryBo, UocAfOrderWaybillPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfOrderWaybill.class) : new ArrayList<>();
    }

    @Override
    public void modifyAfOrder(UocAfOrderDo uocAfOrderDo) {
        UocAfOrderPo where = new UocAfOrderPo();
        where.setAfOrderId(uocAfOrderDo.getAfOrderId());
        uocAfOrderMapper.updateBy(UocRu.js(uocAfOrderDo, UocAfOrderPo.class), where);
    }

    @Override
    public UocAfOrderDo saveAfterOder(UocAfOrderDo afOrderDo) {
        UocAfOrderPo uocAfOrderPo = UocRu.js(afOrderDo, UocAfOrderPo.class);
        uocAfOrderMapper.insert(uocAfOrderPo);
        List<UocAfOrderMap> extParallelBoList = afOrderDo.getExtParallelBoList();
        if (ObjectUtil.isNotEmpty(extParallelBoList)) {
            uocAfOrderMapMapper.insertBatch(UocRu.jsl(extParallelBoList, UocAfOrderMapPo.class));
        }
        uocAfOrderObjMapper.insertBatch(UocRu.jsl(afOrderDo.getAfOrderObjList(), UocAfOrderObjPo.class));
        List<UocAfOrderItem> afOrderItemBoList = afOrderDo.getAfOrderItemBoList();
        if (ObjectUtil.isNotEmpty(afOrderItemBoList)) {
            uocAfOrderItemMapper.insertBatch(UocRu.jsl(afOrderItemBoList, UocAfOrderItemPo.class));
        }

        List<UocOrderAccessory> orderAccessoryBoList = afOrderDo.getOrderAccessoryBoList();
        if (ObjectUtil.isNotEmpty(orderAccessoryBoList)) {
            uocOrderAccessoryMapper.insertBatch(UocRu.jsl(orderAccessoryBoList, UocOrderAccessoryPo.class));
        }
        UocOrdLogisticsRela takeAddress = afOrderDo.getTakeAddress();
        if (ObjectUtil.isNotEmpty(takeAddress)) {
            uocOrdLogisticsRelaMapper.insert(UocRu.js(takeAddress, UocOrdLogisticsRelaPo.class));
        }
        UocOrdLogisticsRela returnAddress = afOrderDo.getReturnAddress();
        if (ObjectUtil.isNotEmpty(returnAddress)) {
            uocOrdLogisticsRelaMapper.insert(UocRu.js(returnAddress, UocOrdLogisticsRelaPo.class));
        }
        return afOrderDo;
    }


    @Override
    public List<UocAfItemMap> getAfOrderItemMapList(UocAfItemMapQryBo uocAfItemMapQryBo) {
        List<UocAfItemMapPo> list = uocAfItemMapMapper.getList(UocRu.js(uocAfItemMapQryBo, UocAfItemMapPo.class));
        return ObjectUtil.isNotEmpty(list) ? UocRu.jsl(list, UocAfItemMap.class) : new ArrayList<>();
    }

    @Override
    public void modifyBatchAfOrderRemark(List<UocAfOrderDo> uocAfOrderDoList) {
        if (!CollectionUtils.isEmpty(uocAfOrderDoList)) {
            uocAfOrderMapper.updateBatch(UocRu.jsl(uocAfOrderDoList, UocAfOrderPo.class), UocRu.js(uocAfOrderDoList.get(0), UocAfOrderPo.class));
            List<UocOrdLogisticsRela> uocOrdLogisticsRelas = new ArrayList<>();

            //修改预警状态
            UocAlertInfoPO uocAlertInfoPO = new UocAlertInfoPO();
            uocAlertInfoPO.setAlertState(1);
            uocAlertInfoPO.setOldAlertState(0);
            uocAlertInfoPO.setUpdateTime(new Date());
            uocAlertInfoPO.setObjType(20);
            List<Long> list = new ArrayList<>();
            for (UocAfOrderDo uocAfOrderDo : uocAfOrderDoList) {
                if (null != uocAfOrderDo.getReturnAddress() && null != uocAfOrderDo.getReturnAddress().getContactId()) {
                    uocOrdLogisticsRelas.add(uocAfOrderDo.getReturnAddress());
                }
                //修改预警状态
                list.add(uocAfOrderDo.getAfOrderId());
            }
            uocAlertInfoPO.setObjIds(list);
            if (list.size() > 0) {
                uocAlertInfoMapper.updateBatch1(uocAlertInfoPO);
            }
            if (!CollectionUtils.isEmpty(uocOrdLogisticsRelas)) {
                uocOrdLogisticsRelaMapper.insertBatch(UocRu.jsl(uocOrdLogisticsRelas, UocOrdLogisticsRelaPo.class));
            }
        }
    }

    @Override
    public void modifyAfOrderExtOrderId(UocAfOrderDo afOrderDo) {
        uocAfOrderMapper.updateExtId(UocRu.js(afOrderDo, UocAfOrderPo.class));

    }

    @Override
    public void saveAfOrderWayBill(UocAfOrderWaybill uocAfOrderWaybill) {
        if (ObjectUtil.isNotEmpty(uocAfOrderWaybill)) {
            uocAfOrderWaybillMapper.insert(UocRu.js(uocAfOrderWaybill, UocAfOrderWaybillPo.class));
            UocAfOrderPo set = new UocAfOrderPo();
            set.setWaybillFlag(0);
            UocAfOrderPo where = new UocAfOrderPo();
            where.setAfOrderId(uocAfOrderWaybill.getAfOrderId());
            uocAfOrderMapper.updateBy(set, where);
        }
    }

    @Override
    public void modifyAfOrderState(UocAfOrderDo afOrderDo) {
        uocAfOrderMapper.updateStateId(UocRu.js(afOrderDo, UocAfOrderPo.class));

        //修改预警状态
        UocAlertInfoPO uocAlertInfoPO = new UocAlertInfoPO();
        uocAlertInfoPO.setObjId(String.valueOf(afOrderDo.getAfOrderId()));
        uocAlertInfoPO.setAlertState(1);
        uocAlertInfoPO.setOldAlertState(0);
        uocAlertInfoPO.setUpdateTime(new Date());
        uocAlertInfoPO.setObjType(20);
        uocAlertInfoMapper.update(uocAlertInfoPO);
    }

    @Override
    public List<UocAfOrderDo> getCheckAfOrders(UocAfOrderDo afOrderDo) {
        List<UocAfOrderPo> uocAfOrderPos = uocAfOrderMapper.getCheckAfOrders(UocRu.js(afOrderDo, UocAfOrderPo.class));
        return UocRu.jsl(uocAfOrderPos, UocAfOrderDo.class);
    }

    /**
     * 查询售后单明细
     */
    @Override
    public UocAfOrderItem getAfOrderItem(UocAfOrderItemQryBo uocAfOrderItemQryBo) {
        //定义出参对象
        UocAfOrderItem uocAfOrderItem = new UocAfOrderItem();

        //调用根据条件查询单条数据
        UocAfOrderItemPo uocAfOrderItemPo = this.uocAfOrderItemMapper.getModelBy(UocRu.js(uocAfOrderItemQryBo, UocAfOrderItemPo.class));

        if (ObjectUtil.isNotEmpty(uocAfOrderItemPo)) {
            //设置出参
            uocAfOrderItem = UocRu.js(uocAfOrderItemPo, UocAfOrderItem.class);
        }
        if (ObjectUtil.isEmpty(uocAfOrderItemPo)) {
            //设置出参
            uocAfOrderItem = null;
        }

        return uocAfOrderItem;
    }

    /**
     * 新增临时验收售后处理任务
     */
    @Override
    public void addInspTempAfProcessTask(UocInspTempAfProcessTaskDo uocInspTempAfProcessTaskDo) {
        //定义新增参数，转换入参
        UocInspTempAfProcessTaskPO addInspTempAfProcessTask = UocRu.js(uocInspTempAfProcessTaskDo, UocInspTempAfProcessTaskPO.class);
        //设置任务ID
        addInspTempAfProcessTask.setTaskId(IdUtil.nextId());
        //设置创建时间
        addInspTempAfProcessTask.setCreateTime(new Date());
        //调用插入单条数据
        this.uocInspTempAfProcessTaskMapper.insert(addInspTempAfProcessTask);
    }

    /**
     * 分页查询临时验收售后处理任务列表
     */
    @Override
    public UocInspTempAfProcessTaskQryRspPageBo getInspTempAfProcessTaskPageList(UocInspTempAfProcessTaskQryReqPageBo reqPageBo) {
        //定义出参对象
        UocInspTempAfProcessTaskQryRspPageBo rspPageBo = new UocInspTempAfProcessTaskQryRspPageBo();

        //设置分页参数
        Page<UocInspTempAfProcessTaskPO> page = new Page<>(reqPageBo.getPageNo(), reqPageBo.getPageSize());

        //入参条件参数转换
        UocInspTempAfProcessTaskPO queryUocInspTempAfProcessTaskPage = UocRu.js(reqPageBo, UocInspTempAfProcessTaskPO.class);

        //调用根据条件分页查询列表数据
        List<UocInspTempAfProcessTaskPO> uocInspTempAfProcessTaskMapperListPage = this.uocInspTempAfProcessTaskMapper.getListPage(queryUocInspTempAfProcessTaskPage, page);

        if (CollectionUtils.isEmpty(uocInspTempAfProcessTaskMapperListPage)) {
            rspPageBo.setPageNo(reqPageBo.getPageNo());
            rspPageBo.setRecordsTotal(0);
            rspPageBo.setTotal(0);
            rspPageBo.setRows(new ArrayList<>());
            return rspPageBo;
        }

        //出参转换
        List<UocInspTempAfProcessTaskQryPageBo> uocInspTempAfProcessTaskQryPageBoList = UocRu.jsl(uocInspTempAfProcessTaskMapperListPage, UocInspTempAfProcessTaskQryPageBo.class);

        //出参
        rspPageBo.setPageNo(reqPageBo.getPageNo());
        rspPageBo.setRecordsTotal(page.getTotalCount());
        rspPageBo.setTotal(page.getTotalPages());
        rspPageBo.setRows(uocInspTempAfProcessTaskQryPageBoList);
        return rspPageBo;
    }

    /**
     * 修改临时验收售后处理任务
     */
    @Override
    public void updateInspTempAfProcessTask(UocInspTempAfProcessTaskDo uocInspTempAfProcessTaskDo) {
        //定义临时验收售后处理任务修改Set
        UocInspTempAfProcessTaskPO uocInspTempAfProcessTaskSet = new UocInspTempAfProcessTaskPO();
        //设置状态
        uocInspTempAfProcessTaskSet.setStatus(uocInspTempAfProcessTaskDo.getStatus());
        //设置修改时间
        uocInspTempAfProcessTaskSet.setUpdateTime(new Date());

        //定义临时验收售后处理修改Where
        UocInspTempAfProcessTaskPO uocInspTempAfProcessTaskWhere = new UocInspTempAfProcessTaskPO();
        //设置任务ID
        uocInspTempAfProcessTaskWhere.setTaskId(uocInspTempAfProcessTaskDo.getTaskId());

        //调用根据条件更新数据
        this.uocInspTempAfProcessTaskMapper.updateBy(uocInspTempAfProcessTaskSet, uocInspTempAfProcessTaskWhere);
    }

    @Override
    @Transactional
    public UocEarlyWarnECNotConfirmListRspBo earlyWarnECNotConfirm(UocEarlyWarnECNotConfirmReqBo reqBo) {
        Date date = new Date();
        //先全部更新为处理中
        UocAlertInfoPO uocAlertInfoPO = new UocAlertInfoPO();
        uocAlertInfoPO.setOldAlertState(UocConstant.UocAlertState.TO_DEAL);
        uocAlertInfoPO.setAlertState(UocConstant.UocAlertState.IN_DEAL);
        uocAlertInfoPO.setObjType(20);
        uocAlertInfoPO.setAlertType(reqBo.getOperateType());
        uocAlertInfoPO.setUpdateTime(date);
        uocAlertInfoMapper.update(uocAlertInfoPO);

        List<UocEarlyWarnECNotConfirmRspBo> list = uocAfOrderMapper.earlyWarn(reqBo);
        UocAlertInfoPO po1 = new UocAlertInfoPO();
        po1.setOldAlertState(UocConstant.UocAlertState.TO_DEAL);
        po1.setAlertState(UocConstant.UocAlertState.IN_DEAL);
        po1.setObjType(20);
        po1.setAlertType(reqBo.getOperateType());
        List<UocAlertInfoPO> uocAlertInfoPOS = uocAlertInfoMapper.selectByCondition(po1);
        //新增的数据
        List<UocAlertInfoPO> uocAlertInfoPOS1 = new ArrayList<>();
        List<Long> list1 = new ArrayList<>();
        //完成的数据
        List<Long> list2 = new ArrayList<>();
        //修改的数据
        List<Long> list3 = new ArrayList<>();
        if (!list.isEmpty() && uocAlertInfoPOS.isEmpty()) {
            list1 = list.stream().map(UocEarlyWarnECNotConfirmRspBo::getAfOrderId).collect(Collectors.toList());
            for (UocEarlyWarnECNotConfirmRspBo uocEarlyWarnECNotConfirmRspBo : list) {
                UocAlertInfoPO po = new UocAlertInfoPO();
                po.setId(IdUtil.nextId());
                po.setOrderId(uocEarlyWarnECNotConfirmRspBo.getOrderId());
                po.setObjId(String.valueOf(uocEarlyWarnECNotConfirmRspBo.getAfOrderId()));
                po.setObjType(20);
                po.setAlertType(reqBo.getOperateType());
                po.setCreateTime(date);
                po.setAlertState(0);
                po.setIsSend(0);
                po.setCreateUserId(Long.valueOf(uocEarlyWarnECNotConfirmRspBo.getSubmitterOperId()));
                po.setCreateUserName(uocEarlyWarnECNotConfirmRspBo.getSubmitterOperName());
                po.setCreateOrgId(Long.valueOf(uocEarlyWarnECNotConfirmRspBo.getSubDeptId()));
                po.setCreateOrgName(uocEarlyWarnECNotConfirmRspBo.getSubDeptName());
                po.setCreateCompanyId(Long.valueOf(uocEarlyWarnECNotConfirmRspBo.getSubCompId()));
                po.setCreateCompanyName(uocEarlyWarnECNotConfirmRspBo.getSubCompName());
                uocAlertInfoPOS1.add(po);
            }
        }
        if (list.isEmpty() && !uocAlertInfoPOS.isEmpty()) {
            list2 = uocAlertInfoPOS.stream().map(e -> Long.valueOf(e.getObjId())).collect(Collectors.toList());
        }
        if (!list.isEmpty() && !uocAlertInfoPOS.isEmpty()) {
            // 提取数据
            Set<Long> collect = list.stream().map(UocEarlyWarnECNotConfirmRspBo::getAfOrderId).collect(Collectors.toSet());
            Set<String> collect1 = uocAlertInfoPOS.stream().map(UocAlertInfoPO::getObjId).collect(Collectors.toSet());

            // 找出修改的数据
            for (UocAlertInfoPO po : uocAlertInfoPOS) {
                if (collect.contains(Long.valueOf(po.getObjId()))) {
                    list3.add(Long.valueOf(po.getObjId()));
                }
            }

            // 找出新增的数据
            list1 = collect.stream().filter(id -> !collect1.contains(String.valueOf(id))).collect(Collectors.toList());

            // 找出完成的数据
            list2 = collect1.stream().filter(id -> !collect.contains(Long.valueOf(id))).map(Long::valueOf).collect(Collectors.toList());

            // 处理新增数据
            for (Long aLong : list1) {
                UocEarlyWarnECNotConfirmRspBo match = list.stream()
                        .filter(item -> item.getAfOrderId().equals(aLong))
                        .findFirst().orElse(null);

                if (match != null) {
                    UocAlertInfoPO po = new UocAlertInfoPO();
                    po.setId(IdUtil.nextId());
                    po.setObjId(String.valueOf(aLong));
                    po.setObjType(20);
                    po.setAlertType(reqBo.getOperateType());
                    po.setCreateTime(date);
                    po.setAlertState(0);
                    po.setIsSend(0);
                    po.setOrderId(match.getOrderId());
                    po.setCreateUserId(Long.valueOf(match.getSubmitterOperId()));
                    po.setCreateUserName(match.getSubmitterOperName());
                    po.setCreateOrgId(Long.valueOf(match.getSubDeptId()));
                    po.setCreateOrgName(match.getSubDeptName());
                    po.setCreateCompanyId(Long.valueOf(match.getSubCompId()));
                    po.setCreateCompanyName(match.getSubCompName());
                    uocAlertInfoPOS1.add(po);
                }
            }
        }
        log.info("新增的业务id集合:{}", JSON.toJSONString(list1));
        log.info("完成的业务id集合:{}", JSON.toJSONString(list2));
        log.info("没动的业务id集合:{}", JSON.toJSONString(list3));
        if (uocAlertInfoPOS1.size() > 0) {
            uocAlertInfoMapper.insertBatch(uocAlertInfoPOS1);
            UocAfOrderPo uocAfOrderPo = new UocAfOrderPo();
            uocAfOrderPo.setAfOrderIds(list1);
            uocAfOrderPo.setEarlyWarnType(reqBo.getOperateType());
            uocAfOrderMapper.updateBatchById(uocAfOrderPo);
        }
        if (list2.size() > 0) {
            UocAlertInfoPO uocAlertInfoPO1 = new UocAlertInfoPO();
            uocAlertInfoPO1.setObjType(20);
            uocAlertInfoPO1.setAlertState(1);
            uocAlertInfoPO1.setAlertType(reqBo.getOperateType());
            uocAlertInfoPO1.setObjIds(list2);
            uocAlertInfoPO1.setOldAlertState(2);
            uocAlertInfoMapper.updateBatch(uocAlertInfoPO1);

            UocAfOrderPo uocAfOrderPo = new UocAfOrderPo();
            uocAfOrderPo.setAfOrderIds(list2);
            uocAfOrderPo.setEarlyWarnType(0);
            uocAfOrderMapper.updateBatchById(uocAfOrderPo);
        }
        if (list3.size() > 0) {
            UocAlertInfoPO uocAlertInfoPO1 = new UocAlertInfoPO();
            uocAlertInfoPO1.setObjType(20);
            uocAlertInfoPO1.setAlertState(0);
            uocAlertInfoPO1.setAlertType(reqBo.getOperateType());
            uocAlertInfoPO1.setObjIds(list3);
            uocAlertInfoPO1.setOldAlertState(2);
            uocAlertInfoMapper.updateBatch(uocAlertInfoPO1);
        }
        list1.addAll(list2);
        UocAfOrderPo uocAfOrderPo = new UocAfOrderPo();
        uocAfOrderPo.setAfOrderIds(list1);
        UocEarlyWarnECNotConfirmListRspBo rspBo = new UocEarlyWarnECNotConfirmListRspBo();
        List<UocEarlyWarnECNotConfirmRspBo> poList = new ArrayList<>();
        if (list1.size() > 0) {
            poList = uocAfOrderMapper.selectByIds(uocAfOrderPo);
        }
        rspBo.setUacEarlyWarnECNotConfirmList(poList);
        return rspBo;
    }

    @Override
    public UocEarlyWarnECNotConfirmListRspBo earlyWarnECNotConfirmByOrderId(UocEarlyWarnECNotConfirmReqBo reqBo) {
        UocEarlyWarnECNotConfirmListRspBo rspBo = new UocEarlyWarnECNotConfirmListRspBo();
        UocAfOrderPo uocAfOrderPo = new UocAfOrderPo();
        uocAfOrderPo.setAfOrderIds(reqBo.getAfOrderIds());
        List<UocEarlyWarnECNotConfirmRspBo> poList = uocAfOrderMapper.earlyWarnECNotConfirmByOrderId(uocAfOrderPo);
        rspBo.setUacEarlyWarnECNotConfirmList(poList);
        return rspBo;
    }

    @Override
    public UocEarlyWarnECNotConfirmListRspBo queryEarlyWarnECNotConfirm(UocEarlyWarnECNotConfirmReqBo reqBo) {
        UocEarlyWarnECNotConfirmListRspBo rspBo = new UocEarlyWarnECNotConfirmListRspBo();
        UocAlertInfoPO uocAlertInfoPO = new UocAlertInfoPO();
        uocAlertInfoPO.setAlertState(UocConstant.UocAlertState.TO_DEAL);
        uocAlertInfoPO.setObjType(20);
        uocAlertInfoPO.setAlertType(reqBo.getOperateType());
        if (reqBo.getIsSend() != null) {
            uocAlertInfoPO.setIsSend(reqBo.getIsSend());
        }
        List<UocAlertInfoPO> uocAlertInfoPOS = uocAlertInfoMapper.selectByCondition(uocAlertInfoPO);
        if (uocAlertInfoPOS.size() > 0) {
            List<Long> collect = uocAlertInfoPOS.stream().map(e -> Long.valueOf(e.getObjId())).collect(Collectors.toList());
            rspBo.setIds(collect);
        }
        return rspBo;
    }

    @Override
    public UocEarlyWarnECNotConfirmListRspBo updateEarlyWarnECNotConfirm(UocEarlyWarnECNotConfirmReqBo reqBo) {
        UocAlertInfoPO uocAlertInfoPO = new UocAlertInfoPO();
        uocAlertInfoPO.setAlertState(UocConstant.UocAlertState.TO_DEAL);
        uocAlertInfoPO.setObjType(20);
        uocAlertInfoPO.setAlertType(reqBo.getOperateType());
//        if (reqBo.getIsSend() != null) {
//            uocAlertInfoPO.setIsSend(reqBo.getIsSend());
//        }
        uocAlertInfoPO.setObjIds(reqBo.getAfOrderIds());
        uocAlertInfoMapper.updateBatchByIsSend(uocAlertInfoPO);
        return new UocEarlyWarnECNotConfirmListRspBo();
    }
}
