package com.tydic.dyc.oc.repository.impl;

import com.tydic.dyc.oc.model.checkorder.UocCheckOrderDo;
import com.tydic.dyc.oc.model.checkorder.UocCheckOrderErrorItemDo;
import com.tydic.dyc.oc.model.checkorder.UocOutCheckOrderDo;
import com.tydic.dyc.oc.repository.UocOutCheckOrderRepository;
import com.tydic.dyc.oc.repository.dao.UocCheckOrderErrorItemMapper;
import com.tydic.dyc.oc.repository.dao.UocCheckOrderMapper;
import com.tydic.dyc.oc.repository.dao.UocOutCheckOrderMapper;
import com.tydic.dyc.oc.repository.po.UocCheckOrderErrorItemPo;
import com.tydic.dyc.oc.repository.po.UocCheckOrderPo;
import com.tydic.dyc.oc.repository.po.UocOutCheckOrderPo;
import com.tydic.dyc.oc.utils.UocRu;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;


@Service
public class UocOutCheckOrderRepositoryImpl implements UocOutCheckOrderRepository {
    
    @Autowired
    private UocOutCheckOrderMapper uocOutCheckOrderMapper;
    
    @Autowired
    private UocCheckOrderMapper uocCheckOrderMapper;
    
    @Autowired
    private UocCheckOrderErrorItemMapper uocCheckOrderErrorItemMapper;
    
    @Override
    public int createOutCheckOrder(UocOutCheckOrderDo record) {
        int result = uocOutCheckOrderMapper.insertSelective(UocRu.js(record, UocOutCheckOrderPo.class));
        return result;
    }
    
    @Override
    public List<UocOutCheckOrderDo> selectOutCheckOrderList(UocOutCheckOrderDo record) {
        List<UocOutCheckOrderPo> uocOutCheckOrderPos = uocOutCheckOrderMapper.selectOutCheckOrderList(UocRu.js(record, UocOutCheckOrderPo.class));
        List<UocOutCheckOrderDo> uocOutCheckOrderDos = UocRu.jsl(uocOutCheckOrderPos,UocOutCheckOrderDo.class);
        return uocOutCheckOrderDos;
    }
    
    @Override
    public int createCheckOrder(UocCheckOrderDo record) {
        int result = uocCheckOrderMapper.insertSelective(UocRu.js(record, UocCheckOrderPo.class));
        return result;
    }
    
    @Override
    public int createCheckOrderErrorItem(UocCheckOrderErrorItemDo record) {
        int result = uocCheckOrderErrorItemMapper.insertSelective(UocRu.js(record, UocCheckOrderErrorItemPo.class));
        return result;
    }
}
