package com.tydic.dyc.oc.repository.po;

import lombok.Data;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 描述：快照销售订单表
 **/
@Data
public class UocSnapSaleOrderPO implements Serializable {
	private static final long serialVersionUID =  9182876970020444171L;

	/**
	 * 快照ID
	 */
	private Long snapshotId;
	/**
	 * 订单ID
	 */
	private Long orderId;
	/**
	 * 销售单ID
	 */
	private Long saleOrderId;
	/**
	 * 销售单编码
	 */
	private String saleOrderNo;
	/**
	 * 订单总金额
	 */
	private BigDecimal orderTotalFee;
	/**
	 * 订单来源 1自营单品 2电商导入 3协议生成
	 */
	private Integer orderSource;
	/**
	 * 专区类型
	 */
	private Integer areaType;
	/**
	 * 创建人机构ID
	 */
	private String createOrgId;
	/**
	 * 创建人机构名称
	 */
	private String createOrgName;
	/**
	 * 创建人公司ID
	 */
	private String createCompanyId;
	/**
	 * 创建人公司名称
	 */
	private String createCompanyName;
	/**
	 * 创建人工号
	 */
	private String createUserId;
	/**
	 * 创建人名称
	 */
	private String createUserName;
	/**
	 * 创建时间
	 */
	private Date createTime;
	private Date createTimeStart;
	private Date createTimeEnd;
	/**
	 * 排序
	 */
	private String orderBy;

}
