package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocBargainingProgressRecordPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：寻源操作记录表pro
 * 
 * @author 文乐
 * @date 2023-07-21 18:11
 **/
@Mapper
@Repository
public interface UocBargainingProgressRecordMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocBargainingProgressRecordPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocBargainingProgressRecordPO uocBargainingProgressRecordPo);

	/**
	 * 根据条件删除数据
	 *
	 * @param uocBargainingProgressRecordPo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(UocBargainingProgressRecordPO uocBargainingProgressRecordPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocBargainingProgressRecordPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocBargainingProgressRecordPO uocBargainingProgressRecordPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocBargainingProgressRecordPO set, @Param("where") UocBargainingProgressRecordPO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocBargainingProgressRecordPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocBargainingProgressRecordPO uocBargainingProgressRecordPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocBargainingProgressRecordPo 参数对象
	 * @return UocBargainingProgressRecordPO 结果对象
	 */
	UocBargainingProgressRecordPO getModelBy(UocBargainingProgressRecordPO uocBargainingProgressRecordPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocBargainingProgressRecordPo 参数对象
	 * @return List<UocBargainingProgressRecordPO> 结果对象
	 */
	List<UocBargainingProgressRecordPO> getList(UocBargainingProgressRecordPO uocBargainingProgressRecordPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocBargainingProgressRecordPo 参数对象
	 * @param page 分页参数
	 * @return List<UocBargainingProgressRecordPO> 结果对象
	 */
	List<UocBargainingProgressRecordPO> getListPage(UocBargainingProgressRecordPO uocBargainingProgressRecordPo, Page<UocBargainingProgressRecordPO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocBargainingProgressRecordPO> list);

}
