package com.tydic.dyc.oc.repository.po;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocSaleOrderItemPo
 * 说明:销售订单明细
 * 时间:2022-05-20 10:11
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocSaleOrderItemPo implements Serializable {
    private static final long serialVersionUID = -5861022529706617352L;

    //订单id")
    private Long orderId;

    //销售明细id")
    private Long saleOrderItemId;

    //明细序号
    private String saleOrderItemIndex;

    //销售单id")
    private Long saleOrderId;

    //订单明细id")
    private Long orderItemId;

    //sap订单编号
    private String sapOrderNo;

    //sap 订单明细编号
    private String sapOrderItemNo;


    //明细类型             1 商品sku             2 物资             3 项目")
    private Integer itemType;

    //单品来源      1 自营单品   2 电商导入   3 协议生成    ")
    private Integer skuSource;

    //明细状态")
    private String saleItemState;

    //单品ID")
    private String skuId;

    //单品编码")
    private String skuCode;

    //单品名称")
    private String skuName;

    //商品id")
    private String commodityId;

    //商品编码")
    private String commodityCode;

    //商品名称")
    private String commodityName;

    //商品类型id")
    private String commodityTypeId;

    //商品类型名称")
    private String commodityTypeName;

    //供应商ID")
    private String supplierId;

    //店铺ID")
    private String supplierShopId;

    //采购金额")
    private BigDecimal purchasePrice;

    //采购金额")
    private BigDecimal salePrice;

    //采购数量")
    private BigDecimal purchaseCount;

    //发货数量")
    private BigDecimal sendCount;

    //到货数量")
    private BigDecimal arriveCount;

    //拒收数量")
    private BigDecimal refuseCount;

    //验收数量")
    private BigDecimal acceptanceCount;

    //是否存在超验 0否 1是")
    private Integer inspSuper;

    //退货数量")
    private BigDecimal returnCount;

    //异常变更在途数量，表示异常供应商确认之前的记录数量")
    private BigDecimal chngingCount;

    //运费")
    private BigDecimal transFee;

    //销售金额")
    private BigDecimal saleFee;

    //采购金额")
    private BigDecimal purchaseFee;

    //应付金额")
    private BigDecimal payFee;

    //积分优惠金额")
    private BigDecimal integralDisFee;

    //活动优惠金额")
    private BigDecimal actDisFee;

    //其它优惠金额")
    private BigDecimal otherDisFee;

    //实付金额")
    private BigDecimal usedFee;

    //实付积分")
    private BigDecimal usedIntegral;

    //币种")
    private String currencyType;

    //税金")
    private BigDecimal taxPrice;

    //裸价")
    private BigDecimal nakedPrice;

    //税率")
    private BigDecimal tax;

    //税务编码")
    private String taxId;

    //预计发货时间")
    private Date preSendTime;

    //预计发货时间 开始")
    private Date preSendTimeStart;

    //预计发货时间 结束")
    private Date preSendTimeEnd;

    //预计交货时间")
    private Date preOfferTime;

    //预计交货时间 开始")
    private Date preOfferTimeStart;

    //预计交货时间 结束")
    private Date preOfferTimeEnd;

    //计量单位")
    private String unitName;

    //结算计量单位")
    private String settleUnit;

    //售后在途数量")
    private BigDecimal afterServingCount;

    //外部电商主订单id")
    private String lmOrderId;

    //外部电商子订单id")
    private String lmSubOrderId;

    //到货周期")
    private String arrivalTime;

    //加价率")
    private Double markUpRate;

    //商品服务费 ")
    private String serPrice;

    //比选单号")
    private String cmpOrderNo;

    //比选备注")
    private String cmpRemark;

    //计划id")
    private String planId;

    //计划明细id")
    private String planItemId;

    //计划编号")
    private String planNo;

    //计划明细编号")
    private String planItemNo;
    /**
     * 计划来源1SAP;2电商平台
     */
    private Integer planSource;
    /**
     * 计划单位
     */
    private String planUnit;
    /**
     * 单位转换倍率
     */
    private BigDecimal planConversionRate;

    //协议id")
    private String agreementId;

    //协议编号")
    private String agreementNo;

    //协议模式 1：平台协议 2：单位协议")
    private Integer agreementCode;

    //协议明细编号")
    private String agreementIdItemNo;

    //创建时间")
    private Date createTime;

    //创建时间 开始")
    private Date createTimeStart;

    //创建时间 结束")
    private Date createTimeEnd;

    //创建工号")
    private String createOperId;

    //更新时间")
    private Date updateTime;

    //更新时间 开始")
    private Date updateTimeStart;

    //更新时间 结束")
    private Date updateTimeEnd;

    //更新工号")
    private String updateOperId;

    //备注")
    private String remark;

    //sku物料ID")
    private String skuMaterialId;

    //sku物料编码")
    private String skuMaterialCode;

    //sku外部单品id")
    private String skuExtSkuId;

    //sku品牌id")
    private Long skuBrandId;

    //单品品牌名称")
    private String skuBrandName;

    //sku明细id")
    private String skuItemId;

    //sku物料名称")
    private String skuMaterialName;

    //sku物料类型名称")
    private String skuMaterialTypeName;

    //sku物料类型id")
    private String skuMaterialTypeId;

    //型号")
    private String model;

    //规格")
    private String spec;

    //材质")
    private String texture;

    //图号")
    private String figure;

    //一级类目")
    private Long l1Catalog;

    //二级类目")
    private Long l2Catalog;

    //三级类目")
    private Long l3Catalog;

    //一级类目名称")
    private String l1CatalogName;

    //二级类目名称")
    private String l2CatalogName;

    //三级类目名称")
    private String l3CatalogName;

    //退货时间，空代表不支持")
    private Integer rejectAllowDate;

    //换货时间，空代表不支持")
    private Integer exchangeAllowDate;

    //维修时间，空代表不支持")
    private Integer maintainAllowDate;

    //sku单品主图url")
    private String skuMainPicUrl;

    //删除标志1已删除")
    private Integer delTag;

    //超验百分比，下单时保存（协议、无协议）")
    private Integer inspectionExcessPercent;

    //超验数量")
    private BigDecimal inspSuperCount;

    //排序")
    private String orderBy;

    //销售明细id List")
    private List<Long> saleOrderItemIdList;


    /**
     * 未比选原因
     */
    private String noCmpReason;

    //计量单位位数")
    private String unitDigit;
     //@DocField(value = "归档表后缀")
    private String dataAchiveTabSuffix;
    
    
    /**
     * 议价单id
     */
    private Long bargainingId;
    /**
     * 议价单编码
     */
    private String bargainingNo;
    
    
    //销售id List")
    private List<Long> saleOrderIdList;
    //sap 订单明细编号
    private List<String> sapOrderItemNoList;
    //sap 订单编号
    private List<String> sapOrderNoList;

    /**
     * 协议价格明细执行时间
     */
    private Date agrItemActiveTime;
    /**
     * 协议价格明细创建时间
     */
    private Date agrItemCreateTime;
    /**
     * 协议价格明细不含税单价
     */
    private BigDecimal agrItemNoTaxPrice;

    /**
     * 分配标识  1.已分配 2.待分配 3.同款价格异常商品
     */
    private Integer allocationFlag;

    /**
     * 分配人ID
     */
    private String allocationUserId;

    /**
     * 分配人名称
     */
    private String allocationName;

    /**
     * 核查结果  1.未核查 2.问题商品 3.超时未核查
     */
    private Integer checkFlag;

    /**
     * 核查人ID
     */
    private String checkUserId;

    /**
     * 核查人名称
     */
    private String checkName;

    /**
     * 问题商品记录ID
     */
    private Long problemSaleItemId;

    /**
     * 价格异常商品标识  1.异常商品，0未异常商品 2.已提交反馈单
     */
    private Integer priceAbnormalFlag;

    /**
     * 商品核查价
     */
    private BigDecimal goodCheckPrice;

    /**
     * 罚款系数
     */
    private BigDecimal penaltyCoefficient;

    /**
     * 追加罚款
     */
    private BigDecimal penaltyFee;

    /**
     * 是否追加罚款  1.已追加 2.无需追加
     */
    private Integer isPenaltyFlag;

    /**
     * 是否追加罚款说明
     */
    private String isPenaltyDesc;

    /**
     * 反馈单ID
     */
    private String feedbackId;

    /**
     * 审批时间
     */
    private Date approvalTime;

    /**
     * 订单编号
     */
    private String saleOrderNo;

    /**
     * 外部销售单编码
     */
    private String saleOrderNoExt;

    /**
     * 专区类型
     */
    private Integer areaType;

    /**
     * 订单状态
     */
    private String saleOrderState;

    /**
     * 订单金额
     */
    private BigDecimal totalSaleFee;

    /**
     * 下单人
     */
    private String createOperName;

    /**
     * 供应商名称
     */
    private String supplierName;

    /**
     * 采购方公司名称
     */
    private String purCompanyName;

    /**
     * 商品类目
     */
    private String l3catalogName;

    /**
     * 订单状态集合
     */
    private List<String> saleOrderStateList;

    /**
     * 采购方公司ID
     */
    private String purCompanyId;

    /**
     * 核查结果集合
     */
    private List<Integer> checkFlagList;

    /**
     * 创建时间开始范围
     */
    private Date createTimeRangeStart;

    /**
     * 创建时间结束范围
     */
    private Date createTimeRangeEnd;

    /**
     * 审批开始时间
     */
    private Date approvalTimeStart;

    /**
     * 审批结束时间
     */
    private Date approvalTimeEnd;

    /**
     * 审批时间开始范围
     */
    private Date approvalTimeRangeStart;

    /**
     * 审批时间结束范围
     */
    private Date approvalTimeRangeEnd;
    /**
     * 反馈单编号
     */
    private String feedbackNo;
    /**
     * 反馈单状态值
     */
    private String feedbackStateCode;
    /**
     * 反馈单状态名称
     */
    private String feedbackStateName;
}
