package com.tydic.dyc.oc.repository.dao;

import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.repository.po.UocStateCalculatorConfPO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * 描述：uoc_state_calculator_conf
 * 
 * @author 文乐
 * @date 2023-07-21 18:06
 **/
@Mapper
@Repository
public interface UocStateCalculatorConfMapper {

	/**
	 * 插入单条数据
	 *
	 * @param uocStateCalculatorConfPo 参数对象
	 * @return int 影响数量
	 */
	int insert(UocStateCalculatorConfPO uocStateCalculatorConfPo);

	/**
	 * 根据条件删除数据
	 *
	 * @param uocStateCalculatorConfPo 参数对象
	 * @return int 影响数量
	 */
	int deleteBy(UocStateCalculatorConfPO uocStateCalculatorConfPo);

	/**
	 * 根据主键更新数据
	 *
	 * @param uocStateCalculatorConfPo 参数对象
	 * @return int 影响数量
	 * @deprecated 无主键表或者由于数据库工具没有读取到主键的情况下不可用
	 */
	@Deprecated
	int updateById(UocStateCalculatorConfPO uocStateCalculatorConfPo);

	/**
	 * 根据条件更新数据
	 *
	 * @param set set新值
	 * @param where where条件（旧值）
	 * @return int 影响数量
	 */
	int updateBy(@Param("set") UocStateCalculatorConfPO set, @Param("where") UocStateCalculatorConfPO where);

	/**
	 * 根据条件校验有多少条数据
	 *
	 * @param uocStateCalculatorConfPo 参数对象
	 * @return int 总数量
	 */
	int getCheckBy(UocStateCalculatorConfPO uocStateCalculatorConfPo);

	/**
	 * 根据条件查询单条数据
	 *
	 * @param uocStateCalculatorConfPo 参数对象
	 * @return UocStateCalculatorConfPO 结果对象
	 */
	UocStateCalculatorConfPO getModelBy(UocStateCalculatorConfPO uocStateCalculatorConfPo);

	/**
	 * 根据条件查询列表数据
	 *
	 * @param uocStateCalculatorConfPo 参数对象
	 * @return List<UocStateCalculatorConfPO> 结果对象
	 */
	List<UocStateCalculatorConfPO> getList(UocStateCalculatorConfPO uocStateCalculatorConfPo);

	/**
	 * 根据条件分页查询列表数据
	 *
	 * @param uocStateCalculatorConfPo 参数对象
	 * @param page 分页参数
	 * @return List<UocStateCalculatorConfPO> 结果对象
	 */
	List<UocStateCalculatorConfPO> getListPage(UocStateCalculatorConfPO uocStateCalculatorConfPo, Page<UocStateCalculatorConfPO> page);

	/**
	 * 批量插入数据
	 *
	 * @param list 参数列表
	 */
	void insertBatch(List<UocStateCalculatorConfPO> list);

}
