package com.tydic.dyc.oc.repository.po;


import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 标题:UocInspOrderItemPo
 * 说明:验收明细
 * 时间:2022-04-01 17:35
 * 作者:罗有
 **/
@Data
@EqualsAndHashCode(callSuper=false)
public class UocInspOrderItemPo implements Serializable {
	private static final long serialVersionUID = -1226543287368976926L;

	//验收明细id")
	private Long inspOrderItemId;

	//订单id")
	private Long orderId;

	//销售单id")
	private Long saleOrderId;

	//销售明细id")
	private Long saleOrderItemId;

	//发货明细id")
	private Long shipOrderItemId;

	//验收单id")
	private Long inspOrderId;

	//状态1 已验收 2 退货申请中             3 退货完成")
	private String inspItemStatus;

	//计量单位")
	private String unitName;

	//验收数量")
	private BigDecimal inspCount;

	//退货中数量")
	private BigDecimal returnCount;

	//已退货数量")
	private BigDecimal alreadyReturnCount;

	//异常变更在途数量")
	private BigDecimal chngingCount;

	//创建时间")
	private Date createTime;

	//创建时间 开始")
	private Date createTimeStart;

	//创建时间 结束")
	private Date createTimeEnd;

	//创建工号")
	private String createOperId;

	//更新时间")
	private Date updateTime;

	//更新时间 开始")
	private Date updateTimeStart;

	//更新时间 结束")
	private Date updateTimeEnd;

	//更新工号")
	private String updateOperId;

	//剩余验收数量")
	private BigDecimal remainInspCount;

	//初始明细数量")
	private BigDecimal initInspCount;

	//备注")
	private String remark;

	//删除标志1已删除")
	private Integer delTag;

	//扩展字段")
	private String extField1;

	//扩展字段")
	private String extField2;

	//扩展字段")
	private String extField3;

	//扩展字段")
	private String extField4;

	//扩展字段")
	private String extField5;

	//排序")
	private String orderBy;

	//销售单idList")
	private List<Long> saleOrderIdList;

	//验收明细id List")
	private List<Long> inspOrderItemIdList;

	//发货明细List")
	private List<Long> shipOrderItemIdList;
	
    //验收单idList （打印验收单用）")
    private List<Long> inspOrderIdList;
    
    //验收明细数量")
    private BigDecimal inspItemCount;
	 //@DocField(value = "归档表后缀")
	private String dataAchiveTabSuffix;
}
