/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.oc.repository.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.db.Page;
import com.tydic.dyc.oc.model.snaporder.UocSnapOrderDo;
import com.tydic.dyc.oc.model.snaporder.qrybo.UocSnapshotOrderItemSameQryListBo;
import com.tydic.dyc.oc.model.snaporder.qrybo.UocSnapshotOrderItemSameQryListReqBo;
import com.tydic.dyc.oc.model.snaporder.qrybo.UocSnapshotOrderItemSameQryListRspBo;
import com.tydic.dyc.oc.model.snaporder.qrybo.UocSnapshotOrderQryListBo;
import com.tydic.dyc.oc.model.snaporder.qrybo.UocSnapshotOrderQryListReqBo;
import com.tydic.dyc.oc.model.snaporder.qrybo.UocSnapshotOrderQryListRspBo;
import com.tydic.dyc.oc.model.snaporder.sub.UocSnapSaleOrderItem;
import com.tydic.dyc.oc.model.snaporder.sub.UocSnapSaleOrderItemSame;
import com.tydic.dyc.oc.repository.UocSnapOrderRepository;
import com.tydic.dyc.oc.repository.dao.UocSnapSaleOrderItemMapper;
import com.tydic.dyc.oc.repository.dao.UocSnapSaleOrderItemSameMapper;
import com.tydic.dyc.oc.repository.dao.UocSnapSaleOrderMapper;
import com.tydic.dyc.oc.repository.po.UocSnapSaleOrderItemPO;
import com.tydic.dyc.oc.repository.po.UocSnapSaleOrderItemSamePO;
import com.tydic.dyc.oc.repository.po.UocSnapSaleOrderPO;
import com.tydic.dyc.oc.utils.IdUtil;
import com.tydic.dyc.oc.utils.UocRu;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UocSnapOrderRepositoryImpl
implements UocSnapOrderRepository {
    private static final Logger log = LoggerFactory.getLogger(UocSnapOrderRepositoryImpl.class);
    @Autowired
    private UocSnapSaleOrderMapper uocSnapSaleOrderMapper;
    @Autowired
    private UocSnapSaleOrderItemMapper uocSnapSaleOrderItemMapper;
    @Autowired
    private UocSnapSaleOrderItemSameMapper uocSnapSaleOrderItemSameMapper;

    public void createSnapOrder(UocSnapOrderDo uocSnapOrderDo) {
        UocSnapSaleOrderPO uocSnapSaleOrderPO = this.addUocSnapSaleOrder(uocSnapOrderDo);
        for (UocSnapSaleOrderItem uocSnapSaleOrderItem : uocSnapOrderDo.getUocSnapSaleOrderItemList()) {
            UocSnapSaleOrderItemPO uocSnapSaleOrderItemPO = this.addUocSnapSaleOrderItem(uocSnapSaleOrderItem, uocSnapSaleOrderPO);
            this.addUocSnapSaleOrderItemSame(uocSnapSaleOrderItem.getUocSnapSaleOrderItemSameList(), uocSnapSaleOrderItemPO);
        }
    }

    private UocSnapSaleOrderPO addUocSnapSaleOrder(UocSnapOrderDo uocSnapOrderDo) {
        UocSnapSaleOrderPO qryUocSnapSaleOrder = new UocSnapSaleOrderPO();
        qryUocSnapSaleOrder.setOrderId(uocSnapOrderDo.getOrderId());
        qryUocSnapSaleOrder.setSaleOrderId(uocSnapOrderDo.getSaleOrderId());
        UocSnapSaleOrderPO uocSnapSaleOrderPO = this.uocSnapSaleOrderMapper.getModelBy(qryUocSnapSaleOrder);
        if (ObjectUtil.isNotEmpty((Object)uocSnapSaleOrderPO)) {
            return uocSnapSaleOrderPO;
        }
        UocSnapSaleOrderPO addUocSnapSaleOrder = (UocSnapSaleOrderPO)UocRu.js((Object)uocSnapOrderDo, UocSnapSaleOrderPO.class);
        addUocSnapSaleOrder.setSnapshotId(IdUtil.nextId());
        this.uocSnapSaleOrderMapper.insert(addUocSnapSaleOrder);
        return addUocSnapSaleOrder;
    }

    private UocSnapSaleOrderItemPO addUocSnapSaleOrderItem(UocSnapSaleOrderItem uocSnapSaleOrderItem, UocSnapSaleOrderPO uocSnapSaleOrderPO) {
        UocSnapSaleOrderItemPO qryUocSnapSaleOrderItem = new UocSnapSaleOrderItemPO();
        qryUocSnapSaleOrderItem.setSnapshotId(uocSnapSaleOrderPO.getSnapshotId());
        qryUocSnapSaleOrderItem.setSkuId(uocSnapSaleOrderItem.getSkuId());
        UocSnapSaleOrderItemPO uocSnapSaleOrderItemPO = this.uocSnapSaleOrderItemMapper.getModelBy(qryUocSnapSaleOrderItem);
        if (ObjectUtil.isNotEmpty((Object)uocSnapSaleOrderItemPO)) {
            return uocSnapSaleOrderItemPO;
        }
        UocSnapSaleOrderItemPO addUocSnapSaleOrderItemPO = (UocSnapSaleOrderItemPO)UocRu.js((Object)uocSnapSaleOrderItem, UocSnapSaleOrderItemPO.class);
        addUocSnapSaleOrderItemPO.setSnapshotItemId(IdUtil.nextId());
        addUocSnapSaleOrderItemPO.setSnapshotId(uocSnapSaleOrderPO.getSnapshotId());
        this.uocSnapSaleOrderItemMapper.insert(addUocSnapSaleOrderItemPO);
        return addUocSnapSaleOrderItemPO;
    }

    private void addUocSnapSaleOrderItemSame(List<UocSnapSaleOrderItemSame> uocSnapSaleOrderItemSameList, UocSnapSaleOrderItemPO uocSnapSaleOrderItemPO) {
        if (!CollectionUtils.isEmpty(uocSnapSaleOrderItemSameList)) {
            List addUocSnapSaleOrderItemSameList = UocRu.jsl(uocSnapSaleOrderItemSameList, UocSnapSaleOrderItemSamePO.class);
            for (UocSnapSaleOrderItemSamePO addUocSnapSaleOrderItemSame : addUocSnapSaleOrderItemSameList) {
                addUocSnapSaleOrderItemSame.setSameId(IdUtil.nextId());
                addUocSnapSaleOrderItemSame.setSnapshotItemId(uocSnapSaleOrderItemPO.getSnapshotItemId());
            }
            this.uocSnapSaleOrderItemSameMapper.insertBatch(addUocSnapSaleOrderItemSameList);
        }
    }

    public UocSnapshotOrderQryListRspBo qryUocSnapshotOrderList(UocSnapshotOrderQryListReqBo reqBo) {
        UocSnapshotOrderQryListRspBo rspBo = new UocSnapshotOrderQryListRspBo();
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        UocSnapSaleOrderItemPO uocSnapSaleOrderItemPO = (UocSnapSaleOrderItemPO)UocRu.js((Object)reqBo, UocSnapSaleOrderItemPO.class);
        uocSnapSaleOrderItemPO.setOrderBy("usso.create_time DESC, ussoi.sku_code DESC");
        List<UocSnapSaleOrderItemPO> listPage = this.uocSnapSaleOrderItemMapper.getSnapshotOrderListPage(uocSnapSaleOrderItemPO, (Page<UocSnapSaleOrderItemPO>)page);
        if (CollectionUtils.isEmpty(listPage)) {
            rspBo.setPageNo(reqBo.getPageNo());
            rspBo.setRecordsTotal(0);
            rspBo.setTotal(0);
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        List uocSnapshotOrderQryListBoList = UocRu.jsl(listPage, UocSnapshotOrderQryListBo.class);
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRows(uocSnapshotOrderQryListBoList);
        return rspBo;
    }

    public UocSnapshotOrderItemSameQryListRspBo qryUocSnapshotOrderItemSameList(UocSnapshotOrderItemSameQryListReqBo reqBo) {
        UocSnapshotOrderItemSameQryListRspBo rspBo = new UocSnapshotOrderItemSameQryListRspBo();
        Page page = new Page(reqBo.getPageNo(), reqBo.getPageSize());
        UocSnapSaleOrderItemSamePO uocSnapSaleOrderItemSamePO = (UocSnapSaleOrderItemSamePO)UocRu.js((Object)reqBo, UocSnapSaleOrderItemSamePO.class);
        uocSnapSaleOrderItemSamePO.setOrderBy("sale_price DESC");
        List<UocSnapSaleOrderItemSamePO> listPage = this.uocSnapSaleOrderItemSameMapper.getListPage(uocSnapSaleOrderItemSamePO, (Page<UocSnapSaleOrderItemSamePO>)page);
        if (CollectionUtils.isEmpty(listPage)) {
            rspBo.setPageNo(reqBo.getPageNo());
            rspBo.setRecordsTotal(0);
            rspBo.setTotal(0);
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        List uocSnapshotOrderItemSameQryListBoList = UocRu.jsl(listPage, UocSnapshotOrderItemSameQryListBo.class);
        rspBo.setPageNo(reqBo.getPageNo());
        rspBo.setRecordsTotal(page.getTotalCount());
        rspBo.setTotal(page.getTotalPages());
        rspBo.setRows(uocSnapshotOrderItemSameQryListBoList);
        return rspBo;
    }
}

