/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.jn.atom.act.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.service.api.DycActDealFscGetInvoiceItemService;
import com.tydic.dyc.act.service.api.DycActQueryFscInvoicePageListService;
import com.tydic.dyc.act.service.api.DycActQueryFscOrderDetailService;
import com.tydic.dyc.act.service.bo.DycActDealFscGetInvoiceItemReqBO;
import com.tydic.dyc.act.service.bo.DycActFscInvoiceInfoBO;
import com.tydic.dyc.act.service.bo.DycActFscItemInfoBO;
import com.tydic.dyc.act.service.bo.DycActQueryFscInvoicePageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryFscInvoicePageListRspBO;
import com.tydic.dyc.act.service.bo.DycActQueryFscOrderDetailReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryFscOrderDetailRspBO;
import com.tydic.dyc.atom.busicommon.api.DycAbilityAfterInvokeFunction;
import com.tydic.dyc.atom.busicommon.bo.DycAbilityAfterInvokeFuncReqBO;
import com.tydic.jn.atom.act.api.DycActDealInvoiceItemFunc;
import com.tydic.jn.atom.act.api.DycActGetInvoiceItemFunc;
import com.tydic.jn.atom.act.api.DycActSendDealInvoiceItemNoticeFunc;
import com.tydic.jn.atom.act.bo.DycActDealInvoiceItemFuncReqBO;
import com.tydic.jn.atom.act.bo.DycActGetInvoiceItemFuncReqBO;
import com.tydic.jn.atom.act.bo.DycActGetInvoiceItemFuncRspBO;
import com.tydic.jn.atom.act.bo.DycActInvoiceItemExternalBO;
import com.tydic.jn.atom.act.bo.DycActSendDealInvoiceItemNoticeFuncReqBO;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycActDealInvoiceItemFuncImpl
implements DycActDealInvoiceItemFunc {
    private static final Logger log = LoggerFactory.getLogger(DycActDealInvoiceItemFuncImpl.class);
    @Autowired
    private DycActGetInvoiceItemFunc dycActGetInvoiceItemFunc;
    @Autowired
    private DycActQueryFscInvoicePageListService dycActQueryFscInvoicePageListService;
    @Autowired
    private DycActDealFscGetInvoiceItemService dycActDealFscGetInvoiceItemService;
    @Autowired
    private DycAbilityAfterInvokeFunction dycAbilityAfterInvokeFunction;
    @Autowired
    private DycActQueryFscOrderDetailService dycActQueryFscOrderDetailService;
    @Autowired
    private DycActSendDealInvoiceItemNoticeFunc dycActSendDealInvoiceItemNoticeFunc;
    @Autowired
    private CacheClient cacheClient;
    private final String getInvoiceStr = "ReGetInvoice";

    @Override
    @Async
    public void dealFscInvoiceItem(DycActDealInvoiceItemFuncReqBO reqBO) {
        log.info("\u5f02\u6b65\u83b7\u53d6\u53d1\u7968\u660e\u7ec6\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        if ("1".equals(reqBO.getDealFlag())) {
            Long fscOrderId;
            List<DycActFscInvoiceInfoBO> invoiceList = this.getInvoiceList(reqBO);
            for (DycActFscInvoiceInfoBO invoiceBO : invoiceList) {
                DycActInvoiceItemExternalBO dycActInvoiceItemExternalBO = null;
                try {
                    dycActInvoiceItemExternalBO = this.getInvoiceItemList(invoiceBO.getInvoiceCode(), invoiceBO.getInvoiceNo(), reqBO.getSupplierId());
                    if (dycActInvoiceItemExternalBO == null) continue;
                    List<DycActFscItemInfoBO> itemInfoBOS = this.assembleInvoiceItem(dycActInvoiceItemExternalBO, reqBO.getFscOrderId(), invoiceBO.getInvoiceId());
                    this.saveInvoiceItem(reqBO.getFscOrderId(), invoiceBO.getInvoiceId(), itemInfoBOS);
                }
                catch (Exception e) {
                    log.info("\u5f53\u524d\u53d1\u7968\u53f7\u7801{}\u660e\u7ec6\u6570\u636e\u83b7\u53d6\u5f02\u5e38.", (Object)invoiceBO.getInvoiceNo());
                    this.invokeAfterService(reqBO, "\u7ed3\u7b97\u5355" + reqBO.getFscOrderId() + "\u83b7\u53d6\u53d1\u7968\u660e\u7ec6\u6570\u636e\u83b7\u53d6\u5f02\u5e38");
                    break;
                }
            }
            if ((fscOrderId = (Long)this.cacheClient.get("ReGetInvoice" + reqBO.getFscOrderId())) != null) {
                this.cacheClient.delete("ReGetInvoice" + reqBO.getFscOrderId());
            }
        } else if ("2".equals(reqBO.getDealFlag())) {
            try {
                DycActInvoiceItemExternalBO dycActInvoiceItemExternalBO = this.getInvoiceItemList(reqBO.getInvoiceCode(), reqBO.getInvoiceNo(), reqBO.getSupplierId());
                if (dycActInvoiceItemExternalBO != null) {
                    List<DycActFscItemInfoBO> itemInfoBOS = this.assembleInvoiceItem(dycActInvoiceItemExternalBO, reqBO.getFscOrderId(), reqBO.getInvoiceId());
                    this.saveInvoiceItem(reqBO.getFscOrderId(), reqBO.getInvoiceId(), itemInfoBOS);
                }
            }
            catch (Exception e) {
                log.info("\u5f53\u524d\u53d1\u7968\u53f7\u7801{}\u660e\u7ec6\u6570\u636e\u83b7\u53d6\u5f02\u5e38.", (Object)reqBO.getInvoiceNo());
            }
        } else {
            throw new ZTBusinessException("\u83b7\u53d6\u53d1\u7968\u660e\u7ec6\u670d\u52a1\u5904\u7406\u7c7b\u578b\u6709\u8bef");
        }
        this.invokeAfterService(reqBO, "");
        try {
            if (DycActivityConstants.FSC_ORDER_STATE.INVOICING.equals(reqBO.getOrderState())) {
                this.sendDealInvoiceItemNotice(reqBO);
            }
        }
        catch (Exception e) {
            log.error("\u4f9b\u5e94\u5546\u53d1\u7968\u4fe1\u606f\u56de\u4f20\u5b8c\u6210\u540e\u9700\u8981\u53d1\u9001\u5f85\u529e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
    }

    private void sendDealInvoiceItemNotice(DycActDealInvoiceItemFuncReqBO reqBO) {
        DycActQueryFscOrderDetailReqBO dycActQueryFscOrderDetailReqBO = new DycActQueryFscOrderDetailReqBO();
        dycActQueryFscOrderDetailReqBO.setFscOrderId(reqBO.getFscOrderId());
        DycActQueryFscOrderDetailRspBO dycActQueryFscOrderDetailRspBO = this.dycActQueryFscOrderDetailService.queryFscOrderDetail(dycActQueryFscOrderDetailReqBO);
        if (!"0000".equals(dycActQueryFscOrderDetailRspBO.getRespCode())) {
            throw new ZTBusinessException(dycActQueryFscOrderDetailRspBO.getRespDesc());
        }
        if (DycActivityConstants.FSC_ORDER_STATE.INVOICED.equals(dycActQueryFscOrderDetailRspBO.getOrderState())) {
            DycActSendDealInvoiceItemNoticeFuncReqBO dycActSendDealInvoiceItemNoticeFuncReqBo = new DycActSendDealInvoiceItemNoticeFuncReqBO();
            dycActSendDealInvoiceItemNoticeFuncReqBo.setFscOrderId(dycActQueryFscOrderDetailRspBO.getFscOrderId());
            dycActSendDealInvoiceItemNoticeFuncReqBo.setObjId(dycActQueryFscOrderDetailRspBO.getFscOrderId());
            dycActSendDealInvoiceItemNoticeFuncReqBo.setShareId(dycActQueryFscOrderDetailRspBO.getFscOrderId());
            dycActSendDealInvoiceItemNoticeFuncReqBo.setFscOrderNo(dycActQueryFscOrderDetailRspBO.getOrderNo());
            dycActSendDealInvoiceItemNoticeFuncReqBo.setCenter("JN_FSC");
            dycActSendDealInvoiceItemNoticeFuncReqBo.setAuditUserIds(Collections.singletonList(dycActQueryFscOrderDetailRspBO.getCreateUserId()));
            this.dycActSendDealInvoiceItemNoticeFunc.sendDealInvoiceItemNotice(dycActSendDealInvoiceItemNoticeFuncReqBo);
        }
    }

    List<DycActFscInvoiceInfoBO> getInvoiceList(DycActDealInvoiceItemFuncReqBO reqBO) {
        DycActQueryFscInvoicePageListReqBO dycActQueryFscInvoicePageListReqBO = new DycActQueryFscInvoicePageListReqBO();
        dycActQueryFscInvoicePageListReqBO.setFscOrderId(reqBO.getFscOrderId());
        dycActQueryFscInvoicePageListReqBO.setPageNo(1);
        dycActQueryFscInvoicePageListReqBO.setPageSize(100);
        DycActQueryFscInvoicePageListRspBO dycActQueryFscInvoicePageListRspBO = this.dycActQueryFscInvoicePageListService.queryFscInvoicePageList(dycActQueryFscInvoicePageListReqBO);
        if (dycActQueryFscInvoicePageListRspBO == null) {
            throw new ZTBusinessException("\u67e5\u8be2\u5f53\u524d\u7ed3\u7b97\u5355\u7684\u53d1\u7968\u4fe1\u606f\u5f02\u5e38");
        }
        if (CollectionUtils.isEmpty((Collection)dycActQueryFscInvoicePageListRspBO.getRows())) {
            throw new ZTBusinessException("\u67e5\u8be2\u5f53\u524d\u7ed3\u7b97\u5355\u7684\u53d1\u7968\u4fe1\u606f\u65e0\u6570\u636e");
        }
        return dycActQueryFscInvoicePageListRspBO.getRows();
    }

    DycActInvoiceItemExternalBO getInvoiceItemList(String invoiceCode, String invoiceNo, Long supplierId) {
        DycActGetInvoiceItemFuncReqBO dycActGetInvoiceItemFuncReqBO = new DycActGetInvoiceItemFuncReqBO();
        dycActGetInvoiceItemFuncReqBO.setInvoiceCode(invoiceCode);
        dycActGetInvoiceItemFuncReqBO.setInvoiceId(invoiceNo);
        dycActGetInvoiceItemFuncReqBO.setSupplierId(supplierId.toString());
        DycActGetInvoiceItemFuncRspBO dycActGetInvoiceItemFuncRspBO = this.dycActGetInvoiceItemFunc.getInvoiceItemInfo(dycActGetInvoiceItemFuncReqBO);
        if (dycActGetInvoiceItemFuncRspBO == null) {
            throw new ZTBusinessException("\u67e5\u8be2\u5f53\u524d\u53d1\u7968\u660e\u7ec6\u4fe1\u606f\u8fd4\u56denull");
        }
        if (dycActGetInvoiceItemFuncRspBO.getResult() == null) {
            throw new ZTBusinessException("\u67e5\u8be2\u5f53\u524d\u53d1\u7968\u660e\u7ec6\u4fe1\u606f\u8fd4\u56de\u7a7a");
        }
        return dycActGetInvoiceItemFuncRspBO.getResult();
    }

    void saveInvoiceItem(Long fscOrderId, Long invoiceId, List<DycActFscItemInfoBO> itemInfoBOS) {
        DycActDealFscGetInvoiceItemReqBO dycActDealFscGetInvoiceItemReqBO = new DycActDealFscGetInvoiceItemReqBO();
        dycActDealFscGetInvoiceItemReqBO.setFscOrderId(fscOrderId);
        dycActDealFscGetInvoiceItemReqBO.setInvoiceId(invoiceId);
        dycActDealFscGetInvoiceItemReqBO.setInvoiceItemList(itemInfoBOS);
        this.dycActDealFscGetInvoiceItemService.dealFscGetInvoiceItem(dycActDealFscGetInvoiceItemReqBO);
    }

    List<DycActFscItemInfoBO> assembleInvoiceItem(DycActInvoiceItemExternalBO dycActInvoiceItemExternalBO, Long fscOrderId, Long invoiceId) {
        List<DycActFscItemInfoBO> dycActFscItemInfoBOS = dycActInvoiceItemExternalBO.getSkuDetails().stream().map(item -> {
            DycActFscItemInfoBO dycActFscItemInfoBO = new DycActFscItemInfoBO();
            BeanUtils.copyProperties((Object)item, (Object)dycActFscItemInfoBO);
            dycActFscItemInfoBO.setFscOrderId(fscOrderId);
            dycActFscItemInfoBO.setInvoiceId(invoiceId);
            dycActFscItemInfoBO.setUnit(item.getSettleUnit());
            dycActFscItemInfoBO.setSpec(item.getSpecification());
            dycActFscItemInfoBO.setOrderId(Long.valueOf(Long.parseLong(item.getJdOrderId())));
            dycActFscItemInfoBO.setAmt(item.getAmount());
            dycActFscItemInfoBO.setUntaxAmt(item.getAmountUnTax());
            dycActFscItemInfoBO.setTaxAmt(item.getTaxAmount());
            return dycActFscItemInfoBO;
        }).collect(Collectors.toList());
        return dycActFscItemInfoBOS;
    }

    private void invokeAfterService(DycActDealInvoiceItemFuncReqBO reqBO, String excepStr) {
        DycAbilityAfterInvokeFuncReqBO dycAbilityAfterInvokeFuncReqBO = new DycAbilityAfterInvokeFuncReqBO();
        dycAbilityAfterInvokeFuncReqBO.setTraceId(reqBO.getTraceId());
        dycAbilityAfterInvokeFuncReqBO.setMqMsgId(reqBO.getMqMsgId());
        dycAbilityAfterInvokeFuncReqBO.setBusiCenterCode(reqBO.getBusiCenterCode());
        dycAbilityAfterInvokeFuncReqBO.setException(excepStr);
        this.dycAbilityAfterInvokeFunction.invokeAfter(dycAbilityAfterInvokeFuncReqBO);
    }
}

