/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.jn.atom.act.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.atom.base.utils.DycEsbParamUtil;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.fsc.constants.FscConstants;
import com.tydic.jn.atom.act.api.DycActFscInvoiceSubmitExternalFunc;
import com.tydic.jn.atom.act.bo.DycActFscInvoiceSubmitExternalFuncReqBO;
import com.tydic.jn.atom.act.bo.DycActFscInvoiceSubmitExternalFuncRspBO;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class DycActFscInvoiceSubmitExternalFuncImpl
implements DycActFscInvoiceSubmitExternalFunc {
    private static final Logger log = LoggerFactory.getLogger(DycActFscInvoiceSubmitExternalFuncImpl.class);
    @Autowired
    private Environment environment;
    private static final String JD_SUP_ID = "JD_SUP_ID";
    @Value(value="${esb.invoiceApply.url:http://39.106.83.78:8001/OSN/api/invoiceApply/v1}")
    private String URL;
    @Value(value="${esb.invoiceApply.jdSuccess:0004}")
    private String JD_SUCCESS_CODE;
    @Value(value="${esb.invoiceApply.jd.org:101}")
    private String BASIC_INVOICE_ORG_JD;
    private static final String ZORE = "0";
    @Value(value="${isInvokeExternal}")
    private Boolean isInvokeExternal;
    @Value(value="${BillingType:1}")
    private Integer billingType;

    @Override
    public DycActFscInvoiceSubmitExternalFuncRspBO submitInvoice(DycActFscInvoiceSubmitExternalFuncReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u5f00\u7968\u63d0\u4ea4\u8bf7\u6c42\u7535\u5546\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)reqBO));
        }
        this.initReqBO(reqBO);
        JSONObject jsonObject = JSON.parseObject((String)JSON.toJSONString((Object)reqBO));
        if (reqBO.getSupplierId().equals(this.environment.getProperty(JD_SUP_ID))) {
            jsonObject.put("supplierOrder", (Object)StringUtils.join((Object[])reqBO.getExtOrderNos().toArray(), (String)","));
        } else {
            jsonObject.put("supplierOrder", reqBO.getExtOrderNos());
        }
        jsonObject.remove((Object)"extOrderNos");
        jsonObject.put("billingType", (Object)this.billingType);
        String reqEsbJson = DycEsbParamUtil.getEsbReqStr((String)JSON.toJSONString((Object)jsonObject), (String)"jdvop", (String)"BUSINESS_PAY");
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42ESB\u7535\u5546\u5f00\u7968\u63d0\u4ea4\u5165\u53c2:{},URL:{}", (Object)reqEsbJson, (Object)this.URL);
        }
        String rspJson = "";
        rspJson = this.isInvokeExternal != false ? SSLClient.doPost((String)this.URL, (String)reqEsbJson) : "{\n  \"success\": true,\n  \"resultMessage\": \"\u64cd\u4f5c\u6210\u529f\uff0c\u53d1\u7968\u90ae\u5bc4\u65b9\u5f0f\u4e3a\uff1a\u5feb\u9012\u914d\u9001\",\n  \"resultCode\": \"0004\",\n  \"result\": true\n}\n";
        if (log.isDebugEnabled()) {
            log.debug("\u8bf7\u6c42ESB\u7535\u5546\u5f00\u7968\u63d0\u4ea4\u51fa\u53c2:{}", (Object)rspJson);
        }
        if (StringUtils.isBlank((CharSequence)rspJson)) {
            throw new ZTBusinessException("\u8bf7\u6c42\u8bf7\u6c42ESB\u7535\u5546\u5f00\u7968\u63d0\u4ea4\u63a5\u53e3\u8fd4\u56de\u7a7a");
        }
        DycActFscInvoiceSubmitExternalFuncRspBO rspBO = (DycActFscInvoiceSubmitExternalFuncRspBO)((Object)JSON.parseObject((String)rspJson, DycActFscInvoiceSubmitExternalFuncRspBO.class));
        if (reqBO.getSupplierId().equals(this.environment.getProperty(JD_SUP_ID)) ? !this.JD_SUCCESS_CODE.equals(rspBO.getResultCode()) : StringUtils.isNotBlank((CharSequence)rspBO.getResultCode()) && !"0000".equals(rspBO.getResultCode())) {
            throw new ZTBusinessException(rspBO.getResultMessage());
        }
        return rspBO;
    }

    private void initReqBO(DycActFscInvoiceSubmitExternalFuncReqBO reqBO) {
        String jdSupId = this.environment.getProperty(JD_SUP_ID);
        if (reqBO.getSupplierId().equals(jdSupId)) {
            reqBO.setEnterpriseBankAccount(reqBO.getAccount());
            reqBO.setEnterpriseBankName(reqBO.getBank());
            reqBO.setEnterpriseRegAddress(reqBO.getAddress());
            reqBO.setEnterpriseRegPhone(reqBO.getPhone());
            reqBO.setInvoiceOrg(this.BASIC_INVOICE_ORG_JD);
        }
        if (null == reqBO.getTotalBatch()) {
            reqBO.setTotalBatch(1);
        }
        if (null == reqBO.getCurrentBatch()) {
            reqBO.setCurrentBatch(1);
        }
        if (null == reqBO.getBizInvoiceContent()) {
            reqBO.setBizInvoiceContent(FscConstants.BASIC_INVOICE_CONTENT);
        }
        if (null == reqBO.getInvoiceOrg()) {
            reqBO.setInvoiceOrg("6");
        }
        if (null == reqBO.getInvoiceNum()) {
            reqBO.setInvoiceNum(reqBO.getExtOrderNos().size());
        }
        if (null == reqBO.getTotalBatchInvoiceAmount()) {
            reqBO.setTotalBatchInvoiceAmount(reqBO.getTotalCharge());
        }
        if (null == reqBO.getBillDate()) {
            reqBO.setBillDate(DateUtils.dateToStr((Date)new Date()));
        }
        if (StringUtils.isBlank((CharSequence)reqBO.getTownCode())) {
            reqBO.setTownCode(ZORE);
        }
        if (reqBO.getSupplierId().equals(this.environment.getProperty(JD_SUP_ID))) {
            if ("00".equals(reqBO.getInvoiceType())) {
                reqBO.setInvoiceType("24");
            } else {
                reqBO.setInvoiceType("23");
            }
        } else {
            reqBO.setInvoiceType(Convert.toStr((Object)FscConstants.invoiceCombine((Integer)reqBO.getInvoiceCategory(), (String)reqBO.getInvoiceType())));
        }
    }
}

