/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.jn.atom.act.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.jn.atom.act.api.DycSaasActActivitySyncInfoFunc;
import com.tydic.jn.atom.act.bo.DycSaasActSyncInfoFuncRepBO;
import com.tydic.jn.atom.act.bo.OpenRpcActResult;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycSaasActActivitySyncInfoFuncImpl
implements DycSaasActActivitySyncInfoFunc {
    private static final Logger log = LoggerFactory.getLogger(DycSaasActActivitySyncInfoFuncImpl.class);
    @Value(value="${ESB_ACT_ADD_UPDATE_ACTIVITY:${ESB_ACCESS_IP}/OSN/api/bbcAddOrUpdateActivity/v1}")
    private String ESB_ACT_ADD_UPDATE_ACTIVITY;
    private static final Integer OPER_TYPE_CHANGE = 2;

    @Override
    public OpenRpcActResult activitySync(DycSaasActSyncInfoFuncRepBO repBO) {
        JSONObject activityExecuteDTO = new JSONObject();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("activityName", (Object)repBO.getActivityName());
        String startDate = sdf.format(repBO.getActivityStartTime());
        String endDate = sdf.format(repBO.getActivityEndTime());
        jsonObject.put("startDate", (Object)startDate);
        jsonObject.put("endDate", (Object)endDate);
        if (OPER_TYPE_CHANGE.equals(repBO.getOperType())) {
            jsonObject.put("activityCode", (Object)repBO.getExtActivityId());
        }
        JSONObject payInfo = new JSONObject();
        payInfo.put("payType", (Object)5);
        if (2 == repBO.getActivityPayMode()) {
            JSONObject mixPayTypeDto = new JSONObject();
            mixPayTypeDto.put("enterprise", (Object)"1");
            mixPayTypeDto.put("personal", (Object)"1");
            payInfo.put("mixPayTypeDto", (Object)mixPayTypeDto);
        }
        jsonObject.put("payInfo", (Object)payInfo);
        JSONObject invoiceInfo = new JSONObject();
        if (1 == repBO.getInvoiceType()) {
            JSONObject vatInvoiceInfo = new JSONObject();
            vatInvoiceInfo.put("vatMethod", (Object)1);
            vatInvoiceInfo.put("vatTitle", (Object)repBO.getInvoiceTitle());
            vatInvoiceInfo.put("vatTaxId", (Object)repBO.getInvoiceTaxpayerId());
            vatInvoiceInfo.put("vatContent", (Object)0);
            vatInvoiceInfo.put("vatOrEleInvoiceValue", (Object)0);
            vatInvoiceInfo.put("companyRegistAddr", (Object)repBO.getInvoiceAddress());
            vatInvoiceInfo.put("companyRegistPhone", (Object)repBO.getInvoicePhone());
            vatInvoiceInfo.put("companyRegistBank", (Object)repBO.getInvoiceBank());
            vatInvoiceInfo.put("companyRegistBankAccount", (Object)repBO.getInvoiceBankAccount());
            invoiceInfo.put("vatInvoiceInfo", (Object)vatInvoiceInfo);
        } else if (2 == repBO.getInvoiceType()) {
            JSONObject generalInvoiceInfo = new JSONObject();
            generalInvoiceInfo.put("generalMethod", (Object)1);
            generalInvoiceInfo.put("generalTitle", (Object)repBO.getInvoiceTitle());
            generalInvoiceInfo.put("generalTaxId", (Object)repBO.getInvoiceTaxpayerId());
            generalInvoiceInfo.put("generalContent", (Object)0);
            generalInvoiceInfo.put("invoicePhone", (Object)repBO.getContactPhone());
            generalInvoiceInfo.put("invoiceEmail", (Object)repBO.getContactEmial());
            invoiceInfo.put("generalInvoiceInfo", (Object)generalInvoiceInfo);
        }
        jsonObject.put("invoiceInfo", (Object)invoiceInfo);
        JSONObject extend = new JSONObject();
        extend.put("activityLabelCode", (Object)repBO.getActivitySceneCode());
        extend.put("activityLabelValue", (Object)repBO.getActivitySceneName());
        extend.put("activityRemark1", (Object)repBO.getRemark());
        jsonObject.put("extend", (Object)extend);
        activityExecuteDTO.put("activityExecuteDTO", (Object)jsonObject);
        activityExecuteDTO.put("hsn", (Object)"jdsdk");
        log.info("\u540c\u6b65\u6d3b\u52a8\u5230\u4eac\u4e1c\u5165\u53c2\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)activityExecuteDTO));
        String rspJson = SSLClient.doPost((String)this.ESB_ACT_ADD_UPDATE_ACTIVITY, (String)JSONObject.toJSONString((Object)activityExecuteDTO));
        log.info("\u540c\u6b65\u6d3b\u52a8\u5230\u4eac\u4e1c\u51fa\u53c2\u4fe1\u606f\uff1a{}", (Object)rspJson);
        OpenRpcActResult rspBO = this.rsp(rspJson);
        return rspBO;
    }

    private OpenRpcActResult rsp(String rspJson) {
        OpenRpcActResult rspBO = new OpenRpcActResult();
        try {
            rspBO = (OpenRpcActResult)JSON.parseObject((String)rspJson, OpenRpcActResult.class);
            if (!rspBO.getSuccess().booleanValue()) {
                rspBO.setResultMessage(rspJson);
            }
        }
        catch (Exception e) {
            rspBO.setSuccess(false);
            rspBO.setResultMessage(rspJson);
        }
        return rspBO;
    }
}

