/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.jn.atom.act.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.jn.atom.act.api.DycSaasActActivityUserScoresSyncInfoFunc;
import com.tydic.jn.atom.act.bo.BatchAddOrUpdateAssetResponse;
import com.tydic.jn.atom.act.bo.DycActActivityUserInfoDO;
import com.tydic.jn.atom.act.bo.DycActActivityUserInfoReqBO;
import com.tydic.jn.atom.act.bo.OpenRpcResult;
import com.tydic.jn.atom.act.bo.UserBatchExecuteVO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycSaasActActivityUserScoresSyncInfoFuncImpl
implements DycSaasActActivityUserScoresSyncInfoFunc {
    private static final Logger log = LoggerFactory.getLogger(DycSaasActActivityUserScoresSyncInfoFuncImpl.class);
    @Value(value="${ESB_ACT_BATCH_ADD_UPDATE_ASSET:${ESB_ACCESS_IP}/OSN/api/bbcBatchAddOrUpdateAsset/v1}")
    private String ESB_ACT_BATCH_ADD_UPDATE_ASSET;
    @Value(value="${sync_scores_size:150}")
    private String sync_scores_size;

    @Override
    public BatchAddOrUpdateAssetResponse activityUserScoresSync(DycActActivityUserInfoDO reqBO) {
        int total = reqBO.getDate().size();
        int batchSize = Integer.valueOf(this.sync_scores_size);
        int totalBatch = (total + batchSize - 1) / batchSize;
        Boolean flag = false;
        Integer failtureNum = 0;
        ArrayList<String> errorList = new ArrayList<String>();
        for (int batchIndex = 0; batchIndex < totalBatch; ++batchIndex) {
            int startIndex = batchIndex * batchSize;
            int endIndex = Math.min((batchIndex + 1) * batchSize, total);
            List<DycActActivityUserInfoReqBO> subList = reqBO.getDate().subList(startIndex, endIndex);
            JSONObject jsonObject = new JSONObject();
            JSONObject batchAddOrUpdateAssetDTO = new JSONObject();
            batchAddOrUpdateAssetDTO.put("appKey", (Object)"");
            JSONArray addOrUpdateAssertReq = new JSONArray();
            subList.forEach(item -> {
                JSONObject object = new JSONObject();
                object.put("assets", (Object)item.getGiveScores());
                object.put("personId", (Object)item.getActUserId());
                object.put("type", (Object)4);
                object.put("projectId", (Object)reqBO.getExtActivityId());
                addOrUpdateAssertReq.add((Object)object);
            });
            batchAddOrUpdateAssetDTO.put("addOrUpdateAssertReq", (Object)addOrUpdateAssertReq);
            jsonObject.put("batchAddOrUpdateAssetDTO", (Object)batchAddOrUpdateAssetDTO);
            jsonObject.put("hsn", (Object)"jdsdk");
            log.info("\u540c\u6b65\u79ef\u5206\u5230\u4eac\u4e1c\u5165\u53c2\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)jsonObject));
            String rspJson = SSLClient.doPost((String)this.ESB_ACT_BATCH_ADD_UPDATE_ASSET, (String)JSONObject.toJSONString((Object)jsonObject));
            log.info("\u540c\u6b65\u79ef\u5206\u5230\u4eac\u4e1c\u51fa\u53c2\u4fe1\u606f\uff1a{}", (Object)rspJson);
            OpenRpcResult rspTempBO = this.rsp(rspJson);
            if (!rspTempBO.getSuccess().booleanValue()) {
                flag = true;
                errorList.add(rspTempBO.getResultMessage());
            }
            if (rspTempBO.getResult().getFailtureNum() <= 0) continue;
            failtureNum = failtureNum + rspTempBO.getResult().getFailtureNum();
            errorList.add(JSON.toJSONString(rspTempBO.getResult().getFailtureList()));
        }
        BatchAddOrUpdateAssetResponse rspBO = new BatchAddOrUpdateAssetResponse();
        OpenRpcResult result = new OpenRpcResult();
        UserBatchExecuteVO executeVO = new UserBatchExecuteVO();
        executeVO.setFailtureNum(failtureNum);
        result.setResult(executeVO);
        if (flag.booleanValue()) {
            result.setSuccess(false);
            result.setResultMessage(JSON.toJSONString(errorList));
        } else {
            result.setSuccess(true);
        }
        rspBO.setOpenRpcResult(result);
        return rspBO;
    }

    private OpenRpcResult rsp(String rspJson) {
        OpenRpcResult rspBO = new OpenRpcResult();
        try {
            rspBO = (OpenRpcResult)JSON.parseObject((String)rspJson, OpenRpcResult.class);
            if (!rspBO.getSuccess().booleanValue()) {
                rspBO.setResultMessage(rspJson);
            }
        }
        catch (Exception e) {
            rspBO.setSuccess(false);
            rspBO.setResultMessage(rspJson);
        }
        return rspBO;
    }
}

