/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.jn.atom.act.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.service.api.DycActDealFscOrderStateUpdService;
import com.tydic.dyc.act.service.api.DycActFscOrderRelationQryListService;
import com.tydic.dyc.act.service.api.DycActFscOrderSubmitInvoiceSplitService;
import com.tydic.dyc.act.service.api.DycActQueryFscOrderDetailService;
import com.tydic.dyc.act.service.bo.DycActDealFscOrderStateUpdReqBO;
import com.tydic.dyc.act.service.bo.DycActFscOrderBatchInfoBO;
import com.tydic.dyc.act.service.bo.DycActFscOrderRelationQryListReqBO;
import com.tydic.dyc.act.service.bo.DycActFscOrderRelationQryListRspBO;
import com.tydic.dyc.act.service.bo.DycActFscOrderSubmitInvoiceSplitReqBO;
import com.tydic.dyc.act.service.bo.DycActFscOrderSubmitInvoiceSplitRspBO;
import com.tydic.dyc.act.service.bo.DycActQueryFscOrderDetailReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryFscOrderDetailRspBO;
import com.tydic.jn.atom.act.api.DycActDealEInvoiceSubmitFunc;
import com.tydic.jn.atom.act.api.DycActFscInvoiceSubmitExternalFunc;
import com.tydic.jn.atom.act.bo.DycActDealEInvoiceSubmitFuncReqBO;
import com.tydic.jn.atom.act.bo.DycActFscInvoiceSubmitExternalFuncReqBO;
import com.tydic.jn.atom.act.bo.DycActFscInvoiceSubmitExternalFuncRspBO;
import java.text.SimpleDateFormat;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;

@Service
public class DycActDealEInvoiceSubmitFuncImpl
implements DycActDealEInvoiceSubmitFunc {
    private static final Logger log = LoggerFactory.getLogger(DycActDealEInvoiceSubmitFuncImpl.class);
    @Autowired
    private DycActFscOrderSubmitInvoiceSplitService dycActFscOrderSubmitInvoiceSplitService;
    @Autowired
    private DycActFscOrderRelationQryListService dycActFscOrderRelationQryListService;
    @Autowired
    private DycActFscInvoiceSubmitExternalFunc dycActFscInvoiceSubmitExternalFunc;
    @Autowired
    private DycActQueryFscOrderDetailService dycActQueryFscOrderDetailService;
    @Autowired
    private DycActDealFscOrderStateUpdService dycActDealFscOrderStateUpdService;

    @Override
    @Async
    public void dealApplyInvoiceSubmit(DycActDealEInvoiceSubmitFuncReqBO reqBO) {
        DycActQueryFscOrderDetailReqBO dycActQueryFscOrderDetailReqBO = new DycActQueryFscOrderDetailReqBO();
        dycActQueryFscOrderDetailReqBO.setFscOrderId(reqBO.getFscOrderId());
        DycActQueryFscOrderDetailRspBO dycActQueryFscOrderDetailRspBO = this.dycActQueryFscOrderDetailService.queryFscOrderDetail(dycActQueryFscOrderDetailReqBO);
        if (!"0000".equals(dycActQueryFscOrderDetailRspBO.getRespCode())) {
            throw new ZTBusinessException(dycActQueryFscOrderDetailRspBO.getRespDesc());
        }
        DycActFscOrderSubmitInvoiceSplitReqBO dycActFscOrderSubmitInvoiceSplitReqBO = new DycActFscOrderSubmitInvoiceSplitReqBO();
        dycActFscOrderSubmitInvoiceSplitReqBO.setFscOrderId(reqBO.getFscOrderId());
        DycActFscOrderSubmitInvoiceSplitRspBO dycActFscOrderSubmitInvoiceSplitRspBO = this.dycActFscOrderSubmitInvoiceSplitService.dealfscOrderSplit(dycActFscOrderSubmitInvoiceSplitReqBO);
        if (!"0000".equals(dycActFscOrderSubmitInvoiceSplitRspBO.getRespCode())) {
            throw new ZTBusinessException(dycActFscOrderSubmitInvoiceSplitRspBO.getRespDesc());
        }
        List dycActFscOrderBatchInfoBOS = dycActFscOrderSubmitInvoiceSplitRspBO.getBatchInfoList();
        for (DycActFscOrderBatchInfoBO dycActFscOrderBatchInfoBO : dycActFscOrderBatchInfoBOS) {
            try {
                DycActFscOrderRelationQryListReqBO dycActFscOrderRelationQryListReqBO = new DycActFscOrderRelationQryListReqBO();
                dycActFscOrderRelationQryListReqBO.setFscOrderId(reqBO.getFscOrderId());
                dycActFscOrderRelationQryListReqBO.setBatchId(dycActFscOrderBatchInfoBO.getBatchId());
                DycActFscOrderRelationQryListRspBO dycActFscOrderRelationQryListRspBO = this.dycActFscOrderRelationQryListService.qryOrderRelationList(dycActFscOrderRelationQryListReqBO);
                if (!"0000".equals(dycActFscOrderRelationQryListRspBO.getRespCode())) {
                    throw new ZTBusinessException(dycActFscOrderRelationQryListRspBO.getRespCode());
                }
                DycActFscInvoiceSubmitExternalFuncReqBO submitFuncReqBO = this.assemableParam(dycActQueryFscOrderDetailRspBO, dycActFscOrderRelationQryListRspBO, dycActFscOrderBatchInfoBO);
                DycActFscInvoiceSubmitExternalFuncRspBO submitFuncRspBO = this.dycActFscInvoiceSubmitExternalFunc.submitInvoice(submitFuncReqBO);
                if (!submitFuncRspBO.getSuccess().booleanValue()) {
                    this.savePushResult(dycActFscOrderBatchInfoBO, DycActivityConstants.PushResult.PUSH_FAIL, submitFuncRspBO.getResultMessage());
                }
                this.savePushResult(dycActFscOrderBatchInfoBO, DycActivityConstants.PushResult.PUSH_SUCCESS, submitFuncRspBO.getResultMessage());
            }
            catch (Exception e) {
                log.info("\u63a8\u9001\u7535\u5546\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
                String failInfo = "";
                failInfo = StringUtils.isNotBlank((String)e.getMessage()) ? (e.getMessage().length() > 128 ? e.getMessage().substring(0, 128) : e.getMessage()) : "\u672a\u77e5\u9519\u8bef";
                this.savePushResult(dycActFscOrderBatchInfoBO, DycActivityConstants.PushResult.PUSH_FAIL, failInfo);
            }
        }
        this.updatefscOrderState(reqBO.getFscOrderId());
    }

    private DycActFscInvoiceSubmitExternalFuncReqBO assemableParam(DycActQueryFscOrderDetailRspBO dycActQueryFscOrderDetailRspBO, DycActFscOrderRelationQryListRspBO dycActFscOrderRelationQryListRspBO, DycActFscOrderBatchInfoBO dycActFscOrderBatchInfoBO) {
        DycActFscInvoiceSubmitExternalFuncReqBO dycActFscInvoiceSubmitExternalFuncReqBO = new DycActFscInvoiceSubmitExternalFuncReqBO();
        dycActFscInvoiceSubmitExternalFuncReqBO.setFscOrderId(dycActQueryFscOrderDetailRspBO.getFscOrderId().toString());
        dycActFscInvoiceSubmitExternalFuncReqBO.setSupplierId(dycActQueryFscOrderDetailRspBO.getSupplierId().toString());
        dycActFscInvoiceSubmitExternalFuncReqBO.setExtOrderNos(dycActFscOrderRelationQryListRspBO.getOrderIds());
        dycActFscInvoiceSubmitExternalFuncReqBO.setOrderNo(dycActQueryFscOrderDetailRspBO.getOrderNo());
        dycActFscInvoiceSubmitExternalFuncReqBO.setInvoiceOrg("");
        dycActFscInvoiceSubmitExternalFuncReqBO.setInvoiceNum(dycActFscOrderRelationQryListRspBO.getOrderIds().size());
        dycActFscInvoiceSubmitExternalFuncReqBO.setCurrentBatch(dycActFscOrderBatchInfoBO.getBatchId());
        dycActFscInvoiceSubmitExternalFuncReqBO.setTotalBatch(dycActFscOrderBatchInfoBO.getTotalBatch());
        dycActFscInvoiceSubmitExternalFuncReqBO.setTotalBatchInvoiceAmount(dycActQueryFscOrderDetailRspBO.getTotalCharge());
        dycActFscInvoiceSubmitExternalFuncReqBO.setTotalCharge(dycActFscOrderRelationQryListRspBO.getBatchAmt());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        dycActFscInvoiceSubmitExternalFuncReqBO.setBillDate(simpleDateFormat.format(dycActQueryFscOrderDetailRspBO.getCreateTime()));
        dycActFscInvoiceSubmitExternalFuncReqBO.setInvoiceType(dycActQueryFscOrderDetailRspBO.getOrderInvoice().getInvoiceType());
        dycActFscInvoiceSubmitExternalFuncReqBO.setInvoiceCategory(dycActQueryFscOrderDetailRspBO.getOrderInvoice().getInvoiceCategory());
        dycActFscInvoiceSubmitExternalFuncReqBO.setBuyName(dycActQueryFscOrderDetailRspBO.getOrderInvoice().getBuyName());
        dycActFscInvoiceSubmitExternalFuncReqBO.setTaxNo(dycActQueryFscOrderDetailRspBO.getOrderInvoice().getTaxNo());
        dycActFscInvoiceSubmitExternalFuncReqBO.setBank(dycActQueryFscOrderDetailRspBO.getOrderInvoice().getBank());
        dycActFscInvoiceSubmitExternalFuncReqBO.setAccount(dycActQueryFscOrderDetailRspBO.getOrderInvoice().getAccount());
        dycActFscInvoiceSubmitExternalFuncReqBO.setAddress(dycActQueryFscOrderDetailRspBO.getOrderInvoice().getAddress());
        dycActFscInvoiceSubmitExternalFuncReqBO.setPhone(dycActQueryFscOrderDetailRspBO.getOrderInvoice().getPhone());
        dycActFscInvoiceSubmitExternalFuncReqBO.setReceiveName(dycActQueryFscOrderDetailRspBO.getOrderInvoice().getReceiveName());
        dycActFscInvoiceSubmitExternalFuncReqBO.setReceivePhone(dycActQueryFscOrderDetailRspBO.getOrderInvoice().getReceivePhone());
        String receiveaddr = dycActQueryFscOrderDetailRspBO.getOrderInvoice().getProvince() + dycActQueryFscOrderDetailRspBO.getOrderInvoice().getCity() + dycActQueryFscOrderDetailRspBO.getOrderInvoice().getArea() + dycActQueryFscOrderDetailRspBO.getOrderInvoice().getTown() + dycActQueryFscOrderDetailRspBO.getOrderInvoice().getReceiveAddr();
        dycActFscInvoiceSubmitExternalFuncReqBO.setReceiveAddr(receiveaddr);
        dycActFscInvoiceSubmitExternalFuncReqBO.setInvoiceMemo(dycActQueryFscOrderDetailRspBO.getExtField1());
        return dycActFscInvoiceSubmitExternalFuncReqBO;
    }

    private void savePushResult(DycActFscOrderBatchInfoBO dycActFscOrderBatchInfoBO, Integer pushResult, String failInfo) {
        DycActFscOrderSubmitInvoiceSplitReqBO dycActFscOrderSubmitInvoiceSplitReqBO = new DycActFscOrderSubmitInvoiceSplitReqBO();
        dycActFscOrderSubmitInvoiceSplitReqBO.setId(dycActFscOrderBatchInfoBO.getId());
        dycActFscOrderSubmitInvoiceSplitReqBO.setFscOrderId(dycActFscOrderBatchInfoBO.getFscOrderId());
        dycActFscOrderSubmitInvoiceSplitReqBO.setBatchNo(dycActFscOrderBatchInfoBO.getBatchId());
        dycActFscOrderSubmitInvoiceSplitReqBO.setPushResult(pushResult);
        dycActFscOrderSubmitInvoiceSplitReqBO.setFailInfo(failInfo);
        this.dycActFscOrderSubmitInvoiceSplitService.dealSubmitResult(dycActFscOrderSubmitInvoiceSplitReqBO);
    }

    private void updatefscOrderState(Long fscOrderId) {
        DycActDealFscOrderStateUpdReqBO dycActDealFscOrderStateUpdReqBO = new DycActDealFscOrderStateUpdReqBO();
        dycActDealFscOrderStateUpdReqBO.setFscOrderId(fscOrderId);
        dycActDealFscOrderStateUpdReqBO.setDealFlag("1");
        this.dycActDealFscOrderStateUpdService.dealFscOrderStateUpd(dycActDealFscOrderStateUpdReqBO);
    }
}

