/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.jn.atom.act.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.dyc.atom.base.utils.DycEsbParamUtil;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.jn.atom.act.api.DycActGetInvoiceFunc;
import com.tydic.jn.atom.act.bo.DycActGetInvoiceFuncReqBO;
import com.tydic.jn.atom.act.bo.DycActGetInvoiceFuncRspBO;
import com.tydic.jn.atom.act.bo.DycActInvoiceExternalBO;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycActGetInvoiceFuncImpl
implements DycActGetInvoiceFunc {
    private static final Logger log = LoggerFactory.getLogger(DycActGetInvoiceFuncImpl.class);
    @Autowired
    private Environment environment;
    @Value(value="${esb.getInvoice.url:}")
    private String ESB_GET_INVOICE_INFO_URL;
    private static final String JD_SUP_ID = "JD_SUP_ID";
    @Value(value="${isInvokeExternal}")
    private Boolean isInvokeExternal;

    @Override
    public DycActGetInvoiceFuncRspBO getInvoiceInfo(DycActGetInvoiceFuncReqBO reqBO) {
        this.val(reqBO);
        String hsn = this.environment.getProperty("SUPPLIER_ID_" + reqBO.getSupplierId());
        String reqStr = JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        JSONObject jsonObject = JSON.parseObject((String)reqStr);
        if (null != reqBO.getProOrgId()) {
            jsonObject.put("orgId", (Object)reqBO.getProOrgId());
        }
        reqStr = JSON.toJSONString((Object)jsonObject);
        String reqEsbStr = DycEsbParamUtil.getEsbReqStr((String)reqStr, (String)hsn, (String)"BUSINESS_PAY");
        log.debug("\u83b7\u53d6\u7b2c\u4e09\u65b9\u5f00\u7968\u6570\u636e\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)this.ESB_GET_INVOICE_INFO_URL);
        log.debug("\u83b7\u53d6\u7b2c\u4e09\u65b9\u5f00\u7968\u6570\u636e\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)reqEsbStr);
        String rspJson = "";
        rspJson = this.isInvokeExternal != false ? SSLClient.doPost((String)this.ESB_GET_INVOICE_INFO_URL, (String)reqEsbStr) : "{\n  \"success\": true,\n  \"resultMessage\": \"\u5168\u90e8\u53d1\u7968\u53ef\u67e5\u9605\",\n  \"resultCode\": \"0004\",\n  \"result\": \"[{\\\"invoiceId\\\":\\\"27984311\\\",\\\"invoiceCode\\\":\\\"4400184130\\\",\\\"invoiceDate\\\":\\\"2019-03-01 00:00:00\\\",\\\"invoiceNakedAmount\\\":95.08,\\\"invoiceTaxRate\\\":0.16,\\\"invoiceTaxAmount\\\":15.22,\\\"invoiceAmount\\\":110.30,\\\"invoiceType\\\":2,\\\"success\\\":true}]\"\n}\n";
        String replaced = rspJson.replaceAll("\\\\r", "");
        String replacedd = replaced.replaceAll("\\\\n", "");
        log.debug("\u83b7\u53d6\u7b2c\u4e09\u65b9\u5f00\u7968\u6570\u636e\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)rspJson);
        log.debug("\u83b7\u53d6\u7b2c\u4e09\u65b9\u5f00\u7968\u6570\u636e\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)replacedd);
        DycActGetInvoiceFuncRspBO rspBO = new DycActGetInvoiceFuncRspBO();
        if (StringUtils.isBlank((String)rspJson)) {
            rspBO.setRespCode("194318");
            rspBO.setRespDesc("\u7535\u5546\u8fd4\u56de\u5f00\u7968\u6570\u636e\u4e3a\u7a7a");
            return rspBO;
        }
        if (reqBO.getSupplierId().equals(this.environment.getProperty(JD_SUP_ID))) {
            JSONObject jdRspJsonObject = JSON.parseObject((String)replacedd);
            rspBO.setSuccess(jdRspJsonObject.getBoolean("success"));
            rspBO.setResultCode(jdRspJsonObject.getString("resultCode"));
            rspBO.setResultMessage(jdRspJsonObject.getString("resultMessage"));
            String result = jdRspJsonObject.getString("result");
            List dycActInvoiceExternalBOS = JSON.parseArray((String)result, DycActInvoiceExternalBO.class);
            rspBO.setResult(dycActInvoiceExternalBOS);
            if (null == rspBO.getSuccess() || !rspBO.getSuccess().booleanValue() || CollectionUtils.isEmpty(rspBO.getResult())) {
                rspBO.setRespCode("194318");
                rspBO.setRespDesc("\u7535\u5546\u8fd4\u56de\u9519\u8bef\u63cf\u8ff0\uff1a" + rspBO.getResultMessage());
                return rspBO;
            }
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        rspBO = (DycActGetInvoiceFuncRspBO)((Object)JSON.parseObject((String)replacedd, DycActGetInvoiceFuncRspBO.class));
        if (null == rspBO.getSuccess() || !rspBO.getSuccess().booleanValue() || CollectionUtils.isEmpty(rspBO.getResult())) {
            rspBO.setRespCode("194318");
            rspBO.setRespDesc("\u7535\u5546\u8fd4\u56de\u9519\u8bef\u63cf\u8ff0\uff1a" + rspBO.getResultMessage());
            return rspBO;
        }
        rspBO.setRespCode("0000");
        return rspBO;
    }

    private void val(DycActGetInvoiceFuncReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u7535\u5546\u53d1\u7968\u4fe1\u606f\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO));
        }
        if (StringUtils.isBlank((String)reqBO.getMarkId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[markId]\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getSupplierId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[supplierId]\u4e3a\u7a7a");
        }
    }
}

