/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.jn.atom.act.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.tydic.dyc.atom.base.utils.DycEsbParamUtil;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.fsc.exception.FscBusinessException;
import com.tydic.jn.atom.act.api.DycActGetInvoiceItemFunc;
import com.tydic.jn.atom.act.bo.DycActGetInvoiceItemFuncReqBO;
import com.tydic.jn.atom.act.bo.DycActGetInvoiceItemFuncRspBO;
import com.tydic.jn.atom.act.bo.DycActInvoiceItemExternalBO;
import com.tydic.jn.atom.act.bo.DycActInvoiceItemSkuBO;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Service;

@Service
public class DycActGetInvoiceItemFuncImpl
implements DycActGetInvoiceItemFunc {
    private static final Logger log = LoggerFactory.getLogger(DycActGetInvoiceItemFuncImpl.class);
    @Autowired
    private Environment environment;
    @Value(value="${esb.getInvoiceItem.url:}")
    private String ESB_GET_INVOICE_ITEM_URL;
    @Value(value="${JD_SUP_ID:100055}")
    private String JD_SUPPLIER_ID;
    @Value(value="${isInvokeExternal}")
    private Boolean isInvokeExternal;

    @Override
    public DycActGetInvoiceItemFuncRspBO getInvoiceItemInfo(DycActGetInvoiceItemFuncReqBO reqBO) {
        this.val(reqBO);
        String hsn = this.environment.getProperty("SUPPLIER_ID_" + reqBO.getSupplierId());
        String reqStr = JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue});
        JSONObject jsonObject = JSON.parseObject((String)reqStr);
        if (null != reqBO.getProOrgId()) {
            jsonObject.put("orgId", (Object)reqBO.getProOrgId());
        }
        reqStr = JSON.toJSONString((Object)jsonObject);
        String reqEsbStr = DycEsbParamUtil.getEsbReqStr((String)reqStr, (String)hsn, (String)"BUSINESS_PAY");
        log.debug("\u83b7\u53d6\u7535\u5546\u5f00\u7968\u660e\u7ec6\u6570\u636e\u8bf7\u6c42\u5730\u5740\uff1a{}", (Object)this.ESB_GET_INVOICE_ITEM_URL);
        log.debug("\u83b7\u53d6\u7535\u5546\u5f00\u7968\u660e\u7ec6\u6570\u636e\u8bf7\u6c42\u62a5\u6587\uff1a{}", (Object)reqEsbStr);
        String rspJson = "";
        rspJson = this.isInvokeExternal != false ? SSLClient.doPost((String)this.ESB_GET_INVOICE_ITEM_URL, (String)reqEsbStr) : "{\n    \"success\": true,\n    \"resultMessage\": \"\u64cd\u4f5c\u6210\u529f\",\n    \"resultCode\": \"0000\",\n    \"result\": {\n        \"invoiceCode\": \"4400184130\",\n        \"invoiceId\": \"27984311\",\n        \"state\": 1,\n        \"originalInvoiceId\": null,\n        \"originalInvoiceCode\": null,\n        \"invoiceDate\": \"2019-02-12 00:00:00.0\",\n        \"invoiceNakedAmount\": 981528.4,\n        \"invoiceTaxRate\": 0.16,\n        \"invoiceTaxAmount\": 157044.99,\n        \"invoiceAmount\": 1138573.39,\n        \"invoiceType\": 2,\n        \"title\": \"\u4e2d\u56fd****\u5206\u516c\u53f8\",\n        \"taxpayer\": null,\n        \"bank\": null,\n        \"account\": null,\n        \"remark\": null,\n        \"skuDetails\": [\n            {\n                \"jdOrderId\": \"85368626822\",\n                \"skuId\": \"100000177696\",\n                \"skuName\": \"Apple iPhone XS (A2100)  256GB \u94f6\u8272 \u79fb\u52a8\u8054\u901a\u7535\u4fe14G\u624b\u673a\",\n                \"price\": 9599,\n                \"num\": 1,\n                \"taxRate\": 0.16,\n                \"amount\": 9599,\n                \"amountUnTax\": 8275,\n                \"taxAmount\": 1324,\n                \"specification\": \"iPhone XS\",\n                \"settleUnit\": \"\u4e2a\"\n            },\n            {\n                \"jdOrderId\": \"83306604044\",\n                \"skuId\": \"100000077466\",\n                \"skuName\": \"\u7f8e\u7684\uff08Midea\uff09\u7535\u70ed\u6c34\u74f6 304\u4e0d\u9508\u94a2\u7535\u6c34\u58f6 5L\u5bb9\u91cf \u591a\u6bb5\u6e29\u63a7\u7535\u70ed\u6c34\u58f6 \u51c9\u767d\u5f00\u4e00\u952e\u901a\u70e7\u6c34\u58f6PF703-50T\",\n                \"price\": 279,\n                \"num\": 1,\n                \"taxRate\": 0.16,\n                \"amount\": 279,\n                \"amountUnTax\": 240.52,\n                \"taxAmount\": 38.48,\n                \"specification\": \"PF703-50T\",\n                \"settleUnit\": \"\u4e2a\"\n            }\n        ]\n    }\n}\n";
        String replaced = rspJson.replaceAll("\\\\r", "");
        String replacedd = replaced.replaceAll("\\\\n", "");
        log.debug("\u83b7\u53d6\u7535\u5546\u5f00\u7968\u660e\u7ec6\u6570\u636e\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)rspJson);
        log.debug("\u83b7\u53d6\u7535\u5546\u5f00\u7968\u660e\u7ec6\u6570\u636e\u54cd\u5e94\u62a5\u6587\uff1a{}", (Object)replacedd);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)rspJson)) {
            throw new FscBusinessException("194319", "\u83b7\u53d6\u7535\u5546\u5f00\u7968\u660e\u7ec6\u6570\u636e\u63a5\u53e3\u8fd4\u56de\u7a7a");
        }
        DycActGetInvoiceItemFuncRspBO rspBO = this.parseReturn(replacedd, reqBO);
        if (null == rspBO.getSuccess() || !rspBO.getSuccess().booleanValue() || null == rspBO.getResult()) {
            throw new FscBusinessException("194319", "\u7535\u5546\u8fd4\u56de\u9519\u8bef\u63cf\u8ff0\uff1a" + rspBO.getResultMessage());
        }
        if (null == rspBO.getResult()) {
            throw new FscBusinessException("194319", "\u8bf7\u6c42\u8bf7\u6c42ESB\u83b7\u53d6\u7535\u5546\u5f00\u7968\u660e\u7ec6\u6570\u636e\u63a5\u53e3result\u8fd4\u56de\u7a7a");
        }
        rspBO.setResultCode("0000");
        return rspBO;
    }

    private void val(DycActGetInvoiceItemFuncReqBO reqBO) {
        if (log.isDebugEnabled()) {
            log.debug("\u83b7\u53d6\u7535\u5546\u53d1\u7968\u660e\u7ec6\u8be6\u60c5\u6570\u636e\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)reqBO, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
        if (StringUtils.isBlank((String)reqBO.getInvoiceId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[invoiceId]\u4e3a\u7a7a");
        }
        if (StringUtils.isBlank((String)reqBO.getSupplierId())) {
            throw new FscBusinessException("191000", "\u5165\u53c2[supplierId]\u4e3a\u7a7a");
        }
    }

    private DycActGetInvoiceItemFuncRspBO parseReturn(String replacedd, DycActGetInvoiceItemFuncReqBO reqBO) {
        if (this.JD_SUPPLIER_ID.equals(reqBO.getSupplierId())) {
            DycActGetInvoiceItemFuncRspBO rspBO = (DycActGetInvoiceItemFuncRspBO)((Object)JSON.parseObject((String)replacedd, DycActGetInvoiceItemFuncRspBO.class));
            JSONObject jsonObject = JSON.parseObject((String)replacedd);
            JSONObject result = jsonObject.getJSONObject("result");
            JSONArray skuDetails = result.getJSONArray("skuDetails");
            List<DycActInvoiceItemSkuBO> dycActInvoiceItemSkuBOS = skuDetails.stream().map(o -> {
                JSONObject skuEntity = (JSONObject)o;
                DycActInvoiceItemSkuBO dycActInvoiceItemSkuBO = new DycActInvoiceItemSkuBO();
                dycActInvoiceItemSkuBO.setJdOrderId(skuEntity.getString("jdOrderId"));
                dycActInvoiceItemSkuBO.setSkuId(skuEntity.getString("skuId"));
                dycActInvoiceItemSkuBO.setSkuName(skuEntity.getString("skuName"));
                dycActInvoiceItemSkuBO.setPrice(skuEntity.getBigDecimal("price"));
                dycActInvoiceItemSkuBO.setNum(skuEntity.getBigDecimal("num"));
                dycActInvoiceItemSkuBO.setTaxRate(skuEntity.getBigDecimal("taxRate"));
                dycActInvoiceItemSkuBO.setAmount(skuEntity.getBigDecimal("amount"));
                dycActInvoiceItemSkuBO.setAmountUnTax(skuEntity.getBigDecimal("amountUnTax"));
                dycActInvoiceItemSkuBO.setTaxAmount(skuEntity.getBigDecimal("taxAmount"));
                dycActInvoiceItemSkuBO.setSpecification(skuEntity.getString("specification"));
                dycActInvoiceItemSkuBO.setSettleUnit(skuEntity.getString("settleUnit"));
                return dycActInvoiceItemSkuBO;
            }).collect(Collectors.toList());
            DycActInvoiceItemExternalBO dycActGetInvoiceItemFuncRspBO = rspBO.getResult();
            dycActGetInvoiceItemFuncRspBO.setSkuDetails(dycActInvoiceItemSkuBOS);
            return rspBO;
        }
        return (DycActGetInvoiceItemFuncRspBO)((Object)JSON.parseObject((String)replacedd, DycActGetInvoiceItemFuncRspBO.class));
    }
}

