/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.jn.atom.act.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.jn.atom.act.api.DycSaasActActivityCommoditySyncInfoFunc;
import com.tydic.jn.atom.act.bo.DycSaasActCommoditySyncReqBO;
import com.tydic.jn.atom.act.bo.OpenRpcActCommodityResult;
import com.tydic.jn.atom.act.bo.OpenRpcActResult;
import com.tydic.jn.atom.act.bo.OpenRpcResult;
import com.tydic.jn.atom.act.bo.SkuFailureDetailDTO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class DycSaasActActivityCommoditySyncInfoFuncImpl
implements DycSaasActActivityCommoditySyncInfoFunc {
    private static final Logger log = LoggerFactory.getLogger(DycSaasActActivityCommoditySyncInfoFuncImpl.class);
    @Value(value="${ESB_ACT_CHANGE_SKU_GROUP:${ESB_ACCESS_IP}/OSN/api/bbcChangeSkuGroup/v1}")
    private String ESB_ACT_CHANGE_SKU_GROUP;
    @Value(value="${ESB_ACT_BATCH_ADD_SKUS:${ESB_ACCESS_IP}/OSN/api/bbcBatchAddSkus/v1}")
    private String ESB_ACT_BATCH_ADD_SKUS;
    @Value(value="${ESB_ACT_SET_PRODUCT_GROUP_RELATION:${ESB_ACCESS_IP}/OSN/api/bbcSetProductGroupRelation/v1}")
    private String ESB_ACT_SET_PRODUCT_GROUP_RELATION;
    @Value(value="${sync_commodity_size:150}")
    private String sync_commodity_size;

    @Override
    public OpenRpcActResult activityCommoditySync(DycSaasActCommoditySyncReqBO reqBO) {
        OpenRpcActResult response = new OpenRpcActResult();
        JSONObject skuGroupExecuteDTO = new JSONObject();
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("groupName", (Object)reqBO.getActivityId());
        skuGroupExecuteDTO.put("hsn", (Object)"jdsdk");
        skuGroupExecuteDTO.put("skuGroupExecuteDTO", (Object)jsonObject);
        log.info("\u540c\u6b65\u521b\u5efa\u5546\u54c1\u7ec4\u5230\u4eac\u4e1c\u5165\u53c2\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)skuGroupExecuteDTO));
        String rspJson = SSLClient.doPost((String)this.ESB_ACT_CHANGE_SKU_GROUP, (String)JSONObject.toJSONString((Object)skuGroupExecuteDTO));
        log.info("\u540c\u6b65\u521b\u5efa\u5546\u54c1\u7ec4\u5230\u4eac\u4e1c\u51fa\u53c2\u4fe1\u606f\uff1a{}", (Object)rspJson);
        OpenRpcActResult actResult = this.rspDO(rspJson);
        if (!actResult.getSuccess().booleanValue()) {
            return actResult;
        }
        int total = reqBO.getSkuIdList().size();
        int batchSize = Integer.valueOf(this.sync_commodity_size);
        int totalBatch = (total + batchSize - 1) / batchSize;
        ArrayList<String> errorList = new ArrayList<String>();
        ArrayList<SkuFailureDetailDTO> failureDetails = new ArrayList<SkuFailureDetailDTO>();
        Boolean flag = false;
        for (int batchIndex = 0; batchIndex < totalBatch; ++batchIndex) {
            int startIndex = batchIndex * batchSize;
            int endIndex = Math.min((batchIndex + 1) * batchSize, total);
            List<String> subList = reqBO.getSkuIdList().subList(startIndex, endIndex);
            JSONObject skuGroupBatchAddSkuDTO = new JSONObject();
            JSONObject skuIds = new JSONObject();
            skuIds.put("groupCode", (Object)actResult.getResult());
            skuIds.put("skuIdList", subList);
            skuGroupBatchAddSkuDTO.put("hsn", (Object)"jdsdk");
            skuGroupBatchAddSkuDTO.put("skuGroupBatchAddSkuDTO", (Object)skuIds);
            log.info("\u540c\u6b65\u5546\u54c1\u5230\u4eac\u4e1c\u5165\u53c2\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)skuGroupBatchAddSkuDTO));
            String skuIdsRspJson = SSLClient.doPost((String)this.ESB_ACT_BATCH_ADD_SKUS, (String)JSONObject.toJSONString((Object)skuGroupBatchAddSkuDTO));
            log.info("\u540c\u6b65\u5546\u54c1\u5230\u4eac\u4e1c\u51fa\u53c2\u4fe1\u606f\uff1a{}", (Object)skuIdsRspJson);
            OpenRpcResult commodityResult = this.rsp(skuIdsRspJson);
            if (!commodityResult.getSuccess().booleanValue()) {
                SkuFailureDetailDTO detailDTO = new SkuFailureDetailDTO();
                detailDTO.setFailStr(commodityResult.getResultMessage());
                failureDetails.add(detailDTO);
                errorList.add(JSON.toJSONString(failureDetails));
                response.setSuccess(false);
                response.setResultMessage(JSON.toJSONString(errorList));
                response.setFlag(false);
                return response;
            }
            if (ObjectUtils.isEmpty((Object)commodityResult.getResult()) || commodityResult.getResult().getSuccessNum().intValue() == subList.size()) continue;
            flag = true;
            failureDetails.addAll(commodityResult.getResult().getFailureDetails());
        }
        JSONObject actJson = new JSONObject();
        JSONObject activityProductGroupExcuteDTO = new JSONObject();
        activityProductGroupExcuteDTO.put("activityCode", (Object)reqBO.getExtActivityId());
        activityProductGroupExcuteDTO.put("groupCode", (Object)actResult.getResult());
        actJson.put("activityProductGroupExcuteDTO", (Object)activityProductGroupExcuteDTO);
        actJson.put("hsn", (Object)"jdsdk");
        log.info("\u540c\u6b65\u5546\u54c1\u7ec4\u5173\u8054\u6d3b\u52a8\u5230\u4eac\u4e1c\u5165\u53c2\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString((Object)actJson));
        String actJsonRspJson = SSLClient.doPost((String)this.ESB_ACT_SET_PRODUCT_GROUP_RELATION, (String)JSONObject.toJSONString((Object)actJson));
        log.info("\u540c\u6b65\u5546\u54c1\u7ec4\u5173\u8054\u6d3b\u52a8\u5230\u4eac\u4e1c\u51fa\u53c2\u4fe1\u606f\uff1a{}", (Object)actJsonRspJson);
        response = this.rspDO(actJsonRspJson);
        if (failureDetails.size() > 0) {
            errorList.add(JSON.toJSONString(failureDetails));
            response.setSuccess(false);
            response.setResultMessage(JSON.toJSONString(errorList));
            response.setFlag(flag);
        }
        return response;
    }

    private OpenRpcResult rsp(String rspJson) {
        OpenRpcResult rspBO = new OpenRpcResult();
        try {
            rspBO = (OpenRpcResult)JSON.parseObject((String)rspJson, OpenRpcResult.class);
            if (!rspBO.getSuccess().booleanValue()) {
                rspBO.setResultMessage(rspJson);
            }
        }
        catch (Exception e) {
            rspBO.setSuccess(false);
            rspBO.setResultMessage(rspJson);
        }
        return rspBO;
    }

    private OpenRpcActResult rspDO(String rspJson) {
        OpenRpcActResult rspBO = new OpenRpcActResult();
        try {
            rspBO = (OpenRpcActResult)JSON.parseObject((String)rspJson, OpenRpcActResult.class);
            if (!rspBO.getSuccess().booleanValue()) {
                rspBO.setResultMessage(rspJson);
            }
        }
        catch (Exception e) {
            rspBO.setSuccess(false);
            rspBO.setResultMessage(rspJson);
        }
        return rspBO;
    }

    private OpenRpcActCommodityResult rspCommodityDO(String rspJson) {
        OpenRpcActCommodityResult rspBO = new OpenRpcActCommodityResult();
        try {
            rspBO = (OpenRpcActCommodityResult)JSON.parseObject((String)rspJson, OpenRpcActCommodityResult.class);
            if (!rspBO.getSuccess().booleanValue()) {
                rspBO.setResultMessage(rspJson);
            }
        }
        catch (Exception e) {
            rspBO.setSuccess(false);
            rspBO.setResultMessage(rspJson);
        }
        return rspBO;
    }
}

