/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.jn.atom.act.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.jn.atom.act.api.DycSaasActActivityUserSyncInfoFunc;
import com.tydic.jn.atom.act.bo.AssetExecuteResult;
import com.tydic.jn.atom.act.bo.DycActActivityUserInfoReqBO;
import com.tydic.jn.atom.act.bo.OpenRpcResult;
import com.tydic.jn.atom.act.bo.UserBatchExecuteVO;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycSaasActActivityUserSyncInfoFuncImpl
implements DycSaasActActivityUserSyncInfoFunc {
    private static final Logger log = LoggerFactory.getLogger(DycSaasActActivityUserSyncInfoFuncImpl.class);
    @Value(value="${ESB_ACT_BATCH_ADD_USERS:${ESB_ACCESS_IP}/OSN/api/bbcBatchAddUsers/v1}")
    private String ESB_ACT_BATCH_ADD_USERS;
    @Value(value="${sync_user_size:150}")
    private String sync_user_size;

    @Override
    public OpenRpcResult activityUserSync(List<DycActActivityUserInfoReqBO> reqBO) {
        int total = reqBO.size();
        int batchSize = Integer.valueOf(this.sync_user_size);
        int totalBatch = (total + batchSize - 1) / batchSize;
        Boolean flag = false;
        ArrayList<AssetExecuteResult> successList = new ArrayList<AssetExecuteResult>();
        ArrayList<String> errorList = new ArrayList<String>();
        for (int batchIndex = 0; batchIndex < totalBatch; ++batchIndex) {
            int startIndex = batchIndex * batchSize;
            int endIndex = Math.min((batchIndex + 1) * batchSize, total);
            List<DycActActivityUserInfoReqBO> subList = reqBO.subList(startIndex, endIndex);
            JSONObject jsonObject = new JSONObject();
            JSONObject batchAddOrUpdateUserDTO = new JSONObject();
            JSONArray array = new JSONArray();
            subList.forEach(item -> {
                JSONObject object = new JSONObject();
                object.put("employeeId", (Object)item.getActUserName());
                object.put("name", (Object)item.getActName());
                object.put("userId", (Object)item.getActUserId());
                array.add((Object)object);
            });
            batchAddOrUpdateUserDTO.put("users", (Object)array);
            jsonObject.put("batchAddOrUpdateUserDTO", (Object)batchAddOrUpdateUserDTO);
            jsonObject.put("hsn", (Object)"jdsdk");
            log.info("\u540c\u6b65\u7528\u6237\u5230\u4eac\u4e1c\u5165\u53c2\u4fe1\u606f\uff1a{}, \u540c\u6b65\u6570\u91cf{}", (Object)JSONObject.toJSONString((Object)jsonObject), (Object)array.size());
            String rspJson = SSLClient.doPost((String)this.ESB_ACT_BATCH_ADD_USERS, (String)JSONObject.toJSONString((Object)jsonObject));
            log.info("\u540c\u6b65\u7528\u6237\u5230\u4eac\u4e1c\u51fa\u53c2\u4fe1\u606f\uff1a{}", (Object)rspJson);
            OpenRpcResult rspTempBO = this.rsp(rspJson);
            successList.addAll(rspTempBO.getResult().getSuccessList());
            if (!rspTempBO.getSuccess().booleanValue()) {
                flag = true;
                errorList.add(rspTempBO.getResultMessage());
            }
            if (rspTempBO.getResult().getFailtureNum() <= 0) continue;
            errorList.add(JSON.toJSONString(rspTempBO.getResult().getFailtureList()));
        }
        OpenRpcResult rspBO = new OpenRpcResult();
        UserBatchExecuteVO executeVO = new UserBatchExecuteVO();
        executeVO.setSuccessList(successList);
        rspBO.setResult(executeVO);
        if (flag.booleanValue()) {
            rspBO.setSuccess(false);
            rspBO.setResultMessage(JSON.toJSONString(errorList));
        } else {
            rspBO.setSuccess(true);
        }
        return rspBO;
    }

    private OpenRpcResult rsp(String rspJson) {
        OpenRpcResult rspBO = new OpenRpcResult();
        try {
            rspBO = (OpenRpcResult)JSON.parseObject((String)rspJson, OpenRpcResult.class);
            if (!rspBO.getSuccess().booleanValue()) {
                rspBO.setResultMessage(rspJson);
            }
        }
        catch (Exception e) {
            rspBO.setSuccess(false);
            rspBO.setResultMessage(rspJson);
        }
        return rspBO;
    }
}

