/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.jn.atom.act.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.jn.atom.act.api.DycActGetJDOrderListFunc;
import com.tydic.jn.atom.act.bo.DycActGetJDOrderListFuncReqBO;
import com.tydic.jn.atom.act.bo.DycActGetJDOrderListFuncRspBO;
import com.tydic.jn.atom.act.bo.DycActJDOrderInfoBO;
import com.tydic.jn.atom.act.bo.DycActJDOrderItemBO;
import com.tydic.jn.atom.act.bo.DycActJDOrderPayInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DycActGetJDOrderListFuncImpl
implements DycActGetJDOrderListFunc {
    private static final Logger log = LoggerFactory.getLogger(DycActGetJDOrderListFuncImpl.class);

    @Override
    public DycActGetJDOrderListFuncRspBO getEOrderList(DycActGetJDOrderListFuncReqBO reqBO) {
        DycActGetJDOrderListFuncRspBO rspBO = new DycActGetJDOrderListFuncRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        String hsn = DycPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + reqBO.getSupplierId()));
        try {
            log.info("\u4eac\u4e1c\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)reqBO));
            String httpRspStr = "{\n    \"success\":true,\n    \"resultMessage\":\"\u64cd\u4f5c\u6210\u529f\",\n    \"resultCode\":\"0000\",\n    \"result\":{\n        \"pageSize\":20,\n        \"pageNo\":1,\n        \"total\":1,\n        \"datas\":[\n            {\n                \"jdOrderId\":46666735363,\n                \"pin\":\"jincai000\",\n                \"orderPrice\":132,\n                \"payMoney\":132,\n                \"freight\":null,\n                \"orderType\":1,\n                \"paymentType\":101,\n                \"priceType\":4,\n                \"type\":2,\n                \"sourceType\":4,\n                \"state\":0,\n                \"orderState\":1,\n                \"submitState\":0,\n                \"submitType\":1,\n                \"name\":\"shande1\",\n                \"address\":\"\u4e0a\u6d77 \u95f8\u5317\u533a \u57ce\u533a \u897f\u90e8\u667a\u8c37\",\n                \"zip\":null,\n                \"phone\":null,\n                \"mobile\":\"18349181121\",\n                \"email\":\"\",\n                \"parentId\":0,\n                \"remark\":null,\n                \"created\":\"2016-12-15 21:28:18\",\n                \"outTime\":null,\n                \"arriveTime\":null,\n                \"finishTime\":null,\n                \"jdOrderState\":2,\n                \"invoiceState\":1,\n                \"serviceRate\":1000,\n                \"skuList\":[\n                    {\n                        \"skuId\":107702,\n                        \"num\":1,\n                        \"price\":22,\n                        \"name\":\"\u7d22\u5c3c\u7231\u7acb\u4fe1(Sony Ericsson)GC7511\",\n                        \"imgUrl\":\"58/b1a89d3f-da89-4b18-8c5d-2f8ee86d2730.jpg\",\n                        \"type\":0,\n                        \"oid\":null,\n                        \"bp\":22,\n                        \"moneyBpRate\":1,\n                        \"moneyBpRateDecimal\":1.06\n                    },\n                    {\n                        \"skuId\":107703,\n                        \"num\":1,\n                        \"price\":22,\n                        \"name\":\"\u534e\u4e3a(huawei)P70\",\n                        \"imgUrl\":\"58/b1a89d3f-da89-4b18-8c5d-2f8ee86d2730.jpg\",\n                        \"type\":0,\n                        \"oid\":null,\n                        \"bp\":22,\n                        \"moneyBpRate\":1,\n                        \"moneyBpRateDecimal\":1.06\n                    },\n                    {\n                        \"skuId\":107704,\n                        \"num\":1,\n                        \"price\":22,\n                        \"name\":\"\u5c0f\u7c73(xiaomi)red mi 15\",\n                        \"imgUrl\":\"58/b1a89d3f-da89-4b18-8c5d-2f8ee86d2730.jpg\",\n                        \"type\":0,\n                        \"oid\":null,\n                        \"bp\":22,\n                        \"moneyBpRate\":1,\n                        \"moneyBpRateDecimal\":1.06\n                    },\n                    {\n                        \"skuId\":102194,\n                        \"num\":1,\n                        \"price\":110,\n                        \"name\":\"\u7ef4\u6c0f VICTORINOX \u745e\u58eb\u519b\u5200\u661f\u5ea7\u7cfb\u5217\u6c34\u74f6 0.6223.8.AQUA11\",\n                        \"imgUrl\":\"1826/3b800b51-acaa-482a-b571-e208d540de0c.jpg\",\n                        \"type\":0,\n                        \"oid\":null,\n                        \"bp\":110,\n                        \"moneyBpRate\":1,\n                        \"moneyBpRateDecimal\":1.06\n                    }\n                ],\n                \"childOrderList\":[\n\n                ],\n                \"confirmedType\":0,\n                \"enterpriseId\":2190,\n                \"provinceName\":\"\u4e0a\u6d77\",\n                \"cityName\":\"\u95f8\u5317\u533a\",\n                \"countyName\":\"\u57ce\u533a\",\n                \"townName\":\"\",\n                \"bp\":132,\n                \"moneyBpRate\":1,\n                \"moneyBpRateDecimal\":1.06,\n                \"uid\":\"1\",\n                \"extInfo\":{\n                    \"payDetails\":[\n                        {\n                            \"flag\":1,\n                            \"payMoney\":0.8,\n                            \"paymentType\":17\n                        },\n                        {\n                            \"flag\":2,\n                            \"payMoney\":19.2,\n                            \"paymentType\":4\n                        }\n                    ]\n                }\n            }\n        ],\n        \"pageCount\":1\n    }\n}";
            log.info("\u4eac\u4e1c\u8ba2\u5355\u5217\u8868\u67e5\u8be2\u51fa\u53c2: {}", (Object)httpRspStr);
            rspBO = this.resolveRsp(httpRspStr);
        }
        catch (ZTBusinessException e) {
            log.error("e: {}", (Object)e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        return rspBO;
    }

    private DycActGetJDOrderListFuncRspBO resolveRsp(String returnString) {
        DycActGetJDOrderListFuncRspBO rspBO = new DycActGetJDOrderListFuncRspBO();
        JSONObject jsonObject = JSONObject.parseObject((String)returnString);
        if (jsonObject.getBoolean("success").booleanValue()) {
            String jsonStr = JSONObject.toJSONString((Object)jsonObject.get((Object)"result"));
            if (StringUtils.isNotBlank((String)jsonStr)) {
                JSONObject jsonObj = JSONObject.parseObject((String)jsonStr);
                rspBO.setPageNo((Integer)jsonObj.get((Object)"pageNo"));
                rspBO.setRecordsTotal((Integer)jsonObj.get((Object)"total"));
                rspBO.setTotal((Integer)jsonObj.get((Object)"pageCount"));
                String dataList = JSONObject.toJSONString((Object)jsonObj.get((Object)"datas"));
                if (StringUtils.isNotBlank((String)dataList)) {
                    JSONArray jsonData = JSONArray.parseArray((String)dataList);
                    List dycActJDOrderInfoBOS = jsonData.stream().map(o -> {
                        JSONObject orderEntity = (JSONObject)o;
                        DycActJDOrderInfoBO dycActJDOrderInfoBO = new DycActJDOrderInfoBO();
                        dycActJDOrderInfoBO.setJdOrderId(orderEntity.getLong("jdOrderId"));
                        dycActJDOrderInfoBO.setOrderPrice(orderEntity.getBigDecimal("orderPrice"));
                        dycActJDOrderInfoBO.setJdOrderState(orderEntity.getInteger("jdOrderState"));
                        dycActJDOrderInfoBO.setType(orderEntity.getInteger("type"));
                        dycActJDOrderInfoBO.setName(orderEntity.getString("name"));
                        dycActJDOrderInfoBO.setParentId(orderEntity.getLong("parentId"));
                        dycActJDOrderInfoBO.setCreated(orderEntity.getDate("created"));
                        dycActJDOrderInfoBO.setFinishTime(orderEntity.getDate("finishTime"));
                        dycActJDOrderInfoBO.setUid(orderEntity.getLong("uid"));
                        String payJsonStr = JSONObject.toJSONString((Object)orderEntity.get((Object)"extInfo"));
                        JSONObject payJsonObj = JSONObject.parseObject((String)payJsonStr);
                        JSONArray payDetails = payJsonObj.getJSONArray("payDetails");
                        if (payDetails != null) {
                            payDetails.forEach(pay -> {
                                String obj = JSONObject.toJSONString((Object)pay);
                                DycActJDOrderPayInfo payInfo = (DycActJDOrderPayInfo)JSON.parseObject((String)obj, DycActJDOrderPayInfo.class);
                                if (payInfo.getFlag() == 2) {
                                    dycActJDOrderInfoBO.setOrderScore(payInfo.getPayMoney());
                                } else if (payInfo.getFlag() == 1) {
                                    dycActJDOrderInfoBO.setPersonMoney(payInfo.getPayMoney());
                                }
                            });
                        }
                        JSONArray ordItem = orderEntity.getJSONArray("skuList");
                        ArrayList<DycActJDOrderItemBO> dycActJDOrderItemBOS = new ArrayList<DycActJDOrderItemBO>();
                        if (ordItem != null) {
                            ordItem.forEach(item -> {
                                String obj = JSONObject.toJSONString((Object)item);
                                DycActJDOrderItemBO itemInfo = (DycActJDOrderItemBO)JSON.parseObject((String)obj, DycActJDOrderItemBO.class);
                                dycActJDOrderItemBOS.add(itemInfo);
                            });
                        }
                        dycActJDOrderInfoBO.setOrdItemList(dycActJDOrderItemBOS);
                        return dycActJDOrderInfoBO;
                    }).collect(Collectors.toList());
                    rspBO.setRows(dycActJDOrderInfoBOS);
                }
            }
        } else {
            rspBO.setRespCode((String)jsonObject.get((Object)"resultCode"));
            rspBO.setRespDesc((String)jsonObject.get((Object)"resultMessage"));
        }
        return rspBO;
    }
}

