/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.base.utils;

import com.tydic.dyc.atom.base.utils.RsaCoder;
import com.tydic.dyc.atom.base.utils.ShaUtil;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class SignatureUtil {
    public static String genSrcData(TreeMap<String, Object> paramMap, List<String> unSignKeyList) {
        StringBuilder sb = new StringBuilder();
        for (String iterator : unSignKeyList) {
            paramMap.remove(iterator);
        }
        for (Map.Entry<String, Object> result1 : paramMap.entrySet()) {
            if (result1.getValue() == null || ((String)result1.getValue()).trim().length() <= 0) continue;
            sb.append(result1.getKey() + "=" + result1.getValue() + "&");
        }
        String result2 = sb.toString();
        if (result2.endsWith("&")) {
            result2 = result2.substring(0, result2.length() - 1);
        }
        return result2;
    }

    public static String signString(Object object, List<String> unSignKeyList) throws IllegalArgumentException, IllegalAccessException {
        TreeMap<String, Object> map = SignatureUtil.objectToMap(object);
        return SignatureUtil.genSrcData(map, unSignKeyList);
    }

    public static TreeMap<String, Object> objectToMap(Object object) throws IllegalArgumentException, IllegalAccessException {
        TreeMap<String, Object> map = new TreeMap<String, Object>();
        for (Class<?> cls = object.getClass(); cls != Object.class; cls = cls.getSuperclass()) {
            Field[] fields;
            Field[] var7 = fields = cls.getDeclaredFields();
            int var6 = fields.length;
            for (int var5 = 0; var5 < var6; ++var5) {
                Field f = var7[var5];
                f.setAccessible(true);
                map.put(f.getName(), f.get(object));
            }
        }
        return map;
    }

    public static boolean verifySign(String s1, String signData, String rsaSignPubKey) {
        if (signData != null && signData.length() != 0) {
            if (rsaSignPubKey != null && rsaSignPubKey.length() != 0) {
                try {
                    String s2 = ShaUtil.encrypt(s1, "SHA-256");
                    byte[] signByte = RsaCoder.decryptBASE64(signData);
                    byte[] decryptArr = RsaCoder.decryptByPublicKey(signByte, rsaSignPubKey);
                    String decryptStr = new String(decryptArr);
                    if (s2.equals(decryptStr)) {
                        boolean flag = true;
                        return flag;
                    }
                    throw new RuntimeException("Signature verification failed.");
                }
                catch (Exception e) {
                    throw new RuntimeException("verify signature failed.", e);
                }
            }
            throw new IllegalArgumentException("Argument 'rsaSignPubKey' is null or empty");
        }
        throw new IllegalArgumentException("Argument 'signData' is null or empty");
    }
}

