/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.base.utils;

import com.ohaotian.plugin.file.FileClient;
import com.tydic.dyc.base.exception.BaseBusinessException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.xhtmlrenderer.pdf.ITextRenderer;

@Component
public class PDFTemplateUtil {
    @Value(value="${dyc.file.inst.data.path:dyc/file/instData}")
    private String instDataPath;
    @Autowired
    private FileClient fileClient;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ByteArrayOutputStream createPDF(Map<String, Object> data, String templateFileName) throws Exception {
        Configuration cfg = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
        cfg.setClassForTemplateLoading(PDFTemplateUtil.class, "/templates/arch");
        ITextRenderer renderer = new ITextRenderer();
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            renderer.getFontResolver().addFont("/templates/font/simsun.ttc", "Identity-H", false);
            cfg.setEncoding(Locale.CHINA, "UTF-8");
            Template template = cfg.getTemplate(templateFileName, "UTF-8");
            StringWriter writer = new StringWriter();
            template.process(data, (Writer)writer);
            writer.flush();
            String html = writer.toString();
            renderer.setDocumentFromString(html);
            renderer.layout();
            renderer.createPDF((OutputStream)out, false);
            renderer.finishPDF();
            out.flush();
            ByteArrayOutputStream byteArrayOutputStream = out;
            return byteArrayOutputStream;
        }
    }

    public String doCreate(Map<String, Object> data, String fileName, String templateName) {
        ByteArrayOutputStream baos = null;
        OutputStream out = null;
        try {
            baos = PDFTemplateUtil.createPDF(data, templateName);
            byte[] pdfBytes = baos.toByteArray();
            ByteArrayInputStream inputStream = new ByteArrayInputStream(pdfBytes);
            String fileDir = UUID.randomUUID().toString().replaceAll("-", "");
            if (!this.instDataPath.endsWith("/")) {
                this.instDataPath = this.instDataPath + "/";
            }
            String path = this.fileClient.uploadFileByInputStream(this.instDataPath + fileDir, fileName, (InputStream)inputStream);
            System.out.println("fileUrl:" + path);
            baos.close();
            String string = path;
            return string;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseBusinessException("8888", "\u5bfc\u51fa\u5931\u8d25\uff1a" + e.getMessage());
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }
}

