/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.busicommon.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.busicommon.api.DycUocApplyDealInvoiceFunction;
import com.tydic.dyc.atom.busicommon.bo.DycUocApplyDealInvoiceFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocApplyDealInvoiceFuncRspBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocDealInvoiceSubmitFuncBO;
import com.tydic.dyc.oc.service.domainservice.UocApplyDealInvoiceService;
import com.tydic.dyc.oc.service.domainservice.bo.UocApplyDealInvoiceReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocApplyDealInvoiceRspBo;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycUocApplyDealInvoiceFunctionImpl
implements DycUocApplyDealInvoiceFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocApplyDealInvoiceFunctionImpl.class);
    @Value(value="${esb.invoiceApply.url:/OSN/api/invoiceApply/v1}")
    private String DEAL_INVOICE_URL;
    @Autowired
    private UocApplyDealInvoiceService uocApplyDealInvoiceService;

    @Override
    public DycUocApplyDealInvoiceFuncRspBO dealApplyDealInvoice(DycUocApplyDealInvoiceFuncReqBO reqBO) {
        DycUocApplyDealInvoiceFuncRspBO rspBO = new DycUocApplyDealInvoiceFuncRspBO();
        this.submitDealInvoice(reqBO);
        this.modifyApplyDealInvoice(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void submitDealInvoice(DycUocApplyDealInvoiceFuncReqBO reqBO) {
        log.info("\u5f00\u7968\u63d0\u4ea4\u8bf7\u6c42\u7535\u5546\u5165\u53c2: {}", (Object)JSON.toJSONString((Object)((Object)reqBO)));
        try {
            String hsn = DycPropertiesUtil.getProperty((String)("GC_SUPPLIER_ID_" + reqBO.getSupId()));
            DycUocDealInvoiceSubmitFuncBO dycUocDealInvoiceSubmitBo = this.packageSubmitDealInvoiceParam(reqBO);
            String httpRspStr = DycEsbUtil.doPostReuest((String)this.DEAL_INVOICE_URL, (String)JSON.toJSONString((Object)dycUocDealInvoiceSubmitBo), (String)"cggc");
            JSONObject httpRspJsonObject = JSON.parseObject((String)httpRspStr);
            if (!httpRspJsonObject.getBoolean("success").booleanValue()) {
                log.info("\u5f00\u7968\u63d0\u4ea4\u8bf7\u6c42\u7535\u5546|\u8c03\u7528\u7535\u5546\u7533\u8bf7\u5f00\u7968\u5931\u8d25|\u5931\u8d25\u539f\u56e0: {}", (Object)httpRspJsonObject.getString("resultMessage"));
                throw new ZTBusinessException("\u5f00\u7968\u63d0\u4ea4\u8bf7\u6c42\u7535\u5546|\u8c03\u7528\u7535\u5546\u7533\u8bf7\u5f00\u7968\u5931\u8d25|\u5931\u8d25\u539f\u56e0: " + httpRspJsonObject.getString("resultMessage"));
            }
        }
        catch (Exception e) {
            log.error("\u5f00\u7968\u63d0\u4ea4\u8bf7\u6c42\u7535\u5546|\u8c03\u7528\u7535\u5546\u7533\u8bf7\u5f00\u7968\u5f02\u5e38|\u5f02\u5e38\u539f\u56e0: {}", (Object)e.getMessage());
            throw new ZTBusinessException("\u5f00\u7968\u63d0\u4ea4\u8bf7\u6c42\u7535\u5546|\u8c03\u7528\u7535\u5546\u7533\u8bf7\u5f00\u7968\u5f02\u5e38|\u5f02\u5e38\u539f\u56e0: " + e.getMessage());
        }
    }

    private DycUocDealInvoiceSubmitFuncBO packageSubmitDealInvoiceParam(DycUocApplyDealInvoiceFuncReqBO reqBO) {
        DycUocDealInvoiceSubmitFuncBO dycUocDealInvoiceSubmitFuncBO = new DycUocDealInvoiceSubmitFuncBO();
        dycUocDealInvoiceSubmitFuncBO.setSupplierOrder(CollectionUtil.newArrayList((Object[])new String[]{reqBO.getSaleOrderNoExt()}));
        dycUocDealInvoiceSubmitFuncBO.setMarkId(String.valueOf(reqBO.getSaleOrderId()));
        dycUocDealInvoiceSubmitFuncBO.setSettlementId(String.valueOf(reqBO.getSaleOrderId()));
        dycUocDealInvoiceSubmitFuncBO.setInvoiceType(3);
        dycUocDealInvoiceSubmitFuncBO.setInvoiceOrg("1");
        dycUocDealInvoiceSubmitFuncBO.setBizInvoiceContent(1);
        dycUocDealInvoiceSubmitFuncBO.setInvoiceDate(new SimpleDateFormat("yyyy-MM-dd").format(new Date()));
        dycUocDealInvoiceSubmitFuncBO.setTitle(reqBO.getBuyerName());
        dycUocDealInvoiceSubmitFuncBO.setEnterpriseTaxpayer(reqBO.getInvoiceNo());
        dycUocDealInvoiceSubmitFuncBO.setBillToParty(reqBO.getContactCompany());
        dycUocDealInvoiceSubmitFuncBO.setBillToer(reqBO.getContactName());
        dycUocDealInvoiceSubmitFuncBO.setBillToContact(reqBO.getContactMobile());
        dycUocDealInvoiceSubmitFuncBO.setBillToProvince(Integer.valueOf(reqBO.getContactProvinceId()));
        dycUocDealInvoiceSubmitFuncBO.setBillToCity(Integer.valueOf(reqBO.getContactCityId()));
        dycUocDealInvoiceSubmitFuncBO.setBillToCounty(ObjectUtil.isNotEmpty((Object)reqBO.getContactCountyId()) ? Integer.parseInt(reqBO.getContactCountyId()) : 0);
        dycUocDealInvoiceSubmitFuncBO.setBillToTown(ObjectUtil.isNotEmpty((Object)reqBO.getContactTownId()) ? Integer.parseInt(reqBO.getContactTownId()) : 0);
        dycUocDealInvoiceSubmitFuncBO.setBillToAddress(reqBO.getContactProvinceName() + reqBO.getContactCityName() + reqBO.getContactCountyName() + reqBO.getContactTown() + reqBO.getContactAddress());
        dycUocDealInvoiceSubmitFuncBO.setInvoiceNum(1);
        dycUocDealInvoiceSubmitFuncBO.setInvoicePrice(reqBO.getTotalSaleFee());
        dycUocDealInvoiceSubmitFuncBO.setCurrentBatch(1L);
        dycUocDealInvoiceSubmitFuncBO.setTotalBatch(1L);
        dycUocDealInvoiceSubmitFuncBO.setTotalBatchInvoiceAmount(reqBO.getTotalSaleFee());
        return dycUocDealInvoiceSubmitFuncBO;
    }

    private void modifyApplyDealInvoice(DycUocApplyDealInvoiceFuncReqBO reqBO) {
        UocApplyDealInvoiceReqBo uocApplyDealInvoiceReqBo = new UocApplyDealInvoiceReqBo();
        uocApplyDealInvoiceReqBo.setSaleOrderId(reqBO.getSaleOrderId());
        UocApplyDealInvoiceRspBo uocApplyDealInvoiceRspBo = this.uocApplyDealInvoiceService.dealApplyDealInvoice(uocApplyDealInvoiceReqBo);
        if (!"0000".equals(uocApplyDealInvoiceRspBo.getRespCode())) {
            throw new ZTBusinessException("\u7f16\u8f91\u7533\u8bf7\u5f00\u7968\u4fe1\u606f|\u7f16\u8f91\u7533\u8bf7\u5f00\u7968\u4fe1\u606f\u5931\u8d25|\u5931\u8d25\u539f\u56e0: " + uocApplyDealInvoiceRspBo.getMessage());
        }
    }
}

