/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.busicommon.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.IdUtil;
import com.tydic.dyc.atom.busicommon.api.DycUocPayOrderRefundFunction;
import com.tydic.dyc.atom.busicommon.bo.DycUocPayOrderRefundFuncReqBO;
import com.tydic.dyc.atom.busicommon.bo.DycUocPayOrderRefundFuncRspBO;
import com.tydic.payment.pay.ability.PayProRefundAbilityService;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityReqBo;
import com.tydic.payment.pay.ability.bo.PayProRefundAbilityRspBo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DycUocPayOrderRefundFunctionImpl
implements DycUocPayOrderRefundFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocPayOrderRefundFunctionImpl.class);
    @Value(value="${uoc.gc.payOrder.busiCode:D500}")
    private String BUSI_CODE;
    @Autowired
    private PayProRefundAbilityService payProRefundAbilityService;

    @Override
    public DycUocPayOrderRefundFuncRspBO dealPayOrderRefund(DycUocPayOrderRefundFuncReqBO reqBO) {
        DycUocPayOrderRefundFuncRspBO rspBO = new DycUocPayOrderRefundFuncRspBO();
        this.dealPayProRefund(reqBO);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealPayProRefund(DycUocPayOrderRefundFuncReqBO reqBO) {
        PayProRefundAbilityReqBo payProRefundAbilityReqBo = new PayProRefundAbilityReqBo();
        payProRefundAbilityReqBo.setBusiCode(this.BUSI_CODE);
        payProRefundAbilityReqBo.setRefundOutOrderId(String.valueOf(IdUtil.nextId()));
        payProRefundAbilityReqBo.setOriOutOrderId(reqBO.getOriOutOrderId());
        payProRefundAbilityReqBo.setRefundFee(reqBO.getRefundFee());
        PayProRefundAbilityRspBo payProRefundAbilityRspBo = this.payProRefundAbilityService.dealRefund(payProRefundAbilityReqBo);
        if (!"0000".equals(payProRefundAbilityRspBo.getRespCode())) {
            throw new ZTBusinessException("\u8ba2\u5355\u5728\u7ebf\u652f\u4ed8\u9000\u6b3e|\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3|\u8c03\u7528\u670d\u52a1\u5931\u8d25|\u5931\u8d25\u539f\u56e0: " + payProRefundAbilityRspBo.getRespDesc());
        }
        if (!"SUCCESS".equals(payProRefundAbilityRspBo.getResultCode())) {
            throw new ZTBusinessException("\u8ba2\u5355\u5728\u7ebf\u652f\u4ed8\u9000\u6b3e|\u8c03\u7528\u652f\u4ed8\u4e2d\u5fc3|\u8ba2\u5355\u9000\u6b3e\u5931\u8d25|\u5931\u8d25\u539f\u56e0: " + payProRefundAbilityRspBo.getResultMsg());
        }
    }
}

