/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.busicommon.arch.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.atom.base.constants.DycFuncCommonConstants;
import com.tydic.dyc.atom.base.utils.PDFTemplateUtil;
import com.tydic.dyc.atom.busicommon.arch.api.DycInquiryArchivistFunction;
import com.tydic.dyc.atom.busicommon.arch.bo.DycArchiveFileFuncBo;
import com.tydic.dyc.atom.busicommon.arch.bo.DycArchiveMainFuncBo;
import com.tydic.dyc.atom.busicommon.arch.bo.DycInquiryArchivistFuncReqBo;
import com.tydic.dyc.atom.busicommon.arch.bo.DycInquiryArchivistFuncRspBo;
import com.tydic.dyc.umc.service.enterprise.UmcQryOrgDropDownListService;
import com.tydic.dyc.umc.service.enterprise.bo.UmcDropDownTreeBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgDropDownListReqBO;
import com.tydic.dyc.umc.service.enterprise.bo.UmcQryOrgDropDownListRspBO;
import com.tydic.dyc.umc.service.sysdictionary.UmcQueryBypCodeBackPoService;
import com.tydic.dyc.umc.service.sysdictionary.bo.UmcQueryBypCodeBackPoReqBo;
import com.tydic.dyc.umc.service.sysdictionary.bo.UmcQueryBypCodeBackPoRspBo;
import com.tydic.jn.personal.service.inquiry.api.JnInquiryArchivistDataQryService;
import com.tydic.jn.personal.service.inquiry.bo.JnInquiryArchivistDataQryReqBO;
import com.tydic.jn.personal.service.inquiry.bo.JnInquiryArchivistDataQryRspBO;
import com.tydic.jn.personal.service.inquiry.bo.JnInquiryFileBaseInfoBO;
import com.tydic.jn.personal.service.inquiry.bo.JnInquirySelectedResultInfoBO;
import com.tydic.jn.personal.service.inquiry.bo.JnInquirySupplierOfferInfoBO;
import com.tydic.osworkflow.approve.ability.EacQueryOperationRecordsListAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacOperationRecordsInfoAbilityBO;
import com.tydic.osworkflow.approve.ability.bo.EacQueryOperationRecordsListAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacQueryOperationRecordsListAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycInquiryArchivistFunctionImpl
implements DycInquiryArchivistFunction {
    private static final Logger log = LoggerFactory.getLogger(DycInquiryArchivistFunctionImpl.class);
    @Autowired
    private JnInquiryArchivistDataQryService jnInquiryArchivistDataQryService;
    @Autowired
    private EacQueryOperationRecordsListAbilityService eacQueryOperationRecordsListAbilityService;
    @Autowired
    private PDFTemplateUtil pdfTemplateUtil;
    @Autowired
    private UmcQueryBypCodeBackPoService umcQueryBypCodeBackPoService;
    @Autowired
    private UmcQryOrgDropDownListService umcQryOrgDropDownListService;

    @Override
    public DycInquiryArchivistFuncRspBo dealInquiryArchivist(DycInquiryArchivistFuncReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo)) {
            throw new ZTBusinessException("\u8be2\u4ef7\u5355\u5f52\u6863\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getInquiryId())) {
            throw new ZTBusinessException("\u8be2\u4ef7\u5355\u5f52\u6863\u539f\u5b50\u670d\u52a1\u5165\u53c2\u4e3a\u7a7a");
        }
        JnInquiryArchivistDataQryReqBO dataQryReqBO = new JnInquiryArchivistDataQryReqBO();
        dataQryReqBO.setInquiryId(reqBo.getInquiryId());
        JnInquiryArchivistDataQryRspBO dataQryRspBO = this.jnInquiryArchivistDataQryService.qryArchivistData(dataQryReqBO);
        if (!"0000".equals(dataQryRspBO.getRespCode())) {
            throw new ZTBusinessException(dataQryRspBO.getRespDesc());
        }
        List<EacOperationRecordsInfoAbilityBO> inquiryAuditList = this.getRecordsList(dataQryRspBO.getInquiryAuditProcInstId());
        List<EacOperationRecordsInfoAbilityBO> inquirySelectedAuditList = this.getRecordsList(dataQryRspBO.getInquirySelectedAuditProcInstId());
        List<UmcDropDownTreeBO> inquirySupplierList = this.getInquirySupplierList(dataQryRspBO);
        DycInquiryArchivistFuncRspBo rspBo = new DycInquiryArchivistFuncRspBo();
        DycInquiryArchivistFunctionImpl.setMain(dataQryRspBO, rspBo);
        ArrayList<DycArchiveFileFuncBo> dycArchiveFileFuncBos = new ArrayList<DycArchiveFileFuncBo>();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("jnInquiryBaseInfoBO", dataQryRspBO.getJnInquiryBaseInfoBO());
        data.put("jnInquiryPlanItemInfoBOS", dataQryRspBO.getJnInquiryPlanItemInfoBOS());
        data.put("jnInquirySupplierOfferInfoBOS", dataQryRspBO.getJnInquirySupplierOfferInfoBOS());
        data.put("jnInquirySelectedResultInfoBOS", dataQryRspBO.getJnInquirySelectedResultInfoBOS());
        data.put("jnInquiryPlanSelectedInfoBOS", dataQryRspBO.getJnInquiryPlanSelectedInfoBOS());
        data.put("jnInquirySelectedNoticeBOS", dataQryRspBO.getJnInquirySelectedNoticeBOS());
        data.put("inquiryAuditList", inquiryAuditList);
        data.put("inquirySelectedAuditList", inquirySelectedAuditList);
        data.put("inquirySupplierList", inquirySupplierList);
        String dateStr = DateUtils.dateToStr((Date)new Date(), (String)"yyyyMMddHHmmss");
        this.setSupplierInvite(dataQryRspBO, dycArchiveFileFuncBos, data, dateStr);
        this.setSupplierPurchase(dycArchiveFileFuncBos);
        this.setSupplierPublic(dycArchiveFileFuncBos);
        this.setSupplierInternal(dycArchiveFileFuncBos);
        this.setSupplierInvite(dycArchiveFileFuncBos, dataQryRspBO.getJnInquiryFileBaseInfoBO());
        this.setSupplierQuote(dataQryRspBO, dycArchiveFileFuncBos);
        this.setSupplierQuoteResponse(dycArchiveFileFuncBos);
        this.setSupplierQuoteOther(dycArchiveFileFuncBos);
        this.setSupplierChooseNotice(dataQryRspBO, dycArchiveFileFuncBos);
        this.setSupplierChooseDesc(dycArchiveFileFuncBos);
        this.setSupplierChooseApproval(dataQryRspBO, dycArchiveFileFuncBos, data, dateStr);
        this.setOtherAttachment(dycArchiveFileFuncBos);
        rspBo.setDycArchiveFileFuncBos(dycArchiveFileFuncBos);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void setOtherAttachment(List<DycArchiveFileFuncBo> dycArchiveFileFuncBos) {
        DycArchiveFileFuncBo fileFuncBo = new DycArchiveFileFuncBo();
        fileFuncBo.setBusiType(20);
        fileFuncBo.setBusiTypeName("\u8865\u5145");
        fileFuncBo.setFileCategory(30);
        fileFuncBo.setFileCategoryName("\u5176\u4ed6\u9644\u4ef6");
        dycArchiveFileFuncBos.add(fileFuncBo);
    }

    private void setSupplierChooseApproval(JnInquiryArchivistDataQryRspBO dataQryRspBO, List<DycArchiveFileFuncBo> dycArchiveFileFuncBos, Map<String, Object> data, String dateStr) {
        DycArchiveFileFuncBo fileFuncBo = new DycArchiveFileFuncBo();
        fileFuncBo.setBusiType(10);
        fileFuncBo.setBusiTypeName("\u8be2\u4ef7\u5355\u4e2d\u9009");
        fileFuncBo.setFileCategory(29);
        fileFuncBo.setFileCategoryName("\u8d85\u5e02\u8be2\u4ef7\u5355\u4e2d\u9009\u5ba1\u6279\u5355\u6587\u4ef6");
        String fileName = dataQryRspBO.getJnInquiryBaseInfoBO().getInquiryCode() + "-" + "\u8d85\u5e02\u8be2\u4ef7\u5355\u4e2d\u9009\u5ba1\u6279\u5355\u6587\u4ef6" + "-" + dateStr + ".pdf";
        String filePath = this.pdfTemplateUtil.doCreate(data, fileName, "inquirySelectedAudit.ftl");
        fileFuncBo.setFileUrl(filePath);
        fileFuncBo.setFileName(fileName);
        dycArchiveFileFuncBos.add(fileFuncBo);
    }

    private void setSupplierChooseDesc(List<DycArchiveFileFuncBo> dycArchiveFileFuncBos) {
        DycArchiveFileFuncBo fileFuncBo = new DycArchiveFileFuncBo();
        fileFuncBo.setBusiType(10);
        fileFuncBo.setBusiTypeName("\u8be2\u4ef7\u5355\u4e2d\u9009");
        fileFuncBo.setFileCategory(28);
        fileFuncBo.setFileCategoryName("\u8d85\u5e02\u8be2\u4ef7\u5355\u4e2d\u9009\u8bf4\u660e\u9644\u4ef6");
        dycArchiveFileFuncBos.add(fileFuncBo);
    }

    private void setSupplierQuoteOther(List<DycArchiveFileFuncBo> dycArchiveFileFuncBos) {
        DycArchiveFileFuncBo fileFuncBo = new DycArchiveFileFuncBo();
        fileFuncBo.setBusiType(9);
        fileFuncBo.setBusiTypeName("\u4f9b\u5e94\u5546\u62a5\u4ef7");
        fileFuncBo.setFileCategory(26);
        fileFuncBo.setFileCategoryName("\u8d85\u5e02\u8be2\u4ef7\u5355\u4f9b\u5e94\u5546\u62a5\u4ef7\u5176\u4ed6\u6587\u4ef6");
        dycArchiveFileFuncBos.add(fileFuncBo);
    }

    private void setSupplierQuoteResponse(List<DycArchiveFileFuncBo> dycArchiveFileFuncBos) {
        DycArchiveFileFuncBo fileFuncBo = new DycArchiveFileFuncBo();
        fileFuncBo.setBusiType(9);
        fileFuncBo.setBusiTypeName("\u4f9b\u5e94\u5546\u62a5\u4ef7");
        fileFuncBo.setFileCategory(25);
        fileFuncBo.setFileCategoryName("\u8d85\u5e02\u8be2\u4ef7\u5355\u4f9b\u5e94\u5546\u62a5\u4ef7\u54cd\u5e94\u6587\u4ef6");
        dycArchiveFileFuncBos.add(fileFuncBo);
    }

    private void setSupplierInvite(JnInquiryArchivistDataQryRspBO dataQryRspBO, List<DycArchiveFileFuncBo> dycArchiveFileFuncBos, Map<String, Object> data, String dateStr) {
        DycArchiveFileFuncBo fileFuncBo = new DycArchiveFileFuncBo();
        fileFuncBo.setBusiType(8);
        fileFuncBo.setBusiTypeName("\u8d85\u5e02\u8be2\u4ef7\u5355");
        fileFuncBo.setFileCategory(19);
        fileFuncBo.setFileCategoryName("\u8d85\u5e02\u8be2\u4ef7\u5355\u5ba1\u6279\u5355\u6587\u4ef6");
        String fileName = dataQryRspBO.getJnInquiryBaseInfoBO().getInquiryCode() + "-" + "\u8d85\u5e02\u8be2\u4ef7\u5355\u5ba1\u6279\u5355\u6587\u4ef6" + "-" + dateStr + ".pdf";
        String filePath = this.pdfTemplateUtil.doCreate(data, fileName, "inquiryAudit.ftl");
        fileFuncBo.setFileUrl(filePath);
        fileFuncBo.setFileName(fileName);
        dycArchiveFileFuncBos.add(fileFuncBo);
    }

    private List<UmcDropDownTreeBO> getInquirySupplierList(JnInquiryArchivistDataQryRspBO dataQryRspBO) {
        UmcQueryBypCodeBackPoReqBo keysReqBo = new UmcQueryBypCodeBackPoReqBo();
        if (1 == dataQryRspBO.getJnInquiryBaseInfoBO().getInquiryType()) {
            keysReqBo.setPCode("CATEGORY_DISCOUNT_RATE_IOP");
        } else if (2 == dataQryRspBO.getJnInquiryBaseInfoBO().getInquiryType()) {
            keysReqBo.setPCode("CATEGORY_DISCOUNT_RATE_VOP");
        }
        UmcQueryBypCodeBackPoRspBo keysIopRspBo = this.umcQueryBypCodeBackPoService.queryBypCodeBackPo(keysReqBo);
        List supplierIds = keysIopRspBo.getData().stream().map(item -> Long.valueOf(item.getCode())).collect(Collectors.toList());
        UmcQryOrgDropDownListReqBO downListReqBO = new UmcQryOrgDropDownListReqBO();
        downListReqBO.setOrgIds(supplierIds);
        downListReqBO.setQueryContact("1");
        UmcQryOrgDropDownListRspBO downListRspBO = this.umcQryOrgDropDownListService.qryOrgDropDownList(downListReqBO);
        if (!"0000".equals(dataQryRspBO.getRespCode())) {
            throw new ZTBusinessException(dataQryRspBO.getRespDesc());
        }
        return downListRspBO.getRows();
    }

    private List<EacOperationRecordsInfoAbilityBO> getRecordsList(String procInstId) {
        EacQueryOperationRecordsListAbilityReqBO recordsListAbilityReqBO = new EacQueryOperationRecordsListAbilityReqBO();
        recordsListAbilityReqBO.setProcInstId(procInstId);
        recordsListAbilityReqBO.setPageNo(Integer.valueOf(1));
        recordsListAbilityReqBO.setPageSize(Integer.valueOf(1000));
        EacQueryOperationRecordsListAbilityRspBO eacQueryOperationRecordsListAbilityRspBO = this.eacQueryOperationRecordsListAbilityService.queryOperationRecordsList(recordsListAbilityReqBO);
        if (!"0000".equals(eacQueryOperationRecordsListAbilityRspBO.getRespCode())) {
            throw new ZTBusinessException("\u83b7\u53d6\u64cd\u4f5c\u5386\u53f2\u5931\u8d25,\u5f02\u5e38\u7f16\u7801\u3010" + eacQueryOperationRecordsListAbilityRspBO.getRespCode() + "\u3011," + eacQueryOperationRecordsListAbilityRspBO.getRespDesc());
        }
        return eacQueryOperationRecordsListAbilityRspBO.getRows();
    }

    private void setSupplierInvite(List<DycArchiveFileFuncBo> dycArchiveFileFuncBos, JnInquiryFileBaseInfoBO jnInquiryFileBaseInfoBO) {
        DycArchiveFileFuncBo fileFuncBo = new DycArchiveFileFuncBo();
        fileFuncBo.setBusiType(8);
        fileFuncBo.setBusiTypeName("\u8d85\u5e02\u8be2\u4ef7\u5355");
        fileFuncBo.setFileCategory(23);
        fileFuncBo.setFileCategoryName("\u8d85\u5e02\u8be2\u4ef7\u5355\u9080\u8bf7\u51fd\u6587\u4ef6");
        fileFuncBo.setFileName(jnInquiryFileBaseInfoBO.getFileName());
        fileFuncBo.setFileUrl(jnInquiryFileBaseInfoBO.getFileUrl());
        dycArchiveFileFuncBos.add(fileFuncBo);
    }

    private void setSupplierInternal(List<DycArchiveFileFuncBo> dycArchiveFileFuncBos) {
        DycArchiveFileFuncBo fileFuncBo = new DycArchiveFileFuncBo();
        fileFuncBo.setBusiType(8);
        fileFuncBo.setBusiTypeName("\u8d85\u5e02\u8be2\u4ef7\u5355");
        fileFuncBo.setFileCategory(22);
        fileFuncBo.setFileCategoryName("\u8d85\u5e02\u8be2\u4ef7\u5355\u5185\u90e8\u9644\u4ef6");
        dycArchiveFileFuncBos.add(fileFuncBo);
    }

    private void setSupplierPublic(List<DycArchiveFileFuncBo> dycArchiveFileFuncBos) {
        DycArchiveFileFuncBo fileFuncBo = new DycArchiveFileFuncBo();
        fileFuncBo.setBusiType(8);
        fileFuncBo.setBusiTypeName("\u8d85\u5e02\u8be2\u4ef7\u5355");
        fileFuncBo.setFileCategory(21);
        fileFuncBo.setFileCategoryName("\u8d85\u5e02\u8be2\u4ef7\u5355\u516c\u5f00\u9644\u4ef6");
        dycArchiveFileFuncBos.add(fileFuncBo);
    }

    private void setSupplierPurchase(List<DycArchiveFileFuncBo> dycArchiveFileFuncBos) {
        DycArchiveFileFuncBo fileFuncBo = new DycArchiveFileFuncBo();
        fileFuncBo.setBusiType(8);
        fileFuncBo.setBusiTypeName("\u8d85\u5e02\u8be2\u4ef7\u5355");
        fileFuncBo.setFileCategory(20);
        fileFuncBo.setFileCategoryName("\u8d85\u5e02\u8be2\u4ef7\u5355\u91c7\u8d2d\u9644\u4ef6");
        dycArchiveFileFuncBos.add(fileFuncBo);
    }

    private void setSupplierChooseNotice(JnInquiryArchivistDataQryRspBO dataQryRspBO, List<DycArchiveFileFuncBo> dycArchiveFileFuncBos) {
        if (!CollectionUtils.isEmpty((Collection)dataQryRspBO.getJnInquirySelectedResultInfoBOS())) {
            for (JnInquirySelectedResultInfoBO jnInquirySelectedResultInfoBO : dataQryRspBO.getJnInquirySelectedResultInfoBOS()) {
                DycArchiveFileFuncBo fileFuncBo = new DycArchiveFileFuncBo();
                fileFuncBo.setBusiType(10);
                fileFuncBo.setBusiTypeName("\u8be2\u4ef7\u5355\u4e2d\u9009");
                fileFuncBo.setFileCategory(27);
                fileFuncBo.setFileCategoryName("\u8d85\u5e02\u8be2\u4ef7\u5355\u4e2d\u9009\u901a\u77e5\u4e66\u6587\u4ef6");
                fileFuncBo.setFileName(jnInquirySelectedResultInfoBO.getFileName());
                fileFuncBo.setFileUrl(jnInquirySelectedResultInfoBO.getFileUrl());
                dycArchiveFileFuncBos.add(fileFuncBo);
            }
        }
    }

    private void setSupplierQuote(JnInquiryArchivistDataQryRspBO dataQryRspBO, List<DycArchiveFileFuncBo> dycArchiveFileFuncBos) {
        if (!CollectionUtils.isEmpty((Collection)dataQryRspBO.getJnInquirySupplierOfferInfoBOS())) {
            for (JnInquirySupplierOfferInfoBO jnInquirySupplierOfferInfoBO : dataQryRspBO.getJnInquirySupplierOfferInfoBOS()) {
                DycArchiveFileFuncBo fileFuncBo = new DycArchiveFileFuncBo();
                fileFuncBo.setBusiType(9);
                fileFuncBo.setBusiTypeName("\u4f9b\u5e94\u5546\u62a5\u4ef7");
                fileFuncBo.setFileCategory(24);
                fileFuncBo.setFileCategoryName("\u8d85\u5e02\u8be2\u4ef7\u5355\u4f9b\u5e94\u5546\u62a5\u4ef7\u5355\u6587\u4ef6");
                fileFuncBo.setFileName(jnInquirySupplierOfferInfoBO.getFileName());
                fileFuncBo.setFileUrl(jnInquirySupplierOfferInfoBO.getFileUrl());
                dycArchiveFileFuncBos.add(fileFuncBo);
            }
        }
    }

    private static void setMain(JnInquiryArchivistDataQryRspBO dataQryRspBO, DycInquiryArchivistFuncRspBo rspBo) {
        DycArchiveMainFuncBo mainFuncBo = new DycArchiveMainFuncBo();
        mainFuncBo.setObjId(Convert.toStr((Object)dataQryRspBO.getJnInquiryBaseInfoBO().getInquiryId()));
        mainFuncBo.setObjCode(dataQryRspBO.getJnInquiryBaseInfoBO().getInquiryCode());
        mainFuncBo.setObjType(DycFuncCommonConstants.ArchivistMainObjType.INQUIRY_ORDER);
        mainFuncBo.setObjName(dataQryRspBO.getJnInquiryBaseInfoBO().getInquiryName());
        mainFuncBo.setAreaType(dataQryRspBO.getJnInquiryBaseInfoBO().getInquiryType());
        mainFuncBo.setAreaTypeName(dataQryRspBO.getJnInquiryBaseInfoBO().getInquiryTypeStr());
        mainFuncBo.setObjCreateTime(dataQryRspBO.getJnInquiryBaseInfoBO().getCreateTime());
        mainFuncBo.setObjCreateCompanyId(dataQryRspBO.getJnInquiryBaseInfoBO().getCreateCompanyId());
        mainFuncBo.setObjCreateOrgId(dataQryRspBO.getJnInquiryBaseInfoBO().getCreateOrgId());
        mainFuncBo.setObjCreateUserId(dataQryRspBO.getJnInquiryBaseInfoBO().getCreateUserId());
        mainFuncBo.setObjCreateCompanyName(dataQryRspBO.getJnInquiryBaseInfoBO().getCreateCompanyName());
        mainFuncBo.setObjCreateOrgName(dataQryRspBO.getJnInquiryBaseInfoBO().getCreateOrgName());
        mainFuncBo.setObjCreateUserName(dataQryRspBO.getJnInquiryBaseInfoBO().getCreateUserName());
        mainFuncBo.setEnquiryStartTime(dataQryRspBO.getJnInquiryBaseInfoBO().getInquiryStartTime());
        mainFuncBo.setEnquiryEndTime(dataQryRspBO.getJnInquiryBaseInfoBO().getInquiryEndTime());
        mainFuncBo.setEnquiryFinishTime(dataQryRspBO.getJnInquiryBaseInfoBO().getFinishTime());
        rspBo.setDycArchiveMainFuncBo(mainFuncBo);
    }
}

