/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.busicommon.arch.impl;

import cn.hutool.core.convert.Convert;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.DateUtils;
import com.tydic.dyc.atom.base.constants.DycFuncCommonConstants;
import com.tydic.dyc.atom.base.utils.PDFTemplateUtil;
import com.tydic.dyc.atom.busicommon.arch.api.DycSaleOrderArchivistFunction;
import com.tydic.dyc.atom.busicommon.arch.bo.DycArchiveFileFuncBo;
import com.tydic.dyc.atom.busicommon.arch.bo.DycArchiveMainFuncBo;
import com.tydic.dyc.atom.busicommon.arch.bo.DycSaleOrderArchivistFuncReqBo;
import com.tydic.dyc.atom.busicommon.arch.bo.DycSaleOrderArchivistFuncRspBo;
import com.tydic.dyc.oc.service.domainservice.UocArchivistDataQryService;
import com.tydic.dyc.oc.service.domainservice.bo.UocArchivistCmpOrderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArchivistCmpOrderItemBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArchivistDataQryReqBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArchivistDataQryRspBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArchivistInspOrderBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArchivistOrderAccessoryBo;
import com.tydic.dyc.oc.service.domainservice.bo.UocArchivistSaleOrderItemBo;
import com.tydic.fsc.bo.FscAchivistDataQryBySaleOrderIdBo;
import com.tydic.fsc.common.ability.api.FscAchivistDataQryBySaleOrderIdAbilityService;
import com.tydic.fsc.common.ability.bo.FscAchivistDataQryBySaleOrderIdAbilityReqBo;
import com.tydic.fsc.common.ability.bo.FscAchivistDataQryBySaleOrderIdAbilityRspBo;
import com.tydic.jn.personal.api.serviceArchive.ServicePlanItemAttachmentsQryService;
import com.tydic.jn.personal.api.servicesaleorder.ServiceSaleOrderApiService;
import com.tydic.jn.personal.bo.serviceArchive.ServicePlanItemAttachmentsBo;
import com.tydic.jn.personal.bo.serviceArchive.ServicePlanItemAttachmentsQryReqBo;
import com.tydic.jn.personal.bo.serviceArchive.ServicePlanItemAttachmentsQryRspBo;
import com.tydic.jn.personal.bo.servicesaleorder.ServiceSaleOrderQueryListRespBo;
import com.tydic.jn.personal.bo.servicesaleorder.ServiceSaleOrderQueryReqBo;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycSaleOrderArchivistFunctionImpl
implements DycSaleOrderArchivistFunction {
    private static final Logger log = LoggerFactory.getLogger(DycSaleOrderArchivistFunctionImpl.class);
    @Autowired
    private UocArchivistDataQryService uocArchivistDataQryService;
    @Autowired
    private PDFTemplateUtil pdfTemplateUtil;
    @Autowired
    private FscAchivistDataQryBySaleOrderIdAbilityService fscAchivistDataQryBySaleOrderIdAbilityService;
    @Autowired
    private ServiceSaleOrderApiService serviceSaleOrderApiService;
    @Autowired
    private ServicePlanItemAttachmentsQryService servicePlanItemAttachmentsQryService;

    @Override
    public DycSaleOrderArchivistFuncRspBo dealSaleOrderArchivist(DycSaleOrderArchivistFuncReqBo reqBo) {
        DycSaleOrderArchivistFuncRspBo rspBo = new DycSaleOrderArchivistFuncRspBo();
        rspBo.setRespCode("0000");
        UocArchivistDataQryReqBo uocArchivistDataQryReqBo = new UocArchivistDataQryReqBo();
        uocArchivistDataQryReqBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocArchivistDataQryRspBo uocArchivistDataQryRspBo = this.uocArchivistDataQryService.qryArchivistData(uocArchivistDataQryReqBo);
        if (!"0000".equals(uocArchivistDataQryRspBo.getRespCode())) {
            throw new ZTBusinessException(uocArchivistDataQryRspBo.getRespDesc());
        }
        FscAchivistDataQryBySaleOrderIdAbilityReqBo fscAchivistDataQryBySaleOrderIdAbilityReqBo = new FscAchivistDataQryBySaleOrderIdAbilityReqBo();
        fscAchivistDataQryBySaleOrderIdAbilityReqBo.setSaleOrderId(reqBo.getSaleOrderId());
        FscAchivistDataQryBySaleOrderIdAbilityRspBo fscAchivistDataQryBySaleOrderIdAbilityRspBo = this.fscAchivistDataQryBySaleOrderIdAbilityService.qryOrderList(fscAchivistDataQryBySaleOrderIdAbilityReqBo);
        if (!"0000".equals(fscAchivistDataQryBySaleOrderIdAbilityRspBo.getRespCode())) {
            throw new ZTBusinessException(fscAchivistDataQryBySaleOrderIdAbilityRspBo.getRespDesc());
        }
        ServiceSaleOrderQueryReqBo serviceSaleOrderQueryReqBo = new ServiceSaleOrderQueryReqBo();
        serviceSaleOrderQueryReqBo.setSaleOrderNo(uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getSaleOrderNo());
        ServiceSaleOrderQueryListRespBo serviceSaleOrderQueryListRespBo = this.serviceSaleOrderApiService.queryListSaleOrder(serviceSaleOrderQueryReqBo);
        if (!"0000".equals(serviceSaleOrderQueryListRespBo.getRespCode())) {
            throw new ZTBusinessException(serviceSaleOrderQueryListRespBo.getRespDesc());
        }
        DycSaleOrderArchivistFunctionImpl.setMain(rspBo, uocArchivistDataQryRspBo, fscAchivistDataQryBySaleOrderIdAbilityRspBo);
        ArrayList<DycArchiveFileFuncBo> dycSaleOrderArchivistFileFuncBos = new ArrayList<DycArchiveFileFuncBo>();
        List planItemNos = uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getUocArchivistSaleOrderItemBoList().stream().map(UocArchivistSaleOrderItemBo::getPlanItemNo).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(planItemNos)) {
            ServicePlanItemAttachmentsQryReqBo servicePlanItemAttachmentsQryReqBo = new ServicePlanItemAttachmentsQryReqBo();
            servicePlanItemAttachmentsQryReqBo.setPlanItemNoList(planItemNos);
            ServicePlanItemAttachmentsQryRspBo servicePlanItemAttachmentsQryRspBo = this.servicePlanItemAttachmentsQryService.qryPlanItemAttachmentsList(servicePlanItemAttachmentsQryReqBo);
            if (!"0000".equals(servicePlanItemAttachmentsQryRspBo.getRespCode())) {
                throw new ZTBusinessException(servicePlanItemAttachmentsQryRspBo.getRespDesc());
            }
            dycSaleOrderArchivistFileFuncBos.addAll(this.setPlanItemAttach(servicePlanItemAttachmentsQryRspBo));
        } else {
            dycSaleOrderArchivistFileFuncBos.addAll(this.setPlanItemAttach(new ServicePlanItemAttachmentsQryRspBo()));
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("saleOrderInfo", uocArchivistDataQryRspBo);
        data.put("fscOrderInfo", fscAchivistDataQryBySaleOrderIdAbilityRspBo);
        data.put("payTimeInfo", serviceSaleOrderQueryListRespBo);
        String dateStr = DateUtils.dateToStr((Date)new Date(), (String)"yyyyMMddHHmmss");
        if (uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getOrderSource().equals(2)) {
            dycSaleOrderArchivistFileFuncBos.add(this.createCmpOrderFile(uocArchivistDataQryRspBo, data, dateStr));
            dycSaleOrderArchivistFileFuncBos.addAll(this.oaFile(uocArchivistDataQryRspBo));
        }
        dycSaleOrderArchivistFileFuncBos.add(this.createConfirmOrderFile(uocArchivistDataQryRspBo, data, dateStr));
        dycSaleOrderArchivistFileFuncBos.add(this.createInspOrderFile(uocArchivistDataQryRspBo, data, dateStr));
        dycSaleOrderArchivistFileFuncBos.add(this.createAfterOrderFile(uocArchivistDataQryRspBo, data, dateStr));
        dycSaleOrderArchivistFileFuncBos.add(this.createSettleOrderFile(uocArchivistDataQryRspBo, data, dateStr, fscAchivistDataQryBySaleOrderIdAbilityRspBo));
        dycSaleOrderArchivistFileFuncBos.add(this.createReplenishmentFile());
        rspBo.setDycArchiveFileFuncBos(dycSaleOrderArchivistFileFuncBos);
        return rspBo;
    }

    private DycArchiveFileFuncBo createReplenishmentFile() {
        DycArchiveFileFuncBo dycArchiveFileFuncBo = new DycArchiveFileFuncBo();
        dycArchiveFileFuncBo.setFileCategory(30);
        dycArchiveFileFuncBo.setFileCategoryName("\u5176\u4ed6\u9644\u4ef6");
        dycArchiveFileFuncBo.setBusiType(20);
        dycArchiveFileFuncBo.setBusiTypeName("\u8865\u5145");
        return dycArchiveFileFuncBo;
    }

    private List<DycArchiveFileFuncBo> oaFile(UocArchivistDataQryRspBo uocArchivistDataQryRspBo) {
        ArrayList<DycArchiveFileFuncBo> dycArchiveFileFuncBos = new ArrayList<DycArchiveFileFuncBo>();
        if (CollectionUtils.isEmpty((Collection)uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getUocArchivistOrderAccessoryBoList())) {
            DycArchiveFileFuncBo dycArchiveFileFuncBo = new DycArchiveFileFuncBo();
            dycArchiveFileFuncBo.setFileCategory(4);
            dycArchiveFileFuncBo.setFileCategoryName("\u8ba2\u5355OA\u5ba1\u6279\u7ed3\u679c\u9644\u4ef6");
            dycArchiveFileFuncBo.setBusiType(1);
            dycArchiveFileFuncBo.setBusiTypeName("\u91c7\u8d2d\u8ba1\u5212");
            dycArchiveFileFuncBos.add(dycArchiveFileFuncBo);
            return dycArchiveFileFuncBos;
        }
        for (UocArchivistOrderAccessoryBo uocArchivistOrderAccessoryBo : uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getUocArchivistOrderAccessoryBoList()) {
            DycArchiveFileFuncBo dycArchiveFileFuncBo = new DycArchiveFileFuncBo();
            dycArchiveFileFuncBo.setFileCategory(4);
            dycArchiveFileFuncBo.setFileCategoryName("\u8ba2\u5355OA\u5ba1\u6279\u7ed3\u679c\u9644\u4ef6");
            dycArchiveFileFuncBo.setBusiType(1);
            dycArchiveFileFuncBo.setBusiTypeName("\u91c7\u8d2d\u8ba1\u5212");
            dycArchiveFileFuncBo.setFileName(uocArchivistOrderAccessoryBo.getAccessoryName());
            dycArchiveFileFuncBo.setFileUrl(uocArchivistOrderAccessoryBo.getAccessoryUrl());
            dycArchiveFileFuncBos.add(dycArchiveFileFuncBo);
        }
        return dycArchiveFileFuncBos;
    }

    private List<DycArchiveFileFuncBo> setPlanItemAttach(ServicePlanItemAttachmentsQryRspBo servicePlanItemAttachmentsQryRspBo) {
        ArrayList<DycArchiveFileFuncBo> dycArchiveFileFuncBos = new ArrayList<DycArchiveFileFuncBo>();
        if (CollectionUtils.isEmpty((Collection)servicePlanItemAttachmentsQryRspBo.getAttachmentsBoList())) {
            DycArchiveFileFuncBo planItemAttachBo = new DycArchiveFileFuncBo();
            planItemAttachBo.setFileCategory(1);
            planItemAttachBo.setFileCategoryName("\u91c7\u8d2d\u8ba1\u5212\u9644\u4ef6");
            planItemAttachBo.setBusiType(1);
            planItemAttachBo.setBusiTypeName("\u91c7\u8d2d\u8ba1\u5212");
            dycArchiveFileFuncBos.add(planItemAttachBo);
            DycArchiveFileFuncBo planItemReturnAttachBo = new DycArchiveFileFuncBo();
            planItemReturnAttachBo.setFileCategory(2);
            planItemReturnAttachBo.setFileCategoryName("\u7533\u8d2d\u4eba-\u9000\u56de\u8ba1\u5212\u9644\u4ef6");
            planItemReturnAttachBo.setBusiType(1);
            planItemReturnAttachBo.setBusiTypeName("\u91c7\u8d2d\u8ba1\u5212");
            dycArchiveFileFuncBos.add(planItemReturnAttachBo);
            return dycArchiveFileFuncBos;
        }
        ConcurrentMap<Integer, List<ServicePlanItemAttachmentsBo>> objTypeMap = servicePlanItemAttachmentsQryRspBo.getAttachmentsBoList().stream().collect(Collectors.groupingByConcurrent(ServicePlanItemAttachmentsBo::getObjType));
        List planItemAttachmentsBoList = (List)objTypeMap.get(2);
        if (CollectionUtils.isEmpty((Collection)planItemAttachmentsBoList)) {
            DycArchiveFileFuncBo planItemAttachBo = new DycArchiveFileFuncBo();
            planItemAttachBo.setFileCategory(1);
            planItemAttachBo.setFileCategoryName("\u91c7\u8d2d\u8ba1\u5212\u9644\u4ef6");
            planItemAttachBo.setBusiType(1);
            planItemAttachBo.setBusiTypeName("\u91c7\u8d2d\u8ba1\u5212");
            dycArchiveFileFuncBos.add(planItemAttachBo);
        } else {
            for (ServicePlanItemAttachmentsBo servicePlanItemAttachmentsBo : planItemAttachmentsBoList) {
                DycArchiveFileFuncBo planItemAttachBo = new DycArchiveFileFuncBo();
                planItemAttachBo.setFileCategory(1);
                planItemAttachBo.setFileCategoryName("\u91c7\u8d2d\u8ba1\u5212\u9644\u4ef6");
                planItemAttachBo.setBusiType(1);
                planItemAttachBo.setBusiTypeName("\u91c7\u8d2d\u8ba1\u5212");
                planItemAttachBo.setFileUrl(servicePlanItemAttachmentsBo.getFileUrl());
                planItemAttachBo.setFileName(servicePlanItemAttachmentsBo.getFileName());
                dycArchiveFileFuncBos.add(planItemAttachBo);
            }
        }
        List planItemReturnAttachmentsBoList = (List)objTypeMap.get(3);
        if (CollectionUtils.isEmpty((Collection)planItemReturnAttachmentsBoList)) {
            DycArchiveFileFuncBo planItemReturnAttachBo = new DycArchiveFileFuncBo();
            planItemReturnAttachBo.setFileCategory(2);
            planItemReturnAttachBo.setFileCategoryName("\u7533\u8d2d\u4eba-\u9000\u56de\u8ba1\u5212\u9644\u4ef6");
            planItemReturnAttachBo.setBusiType(1);
            planItemReturnAttachBo.setBusiTypeName("\u91c7\u8d2d\u8ba1\u5212");
            dycArchiveFileFuncBos.add(planItemReturnAttachBo);
        } else {
            for (ServicePlanItemAttachmentsBo servicePlanItemAttachmentsBo : planItemReturnAttachmentsBoList) {
                DycArchiveFileFuncBo planItemReturnAttachBo = new DycArchiveFileFuncBo();
                planItemReturnAttachBo.setFileCategory(2);
                planItemReturnAttachBo.setFileCategoryName("\u7533\u8d2d\u4eba-\u9000\u56de\u8ba1\u5212\u9644\u4ef6");
                planItemReturnAttachBo.setBusiType(1);
                planItemReturnAttachBo.setBusiTypeName("\u91c7\u8d2d\u8ba1\u5212");
                planItemReturnAttachBo.setFileUrl(servicePlanItemAttachmentsBo.getFileUrl());
                planItemReturnAttachBo.setFileName(servicePlanItemAttachmentsBo.getFileName());
                dycArchiveFileFuncBos.add(planItemReturnAttachBo);
            }
        }
        return dycArchiveFileFuncBos;
    }

    private static void setMain(DycSaleOrderArchivistFuncRspBo rspBo, UocArchivistDataQryRspBo uocArchivistDataQryRspBo, FscAchivistDataQryBySaleOrderIdAbilityRspBo fscAchivistDataQryBySaleOrderIdAbilityRspBo) {
        DycArchiveMainFuncBo dycArchiveMainFuncBo = new DycArchiveMainFuncBo();
        dycArchiveMainFuncBo.setAreaType(uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getAreaType());
        dycArchiveMainFuncBo.setAreaTypeName(uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getAreaTypeStr());
        Optional<UocArchivistInspOrderBo> maxInspTime = uocArchivistDataQryRspBo.getUocArchivistInspOrderBoList().stream().max(Comparator.comparing(UocArchivistInspOrderBo::getCreateTime));
        maxInspTime.ifPresent(uocArchivistInspOrderBo -> dycArchiveMainFuncBo.setOrderAcceptTime(uocArchivistInspOrderBo.getCreateTime()));
        dycArchiveMainFuncBo.setObjCode(uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getSaleOrderNo());
        dycArchiveMainFuncBo.setObjId(Convert.toStr((Object)uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getSaleOrderId()));
        dycArchiveMainFuncBo.setObjCreateTime(uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getCreateTime());
        dycArchiveMainFuncBo.setObjCreateCompanyId(Convert.toLong((Object)uocArchivistDataQryRspBo.getUocArchivistSaleStakeholderBo().getPurCompanyId()));
        dycArchiveMainFuncBo.setObjCreateOrgId(Convert.toLong((Object)uocArchivistDataQryRspBo.getUocArchivistSaleStakeholderBo().getPurOrgId()));
        dycArchiveMainFuncBo.setObjCreateUserId(Convert.toLong((Object)uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getCreateOperId()));
        dycArchiveMainFuncBo.setObjCreateCompanyName(uocArchivistDataQryRspBo.getUocArchivistSaleStakeholderBo().getPurCompanyName());
        dycArchiveMainFuncBo.setObjCreateOrgName(uocArchivistDataQryRspBo.getUocArchivistSaleStakeholderBo().getPurOrgName());
        dycArchiveMainFuncBo.setObjCreateUserName(uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getCreateOperName());
        if (uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getOrderSource().equals(2)) {
            dycArchiveMainFuncBo.setObjType(DycFuncCommonConstants.ArchivistMainObjType.SUPER_MARKET);
        } else {
            dycArchiveMainFuncBo.setObjType(DycFuncCommonConstants.ArchivistMainObjType.AGR);
        }
        if (!CollectionUtils.isEmpty((Collection)fscAchivistDataQryBySaleOrderIdAbilityRspBo.getFscAchivistDataQryBySaleOrderIdBoList())) {
            Optional<FscAchivistDataQryBySaleOrderIdBo> maxInvoiceTime = fscAchivistDataQryBySaleOrderIdAbilityRspBo.getFscAchivistDataQryBySaleOrderIdBoList().stream().max(Comparator.comparing(FscAchivistDataQryBySaleOrderIdBo::getBillTime));
            maxInvoiceTime.ifPresent(fscAchivistDataQryBySaleOrderIdBo -> dycArchiveMainFuncBo.setObjInvoiceTime(fscAchivistDataQryBySaleOrderIdBo.getCreateTime()));
        }
        if (null == uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getUocArchivistOrderTaskBo()) {
            dycArchiveMainFuncBo.setObjApproveTime(uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getCreateTime());
            dycArchiveMainFuncBo.setObjApproveUserId(Convert.toLong((Object)uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getCreateOperId()));
            dycArchiveMainFuncBo.setObjApproveUserName(uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getCreateOperName());
        } else {
            dycArchiveMainFuncBo.setObjApproveTime(uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getUocArchivistOrderTaskBo().getFinishTime());
            dycArchiveMainFuncBo.setObjApproveUserId(Convert.toLong((Object)uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getUocArchivistOrderTaskBo().getDealOperId()));
            dycArchiveMainFuncBo.setObjApproveUserName(uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getUocArchivistOrderTaskBo().getDealOperName());
        }
        dycArchiveMainFuncBo.setSupplierId(Convert.toLong((Object)uocArchivistDataQryRspBo.getUocArchivistSaleStakeholderBo().getSupId()));
        dycArchiveMainFuncBo.setSupplierName(uocArchivistDataQryRspBo.getUocArchivistSaleStakeholderBo().getSupName());
        rspBo.setDycArchiveMainFuncBo(dycArchiveMainFuncBo);
    }

    private DycArchiveFileFuncBo createSettleOrderFile(UocArchivistDataQryRspBo uocArchivistDataQryRspBo, Map<String, Object> data, String dateStr, FscAchivistDataQryBySaleOrderIdAbilityRspBo fscAchivistDataQryBySaleOrderIdAbilityRspBo) {
        DycArchiveFileFuncBo dycArchiveFileFuncBo = new DycArchiveFileFuncBo();
        dycArchiveFileFuncBo.setFileCategory(8);
        dycArchiveFileFuncBo.setFileCategoryName("\u7ed3\u7b97\u5355\u6587\u4ef6");
        dycArchiveFileFuncBo.setBusiType(3);
        dycArchiveFileFuncBo.setBusiTypeName("\u7ed3\u7b97\u5355");
        if (CollectionUtils.isEmpty((Collection)fscAchivistDataQryBySaleOrderIdAbilityRspBo.getFscAchivistDataQryBySaleOrderIdBoList())) {
            return dycArchiveFileFuncBo;
        }
        String fileName = uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getSaleOrderNo() + "-" + "\u7ed3\u7b97\u5355\u6587\u4ef6" + "-" + dateStr + ".pdf";
        String filePath = this.pdfTemplateUtil.doCreate(data, fileName, "settleOrder.ftl");
        dycArchiveFileFuncBo.setFileUrl(filePath);
        dycArchiveFileFuncBo.setFileName(fileName);
        return dycArchiveFileFuncBo;
    }

    private DycArchiveFileFuncBo createAfterOrderFile(UocArchivistDataQryRspBo uocArchivistDataQryRspBo, Map<String, Object> data, String dateStr) {
        DycArchiveFileFuncBo dycArchiveFileFuncBo = new DycArchiveFileFuncBo();
        dycArchiveFileFuncBo.setFileCategory(7);
        dycArchiveFileFuncBo.setFileCategoryName("\u8ba2\u5355\u552e\u540e\u6587\u4ef6");
        dycArchiveFileFuncBo.setBusiType(2);
        dycArchiveFileFuncBo.setBusiTypeName("\u91c7\u8d2d\u8ba2\u5355");
        if (CollectionUtils.isEmpty((Collection)uocArchivistDataQryRspBo.getUocArchivistAfOrderBoList())) {
            return dycArchiveFileFuncBo;
        }
        String fileName = uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getSaleOrderNo() + "-" + "\u8ba2\u5355\u552e\u540e\u6587\u4ef6" + "-" + dateStr + ".pdf";
        String filePath = this.pdfTemplateUtil.doCreate(data, fileName, "afterOrder.ftl");
        dycArchiveFileFuncBo.setFileUrl(filePath);
        dycArchiveFileFuncBo.setFileName(fileName);
        return dycArchiveFileFuncBo;
    }

    private DycArchiveFileFuncBo createInspOrderFile(UocArchivistDataQryRspBo uocArchivistDataQryRspBo, Map<String, Object> data, String dateStr) {
        DycArchiveFileFuncBo dycArchiveFileFuncBo = new DycArchiveFileFuncBo();
        dycArchiveFileFuncBo.setFileCategory(6);
        dycArchiveFileFuncBo.setFileCategoryName("\u8ba2\u5355\u9a8c\u6536\u6587\u4ef6");
        dycArchiveFileFuncBo.setBusiType(2);
        dycArchiveFileFuncBo.setBusiTypeName("\u91c7\u8d2d\u8ba2\u5355");
        if (CollectionUtils.isEmpty((Collection)uocArchivistDataQryRspBo.getUocArchivistInspOrderBoList())) {
            return dycArchiveFileFuncBo;
        }
        String fileName = uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getSaleOrderNo() + "-" + "\u8ba2\u5355\u9a8c\u6536\u6587\u4ef6" + "-" + dateStr + ".pdf";
        String filePath = this.pdfTemplateUtil.doCreate(data, fileName, "inspOrder.ftl");
        dycArchiveFileFuncBo.setFileUrl(filePath);
        dycArchiveFileFuncBo.setFileName(fileName);
        return dycArchiveFileFuncBo;
    }

    private DycArchiveFileFuncBo createCmpOrderFile(UocArchivistDataQryRspBo uocArchivistDataQryRspBo, Map<String, Object> data, String dateStr) {
        this.fillCmpOrder(uocArchivistDataQryRspBo);
        DycArchiveFileFuncBo dycArchiveFileFuncBo = new DycArchiveFileFuncBo();
        dycArchiveFileFuncBo.setFileCategory(3);
        dycArchiveFileFuncBo.setFileCategoryName("\u6bd4\u4ef7\u5355\u6587\u4ef6");
        dycArchiveFileFuncBo.setBusiType(2);
        dycArchiveFileFuncBo.setBusiTypeName("\u91c7\u8d2d\u8ba2\u5355");
        if (CollectionUtils.isEmpty((Collection)uocArchivistDataQryRspBo.getUocArchivistCmpOrderBoList())) {
            return dycArchiveFileFuncBo;
        }
        String fileName = uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getSaleOrderNo() + "-" + "\u6bd4\u4ef7\u5355\u6587\u4ef6" + "-" + dateStr + ".pdf";
        String filePath = this.pdfTemplateUtil.doCreate(data, fileName, "cmpOrder.ftl");
        dycArchiveFileFuncBo.setFileUrl(filePath);
        dycArchiveFileFuncBo.setFileName(fileName);
        return dycArchiveFileFuncBo;
    }

    private DycArchiveFileFuncBo createConfirmOrderFile(UocArchivistDataQryRspBo uocArchivistDataQryRspBo, Map<String, Object> data, String dateStr) {
        DycArchiveFileFuncBo dycArchiveFileFuncBo = new DycArchiveFileFuncBo();
        dycArchiveFileFuncBo.setFileCategory(5);
        dycArchiveFileFuncBo.setFileCategoryName("\u8ba2\u5355\u786e\u8ba4\u4e0b\u5355\u6587\u4ef6");
        dycArchiveFileFuncBo.setBusiType(2);
        dycArchiveFileFuncBo.setBusiTypeName("\u91c7\u8d2d\u8ba2\u5355");
        if (null == uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo()) {
            return dycArchiveFileFuncBo;
        }
        String fileName = uocArchivistDataQryRspBo.getUocArchivistSaleOrderBo().getSaleOrderNo() + "-" + "\u8ba2\u5355\u786e\u8ba4\u4e0b\u5355\u6587\u4ef6" + "-" + dateStr + ".pdf";
        String filePath = this.pdfTemplateUtil.doCreate(data, fileName, "confirmationOrder.ftl");
        dycArchiveFileFuncBo.setFileUrl(filePath);
        dycArchiveFileFuncBo.setFileName(fileName);
        return dycArchiveFileFuncBo;
    }

    private void fillCmpOrder(UocArchivistDataQryRspBo uocArchivistDataQryRspBo) {
        if (!CollectionUtils.isEmpty((Collection)uocArchivistDataQryRspBo.getUocArchivistCmpOrderBoList())) {
            for (UocArchivistCmpOrderBo uocArchivistCmpOrderBo : uocArchivistDataQryRspBo.getUocArchivistCmpOrderBoList()) {
                for (UocArchivistCmpOrderItemBo uocArchivistCmpOrderItemBo : uocArchivistCmpOrderBo.getUocCmpOrderItemList()) {
                    if (!"100058".equals(uocArchivistCmpOrderItemBo.getGoodsSupplierId())) continue;
                    uocArchivistCmpOrderItemBo.setImgUrl(DycSaleOrderArchivistFunctionImpl.parsePicUrl(uocArchivistCmpOrderItemBo.getImgUrl()));
                }
                while (uocArchivistCmpOrderBo.getUocCmpOrderItemList().size() < 5) {
                    uocArchivistCmpOrderBo.getUocCmpOrderItemList().add(new UocArchivistCmpOrderItemBo());
                }
            }
        }
    }

    private static String parsePicUrl(String picUrl) {
        try {
            URL url = new URL(picUrl);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setRequestMethod("GET");
            Map<String, List<String>> headerFields = urlConnection.getHeaderFields();
            List<String> list = headerFields.get("location");
            if (!CollectionUtils.isEmpty(list)) {
                return list.get(0);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return "";
    }
}

