/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.common.member.shoppingcart.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.common.util.MoneyUtils;
import com.tydic.commodity.mall.ability.api.UccMallBatchShopingQryAbilityService;
import com.tydic.commodity.mall.ability.bo.UccBatchShopQryBo;
import com.tydic.commodity.mall.ability.bo.UccMallBatchShopQryMsgBo;
import com.tydic.commodity.mall.ability.bo.UccMallBatchShopingQryAbilityReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallBatchShopingQryAbilityRspBO;
import com.tydic.dyc.atom.common.member.shoppingcart.api.DycUmcAddShoppingCartFunction;
import com.tydic.dyc.atom.common.member.shoppingcart.bo.DycMallImportRecordFunctionBO;
import com.tydic.dyc.atom.common.member.shoppingcart.bo.DycShoppingCartImportSkuFunctionBO;
import com.tydic.dyc.atom.common.member.shoppingcart.bo.DycUmcAddShoppingCartFunctionBo;
import com.tydic.dyc.atom.common.member.shoppingcart.bo.DycUmcAddShoppingCartFunctionReqBo;
import com.tydic.dyc.atom.common.member.shoppingcart.bo.DycUmcAddShoppingCartFunctionRspBo;
import com.tydic.dyc.umc.service.shoppingcart.UmcAddShoppingCartService;
import com.tydic.dyc.umc.service.shoppingcart.UmcGetShoppingCartPageListService;
import com.tydic.dyc.umc.service.shoppingcart.UmcUpdateSoppingCartService;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcAddShoppingCartBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcAddShoppingCartReqBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcAddShoppingCartRspBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcGetShoppingCartPageListReqBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcGetShoppingCartPageListRspBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcUpdateSoppingCartReqBo;
import com.tydic.dyc.umc.service.shoppingcart.bo.UmcUpdateSoppingCartRspBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DycUmcAddShoppingCartFunctionImpl
implements DycUmcAddShoppingCartFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUmcAddShoppingCartFunctionImpl.class);
    @Autowired
    private UmcGetShoppingCartPageListService umcGetShoppingCartPageListService;
    @Autowired
    private UmcAddShoppingCartService umcAddShoppingCartService;
    @Autowired
    private UccMallBatchShopingQryAbilityService uccMallBatchShopingQryAbilityService;
    @Autowired
    private UmcUpdateSoppingCartService umcUpdateSoppingCartService;
    @Value(value="${maxProductAmount:1000000}")
    private int maxProductAmount;
    @Value(value="${maxCartNum:100}")
    private int maxCartNum;
    @Value(value="${staff.welfare.pay.config.enable:true}")
    private Boolean staffWelfarePayConfigEnable;

    @Override
    public DycUmcAddShoppingCartFunctionRspBo addShoppingCart(DycUmcAddShoppingCartFunctionReqBo reqBo) {
        Map<String, DycUmcAddShoppingCartFunctionBo> mapUniqueKeyBoMap = this.validParam(reqBo);
        ArrayList<DycMallImportRecordFunctionBO> uscImportRecordBOSuccess = new ArrayList<DycMallImportRecordFunctionBO>();
        ArrayList<DycMallImportRecordFunctionBO> uscImportRecordBOfail = new ArrayList<DycMallImportRecordFunctionBO>();
        ArrayList<DycShoppingCartImportSkuFunctionBO> uscImportSkuBOFail = new ArrayList<DycShoppingCartImportSkuFunctionBO>();
        DycUmcAddShoppingCartFunctionRspBo busiRspBO = new DycUmcAddShoppingCartFunctionRspBo();
        List<DycUmcAddShoppingCartFunctionBo> uscParmGoddsInfoBOList = reqBo.getUscAddGoddsInfoBOList();
        List<DycUmcAddShoppingCartFunctionBo> uscAddGoddsInfoBOList = new ArrayList<DycUmcAddShoppingCartFunctionBo>(uscParmGoddsInfoBOList);
        List<DycUmcAddShoppingCartFunctionBo> uscUpdateGoddsInfoBOList = new ArrayList<DycUmcAddShoppingCartFunctionBo>();
        ArrayList<Long> numErrorSkuIds = new ArrayList<Long>();
        ArrayList<Long> statusErrorSkuIds = new ArrayList<Long>();
        ArrayList<Long> availableSaleErrorSkuIds = new ArrayList<Long>();
        ArrayList<Long> areaLimitErrorSkuIds = new ArrayList<Long>();
        ArrayList<Long> stockStateErrorSkuIds = new ArrayList<Long>();
        ArrayList availableCatalogErrorSkuId = new ArrayList();
        ArrayList<Long> totalErrorSkuIds = new ArrayList<Long>();
        String errorMsg1 = null;
        this.validShopCart(reqBo, uscImportRecordBOfail, mapUniqueKeyBoMap, uscAddGoddsInfoBOList, uscUpdateGoddsInfoBOList, numErrorSkuIds, totalErrorSkuIds);
        Map<Long, BigDecimal> moqMap = this.validSku(reqBo, uscImportRecordBOfail, uscImportSkuBOFail, uscParmGoddsInfoBOList, statusErrorSkuIds, availableSaleErrorSkuIds, areaLimitErrorSkuIds, stockStateErrorSkuIds, totalErrorSkuIds);
        uscAddGoddsInfoBOList = uscAddGoddsInfoBOList.stream().filter(e -> !totalErrorSkuIds.contains(e.getSkuId())).collect(Collectors.toList());
        uscAddGoddsInfoBOList.forEach(dycUmcAddShoppingCartFunctionBo -> {
            BigDecimal moq = (BigDecimal)moqMap.get(dycUmcAddShoppingCartFunctionBo.getSkuId());
            if (null != moq && Convert.toBigDecimal((Object)dycUmcAddShoppingCartFunctionBo.getProductAmount()).compareTo(moq) < 0) {
                dycUmcAddShoppingCartFunctionBo.setProductAmount(moq.toPlainString());
            }
        });
        uscUpdateGoddsInfoBOList = uscUpdateGoddsInfoBOList.stream().filter(e -> !totalErrorSkuIds.contains(e.getSkuId())).collect(Collectors.toList());
        this.addAndUpdateCart(reqBo, uscAddGoddsInfoBOList, uscUpdateGoddsInfoBOList);
        if (!reqBo.getIsImport().booleanValue()) {
            StringBuilder errorMsg = new StringBuilder();
            if (!CollectionUtils.isEmpty(numErrorSkuIds)) {
                errorMsg1 = "\u65b0\u52a0\u5165\u6570\u91cf\u4e0e\u5df2\u6709\u6570\u91cf\u4e4b\u548c>" + this.maxProductAmount + "!";
                errorMsg.append("<br/>\u5546\u54c1\u7f16\u7801\uff1a").append(numErrorSkuIds).append("\u65b0\u52a0\u5165\u6570\u91cf\u4e0e\u5df2\u6709\u6570\u91cf\u4e4b\u548c>").append(this.maxProductAmount).append("!");
            }
            if (!CollectionUtils.isEmpty(statusErrorSkuIds)) {
                errorMsg1 = "\u5df2\u5931\u6548\uff01";
                errorMsg.append("<br/>\u5546\u54c1\u7f16\u7801\uff1a").append(statusErrorSkuIds).append("\u5df2\u5931\u6548\uff01");
            }
            if (!CollectionUtils.isEmpty(availableSaleErrorSkuIds)) {
                errorMsg1 = "\u4e0d\u53ef\u552e\uff01";
                errorMsg.append("<br/>\u5546\u54c1\u7f16\u7801\uff1a").append(availableSaleErrorSkuIds).append("\u4e0d\u53ef\u552e\uff01");
            }
            if (!CollectionUtils.isEmpty(areaLimitErrorSkuIds)) {
                errorMsg1 = "\u5728\u6536\u8d27\u5730\u5740\u5185\u4e0d\u53ef\u552e\uff01";
                errorMsg.append("<br/>\u5546\u54c1\u7f16\u7801\uff1a").append(areaLimitErrorSkuIds).append("\u5728\u6536\u8d27\u5730\u5740\u5185\u4e0d\u53ef\u552e\uff01");
            }
            if (!CollectionUtils.isEmpty(stockStateErrorSkuIds)) {
                errorMsg1 = "\u5e93\u5b58\u4e0d\u8db3\uff01";
                errorMsg.append("<br/>\u5546\u54c1\u7f16\u7801\uff1a").append(stockStateErrorSkuIds).append("\u5e93\u5b58\u4e0d\u8db3\uff01");
            }
            if (!CollectionUtils.isEmpty(availableCatalogErrorSkuId)) {
                errorMsg1 = "\u4e0d\u5728\u53ef\u8d2d\u7c7b\u76ee\u8303\u56f4\u5185\uff01";
                errorMsg.append("<br/>\u5546\u54c1\u7f16\u7801\uff1a").append(availableCatalogErrorSkuId).append("\u4e0d\u5728\u53ef\u8d2d\u7c7b\u76ee\u8303\u56f4\u5185\uff01");
            }
            if (errorMsg.length() > 0) {
                busiRspBO.setRespCode("0000");
                busiRspBO.setRespDesc("\u5982\u4e0b\u5546\u54c1\u672a\u52a0\u8d2d\u6210\u529f\uff01" + errorMsg.toString());
                busiRspBO.setTipSuccesFlag(true);
            } else {
                busiRspBO.setRespCode("0000");
                busiRspBO.setRespDesc("\u52a0\u8d2d\u6210\u529f");
            }
        } else {
            busiRspBO.setRespCode("0000");
            busiRspBO.setRespDesc("\u52a0\u8d2d\u6210\u529f");
        }
        List<Object> failIds = new ArrayList();
        if (!CollectionUtils.isEmpty(uscImportRecordBOfail)) {
            failIds = uscImportSkuBOFail.stream().map(DycShoppingCartImportSkuFunctionBO::getSkuId).collect(Collectors.toList());
        }
        for (DycUmcAddShoppingCartFunctionBo bo : reqBo.getUscAddGoddsInfoBOList()) {
            if (failIds.contains(bo.getSkuId())) continue;
            DycMallImportRecordFunctionBO successBo = new DycMallImportRecordFunctionBO();
            successBo.setSkuId(bo.getSkuId());
            successBo.setProductAmount(bo.getProductAmount());
            successBo.setSpId(bo.getSpId());
            uscImportRecordBOSuccess.add(successBo);
        }
        busiRspBO.setUscImportRecordBOfail(uscImportRecordBOfail);
        busiRspBO.setUscImportRecordBOSuccess(uscImportRecordBOSuccess);
        busiRspBO.setUscImportSkuBOfail(uscImportSkuBOFail);
        return busiRspBO;
    }

    private void addAndUpdateCart(DycUmcAddShoppingCartFunctionReqBo reqBo, List<DycUmcAddShoppingCartFunctionBo> uscAddGoddsInfoBOList, List<DycUmcAddShoppingCartFunctionBo> uscUpdateGoddsInfoBOList) {
        Long spId;
        Map<Long, Long> skuSpMap;
        String joinPrice;
        Object shoppingCartBo;
        ArrayList<Object> umcAddShoppingCartBos;
        if (uscUpdateGoddsInfoBOList.size() > 0) {
            UmcUpdateSoppingCartReqBo updateSoppingCartReqBo = new UmcUpdateSoppingCartReqBo();
            updateSoppingCartReqBo.setLoginSource(reqBo.getLoginSourceIn());
            updateSoppingCartReqBo.setUserId(reqBo.getUserIdIn());
            updateSoppingCartReqBo.setTenantId(reqBo.getTenantIdIn());
            updateSoppingCartReqBo.setUserName(reqBo.getRegAccountIn());
            umcAddShoppingCartBos = new ArrayList<Object>();
            for (DycUmcAddShoppingCartFunctionBo bo : uscUpdateGoddsInfoBOList) {
                shoppingCartBo = new UmcAddShoppingCartBo();
                joinPrice = bo.getJoinPrice();
                bo.setJoinPrice(null);
                shoppingCartBo = (UmcAddShoppingCartBo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)bo), UmcAddShoppingCartBo.class);
                shoppingCartBo.setProductAmount(new BigDecimal(bo.getProductAmount()));
                if (!StringUtils.isEmpty((Object)joinPrice)) {
                    try {
                        shoppingCartBo.setJoinPrice(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(joinPrice)));
                    }
                    catch (Exception e) {
                        log.error("\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                        throw new ZTBusinessException(e.getMessage());
                    }
                } else {
                    shoppingCartBo.setJoinPrice(Long.valueOf(0L));
                }
                umcAddShoppingCartBos.add(shoppingCartBo);
            }
            updateSoppingCartReqBo.setUmcAddShoppingCartBos(umcAddShoppingCartBos);
            UmcUpdateSoppingCartRspBo umcUpdateSoppingCartRspBo = this.umcUpdateSoppingCartService.updateSoppingCart(updateSoppingCartReqBo);
            if (!"0000".equals(umcUpdateSoppingCartRspBo.getRespCode())) {
                throw new ZTBusinessException(umcUpdateSoppingCartRspBo.getRespDesc());
            }
            if (!CollectionUtils.isEmpty((Collection)umcUpdateSoppingCartRspBo.getUmcAddShoppingCartBos())) {
                skuSpMap = umcUpdateSoppingCartRspBo.getUmcAddShoppingCartBos().stream().collect(Collectors.toMap(UmcAddShoppingCartBo::getSkuId, UmcAddShoppingCartBo::getSpId, (o1, o2) -> o1));
                for (DycUmcAddShoppingCartFunctionBo dycUmcAddShoppingCartFunctionBo : reqBo.getUscAddGoddsInfoBOList()) {
                    spId = skuSpMap.get(dycUmcAddShoppingCartFunctionBo.getSkuId());
                    if (null == spId) continue;
                    dycUmcAddShoppingCartFunctionBo.setSpId(spId);
                }
            }
        }
        if (uscAddGoddsInfoBOList.size() > 0) {
            UmcAddShoppingCartReqBo addShoppingCartReqBo = new UmcAddShoppingCartReqBo();
            addShoppingCartReqBo.setLoginSource(reqBo.getLoginSourceIn());
            addShoppingCartReqBo.setUserId(reqBo.getUserIdIn());
            addShoppingCartReqBo.setTenantId(reqBo.getTenantIdIn());
            addShoppingCartReqBo.setUserName(reqBo.getRegAccountIn());
            umcAddShoppingCartBos = new ArrayList();
            for (DycUmcAddShoppingCartFunctionBo bo : uscAddGoddsInfoBOList) {
                shoppingCartBo = new UmcAddShoppingCartBo();
                joinPrice = bo.getJoinPrice();
                bo.setJoinPrice(null);
                shoppingCartBo = (UmcAddShoppingCartBo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)bo), UmcAddShoppingCartBo.class);
                if (!StringUtils.isEmpty((Object)joinPrice)) {
                    try {
                        shoppingCartBo.setJoinPrice(MoneyUtils.BigDecimal2Long((BigDecimal)new BigDecimal(joinPrice)));
                    }
                    catch (Exception e) {
                        log.error("\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
                        throw new ZTBusinessException("\u4ef7\u683c\u8f6c\u6362\u5f02\u5e38");
                    }
                } else {
                    shoppingCartBo.setJoinPrice(Long.valueOf(0L));
                }
                shoppingCartBo.setProductAmount(new BigDecimal(bo.getProductAmount()));
                umcAddShoppingCartBos.add(shoppingCartBo);
            }
            addShoppingCartReqBo.setUmcAddShoppingCartBos(umcAddShoppingCartBos);
            UmcAddShoppingCartRspBo umcAddShoppingCartRspBo = this.umcAddShoppingCartService.addShoppingCart(addShoppingCartReqBo);
            if (!"0000".equals(umcAddShoppingCartRspBo.getRespCode())) {
                throw new ZTBusinessException(umcAddShoppingCartRspBo.getRespDesc());
            }
            if (!CollectionUtils.isEmpty((Collection)umcAddShoppingCartRspBo.getUmcAddShoppingCartBos())) {
                skuSpMap = umcAddShoppingCartRspBo.getUmcAddShoppingCartBos().stream().collect(Collectors.toMap(UmcAddShoppingCartBo::getSkuId, UmcAddShoppingCartBo::getSpId, (o1, o2) -> o1));
                for (DycUmcAddShoppingCartFunctionBo dycUmcAddShoppingCartFunctionBo : reqBo.getUscAddGoddsInfoBOList()) {
                    spId = skuSpMap.get(dycUmcAddShoppingCartFunctionBo.getSkuId());
                    if (null == spId) continue;
                    dycUmcAddShoppingCartFunctionBo.setSpId(spId);
                }
            }
        }
    }

    private Map<Long, BigDecimal> validSku(DycUmcAddShoppingCartFunctionReqBo reqBo, List<DycMallImportRecordFunctionBO> uscImportRecordBOfail, List<DycShoppingCartImportSkuFunctionBO> uscImportSkuBOFail, List<DycUmcAddShoppingCartFunctionBo> uscParmGoddsInfoBOList, List<Long> statusErrorSkuIds, List<Long> availableSaleErrorSkuIds, List<Long> areaLimitErrorSkuIds, List<Long> stockStateErrorSkuIds, List<Long> totalErrorSkuIds) {
        HashMap<Long, BigDecimal> moqMap = new HashMap<Long, BigDecimal>();
        if (0 != reqBo.getIsCheck()) {
            ArrayList<UccBatchShopQryBo> shopQry = new ArrayList<UccBatchShopQryBo>();
            UccMallBatchShopingQryAbilityReqBO uccMallBatchShopingQryAbilityReqBO = new UccMallBatchShopingQryAbilityReqBO();
            for (DycUmcAddShoppingCartFunctionBo dycUmcAddShoppingCartFunctionBo : uscParmGoddsInfoBOList) {
                UccBatchShopQryBo uscBatchShopQryReqBO = new UccBatchShopQryBo();
                uscBatchShopQryReqBO.setSkuId(dycUmcAddShoppingCartFunctionBo.getSkuId());
                uscBatchShopQryReqBO.setSupplierShopId(dycUmcAddShoppingCartFunctionBo.getSupplierShopId());
                uscBatchShopQryReqBO.setSaleNum(dycUmcAddShoppingCartFunctionBo.getProductAmount());
                uscBatchShopQryReqBO.setProvince(reqBo.getProvince());
                uscBatchShopQryReqBO.setCity(reqBo.getCity());
                uscBatchShopQryReqBO.setCounty(reqBo.getCounty());
                uscBatchShopQryReqBO.setTown(reqBo.getTown());
                shopQry.add(uscBatchShopQryReqBO);
            }
            uccMallBatchShopingQryAbilityReqBO.setShopQry(shopQry);
            uccMallBatchShopingQryAbilityReqBO.setCompanyId(reqBo.getCompanyId());
            uccMallBatchShopingQryAbilityReqBO.setIsprofess(reqBo.getIsprofess());
            uccMallBatchShopingQryAbilityReqBO.setCompanyId(null);
            uccMallBatchShopingQryAbilityReqBO.setIsprofess(null);
            log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5165\u53c2\uff1a" + JSONObject.toJSONString((Object)uccMallBatchShopingQryAbilityReqBO));
            UccMallBatchShopingQryAbilityRspBO uscBatchShopingQryInterfaceRspBO = this.uccMallBatchShopingQryAbilityService.qryInfo(uccMallBatchShopingQryAbilityReqBO);
            log.info("\u8c03\u7528\u5546\u54c1\u4e2d\u5fc3\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u51fa\u53c2\uff1a" + JSONObject.toJSONString((Object)uscBatchShopingQryInterfaceRspBO));
            if (!"0000".equals(uscBatchShopingQryInterfaceRspBO.getRespCode())) {
                throw new ZTBusinessException(uscBatchShopingQryInterfaceRspBO.getRespDesc());
            }
            if (CollectionUtils.isEmpty((Collection)uscBatchShopingQryInterfaceRspBO.getShopQryMsg())) {
                for (DycUmcAddShoppingCartFunctionBo addShoppingCartBo : uscParmGoddsInfoBOList) {
                    totalErrorSkuIds.add(addShoppingCartBo.getSkuId());
                    stockStateErrorSkuIds.add(addShoppingCartBo.getSkuId());
                    DycMallImportRecordFunctionBO uscImportRecordBO = new DycMallImportRecordFunctionBO();
                    uscImportRecordBO.setSkuId(addShoppingCartBo.getSkuId());
                    uscImportRecordBO.setProductAmount(addShoppingCartBo.getProductAmount());
                    uscImportRecordBO.setFailedReason("\u7531\u4e8e\u3010\u4e0d\u5b58\u5728/\u4e0d\u53ef\u552e\u3011\u539f\u56e0\uff0c\u65e0\u6cd5\u8d2d\u4e70\uff0c\u8bf7\u5c06\u5176\u5220\u9664\u540e\u91cd\u65b0\u5bfc\u5165\uff01");
                    uscImportRecordBOfail.add(uscImportRecordBO);
                    DycShoppingCartImportSkuFunctionBO uscImportSkuBO = new DycShoppingCartImportSkuFunctionBO();
                    uscImportSkuBO.setSkuId(addShoppingCartBo.getSkuId());
                    uscImportSkuBO.setSkuCode(addShoppingCartBo.getSkuCode());
                    uscImportSkuBO.setFailedReason("\u7531\u4e8e\u3010\u4e0d\u5b58\u5728/\u4e0d\u53ef\u552e\u3011\u539f\u56e0\uff0c\u65e0\u6cd5\u8d2d\u4e70\uff0c\u8bf7\u5c06\u5176\u5220\u9664\u540e\u91cd\u65b0\u5bfc\u5165\uff01");
                    uscImportSkuBOFail.add(uscImportSkuBO);
                }
            }
            Map<Long, UccMallBatchShopQryMsgBo> map = uscBatchShopingQryInterfaceRspBO.getShopQryMsg().stream().collect(Collectors.toMap(UccMallBatchShopQryMsgBo::getSkuId, o -> o, (o1, o2) -> o1));
            for (DycUmcAddShoppingCartFunctionBo addShoppingCartBo : uscParmGoddsInfoBOList) {
                DycShoppingCartImportSkuFunctionBO uscImportSkuBO;
                DycMallImportRecordFunctionBO uscImportRecordBO;
                DycShoppingCartImportSkuFunctionBO uscImportSkuBO2;
                DycMallImportRecordFunctionBO uscImportRecordBO2;
                UccMallBatchShopQryMsgBo uscBatchShopQryMsgRspBO = map.get(addShoppingCartBo.getSkuId());
                if (reqBo.getIsImport() != null && reqBo.getIsImport().booleanValue()) {
                    if (null == uscBatchShopQryMsgRspBO) {
                        totalErrorSkuIds.add(addShoppingCartBo.getSkuId());
                        stockStateErrorSkuIds.add(addShoppingCartBo.getSkuId());
                        DycMallImportRecordFunctionBO uscImportRecordBO22 = new DycMallImportRecordFunctionBO();
                        uscImportRecordBO22.setSkuId(addShoppingCartBo.getSkuId());
                        uscImportRecordBO22.setProductAmount(addShoppingCartBo.getProductAmount());
                        uscImportRecordBO22.setFailedReason("\u7531\u4e8e\u3010\u4e0d\u5b58\u5728/\u4e0d\u53ef\u552e\u3011\u539f\u56e0\uff0c\u65e0\u6cd5\u8d2d\u4e70\uff0c\u8bf7\u5c06\u5176\u5220\u9664\u540e\u91cd\u65b0\u5bfc\u5165\uff01");
                        uscImportRecordBOfail.add(uscImportRecordBO22);
                        DycShoppingCartImportSkuFunctionBO uscImportSkuBO22 = new DycShoppingCartImportSkuFunctionBO();
                        uscImportSkuBO22.setSkuCode(addShoppingCartBo.getSkuCode());
                        uscImportSkuBO22.setFailedReason("\u7531\u4e8e\u3010\u4e0d\u5b58\u5728/\u4e0d\u53ef\u552e\u3011\u539f\u56e0\uff0c\u65e0\u6cd5\u8d2d\u4e70\uff0c\u8bf7\u5c06\u5176\u5220\u9664\u540e\u91cd\u65b0\u5bfc\u5165\uff01");
                        uscImportSkuBOFail.add(uscImportSkuBO22);
                        continue;
                    }
                } else if (null == uscBatchShopQryMsgRspBO) {
                    throw new ZTBusinessException(uscBatchShopingQryInterfaceRspBO.getRespDesc());
                }
                moqMap.put(uscBatchShopQryMsgRspBO.getSkuId(), uscBatchShopQryMsgRspBO.getMoq());
                try {
                    addShoppingCartBo.setJoinPrice(Convert.toStr((Object)MoneyUtils.BigDecimal2Long((BigDecimal)uscBatchShopQryMsgRspBO.getPrice())));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    totalErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                    statusErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO2 = new DycMallImportRecordFunctionBO();
                    uscImportRecordBO2.setSkuId(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO2.setProductAmount(addShoppingCartBo.getProductAmount());
                    uscImportRecordBO2.setFailedReason("\u5355\u4ef7\u8f6c\u6362\u8d2d\u7269\u8f66\u91d1\u989d\u5f02\u5e38");
                    uscImportRecordBOfail.add(uscImportRecordBO2);
                    uscImportSkuBO2 = new DycShoppingCartImportSkuFunctionBO();
                    BeanUtils.copyProperties((Object)uscBatchShopQryMsgRspBO, (Object)uscImportSkuBO2);
                    uscImportSkuBO2.setStatusStr("\u5355\u4ef7\u8f6c\u6362\u8d2d\u7269\u8f66\u91d1\u989d\u5f02\u5e38");
                    uscImportSkuBO2.setFailedReason("\u5355\u4ef7\u8f6c\u6362\u8d2d\u7269\u8f66\u91d1\u989d\u5f02\u5e38");
                    uscImportSkuBOFail.add(uscImportSkuBO2);
                    continue;
                }
                if (0 == uscBatchShopQryMsgRspBO.getStatus()) {
                    totalErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                    statusErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO = new DycMallImportRecordFunctionBO();
                    uscImportRecordBO.setSkuId(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO.setProductAmount(addShoppingCartBo.getProductAmount());
                    uscImportRecordBO.setFailedReason("\u5546\u54c1\u5df2\u5931\u6548\uff01");
                    uscImportRecordBOfail.add(uscImportRecordBO);
                    uscImportSkuBO = new DycShoppingCartImportSkuFunctionBO();
                    BeanUtils.copyProperties((Object)uscBatchShopQryMsgRspBO, (Object)uscImportSkuBO);
                    uscImportSkuBO.setStatusStr("\u5df2\u5931\u6548");
                    uscImportSkuBO.setFailedReason("\u5546\u54c1\u5df2\u5931\u6548\uff01");
                    uscImportSkuBOFail.add(uscImportSkuBO);
                    continue;
                }
                if (uscBatchShopQryMsgRspBO.getAvailableSale() == null || 1 != uscBatchShopQryMsgRspBO.getAvailableSale()) {
                    totalErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                    availableSaleErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO = new DycMallImportRecordFunctionBO();
                    uscImportRecordBO.setSkuId(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO.setProductAmount(addShoppingCartBo.getProductAmount());
                    uscImportRecordBO.setFailedReason("\u5546\u54c1\u4e0d\u53ef\u552e\uff01");
                    uscImportRecordBOfail.add(uscImportRecordBO);
                    uscImportSkuBO = new DycShoppingCartImportSkuFunctionBO();
                    BeanUtils.copyProperties((Object)uscBatchShopQryMsgRspBO, (Object)uscImportSkuBO);
                    uscImportSkuBO.setStatusStr("\u4e0d\u53ef\u552e");
                    uscImportSkuBO.setFailedReason("\u5546\u54c1\u4e0d\u53ef\u552e\uff01");
                    uscImportSkuBOFail.add(uscImportSkuBO);
                    continue;
                }
                if (uscBatchShopQryMsgRspBO.getAreaLimit() == null || 2 == uscBatchShopQryMsgRspBO.getAreaLimit()) {
                    totalErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                    areaLimitErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO = new DycMallImportRecordFunctionBO();
                    uscImportRecordBO.setSkuId(uscBatchShopQryMsgRspBO.getSkuId());
                    uscImportRecordBO.setProductAmount(addShoppingCartBo.getProductAmount());
                    uscImportRecordBO.setFailedReason("\u5546\u54c1\u5728\u6536\u8d27\u5730\u5740\u5185\u4e0d\u53ef\u552e\uff01");
                    uscImportRecordBOfail.add(uscImportRecordBO);
                    uscImportSkuBO = new DycShoppingCartImportSkuFunctionBO();
                    BeanUtils.copyProperties((Object)uscBatchShopQryMsgRspBO, (Object)uscImportSkuBO);
                    uscImportSkuBO.setFailedReason("\u4e0d\u5728\u51fa\u552e\u8303\u56f4");
                    uscImportSkuBOFail.add(uscImportSkuBO);
                    continue;
                }
                if (null != uscBatchShopQryMsgRspBO.getStockStateId()) {
                    if (reqBo.getIsImport() != null && reqBo.getIsImport().booleanValue()) {
                        BigDecimal importStock = new BigDecimal(addShoppingCartBo.getProductAmount());
                        if (uscBatchShopQryMsgRspBO.getStock() != -1 && uscBatchShopQryMsgRspBO.getStock() != null && addShoppingCartBo.getProductAmount() != null && BigDecimal.valueOf(uscBatchShopQryMsgRspBO.getStock().intValue()).compareTo(importStock) < 0) {
                            totalErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                            stockStateErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                            uscImportRecordBO2 = new DycMallImportRecordFunctionBO();
                            uscImportRecordBO2.setSkuId(uscBatchShopQryMsgRspBO.getSkuId());
                            uscImportRecordBO2.setProductAmount(addShoppingCartBo.getProductAmount());
                            uscImportRecordBO2.setFailedReason("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff01");
                            uscImportRecordBOfail.add(uscImportRecordBO2);
                            uscImportSkuBO2 = new DycShoppingCartImportSkuFunctionBO();
                            BeanUtils.copyProperties((Object)uscBatchShopQryMsgRspBO, (Object)uscImportSkuBO2);
                            uscImportSkuBO2.setFailedReason("\u5e93\u5b58\u4e0d\u8db3");
                            uscImportSkuBOFail.add(uscImportSkuBO2);
                            continue;
                        }
                    }
                    if (uscBatchShopQryMsgRspBO.getStockStateId() == null || 0 == uscBatchShopQryMsgRspBO.getStockStateId()) {
                        totalErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                        stockStateErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                        uscImportRecordBO = new DycMallImportRecordFunctionBO();
                        uscImportRecordBO.setSkuId(uscBatchShopQryMsgRspBO.getSkuId());
                        uscImportRecordBO.setProductAmount(addShoppingCartBo.getProductAmount());
                        uscImportRecordBO.setFailedReason("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff01");
                        uscImportRecordBOfail.add(uscImportRecordBO);
                        uscImportSkuBO = new DycShoppingCartImportSkuFunctionBO();
                        BeanUtils.copyProperties((Object)uscBatchShopQryMsgRspBO, (Object)uscImportSkuBO);
                        uscImportSkuBO.setFailedReason("\u5e93\u5b58\u4e0d\u8db3");
                        uscImportSkuBOFail.add(uscImportSkuBO);
                        continue;
                    }
                    if (uscBatchShopQryMsgRspBO.getStockStateId() == null || 34 == uscBatchShopQryMsgRspBO.getStockStateId()) {
                        totalErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                        stockStateErrorSkuIds.add(uscBatchShopQryMsgRspBO.getSkuId());
                        uscImportRecordBO = new DycMallImportRecordFunctionBO();
                        uscImportRecordBO.setSkuId(uscBatchShopQryMsgRspBO.getSkuId());
                        uscImportRecordBO.setProductAmount(addShoppingCartBo.getProductAmount());
                        uscImportRecordBO.setFailedReason("\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\uff01");
                        uscImportRecordBOfail.add(uscImportRecordBO);
                        uscImportSkuBO = new DycShoppingCartImportSkuFunctionBO();
                        BeanUtils.copyProperties((Object)uscBatchShopQryMsgRspBO, (Object)uscImportSkuBO);
                        uscImportSkuBO.setFailedReason("\u5e93\u5b58\u4e0d\u8db3");
                        uscImportSkuBOFail.add(uscImportSkuBO);
                    }
                }
                if (!reqBo.getIsImport().booleanValue()) continue;
                addShoppingCartBo.setSupplierId(uscBatchShopQryMsgRspBO.getSupplierId());
            }
        }
        return moqMap;
    }

    private void validShopCart(DycUmcAddShoppingCartFunctionReqBo reqBo, List<DycMallImportRecordFunctionBO> uscImportRecordBOfail, Map<String, DycUmcAddShoppingCartFunctionBo> mapUniqueKeyBoMap, List<DycUmcAddShoppingCartFunctionBo> uscAddGoddsInfoBOList, List<DycUmcAddShoppingCartFunctionBo> uscUpdateGoddsInfoBOList, List<Long> numErrorSkuIds, List<Long> totalErrorSkuIds) {
        UmcGetShoppingCartPageListReqBo umcGetShoppingCartPageListReqBo = new UmcGetShoppingCartPageListReqBo();
        umcGetShoppingCartPageListReqBo.setUserId(reqBo.getUserIdIn());
        umcGetShoppingCartPageListReqBo.setPageSize(-1);
        UmcGetShoppingCartPageListRspBo umcGetShoppingCartPageListRspBo = this.umcGetShoppingCartPageListService.getShoppingCartPageList(umcGetShoppingCartPageListReqBo);
        if (!"0000".equals(umcGetShoppingCartPageListRspBo.getRespCode())) {
            throw new ZTBusinessException(umcGetShoppingCartPageListRspBo.getRespDesc());
        }
        if (!CollectionUtils.isEmpty((Collection)umcGetShoppingCartPageListRspBo.getRows())) {
            HashMap<Integer, Integer> shopOrderSourceNum = new HashMap<Integer, Integer>();
            for (UmcAddShoppingCartBo bo : umcGetShoppingCartPageListRspBo.getRows()) {
                DycUmcAddShoppingCartFunctionBo updateGoodsInfoBO = mapUniqueKeyBoMap.get(bo.getUniqueKey());
                if (updateGoodsInfoBO != null) {
                    BigDecimal productAmount = bo.getProductAmount() == null ? new BigDecimal(0) : bo.getProductAmount();
                    BigDecimal joinAmount = new BigDecimal(updateGoodsInfoBO.getProductAmount()).add(productAmount);
                    if (joinAmount.compareTo(new BigDecimal(this.maxProductAmount)) > 0) {
                        totalErrorSkuIds.add(bo.getSkuId());
                        numErrorSkuIds.add(bo.getSkuId());
                        DycMallImportRecordFunctionBO uscImportRecordBO = new DycMallImportRecordFunctionBO();
                        uscImportRecordBO.setSkuId(bo.getSkuId());
                        uscImportRecordBO.setProductAmount(updateGoodsInfoBO.getProductAmount());
                        uscImportRecordBO.setFailedReason("\u65b0\u52a0\u5165\u6570\u91cf\u4e0e\u5df2\u6709\u6570\u91cf\u4e4b\u548c\u8d85\u8fc7\u6700\u5927\u91c7\u8d2d\u6570\u91cf>" + this.maxProductAmount + "!");
                        uscImportRecordBOfail.add(uscImportRecordBO);
                        continue;
                    }
                    updateGoodsInfoBO.setPurchaseModId(Convert.toStr((Object)bo.getPurchaseModId()));
                    updateGoodsInfoBO.setProductAmount(joinAmount.toString());
                    updateGoodsInfoBO.setSpId(bo.getSpId());
                    uscUpdateGoddsInfoBOList.add(updateGoodsInfoBO);
                }
                if (shopOrderSourceNum.containsKey(bo.getOrderSource())) {
                    shopOrderSourceNum.put(bo.getOrderSource(), (Integer)shopOrderSourceNum.get(bo.getOrderSource()) + 1);
                    continue;
                }
                shopOrderSourceNum.put(bo.getOrderSource(), 1);
            }
            uscAddGoddsInfoBOList.removeAll(uscUpdateGoddsInfoBOList);
            if (uscAddGoddsInfoBOList.size() > 0) {
                HashMap<Integer, Integer> addOrderSourceNum = new HashMap<Integer, Integer>();
                for (DycUmcAddShoppingCartFunctionBo addGoddsInfoBO : uscAddGoddsInfoBOList) {
                    if (addOrderSourceNum.containsKey(addGoddsInfoBO.getOrderSource())) {
                        addOrderSourceNum.put(addGoddsInfoBO.getOrderSource(), (Integer)addOrderSourceNum.get(addGoddsInfoBO.getOrderSource()) + 1);
                        continue;
                    }
                    addOrderSourceNum.put(addGoddsInfoBO.getOrderSource(), 1);
                }
                for (Integer orderSource : addOrderSourceNum.keySet()) {
                    Integer origin;
                    Integer add = (Integer)addOrderSourceNum.get(orderSource);
                    Integer n = origin = shopOrderSourceNum.get(orderSource) == null ? Integer.valueOf(0) : (Integer)shopOrderSourceNum.get(orderSource);
                    if (add + origin <= this.maxCartNum) continue;
                    if (orderSource == 2) {
                        throw new ZTBusinessException("\u7535\u5546\u5546\u54c1-\u8d2d\u7269\u8f66\u5df2\u6ee1,\u9700\u8981\u7528\u6237\u8fdb\u5165\u8d2d\u7269\u8f66\u5220\u9664\u90e8\u5206\u5546\u54c1\uff01");
                    }
                    if (orderSource != 3) continue;
                    throw new ZTBusinessException("\u534f\u8bae\u5546\u54c1-\u8d2d\u7269\u8f66\u5df2\u6ee1,\u9700\u8981\u7528\u6237\u8fdb\u5165\u8d2d\u7269\u8f66\u5220\u9664\u90e8\u5206\u5546\u54c1\uff01");
                }
            }
        }
    }

    private Map<String, DycUmcAddShoppingCartFunctionBo> validParam(DycUmcAddShoppingCartFunctionReqBo abilityReqBO) {
        if (null == abilityReqBO) {
            throw new ZTBusinessException("\u5165\u53c2\u4e3a\u7a7a!");
        }
        if (abilityReqBO.getUserId() == null) {
            throw new ZTBusinessException("\u4f1a\u5458Id\u4e3a\u7a7a!");
        }
        if (null == abilityReqBO.getProvince()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010province\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getCity()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010city\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getCounty()) {
            throw new ZTBusinessException("\u5165\u53c2\u3010county\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == abilityReqBO.getTown()) {
            abilityReqBO.setTown(0);
        }
        if (StringUtils.isEmpty(abilityReqBO.getUscAddGoddsInfoBOList())) {
            throw new ZTBusinessException("\u5165\u53c2\u3010uscAddGoddsInfoBOList\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (abilityReqBO.getUscAddGoddsInfoBOList().size() > this.maxCartNum) {
            throw new ZTBusinessException("\u8d2d\u7269\u8f66\u5df2\u6ee1,\u9700\u8981\u7528\u6237\u8fdb\u5165\u8d2d\u7269\u8f66\u5220\u9664\u90e8\u5206\u5546\u54c1\uff01");
        }
        if (abilityReqBO.getIsCheck() == null) {
            abilityReqBO.setIsCheck(1);
        }
        HashMap<String, String> skuPurchaseModIdMap = new HashMap<String, String>();
        HashMap<String, DycUmcAddShoppingCartFunctionBo> mapUniqueKeyBoMap = new HashMap<String, DycUmcAddShoppingCartFunctionBo>();
        Object activeId = null;
        for (DycUmcAddShoppingCartFunctionBo bo : abilityReqBO.getUscAddGoddsInfoBOList()) {
            if (StringUtils.isEmpty((Object)bo.getSpDesc())) {
                bo.setSpDesc("0");
            }
            if (StringUtils.isEmpty((Object)bo.getPurchaseModId())) {
                throw new ZTBusinessException("\u3010purchaseModId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            String purchaseModId = (String)skuPurchaseModIdMap.get(bo.getSkuId().toString());
            if (purchaseModId != null && purchaseModId.equals(bo.getPurchaseModId())) {
                throw new ZTBusinessException("\u540c\u4e00\u4e2a\u91c7\u8d2d\u6a21\u5f0f\u4e0b\u7684\u5355\u54c1\u7f16\u7801[SkuId]\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            skuPurchaseModIdMap.put(bo.getSkuId().toString(), bo.getPurchaseModId());
            if (StringUtils.isEmpty((Object)bo.getSkuId())) {
                throw new ZTBusinessException("\u3010skuId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)bo.getSupplierShopId())) {
                throw new ZTBusinessException("\u3010SupplierShopId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (null == bo.getOrderSource()) {
                throw new ZTBusinessException("\u3010orderSource\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtils.isEmpty((Object)bo.getProductAmount())) {
                bo.setProductAmount("1");
            }
            if (!StringUtils.isEmpty((Object)bo.getProductAmount()) && new BigDecimal(bo.getProductAmount()).compareTo(new BigDecimal(this.maxProductAmount)) > 0) {
                throw new ZTBusinessException("\u3010JoinAmount\u3011\u6700\u5927\u4e0d\u80fd\u8d85\u8fc7" + this.maxProductAmount);
            }
            if (null == bo.getSupplierId()) {
                throw new ZTBusinessException("\u3010supplierId\u3011\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            bo.setUniqueKey(abilityReqBO.getUserId() + "_" + bo.getSpDesc() + "_" + bo.getSkuId());
            mapUniqueKeyBoMap.put(bo.getUniqueKey(), bo);
        }
        return mapUniqueKeyBoMap;
    }
}

