/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.estore.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.estore.api.DycUocJdAddressQryFunction;
import com.tydic.dyc.atom.estore.bo.DycUocJdAddressQryFunctionBO;
import com.tydic.dyc.atom.estore.bo.DycUocJdAddressQryFunctionReqBO;
import com.tydic.dyc.atom.estore.bo.DycUocJdAddressQryFunctionRspBO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class DycUocJdAddressQryFunctionImpl
implements DycUocJdAddressQryFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocJdAddressQryFunctionImpl.class);

    @Override
    public DycUocJdAddressQryFunctionRspBO qryAddressInfo(DycUocJdAddressQryFunctionReqBO reqBo) {
        String returnString;
        String jsonString;
        String callUrl = null;
        String hsn = DycPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + reqBo.getSupplierId()));
        JSONObject jsonObject = new JSONObject();
        if (reqBo.getIsCheckArea().booleanValue()) {
            this.verifyParam(reqBo);
            jsonObject.put("provinceId", (Object)Integer.parseInt(reqBo.getContactProvinceId()));
            jsonObject.put("cityId", (Object)Integer.parseInt(reqBo.getContactCityId()));
            jsonObject.put("countyId", (Object)Integer.parseInt(reqBo.getContactCountyId()));
            jsonObject.put("townId", (Object)(StringUtils.isEmpty((Object)reqBo.getContactTownId()) ? 0 : Integer.parseInt(reqBo.getContactTownId())));
            callUrl = DycPropertiesUtil.getProperty((String)"JD_CHECK_ADDRESS_URL");
            jsonString = JSON.toJSONString((Object)jsonObject);
            log.info("\u4eac\u4e1c\u5730\u5740\u6821\u9a8c\u5165\u53c2:{}", (Object)jsonString);
            log.info("\u4eac\u4e1c\u5730\u5740\u6821\u9a8c\u8bf7\u6c42\u5730\u5740:{}", (Object)callUrl);
            log.info("\u4eac\u4e1c\u5730\u5740\u6821\u9a8c\u8bf7\u6c42hsn:{}", (Object)hsn);
            returnString = DycEsbUtil.doPostReuest((String)callUrl, (String)jsonString, (String)hsn);
            log.info("\u4eac\u4e1c\u5730\u5740\u6821\u9a8c\u51fa\u53c2: " + returnString);
            DycUocJdAddressQryFunctionRspBO dycUocJdAddressQryFunctionRspBO = this.resolveCheckResultRsp(returnString);
            if ("0000".equals(dycUocJdAddressQryFunctionRspBO.getRespCode())) {
                DycUocJdAddressQryFunctionBO addressBo = new DycUocJdAddressQryFunctionBO();
                addressBo.setContactProvinceId(reqBo.getContactProvinceId());
                addressBo.setContactCityId(reqBo.getContactCityId());
                addressBo.setContactCountyId(reqBo.getContactCountyId());
                addressBo.setContactTownId(StringUtils.isEmpty((Object)reqBo.getContactTownId()) ? "0" : reqBo.getContactTownId());
                dycUocJdAddressQryFunctionRspBO.setAddressBo(addressBo);
                return dycUocJdAddressQryFunctionRspBO;
            }
        }
        jsonObject = new JSONObject();
        jsonObject.put("address", (Object)reqBo.getAddress());
        callUrl = DycPropertiesUtil.getProperty((String)"JD_QRY_TRANS_ADDRESS_URL");
        jsonString = JSON.toJSONString((Object)jsonObject);
        log.info("\u4eac\u4e1c\u5730\u5740\u67e5\u8be2\u5165\u53c2:{}", (Object)jsonString);
        log.info("\u4eac\u4e1c\u5730\u5740\u67e5\u8be2\u8bf7\u6c42\u5730\u5740:{}", (Object)callUrl);
        log.info("\u4eac\u4e1c\u5730\u5740\u67e5\u8be2\u8bf7\u6c42hsn:{}", (Object)hsn);
        returnString = DycEsbUtil.doPostReuest((String)callUrl, (String)jsonString, (String)hsn);
        log.info("\u4eac\u4e1c\u5730\u5740\u67e5\u8be2\u51fa\u53c2: " + returnString);
        return this.resolveRsp(returnString);
    }

    private void verifyParam(DycUocJdAddressQryFunctionReqBO reqBo) {
        if (StringUtils.isEmpty((Object)reqBo.getContactProvinceId())) {
            throw new ZTBusinessException("\u5165\u53c2\u8054\u7cfb\u4eba\u7701\u4efd\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getContactCityId())) {
            throw new ZTBusinessException("\u5165\u53c2\u8054\u7cfb\u4eba\u5730\u5e02\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((Object)reqBo.getContactCountyId())) {
            throw new ZTBusinessException("\u5165\u53c2\u8054\u7cfb\u4eba\u533a\u53bf\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private DycUocJdAddressQryFunctionRspBO resolveCheckResultRsp(String returnString) {
        DycUocJdAddressQryFunctionRspBO rspBO = new DycUocJdAddressQryFunctionRspBO();
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        if (rspJsonObject.getBoolean("success").booleanValue() && "0000".equals(rspJsonObject.get((Object)"resultCode"))) {
            JSONObject jsonObject = (JSONObject)rspJsonObject.get((Object)"result");
            Boolean result = jsonObject.getBoolean("success");
            if (result.booleanValue()) {
                rspBO.setRespCode("0000");
                rspBO.setRespDesc("\u6210\u529f");
                return rspBO;
            }
            log.error("\u63d0\u4ea4\u5931\u8d25\uff01\u7531\u4e8e\u4eac\u4e1c\u5730\u5740\u4fe1\u606f\u5339\u914d\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u5904\u7406\uff08\u5f02\u5e38\u4ee3\u7801:" + jsonObject.getString("resultCode") + " :" + jsonObject.getString("resultMessage") + "\uff09");
        } else {
            log.error("\u63d0\u4ea4\u5931\u8d25\uff01\u7531\u4e8e\u4eac\u4e1c\u5730\u5740\u4fe1\u606f\u5339\u914d\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u5904\u7406\uff08\u5f02\u5e38\u4ee3\u7801:" + rspJsonObject.getString("resultCode") + " :" + rspJsonObject.getString("resultMessage") + "\uff09");
        }
        rspBO.setRespCode("8888");
        rspBO.setRespDesc("\u5931\u8d25");
        return rspBO;
    }

    private DycUocJdAddressQryFunctionRspBO resolveRsp(String returnString) {
        DycUocJdAddressQryFunctionRspBO rspBO = new DycUocJdAddressQryFunctionRspBO();
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        if (rspJsonObject.getBoolean("success").booleanValue() && "0000".equals(rspJsonObject.get((Object)"resultCode"))) {
            JSONObject jsonObject = (JSONObject)rspJsonObject.get((Object)"result");
            DycUocJdAddressQryFunctionBO addressBo = new DycUocJdAddressQryFunctionBO();
            addressBo.setContactCountryId(jsonObject.get((Object)"nationId") == null ? "0" : String.valueOf(jsonObject.get((Object)"nationId")));
            addressBo.setContactProvinceId(jsonObject.get((Object)"provinceId") == null ? "0" : String.valueOf(jsonObject.get((Object)"provinceId")));
            addressBo.setContactCityId(jsonObject.get((Object)"cityId") == null ? "0" : String.valueOf(jsonObject.get((Object)"cityId")));
            addressBo.setContactCountyId(jsonObject.get((Object)"countyId") == null ? "0" : String.valueOf(jsonObject.get((Object)"countyId")));
            addressBo.setContactTownId(jsonObject.get((Object)"townId") == null ? "0" : String.valueOf(jsonObject.get((Object)"townId")));
            rspBO.setAddressBo(addressBo);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        rspBO.setRespCode(rspJsonObject.getString("resultCode"));
        rspBO.setRespDesc("\u8ba2\u5355\u63d0\u4ea4\u5931\u8d25\uff01\u7531\u4e8e\u4eac\u4e1c\u5730\u5740\u4fe1\u606f\u5339\u914d\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u5904\u7406\uff08\u5f02\u5e38\u4ee3\u7801:" + rspJsonObject.getString("resultCode") + " :" + rspJsonObject.getString("resultMessage") + "\uff09");
        return rspBO;
    }
}

