/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.estore.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.constants.DycFuncCommonConstants;
import com.tydic.dyc.atom.base.constants.DycFuncRspConstants;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.estore.api.DycUocEstoreCheckAfterOrderTypeFunction;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreCheckAfterOrderTypeFuncReqBO;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreCheckAfterOrderTypeFuncRspBO;
import com.tydic.dyc.atom.estore.bo.afterOrder.AfterOrderTypeEntity;
import com.tydic.dyc.atom.estore.bo.afterOrder.AfterTypeAndTakeValueEntity;
import com.tydic.dyc.atom.estore.bo.afterOrder.JDAfterTypeAndTakeValueEntity;
import com.tydic.dyc.oc.constants.UocConstant;
import com.tydic.dyc.oc.service.saleorder.UocGetSaleOrderDetailService;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceReqBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspBo;
import com.tydic.dyc.oc.service.saleorder.bo.UocGetSaleOrderDetailServiceRspItemBo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycUocEstoreCheckAfterOrderTypeFunctionImpl
implements DycUocEstoreCheckAfterOrderTypeFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocEstoreCheckAfterOrderTypeFunctionImpl.class);
    @Value(value="${ESB_QRY_AFTER_TYPE_URL}")
    private String esbQryArterTypeUrl;
    @Autowired
    private UocGetSaleOrderDetailService uocGetSaleOrderDetailService;

    @Override
    public DycUocEstoreCheckAfterOrderTypeFuncRspBO checkAfterOrderType(DycUocEstoreCheckAfterOrderTypeFuncReqBO reqBo) {
        DycUocEstoreCheckAfterOrderTypeFuncRspBO funcRspBO = new DycUocEstoreCheckAfterOrderTypeFuncRspBO();
        this.validateArg(reqBo);
        UocGetSaleOrderDetailServiceReqBo uocGetSaleOrderDetailServiceReqBo = new UocGetSaleOrderDetailServiceReqBo();
        uocGetSaleOrderDetailServiceReqBo.setOrderId(reqBo.getOrderId());
        uocGetSaleOrderDetailServiceReqBo.setSaleOrderId(reqBo.getSaleOrderId());
        UocGetSaleOrderDetailServiceRspBo saleOrderDetail = this.uocGetSaleOrderDetailService.getSaleOrderDetail(uocGetSaleOrderDetailServiceReqBo);
        HashMap<Long, List<Integer>> afterTypeMap = new HashMap<Long, List<Integer>>();
        for (Long itemId : reqBo.getOrdItemList()) {
            AfterOrderTypeEntity afterOrderType = this.buildThirdEntity(saleOrderDetail, itemId);
            String hsn = DycPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + saleOrderDetail.getSupId()));
            if (saleOrderDetail.getSupId().equals(DycPropertiesUtil.getProperty((String)"SUPPLIER_JD_ID")) || saleOrderDetail.getSupId().equals(DycPropertiesUtil.getProperty((String)"SUPPLIER_JDVOP_ID"))) {
                JSONObject jdInParam = new JSONObject();
                jdInParam.put("orderId", (Object)afterOrderType.getOrderId());
                jdInParam.put("wareIds", Arrays.asList(afterOrderType.getSkuId()));
                JSONObject jdParam = new JSONObject();
                jdParam.put("param", (Object)jdInParam);
                if (UocConstant.ModelSettle.MY.equals(saleOrderDetail.getModelSettle())) {
                    jdParam.put("orgId", (Object)saleOrderDetail.getUocGetSaleOrderDetailServiceRspStakeholderBo().getProId());
                } else {
                    jdParam.put("orgId", (Object)saleOrderDetail.getUocGetSaleOrderDetailServiceRspStakeholderBo().getPurOrgId());
                }
                try {
                    log.info("\u4eac\u4e1c\u6821\u9a8c\u67e5\u8be2\u552e\u540e\u65b9\u5f0f\u5165\u53c2: {}", (Object)JSONObject.toJSONString((Object)jdParam));
                    String httpRspStr = DycEsbUtil.doPostReuest((String)this.esbQryArterTypeUrl, (String)JSONObject.toJSONString((Object)jdParam), (String)hsn);
                    log.info("\u4eac\u4e1c\u6821\u9a8c\u67e5\u8be2\u552e\u540e\u65b9\u5f0f\u51fa\u53c2: {}", (Object)httpRspStr);
                    this.resolveJDRspForCheck(httpRspStr, afterTypeMap, itemId, saleOrderDetail);
                    continue;
                }
                catch (ZTBusinessException e) {
                    throw new ZTBusinessException(e.getMessage());
                }
            }
            try {
                log.info("\u975e\u4eac\u4e1c\u6821\u9a8c\u67e5\u8be2\u552e\u540e\u65b9\u5f0f\u5165\u53c2: {}", (Object)JSONObject.toJSONString((Object)afterOrderType));
                String httpRspStr = DycEsbUtil.doPostReuest((String)this.esbQryArterTypeUrl, (String)JSONObject.toJSONString((Object)afterOrderType), (String)hsn);
                log.info("\u975e\u4eac\u4e1c\u6821\u9a8c\u67e5\u8be2\u552e\u540e\u65b9\u5f0f\u51fa\u53c2: {}", (Object)httpRspStr);
                this.resolveRspForCheck(httpRspStr, afterTypeMap, itemId, saleOrderDetail);
            }
            catch (ZTBusinessException e) {
                throw new ZTBusinessException(e.getMessage());
            }
        }
        List saleOrderDetailServiceRspItemBoList = saleOrderDetail.getSaleOrderDetailServiceRspItemBoList();
        Map<Long, UocGetSaleOrderDetailServiceRspItemBo> itemBoMap = saleOrderDetailServiceRspItemBoList.stream().collect(Collectors.toMap(UocGetSaleOrderDetailServiceRspItemBo::getSaleOrderItemId, o -> o));
        ArrayList<String> checkResultList = new ArrayList<String>();
        Integer isPass = 1;
        StringBuilder resultStr = new StringBuilder();
        ArrayList<String> skuCodeList = new ArrayList<String>();
        for (Long saleOrderItemId : reqBo.getOrdItemList()) {
            UocGetSaleOrderDetailServiceRspItemBo itemInfoBo = itemBoMap.get(saleOrderItemId);
            String skuCode = itemInfoBo.getSkuCode();
            if (!CollectionUtil.isEmpty(afterTypeMap) && !CollectionUtil.isEmpty((Collection)((Collection)afterTypeMap.get(saleOrderItemId)))) continue;
            if (reqBo.getOrdItemList().size() == 1) {
                resultStr.append("\u5f53\u524d\u5546\u54c1\u65e0\u552e\u540e\u65b9\u5f0f\uff0c\u65e0\u6cd5\u53d1\u8d77\u552e\u540e\u7533\u8bf7\uff0c\u8bf7\u77e5\u6653");
            } else {
                skuCodeList.add(skuCode);
            }
            isPass = 0;
        }
        if (!CollectionUtil.isEmpty(skuCodeList)) {
            String join = String.join((CharSequence)",", skuCodeList);
            resultStr.append("\u5546\u54c1\u7f16\u7801\u4e3a").append(join).append("\u7684\u5546\u54c1\u65e0\u552e\u540e\u65b9\u5f0f\uff0c\u65e0\u6cd5\u53d1\u8d77\u552e\u540e\u7533\u8bf7\uff0c\u8bf7\u77e5\u6653");
        }
        checkResultList.add(resultStr.toString());
        funcRspBO.setCheckResultList(checkResultList);
        funcRspBO.setIsPass(isPass);
        funcRspBO.setRespCode("0000");
        funcRspBO.setRespDesc("\u6210\u529f");
        return funcRspBO;
    }

    private AfterOrderTypeEntity buildThirdEntity(UocGetSaleOrderDetailServiceRspBo saleOrderDetail, Long itemId) {
        List saleOrderDetailServiceRspItemBoList = saleOrderDetail.getSaleOrderDetailServiceRspItemBoList();
        Map<Long, UocGetSaleOrderDetailServiceRspItemBo> itemBoMap = saleOrderDetailServiceRspItemBoList.stream().collect(Collectors.toMap(UocGetSaleOrderDetailServiceRspItemBo::getSaleOrderItemId, o -> o));
        UocGetSaleOrderDetailServiceRspItemBo uocGetSaleOrderDetailServiceRspItemBo = itemBoMap.get(itemId);
        String skuExtSkuId = uocGetSaleOrderDetailServiceRspItemBo.getSkuExtSkuId();
        AfterOrderTypeEntity afterOrderTypeEntity = new AfterOrderTypeEntity();
        String saleOrderNoExt = saleOrderDetail.getSaleOrderNoExt();
        afterOrderTypeEntity.setOrderId(saleOrderNoExt);
        afterOrderTypeEntity.setSkuId(skuExtSkuId);
        return afterOrderTypeEntity;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void resolveRspForCheck(String returnString, Map<Long, List<Integer>> afterTypeMap, Long itemId, UocGetSaleOrderDetailServiceRspBo saleOrderDetail) {
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        if (!rspJsonObject.getBoolean("success").booleanValue()) throw new ZTBusinessException("\u67e5\u8be2\u552e\u540e\u65b9\u5f0f\u5931\u8d25\uff01\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u5904\u7406\uff08\u5f02\u5e38\u4ee3\u7801:" + rspJsonObject.getString("resultCode") + " :" + rspJsonObject.getString("resultMessage") + "\uff09");
        if (rspJsonObject.get((Object)"result") == null) return;
        Object object = rspJsonObject.get((Object)"result");
        try {
            List resultByOrder = JSON.parseArray((String)object.toString(), AfterTypeAndTakeValueEntity.class);
            ArrayList<Integer> afterTypeList = new ArrayList<Integer>();
            for (AfterTypeAndTakeValueEntity afterTypeAndTakeValueEntity : resultByOrder) {
                Integer type = afterTypeAndTakeValueEntity.getType();
                afterTypeList.add(type);
            }
            if (CollectionUtil.isEmpty(afterTypeList)) return;
            if ("XS_YS_YS".equals(saleOrderDetail.getSaleOrderState()) || "XS_YS_BFYS".equals(saleOrderDetail.getSaleOrderState())) {
                Iterator iterator = afterTypeList.iterator();
                while (iterator.hasNext()) {
                    Integer next = (Integer)iterator.next();
                    if (!next.equals(DycFuncRspConstants.ThirdApiCommonConstant.AfterTypeConstant.RETURN)) continue;
                    log.info("\u9a8c\u6536\u4e0d\u9700\u8981\u9000\u8d27");
                    iterator.remove();
                }
            }
            if (!CollectionUtils.isEmpty(afterTypeList) && DycFuncCommonConstants.orderSource.ELC.equals(saleOrderDetail.getOrderSource())) {
                afterTypeList.removeIf(afterType -> afterType.equals(DycFuncRspConstants.ThirdApiCommonConstant.AfterTypeConstant.FIX));
            }
            if ("XS_QR_QRSH".equals(saleOrderDetail.getSaleOrderState())) {
                afterTypeList.removeIf(afterType -> afterType.equals(DycFuncRspConstants.ThirdApiCommonConstant.AfterTypeConstant.RETURN));
            }
            afterTypeMap.put(itemId, afterTypeList);
            return;
        }
        catch (Exception e) {
            throw new ZTBusinessException(e.getMessage());
        }
    }

    private void validateArg(DycUocEstoreCheckAfterOrderTypeFuncReqBO reqBo) {
        if (ObjectUtil.isEmpty((Object)((Object)reqBo))) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getOrderId())) {
            throw new ZTBusinessException("\u8ba2\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getSaleOrderId())) {
            throw new ZTBusinessException("\u9500\u552e\u5355Id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtil.isEmpty(reqBo.getOrdItemList())) {
            throw new ZTBusinessException("\u9500\u552e\u5355\u660e\u7ec6Id\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void resolveJDRspForCheck(String returnString, Map<Long, List<Integer>> afterTypeMap, Long itemId, UocGetSaleOrderDetailServiceRspBo saleOrderDetail) {
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        if (rspJsonObject.getBoolean("success").booleanValue()) {
            if (rspJsonObject.get((Object)"result") != null) {
                Object object = rspJsonObject.get((Object)"result");
                try {
                    List parseArray = JSON.parseArray((String)object.toString(), JDAfterTypeAndTakeValueEntity.class);
                    for (JDAfterTypeAndTakeValueEntity afterTypeAndTakeValueEntity : parseArray) {
                        List<Integer> customerExpect = afterTypeAndTakeValueEntity.getCustomerExpect();
                        if (CollectionUtil.isEmpty(customerExpect)) continue;
                        if ("XS_YS_YS".equals(saleOrderDetail.getSaleOrderState()) || "XS_YS_BFYS".equals(saleOrderDetail.getSaleOrderState())) {
                            Iterator<Integer> iterator = customerExpect.iterator();
                            while (iterator.hasNext()) {
                                Integer next = iterator.next();
                                if (!next.equals(DycFuncRspConstants.ThirdApiCommonConstant.AfterTypeConstant.JD_RETURN)) continue;
                                log.info("\u9a8c\u6536\u4e0d\u9700\u8981\u9000\u8d27");
                                iterator.remove();
                            }
                        }
                        if (!CollectionUtils.isEmpty(customerExpect) && DycFuncCommonConstants.orderSource.ELC.equals(saleOrderDetail.getOrderSource())) {
                            customerExpect.removeIf(afterType -> afterType.equals(DycFuncRspConstants.ThirdApiCommonConstant.AfterTypeConstant.JD_FIX));
                        }
                        if ("XS_QR_QRSH".equals(saleOrderDetail.getSaleOrderState())) {
                            customerExpect.removeIf(afterType -> afterType.equals(DycFuncRspConstants.ThirdApiCommonConstant.AfterTypeConstant.JD_RETURN));
                        }
                        afterTypeMap.put(itemId, customerExpect);
                    }
                }
                catch (Exception e) {
                    throw new ZTBusinessException(e.getMessage());
                }
            }
        } else {
            throw new ZTBusinessException("\u67e5\u8be2\u552e\u540e\u65b9\u5f0f\u5931\u8d25\uff01\u8bf7\u8054\u7cfb\u8fd0\u7ef4\u4eba\u5458\u5904\u7406\uff08\u5f02\u5e38\u4ee3\u7801:" + rspJsonObject.getString("resultCode") + " :" + rspJsonObject.getString("resultMessage") + "\uff09");
        }
    }
}

