/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.estore.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.estore.api.DycUocEstoreRevokeCanceSalelOrderFunction;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreRevokeCanceSalelOrderFuncReqBO;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreRevokeCanceSalelOrderFuncRspBO;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.order.UocAddOrderInterLogService;
import com.tydic.dyc.oc.service.order.bo.UocAddOrderInterLogReqBO;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DycUocEstoreRevokeCanceSalelOrderFunctionImpl
implements DycUocEstoreRevokeCanceSalelOrderFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocEstoreRevokeCanceSalelOrderFunctionImpl.class);
    @Autowired
    private UocAddOrderInterLogService uocAddOrderInterLogService;

    @Override
    public DycUocEstoreRevokeCanceSalelOrderFuncRspBO revokeApplyCancel(DycUocEstoreRevokeCanceSalelOrderFuncReqBO reqBO) {
        this.validateArg(reqBO);
        DycUocEstoreRevokeCanceSalelOrderFuncRspBO rspBO = new DycUocEstoreRevokeCanceSalelOrderFuncRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        JSONObject json = new JSONObject();
        json.put("orderId", (Object)reqBO.getOutOrderId());
        json.put("cancelFlag", (Object)1);
        String hsn = DycPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + reqBO.getSupplierNo()));
        try {
            Date callTime = new Date();
            log.info("\u64a4\u9500\u53d6\u6d88\u8ba2\u5355\u7533\u8bf7\u5165\u53c2: {}", (Object)json.toJSONString());
            String httpRspStr = DycEsbUtil.doPostReuest((String)DycPropertiesUtil.getProperty((String)"ESB_CONFIRM_CANCEL_ORDER_URL"), (String)json.toJSONString(), (String)hsn);
            Date retTime = new Date();
            this.intsertInterLog(reqBO.getOrderId(), reqBO.getObjId(), callTime, retTime, hsn, DycPropertiesUtil.getProperty((String)"ESB_CONFIRM_CANCEL_ORDER_URL"), json.toJSONString(), httpRspStr);
            log.info("\u64a4\u9500\u53d6\u6d88\u8ba2\u5355\u7533\u8bf7\u5165\u53c2\u51fa\u53c2: {}", (Object)httpRspStr);
        }
        catch (ZTBusinessException e) {
            log.error("\u64a4\u9500\u7535\u5546\u8ba2\u5355\u53d6\u6d88\u63a5\u53e3\u5f02\u5e38\uff1a {}", (Object)e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        return rspBO;
    }

    public void validateArg(DycUocEstoreRevokeCanceSalelOrderFuncReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getOutOrderId())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027[outOrderId]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getSupplierNo())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61\u5c5e\u6027\u4f9b\u5e94\u5546\u7f16\u7801[supplierNo]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }

    private void intsertInterLog(Long orderId, Long objId, Date callTime, Date retTime, String hsn, String callUrl, String reqJson, String result) {
        UocAddOrderInterLogReqBO uocAddOrderInterLogReqBO = new UocAddOrderInterLogReqBO();
        uocAddOrderInterLogReqBO.setOrderId(orderId);
        uocAddOrderInterLogReqBO.setObjId(objId);
        uocAddOrderInterLogReqBO.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocAddOrderInterLogReqBO.setRetTime(retTime);
        uocAddOrderInterLogReqBO.setCallTime(callTime);
        uocAddOrderInterLogReqBO.setInterSn(hsn);
        uocAddOrderInterLogReqBO.setInterCode(callUrl);
        uocAddOrderInterLogReqBO.setFlowFlag(Integer.valueOf(2));
        uocAddOrderInterLogReqBO.setInContent(reqJson);
        uocAddOrderInterLogReqBO.setOutContent(result);
        this.uocAddOrderInterLogService.addOrderInterLog(uocAddOrderInterLogReqBO);
    }
}

