/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.estore.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.atom.base.utils.DycEsbUtil;
import com.tydic.dyc.atom.base.utils.DycPropertiesUtil;
import com.tydic.dyc.atom.estore.api.DycUocEstoreGetAfOrderDetailsFunction;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreGetAfOrderDetailsFunctionReqBO;
import com.tydic.dyc.atom.estore.bo.DycUocEstoreGetAfOrderDetailsFunctionRspBO;
import com.tydic.dyc.atom.estore.bo.afterOrder.AddressInfoDto;
import com.tydic.dyc.atom.estore.bo.afterOrder.AfsApplyDetailDto;
import com.tydic.dyc.oc.constants.UocDicConstant;
import com.tydic.dyc.oc.service.domainservice.UocDealAfOrderShopAddressService;
import com.tydic.dyc.oc.service.domainservice.bo.UocDealAfOrderShopAddressReqBo;
import com.tydic.dyc.oc.service.order.UocAddOrderInterLogService;
import com.tydic.dyc.oc.service.order.bo.UocAddOrderInterLogReqBO;
import java.util.ArrayList;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DycUocEstoreGetAfOrderDetailsFunctionImpl
implements DycUocEstoreGetAfOrderDetailsFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocEstoreGetAfOrderDetailsFunctionImpl.class);
    @Autowired
    private UocAddOrderInterLogService uocAddOrderInterLogService;
    @Autowired
    private UocDealAfOrderShopAddressService uocDealAfOrderShopAddressService;

    @Override
    public DycUocEstoreGetAfOrderDetailsFunctionRspBO getAfOrderDetails(DycUocEstoreGetAfOrderDetailsFunctionReqBO reqBO) {
        DycUocEstoreGetAfOrderDetailsFunctionRspBO rspBO = new DycUocEstoreGetAfOrderDetailsFunctionRspBO();
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        JSONObject json = new JSONObject();
        json.put("orgId", (Object)reqBO.getOrgId());
        json.put("orderId", (Object)reqBO.getOrderId());
        json.put("thirdApplyId", (Object)reqBO.getThirdApplyId());
        json.put("appendInfoSteps", reqBO.getAppendInfoSteps());
        JSONObject parm = new JSONObject();
        parm.put("param", (Object)json);
        parm.put("orgId", (Object)reqBO.getOrgId());
        String hsn = DycPropertiesUtil.getProperty((String)("SUPPLIER_ID_" + reqBO.getSupplierNo()));
        try {
            log.info("\u67e5\u8be2\u7535\u5546\u552e\u540e\u7533\u8bf7\u5355\u660e\u7ec6\u5165\u53c2: {}", (Object)parm.toJSONString());
            Date callTime = new Date();
            String httpRspStr = DycEsbUtil.doPostReuest((String)DycPropertiesUtil.getProperty((String)"ESB_APPLY_DETAIL_INFO_URL"), (String)parm.toJSONString(), (String)hsn);
            Date retTime = new Date();
            this.intsertInterLog(reqBO.getOrderId(), reqBO.getObjId(), callTime, retTime, hsn, DycPropertiesUtil.getProperty((String)"ESB_AFS_APPLY_URL"), json.toJSONString(), httpRspStr);
            log.info("\u67e5\u8be2\u552e\u540e\u7533\u8bf7\u5355\u660e\u7ec6\u8fd4\u56de: {}", (Object)httpRspStr);
            rspBO = DycUocEstoreGetAfOrderDetailsFunctionImpl.resolveRsp(httpRspStr);
            UocDealAfOrderShopAddressReqBo addressReqBo = new UocDealAfOrderShopAddressReqBo();
            for (AddressInfoDto addressInfoDto : rspBO.getResult().getAddressInfoDtos()) {
                addressReqBo.setLinkedMan(addressInfoDto.getAfterserviceReceiver());
                addressReqBo.setLinkedMobile(addressInfoDto.getAfterserviceTel());
                addressReqBo.setReturnAdress(addressInfoDto.getAfterserviceAddress());
                addressReqBo.setPickwareType(reqBO.getPickwareType());
                addressReqBo.setServiceId(addressInfoDto.getThirdApplyId());
                this.uocDealAfOrderShopAddressService.dealAfOrderShopAddress(addressReqBo);
            }
        }
        catch (ZTBusinessException e) {
            log.error("\u8c03\u7528\u7535\u5546\u63a5\u53e3\u53d6\u6d88\u8ba2\u5355\u5f02\u5e38: {}", (Object)e.getMessage());
            throw new ZTBusinessException(e.getMessage());
        }
        return rspBO;
    }

    private static DycUocEstoreGetAfOrderDetailsFunctionRspBO resolveRsp(String returnString) {
        DycUocEstoreGetAfOrderDetailsFunctionRspBO rspBO = new DycUocEstoreGetAfOrderDetailsFunctionRspBO();
        JSONObject rspJsonObject = JSONObject.parseObject((String)returnString);
        if (rspJsonObject.getBoolean("success").booleanValue()) {
            JSONObject jsonObject = (JSONObject)rspJsonObject.get((Object)"result");
            JSONArray addressInfoDtos = jsonObject.getJSONArray("addressInfoDtos");
            ArrayList list = new ArrayList();
            addressInfoDtos.stream().forEach(x -> {
                JSONObject object = (JSONObject)x;
                AddressInfoDto addressInfoDto = (AddressInfoDto)JSONObject.parseObject((String)JSON.toJSONString((Object)object), AddressInfoDto.class);
                list.add(addressInfoDto);
            });
            AfsApplyDetailDto result = (AfsApplyDetailDto)JSON.parseObject((String)jsonObject.toJSONString(), AfsApplyDetailDto.class);
            rspBO.setResult(result);
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        rspBO.setRespCode(rspJsonObject.getString("resultCode"));
        rspBO.setRespDesc(rspJsonObject.getString("resultMessage"));
        return rspBO;
    }

    private void intsertInterLog(Long orderId, Long objId, Date callTime, Date retTime, String hsn, String callUrl, String reqJson, String result) {
        UocAddOrderInterLogReqBO uocAddOrderInterLogReqBO = new UocAddOrderInterLogReqBO();
        uocAddOrderInterLogReqBO.setOrderId(orderId);
        uocAddOrderInterLogReqBO.setObjId(objId);
        uocAddOrderInterLogReqBO.setObjType(UocDicConstant.OBJ_TYPE.SALE);
        uocAddOrderInterLogReqBO.setRetTime(retTime);
        uocAddOrderInterLogReqBO.setCallTime(callTime);
        uocAddOrderInterLogReqBO.setInterSn(hsn);
        uocAddOrderInterLogReqBO.setInterCode(callUrl);
        uocAddOrderInterLogReqBO.setFlowFlag(Integer.valueOf(2));
        uocAddOrderInterLogReqBO.setInContent(reqJson);
        uocAddOrderInterLogReqBO.setOutContent(result);
        this.uocAddOrderInterLogService.addOrderInterLog(uocAddOrderInterLogReqBO);
    }
}

