/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.jnpersonal.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.service.api.DycActQueryCatalogTreeService;
import com.tydic.dyc.act.service.api.DycActQuerySkuPageListService;
import com.tydic.dyc.act.service.bo.DycActQueryCatalogTreeBO;
import com.tydic.dyc.act.service.bo.DycActQueryCatalogTreeReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryCatalogTreeRspBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPageListBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPageListRspBO;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.dyc.base.utils.IdUtil;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.base.utils.MoneyUtils;
import com.tydic.dyc.jnpersonal.api.DycSaasPushAllSkuService;
import com.tydic.dyc.jnpersonal.bo.DycBaseIntelligentReqBO;
import com.tydic.dyc.jnpersonal.bo.DycBaseIntelligentRspBO;
import com.tydic.dyc.jnpersonal.bo.DycSaasPushAllSkuReqBO;
import com.tydic.dyc.jnpersonal.bo.DycSaasPushSkuBO;
import com.tydic.dyc.jnpersonal.bo.DycSaasPushSkuParamsBO;
import com.tydic.dyc.jnpersonal.bo.DycSaasPushSkuPicBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.jnpersonal.api.DycSaasPushAllSkuService"})
public class DycSaasPushAllSkuServiceImpl
implements DycSaasPushAllSkuService {
    private static final Logger log = LoggerFactory.getLogger(DycSaasPushAllSkuServiceImpl.class);
    @Autowired
    private DycActQuerySkuPageListService dycActQuerySkuPageListService;
    @Autowired
    private DycActQueryCatalogTreeService dycActQueryCatalogTreeService;
    @Value(value="${intelligent.pushSkuUrl:/pushSkuUrl}")
    private String pushSkuUrl;
    private static final Integer MAX_SIZE = 100;

    @Override
    @PostMapping(value={"skuAllPush"})
    public void skuAllPush(@RequestBody DycSaasPushAllSkuReqBO reqBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getPoolName())) {
            throw new ZTBusinessException("\u63a8\u9001\u5546\u54c1\u4fe1\u606f\u5165\u53c2\u5546\u54c1\u6c60\u540d\u79f0[poolName]\u4e3a\u7a7a");
        }
        AtomicInteger syncSize = new AtomicInteger();
        if ("employeeWelfare".equals(reqBO.getPoolName())) {
            DycActQueryCatalogTreeReqBO catalogTreeReqBO = new DycActQueryCatalogTreeReqBO();
            DycActQueryCatalogTreeRspBO catalogTreeRspBO = this.dycActQueryCatalogTreeService.queryCatalogTree(catalogTreeReqBO);
            if (!"0000".equals(catalogTreeRspBO.getRespCode())) {
                throw new ZTBusinessException("\u67e5\u8be2\u5546\u54c1\u5206\u7c7b\u5931\u8d25\uff1a" + catalogTreeRspBO.getRespDesc());
            }
            ArrayList<Long> guiIdList = new ArrayList<Long>();
            for (DycActQueryCatalogTreeBO firstBO : catalogTreeRspBO.getCatalogTreeList()) {
                if (CollectionUtils.isEmpty((Collection)firstBO.getCatalogTreeList())) continue;
                for (DycActQueryCatalogTreeBO secondBO : firstBO.getCatalogTreeList()) {
                    if (CollectionUtils.isEmpty((Collection)secondBO.getCatalogTreeList())) continue;
                    for (DycActQueryCatalogTreeBO threeBO : secondBO.getCatalogTreeList()) {
                        guiIdList.add(threeBO.getGuideCatalogId());
                    }
                }
            }
            ExecutorService executorService = Executors.newFixedThreadPool(10);
            Object lock = new Object();
            for (Long guiId : guiIdList) {
                executorService.submit(() -> {
                    Object object = lock;
                    synchronized (object) {
                        DycActQuerySkuPageListRspBO qrySkuRspBO = this.getRows(guiId, 1);
                        if (qrySkuRspBO.getRows().size() > 1) {
                            this.dealSkuInfo(reqBO.getPoolName(), qrySkuRspBO.getRows());
                            for (int i = 2; i < qrySkuRspBO.getTotal(); ++i) {
                                DycActQuerySkuPageListRspBO qrySkuRspBO1 = this.getRows(guiId, i);
                                this.dealSkuInfo(reqBO.getPoolName(), qrySkuRspBO1.getRows());
                            }
                        } else {
                            this.dealSkuInfo(reqBO.getPoolName(), qrySkuRspBO.getRows());
                        }
                        syncSize.addAndGet(qrySkuRspBO.getRecordsTotal());
                    }
                });
            }
            executorService.shutdown();
            try {
                if (!executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                    executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                executorService.shutdownNow();
            }
        }
        log.info("\u6b64\u6b21\u540c\u6b65\u603b\u6570\u91cf\uff1a{}", (Object)syncSize.get());
    }

    @NotNull
    private DycActQuerySkuPageListRspBO getRows(Long guiId, int pageNo) {
        DycActQuerySkuPageListReqBO qrySkuReqBO = new DycActQuerySkuPageListReqBO();
        qrySkuReqBO.setQrySkuSpecPic(Boolean.TRUE);
        qrySkuReqBO.setGuideCatalogId(guiId);
        qrySkuReqBO.setCatalogLevel(Integer.valueOf(3));
        qrySkuReqBO.setPageNo(pageNo);
        qrySkuReqBO.setPageSize(100);
        qrySkuReqBO.setQryExtMain(Boolean.FALSE);
        DycActQuerySkuPageListRspBO qrySkuRspBO = this.dycActQuerySkuPageListService.querySkuPageList(qrySkuReqBO);
        if (!"0000".equals(qrySkuRspBO.getRespCode())) {
            throw new ZTBusinessException("\u67e5\u8be2\u5458\u5de5\u798f\u5229\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + qrySkuRspBO.getRespDesc());
        }
        return qrySkuRspBO;
    }

    private void dealSkuInfo(String poolName, List<DycActQuerySkuPageListBO> rows) {
        if (ObjectUtil.isNotEmpty(rows)) {
            Map<String, List<DycActQuerySkuPageListBO>> categoryMap = rows.stream().collect(Collectors.groupingBy(DycActQuerySkuPageListBO::getThreeCatalogId));
            Iterator<Map.Entry<String, List<DycActQuerySkuPageListBO>>> iterator = categoryMap.entrySet().iterator();
            while (iterator.hasNext()) {
                ArrayList<DycSaasPushSkuBO> skuInfos = new ArrayList<DycSaasPushSkuBO>();
                Map.Entry<String, List<DycActQuerySkuPageListBO>> map = iterator.next();
                String categoryCode = map.getKey();
                String categoryName = map.getValue().get(0).getThreeCatalogName();
                for (DycActQuerySkuPageListBO skuPageListBO : map.getValue()) {
                    DycSaasPushSkuBO skuPushBO = this.setSkuPushBO(skuPageListBO);
                    skuInfos.add(skuPushBO);
                }
                if (skuInfos.size() >= MAX_SIZE) {
                    int times = skuInfos.size() % MAX_SIZE == 0 ? skuInfos.size() / MAX_SIZE : skuInfos.size() / MAX_SIZE + 1;
                    int startIndex = 0;
                    int endIndex = MAX_SIZE;
                    for (int i = 1; i <= times; ++i) {
                        List<DycSaasPushSkuBO> skuPushBOList = skuInfos.subList(startIndex, i == times ? skuInfos.size() : endIndex);
                        this.skuPushFun(poolName, skuPushBOList, categoryCode, categoryName);
                        startIndex += MAX_SIZE.intValue();
                        endIndex += MAX_SIZE.intValue();
                    }
                    continue;
                }
                this.skuPushFun(poolName, skuInfos, categoryCode, categoryName);
            }
        }
    }

    private DycSaasPushSkuBO setSkuPushBO(DycActQuerySkuPageListBO skuPageListBO) {
        DycSaasPushSkuBO skuPushBO = (DycSaasPushSkuBO)JUtil.js((Object)skuPageListBO, DycSaasPushSkuBO.class);
        skuPushBO.setShopId(skuPageListBO.getSupplierId() + "");
        skuPushBO.setShopName(skuPageListBO.getSupplierName());
        skuPushBO.setSalesPrice(MoneyUtils.yuanToHaoToLong((BigDecimal)skuPageListBO.getAgreementPrice()));
        skuPushBO.setPurchasePrice(MoneyUtils.yuanToHaoToLong((BigDecimal)skuPageListBO.getAgreementPrice()));
        skuPushBO.setMarketPrice(MoneyUtils.yuanToHaoToLong((BigDecimal)skuPageListBO.getMarketPrice()));
        skuPushBO.setUpcCode(skuPageListBO.getUpc());
        if (ObjectUtil.isNotEmpty((Object)skuPageListBO.getSkuPicList())) {
            List<DycSaasPushSkuPicBO> skuImages = skuPageListBO.getSkuPicList().stream().map(picBO -> {
                DycSaasPushSkuPicBO picPushBO = new DycSaasPushSkuPicBO();
                picPushBO.setSkuPicId(picBO.getPicId() + "");
                picPushBO.setCommodityPicType(picBO.getPicType());
                picPushBO.setSkuPicUrl(picBO.getPicUrl());
                return picPushBO;
            }).collect(Collectors.toList());
            skuPushBO.setSkuImages(skuImages);
        }
        if (ObjectUtil.isNotEmpty((Object)skuPageListBO.getSkuParamList())) {
            List specs = JUtil.jsl((List)skuPageListBO.getSkuParamList(), DycSaasPushSkuParamsBO.class);
            skuPushBO.setSpecs(specs);
        }
        return skuPushBO;
    }

    private void skuPushFun(String poolName, List<DycSaasPushSkuBO> skuPushBOList, String categoryCode, String categoryName) {
        String serialNo = IdUtil.nextId() + "";
        DycBaseIntelligentReqBO<JSONObject> intelligentReqBO = new DycBaseIntelligentReqBO<JSONObject>();
        JSONObject data = new JSONObject();
        data.put("serialNo", (Object)serialNo);
        data.put("poolName", (Object)poolName);
        data.put("skuInfos", JSON.toJSON(skuPushBOList));
        data.put("categoryCode", (Object)categoryCode);
        data.put("categoryName", (Object)categoryName);
        intelligentReqBO.setSerialNo(serialNo);
        intelligentReqBO.setPoolName(poolName);
        intelligentReqBO.setData(data);
        log.debug("\u63a8\u9001\u5546\u54c1\u4fe1\u606f\u5165\u53c2----url:{}\nreqString: {}", (Object)this.pushSkuUrl, (Object)JSON.toJSONString(intelligentReqBO));
        String result = SSLClient.doPost((String)this.pushSkuUrl, (String)JSON.toJSONString(intelligentReqBO));
        log.debug("\u63a8\u9001\u5546\u54c1\u4fe1\u606f\u51fa\u53c2----result\uff1a{}", (Object)JSON.toJSONString((Object)result));
        DycBaseIntelligentRspBO intelligentRspBO = (DycBaseIntelligentRspBO)JSON.parseObject((String)result, DycBaseIntelligentRspBO.class);
    }
}

