/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.jnpersonal.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.service.api.DycActQueryCatalogTreeService;
import com.tydic.dyc.act.service.bo.DycActQueryCatalogTreeBO;
import com.tydic.dyc.act.service.bo.DycActQueryCatalogTreeReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryCatalogTreeRspBO;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.dyc.base.utils.IdUtil;
import com.tydic.dyc.jnpersonal.api.DycSaasPushSkuCategoryService;
import com.tydic.dyc.jnpersonal.bo.DycBaseIntelligentReqBO;
import com.tydic.dyc.jnpersonal.bo.DycBaseIntelligentRspBO;
import com.tydic.dyc.jnpersonal.bo.DycSaasPushCategoryBO;
import com.tydic.dyc.jnpersonal.bo.DycSaasPushSkuCategoryReqBO;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.jnpersonal.api.DycSaasPushSkuCategoryService"})
public class DycSaasPushSkuCategoryServiceImpl
implements DycSaasPushSkuCategoryService {
    private static final Logger log = LoggerFactory.getLogger(DycSaasPushSkuCategoryServiceImpl.class);
    @Autowired
    private DycActQueryCatalogTreeService dycActQueryCatalogTreeService;
    @Value(value="${intelligent.pushSkuCategoryUrl:/pushSkuCategoryUrl}")
    private String pushSkuCategoryUrl;

    @Override
    @PostMapping(value={"pushSkuCategory"})
    public void pushSkuCategory(@RequestBody DycSaasPushSkuCategoryReqBO reqBO) {
        if ("employeeWelfare".equals(reqBO.getPoolName())) {
            ArrayList<DycSaasPushCategoryBO> categoryList = new ArrayList<DycSaasPushCategoryBO>();
            DycActQueryCatalogTreeReqBO catalogTreeReqBO = new DycActQueryCatalogTreeReqBO();
            DycActQueryCatalogTreeRspBO catalogTreeRspBO = this.dycActQueryCatalogTreeService.queryCatalogTree(catalogTreeReqBO);
            if (!"0000".equals(catalogTreeRspBO.getRespCode())) {
                throw new ZTBusinessException("\u67e5\u8be2\u5546\u54c1\u5206\u7c7b\u5931\u8d25\uff1a" + catalogTreeRspBO.getRespDesc());
            }
            log.info("\u67e5\u8be2\u5546\u54c1\u5206\u7c7b\u51fa\u53c2\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)catalogTreeRspBO));
            for (DycActQueryCatalogTreeBO firstTreeBO : catalogTreeRspBO.getCatalogTreeList()) {
                DycSaasPushCategoryBO first = DycSaasPushSkuCategoryServiceImpl.setNoFirstBO(firstTreeBO, DycActivityConstants.CatalogLevel.ONE, "0", "0");
                categoryList.add(first);
                if (!ObjectUtil.isNotEmpty((Object)firstTreeBO.getCatalogTreeList())) continue;
                for (DycActQueryCatalogTreeBO secondTreeBO : firstTreeBO.getCatalogTreeList()) {
                    DycSaasPushCategoryBO second = DycSaasPushSkuCategoryServiceImpl.setNoFirstBO(secondTreeBO, DycActivityConstants.CatalogLevel.TWO, firstTreeBO.getGuideCatalogId() + "", "0");
                    categoryList.add(second);
                    if (!ObjectUtil.isNotEmpty((Object)secondTreeBO.getCatalogTreeList())) continue;
                    for (DycActQueryCatalogTreeBO threeTreeBO : secondTreeBO.getCatalogTreeList()) {
                        DycSaasPushCategoryBO three = DycSaasPushSkuCategoryServiceImpl.setNoFirstBO(threeTreeBO, DycActivityConstants.CatalogLevel.THREE, secondTreeBO.getGuideCatalogId() + "", "1");
                        categoryList.add(three);
                    }
                }
            }
            this.skuCategoryPushFun(reqBO.getPoolName(), categoryList);
        }
    }

    @NotNull
    private static DycSaasPushCategoryBO setNoFirstBO(DycActQueryCatalogTreeBO treeBO, Integer level, String fatherId, String isLastLevel) {
        DycSaasPushCategoryBO three = new DycSaasPushCategoryBO();
        three.setCategoryCode(treeBO.getGuideCatalogId() + "");
        three.setCategoryName(treeBO.getCatalogName());
        three.setFatherId(fatherId);
        three.setCategoryLevel(level + "");
        three.setIsLastLevel(isLastLevel);
        return three;
    }

    private void skuCategoryPushFun(String poolName, List<DycSaasPushCategoryBO> categoryList) {
        String serialNo = IdUtil.nextId() + "";
        DycBaseIntelligentReqBO<JSONObject> intelligentReqBO = new DycBaseIntelligentReqBO<JSONObject>();
        JSONObject data = new JSONObject();
        data.put("serialNo", (Object)(IdUtil.nextId() + ""));
        data.put("poolName", (Object)poolName);
        data.put("categoryList", JSON.toJSON(categoryList));
        intelligentReqBO.setSerialNo(serialNo);
        intelligentReqBO.setPoolName(poolName);
        intelligentReqBO.setData(data);
        log.debug("\u63a8\u9001\u5546\u54c1\u5206\u7c7b\u63a5\u53e3\u5165\u53c2----url:{}\nreqString: {}", (Object)this.pushSkuCategoryUrl, (Object)JSON.toJSONString(intelligentReqBO));
        String result = SSLClient.doPost((String)this.pushSkuCategoryUrl, (String)JSON.toJSONString(intelligentReqBO));
        log.debug("\u63a8\u9001\u5546\u54c1\u5206\u7c7b\u63a5\u53e3\u51fa\u53c2----result\uff1a{}", (Object)JSON.toJSONString((Object)result));
        DycBaseIntelligentRspBO intelligentRspBO = (DycBaseIntelligentRspBO)JSON.parseObject((String)result, DycBaseIntelligentRspBO.class);
    }
}

