/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.jnpersonal.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.service.api.DycActQuerySkuPushInfoService;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPushInfoBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPushInfoReqBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPushInfoRspBO;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.dyc.base.utils.IdUtil;
import com.tydic.dyc.base.utils.MoneyUtils;
import com.tydic.dyc.jnpersonal.api.DycSaasPushSkuPriceService;
import com.tydic.dyc.jnpersonal.bo.DycBaseIntelligentReqBO;
import com.tydic.dyc.jnpersonal.bo.DycBaseIntelligentRspBO;
import com.tydic.dyc.jnpersonal.bo.DycSaasPushSkuPriceBO;
import com.tydic.dyc.jnpersonal.bo.DycSaasPushSkuPriceReqBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.jnpersonal.api.DycSaasPushSkuPriceService"})
public class DycSaasPushSkuPriceServiceImpl
implements DycSaasPushSkuPriceService {
    private static final Logger log = LoggerFactory.getLogger(DycSaasPushSkuPriceServiceImpl.class);
    @Autowired
    private DycActQuerySkuPushInfoService dycActQuerySkuPushInfoService;
    @Value(value="${intelligent.pushSkuPriceUrl:/pushSkuPriceUrl}")
    private String pushSkuPriceUrl;
    private static final Integer MAX_SIZE = 100;

    @Override
    @PostMapping(value={"pushSkuPrice"})
    public void pushSkuPrice(@RequestBody DycSaasPushSkuPriceReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO.getSkuIds())) {
            throw new ZTBusinessException("\u63a8\u9001\u5546\u54c1\u4fe1\u606f\u5165\u53c2\u5355\u54c1ID[skuIds]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPoolName())) {
            throw new ZTBusinessException("\u63a8\u9001\u5546\u54c1\u4fe1\u606f\u5165\u53c2\u5546\u54c1\u6c60\u540d\u79f0[poolName]\u4e3a\u7a7a");
        }
        if ("employeeWelfare".equals(reqBO.getPoolName())) {
            DycActQuerySkuPushInfoReqBO qrySkuReqBO = new DycActQuerySkuPushInfoReqBO();
            qrySkuReqBO.setSkuIds(reqBO.getSkuIds());
            DycActQuerySkuPushInfoRspBO qrySkuRspBO = this.dycActQuerySkuPushInfoService.qrySkuPushInfo(qrySkuReqBO);
            if (!"0000".equals(qrySkuRspBO.getRespCode())) {
                throw new ZTBusinessException("\u67e5\u8be2\u5458\u5de5\u798f\u5229\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + qrySkuRspBO.getRespDesc());
            }
            if (ObjectUtil.isNotEmpty((Object)qrySkuRspBO.getRows())) {
                ArrayList<DycSaasPushSkuPriceBO> skuInfos = new ArrayList<DycSaasPushSkuPriceBO>();
                for (DycActQuerySkuPushInfoBO skuPageListBO : qrySkuRspBO.getRows()) {
                    DycSaasPushSkuPriceBO skuMarketPricePushBO = this.setSkuMarketPricePushBO(skuPageListBO, reqBO);
                    DycSaasPushSkuPriceBO skuAgrPricePushBO = this.setSkuAgrPricePushBO(skuPageListBO, reqBO);
                    skuInfos.add(skuMarketPricePushBO);
                    skuInfos.add(skuAgrPricePushBO);
                }
                if (skuInfos.size() >= MAX_SIZE) {
                    int times = skuInfos.size() % MAX_SIZE == 0 ? skuInfos.size() / MAX_SIZE : skuInfos.size() / MAX_SIZE + 1;
                    int startIndex = 0;
                    int endIndex = MAX_SIZE;
                    for (int i = 1; i <= times; ++i) {
                        List<DycSaasPushSkuPriceBO> skuPushBOList = skuInfos.subList(startIndex, i == times ? skuInfos.size() : endIndex);
                        this.skuPushFun(reqBO, skuPushBOList);
                        startIndex += MAX_SIZE.intValue();
                        endIndex += MAX_SIZE.intValue();
                    }
                } else {
                    this.skuPushFun(reqBO, skuInfos);
                }
            }
        }
    }

    private DycSaasPushSkuPriceBO setSkuMarketPricePushBO(DycActQuerySkuPushInfoBO skuPageListBO, DycSaasPushSkuPriceReqBO reqBO) {
        DycSaasPushSkuPriceBO skuPushBO = new DycSaasPushSkuPriceBO();
        skuPushBO.setSkuId(skuPageListBO.getSkuId().toString());
        skuPushBO.setChangeTime(new Date());
        skuPushBO.setChangeType(reqBO.getChangeType());
        skuPushBO.setPriceType("market");
        skuPushBO.setPriceValue(MoneyUtils.yuanToHaoToLong((BigDecimal)skuPageListBO.getMarketPrice()));
        return skuPushBO;
    }

    private DycSaasPushSkuPriceBO setSkuAgrPricePushBO(DycActQuerySkuPushInfoBO skuPageListBO, DycSaasPushSkuPriceReqBO reqBO) {
        DycSaasPushSkuPriceBO skuPushBO = new DycSaasPushSkuPriceBO();
        skuPushBO.setSkuId(skuPageListBO.getSkuId().toString());
        skuPushBO.setChangeTime(new Date());
        skuPushBO.setChangeType(reqBO.getChangeType());
        skuPushBO.setPriceType("purchase");
        skuPushBO.setPriceValue(MoneyUtils.yuanToHaoToLong((BigDecimal)skuPageListBO.getAgreementPrice()));
        return skuPushBO;
    }

    private void skuPushFun(DycSaasPushSkuPriceReqBO reqBO, List<DycSaasPushSkuPriceBO> skuPushBOList) {
        String serialNo = IdUtil.nextId() + "";
        DycBaseIntelligentReqBO<JSONObject> intelligentReqBO = new DycBaseIntelligentReqBO<JSONObject>();
        JSONObject data = new JSONObject();
        data.put("serialNo", (Object)(IdUtil.nextId() + ""));
        data.put("poolName", (Object)reqBO.getPoolName());
        data.put("skuPricelist", JSON.toJSON(skuPushBOList));
        intelligentReqBO.setSerialNo(serialNo);
        intelligentReqBO.setPoolName(reqBO.getPoolName());
        intelligentReqBO.setData(data);
        log.debug("\u63a8\u9001\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u5165\u53c2----url:{}\nreqString: {}", (Object)this.pushSkuPriceUrl, (Object)JSON.toJSONString(intelligentReqBO));
        String result = SSLClient.doPost((String)this.pushSkuPriceUrl, (String)JSON.toJSONString(intelligentReqBO));
        log.debug("\u63a8\u9001\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u51fa\u53c2----result\uff1a{}", (Object)JSON.toJSONString((Object)result));
        DycBaseIntelligentRspBO intelligentRspBO = (DycBaseIntelligentRspBO)JSON.parseObject((String)result, DycBaseIntelligentRspBO.class);
    }
}

