/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.jnpersonal.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.service.api.DycActQuerySkuPageListService;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPageListBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQuerySkuPageListRspBO;
import com.tydic.dyc.atom.base.utils.SSLClient;
import com.tydic.dyc.base.utils.IdUtil;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.dyc.base.utils.MoneyUtils;
import com.tydic.dyc.jnpersonal.api.DycSaasPushSkuService;
import com.tydic.dyc.jnpersonal.bo.DycBaseIntelligentReqBO;
import com.tydic.dyc.jnpersonal.bo.DycBaseIntelligentRspBO;
import com.tydic.dyc.jnpersonal.bo.DycSaasPushSkuBO;
import com.tydic.dyc.jnpersonal.bo.DycSaasPushSkuParamsBO;
import com.tydic.dyc.jnpersonal.bo.DycSaasPushSkuPicBO;
import com.tydic.dyc.jnpersonal.bo.DycSaasPushSkuReqBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.jnpersonal.api.DycSaasPushSkuService"})
public class DycSaasPushSkuServiceImpl
implements DycSaasPushSkuService {
    private static final Logger log = LoggerFactory.getLogger(DycSaasPushSkuServiceImpl.class);
    @Autowired
    private DycActQuerySkuPageListService dycActQuerySkuPageListService;
    @Value(value="${intelligent.pushSkuUrl:/pushSkuUrl}")
    private String pushSkuUrl;
    private static final Integer MAX_SIZE = 100;

    @Override
    @PostMapping(value={"skuPush"})
    public void skuPush(@RequestBody DycSaasPushSkuReqBO reqBO) {
        if (ObjectUtil.isEmpty(reqBO.getSkuIds())) {
            throw new ZTBusinessException("\u63a8\u9001\u5546\u54c1\u4fe1\u606f\u5165\u53c2\u5355\u54c1ID[skuIds]\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBO.getPoolName())) {
            throw new ZTBusinessException("\u63a8\u9001\u5546\u54c1\u4fe1\u606f\u5165\u53c2\u5546\u54c1\u6c60\u540d\u79f0[poolName]\u4e3a\u7a7a");
        }
        if ("employeeWelfare".equals(reqBO.getPoolName())) {
            DycActQuerySkuPageListReqBO qrySkuReqBO = new DycActQuerySkuPageListReqBO();
            qrySkuReqBO.setSkuIds(reqBO.getSkuIds());
            qrySkuReqBO.setQrySkuSpecPic(Boolean.TRUE);
            qrySkuReqBO.setPageSize(reqBO.getSkuIds().size());
            qrySkuReqBO.setQryExtMain(Boolean.FALSE);
            DycActQuerySkuPageListRspBO qrySkuRspBO = this.dycActQuerySkuPageListService.querySkuPageList(qrySkuReqBO);
            if (!"0000".equals(qrySkuRspBO.getRespCode())) {
                throw new ZTBusinessException("\u67e5\u8be2\u5458\u5de5\u798f\u5229\u5546\u54c1\u4fe1\u606f\u5931\u8d25\uff1a" + qrySkuRspBO.getRespDesc());
            }
            if (ObjectUtil.isNotEmpty((Object)qrySkuRspBO.getRows())) {
                Map<String, List<DycActQuerySkuPageListBO>> categoryMap = qrySkuRspBO.getRows().stream().collect(Collectors.groupingBy(DycActQuerySkuPageListBO::getThreeCatalogId));
                Iterator<Map.Entry<String, List<DycActQuerySkuPageListBO>>> iterator = categoryMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    ArrayList<DycSaasPushSkuBO> skuInfos = new ArrayList<DycSaasPushSkuBO>();
                    Map.Entry<String, List<DycActQuerySkuPageListBO>> map = iterator.next();
                    String categoryCode = map.getKey();
                    String categoryName = map.getValue().get(0).getThreeCatalogName();
                    for (DycActQuerySkuPageListBO skuPageListBO : map.getValue()) {
                        DycSaasPushSkuBO skuPushBO = this.setSkuPushBO(skuPageListBO);
                        skuInfos.add(skuPushBO);
                    }
                    if (skuInfos.size() >= MAX_SIZE) {
                        int times = skuInfos.size() % MAX_SIZE == 0 ? skuInfos.size() / MAX_SIZE : skuInfos.size() / MAX_SIZE + 1;
                        int startIndex = 0;
                        int endIndex = MAX_SIZE;
                        for (int i = 1; i <= times; ++i) {
                            List<DycSaasPushSkuBO> skuPushBOList = skuInfos.subList(startIndex, i == times ? skuInfos.size() : endIndex);
                            this.skuPushFun(reqBO, skuPushBOList, categoryCode, categoryName);
                            startIndex += MAX_SIZE.intValue();
                            endIndex += MAX_SIZE.intValue();
                        }
                        continue;
                    }
                    this.skuPushFun(reqBO, skuInfos, categoryCode, categoryName);
                }
            }
        }
    }

    private DycSaasPushSkuBO setSkuPushBO(DycActQuerySkuPageListBO skuPageListBO) {
        DycSaasPushSkuBO skuPushBO = (DycSaasPushSkuBO)JUtil.js((Object)skuPageListBO, DycSaasPushSkuBO.class);
        skuPushBO.setShopId(skuPageListBO.getSupplierId() + "");
        skuPushBO.setShopName(skuPageListBO.getSupplierName());
        skuPushBO.setSalesPrice(MoneyUtils.yuanToHaoToLong((BigDecimal)skuPageListBO.getAgreementPrice()));
        skuPushBO.setPurchasePrice(MoneyUtils.yuanToHaoToLong((BigDecimal)skuPageListBO.getAgreementPrice()));
        skuPushBO.setMarketPrice(MoneyUtils.yuanToHaoToLong((BigDecimal)skuPageListBO.getMarketPrice()));
        skuPushBO.setUpcCode(skuPageListBO.getUpc());
        if (ObjectUtil.isNotEmpty((Object)skuPageListBO.getSkuPicList())) {
            List<DycSaasPushSkuPicBO> skuImages = skuPageListBO.getSkuPicList().stream().map(picBO -> {
                DycSaasPushSkuPicBO picPushBO = new DycSaasPushSkuPicBO();
                picPushBO.setSkuPicId(picBO.getPicId() + "");
                picPushBO.setCommodityPicType(picBO.getPicType());
                picPushBO.setSkuPicUrl(picBO.getPicUrl());
                return picPushBO;
            }).collect(Collectors.toList());
            skuPushBO.setSkuImages(skuImages);
        }
        if (ObjectUtil.isNotEmpty((Object)skuPageListBO.getSkuParamList())) {
            List specs = JUtil.jsl((List)skuPageListBO.getSkuParamList(), DycSaasPushSkuParamsBO.class);
            skuPushBO.setSpecs(specs);
        }
        return skuPushBO;
    }

    private void skuPushFun(DycSaasPushSkuReqBO reqBO, List<DycSaasPushSkuBO> skuPushBOList, String categoryCode, String categoryName) {
        String serialNo = IdUtil.nextId() + "";
        DycBaseIntelligentReqBO<JSONObject> intelligentReqBO = new DycBaseIntelligentReqBO<JSONObject>();
        JSONObject data = new JSONObject();
        data.put("serialNo", (Object)(IdUtil.nextId() + ""));
        data.put("poolName", (Object)reqBO.getPoolName());
        data.put("skuInfos", JSON.toJSON(skuPushBOList));
        data.put("categoryCode", (Object)categoryCode);
        data.put("categoryName", (Object)categoryName);
        intelligentReqBO.setSerialNo(serialNo);
        intelligentReqBO.setPoolName(reqBO.getPoolName());
        intelligentReqBO.setData(data);
        log.debug("\u63a8\u9001\u5546\u54c1\u4fe1\u606f\u5165\u53c2----url:{}\nreqString: {}", (Object)this.pushSkuUrl, (Object)JSON.toJSONString(intelligentReqBO));
        String result = SSLClient.doPost((String)this.pushSkuUrl, (String)JSON.toJSONString(intelligentReqBO));
        log.debug("\u63a8\u9001\u5546\u54c1\u4fe1\u606f\u51fa\u53c2----result\uff1a{}", (Object)JSON.toJSONString((Object)result));
        DycBaseIntelligentRspBO intelligentRspBO = (DycBaseIntelligentRspBO)JSON.parseObject((String)result, DycBaseIntelligentRspBO.class);
    }
}

