/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.jnpersonal.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.dyc.act.service.api.DycActModifySkuCheckInfoService;
import com.tydic.dyc.act.service.bo.DycActModifySkuCheckInfoReqBO;
import com.tydic.dyc.jnpersonal.api.DycSaasSkuExceptionRelieveNoticeService;
import com.tydic.dyc.jnpersonal.bo.DycBaseIntelligentReqBO;
import com.tydic.dyc.jnpersonal.bo.DycBaseIntelligentRspBO;
import com.tydic.dyc.jnpersonal.bo.DycSaasSkuExceptionRelieveNoticeReqBO;
import com.tydic.dyc.jnpersonal.bo.DycSaasSkuExceptionRelieveRstBO;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"SAAS_GROUP_DEV/3.0.0/com.tydic.dyc.jnpersonal.api.DycSaasSkuExceptionRelieveNoticeService"})
public class DycSaasSkuExceptionRelieveNoticeServiceImpl
implements DycSaasSkuExceptionRelieveNoticeService {
    private static final Logger log = LoggerFactory.getLogger(DycSaasSkuExceptionRelieveNoticeServiceImpl.class);
    @Autowired
    private CacheClient cacheService;
    @Value(value="${intelligentRepeatTime:180}")
    private Integer intelligentRepeatTime;
    @Autowired
    private DycActModifySkuCheckInfoService dycActModifySkuCheckInfoService;

    @Override
    @PostMapping(value={"skuExceptionRelieveNotice"})
    public DycBaseIntelligentRspBO skuExceptionRelieveNotice(@RequestBody DycBaseIntelligentReqBO<DycSaasSkuExceptionRelieveNoticeReqBO> reqBO) {
        log.info("\u5546\u54c1\u5f02\u5e38\u89e3\u9664\u5165\u53c2\u4e3a\uff1a{}", reqBO);
        String typeName = this.getClass().getTypeName();
        DycBaseIntelligentRspBO rspBO = new DycBaseIntelligentRspBO();
        rspBO.setSerialNo(reqBO.getSerialNo());
        Object obj = this.cacheService.get(typeName + reqBO.getPoolName() + reqBO.getSerialNo());
        if (null != obj) {
            rspBO.setRespCode("1111");
            rspBO.setRspDesc("\u4ea4\u6613\u5904\u7406\u4e2d");
            return rspBO;
        }
        boolean errorFlag = this.valData(reqBO, rspBO);
        if (errorFlag) {
            return rspBO;
        }
        this.cacheService.set(typeName + reqBO.getPoolName() + reqBO.getSerialNo(), (Object)reqBO.getData(), this.intelligentRepeatTime.intValue());
        List<DycSaasSkuExceptionRelieveRstBO> skuExceptionList = reqBO.getData().getSkuExceptionList();
        List skuIds = skuExceptionList.stream().map(a -> Long.parseLong(a.getSkuId())).collect(Collectors.toList());
        DycActModifySkuCheckInfoReqBO checkInfoReqBO = new DycActModifySkuCheckInfoReqBO();
        checkInfoReqBO.setSkuIds(skuIds);
        checkInfoReqBO.setIsAnomalousPrice(Integer.valueOf(1));
        this.dycActModifySkuCheckInfoService.modifySkuCheckInfo(checkInfoReqBO);
        this.cacheService.delete(typeName + reqBO.getPoolName() + reqBO.getSerialNo());
        rspBO.setRespCode("0000");
        rspBO.setRspDesc("\u4ea4\u6613\u6210\u529f");
        return rspBO;
    }

    private boolean valData(DycBaseIntelligentReqBO<DycSaasSkuExceptionRelieveNoticeReqBO> reqBO, DycBaseIntelligentRspBO rspBO) {
        if (ObjectUtil.isEmpty((Object)reqBO.getData())) {
            rspBO.setRespCode("6666");
            rspBO.setRspDesc("\u53c2\u6570\u9519\u8bef");
            return true;
        }
        if (ObjectUtil.isEmpty(reqBO.getData().getSkuExceptionList())) {
            rspBO.setRespCode("6666");
            rspBO.setRspDesc("\u53c2\u6570\u9519\u8bef");
            return true;
        }
        for (DycSaasSkuExceptionRelieveRstBO rstBO : reqBO.getData().getSkuExceptionList()) {
            if (ObjectUtil.isEmpty((Object)rstBO.getSkuId())) {
                rspBO.setRespCode("6666");
                rspBO.setRspDesc("\u53c2\u6570\u9519\u8bef");
                return true;
            }
            if (!ObjectUtil.isEmpty((Object)rstBO.getRelieveTime())) continue;
            rspBO.setRespCode("6666");
            rspBO.setRspDesc("\u53c2\u6570\u9519\u8bef");
            return true;
        }
        return false;
    }
}

