/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.atom.selfrun.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.commodity.mall.ability.api.UccMallSalesVolumeAbilityService;
import com.tydic.commodity.mall.ability.bo.UccMallUpdateSaleNumBo;
import com.tydic.commodity.mall.ability.bo.UccMallUpdateSalesVolumeBO;
import com.tydic.commodity.mall.ability.bo.UccMallUpdateSalesVolumeReqBO;
import com.tydic.commodity.mall.ability.bo.UccMallUpdateSalesVolumeRspBO;
import com.tydic.dyc.atom.selfrun.api.DycUocDeductSkuNumFunction;
import com.tydic.dyc.atom.selfrun.bo.DycUocDeductSkuNumFuncBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocDeductSkuNumFuncReqBO;
import com.tydic.dyc.atom.selfrun.bo.DycUocDeductSkuNumFuncRspBO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DycUocDeductSkuNumFunctionImpl
implements DycUocDeductSkuNumFunction {
    private static final Logger log = LoggerFactory.getLogger(DycUocDeductSkuNumFunctionImpl.class);
    @Autowired
    private UccMallSalesVolumeAbilityService uccMallSalesVolumeAbilityService;

    @Override
    public DycUocDeductSkuNumFuncRspBO dealDeductSkuNum(DycUocDeductSkuNumFuncReqBO reqBO) {
        this.verifyParam(reqBO);
        Map<Long, List<DycUocDeductSkuNumFuncBO>> supShopMap = reqBO.getSkuDetailBos().stream().collect(Collectors.groupingBy(DycUocDeductSkuNumFuncBO::getSupplierShopId));
        UccMallUpdateSalesVolumeReqBO uccMallUpdateSalesVolumeReqBO = new UccMallUpdateSalesVolumeReqBO();
        ArrayList<UccMallUpdateSalesVolumeBO> uccUpdateSalesVolumeBOS = new ArrayList<UccMallUpdateSalesVolumeBO>();
        for (Map.Entry<Long, List<DycUocDeductSkuNumFuncBO>> entry : supShopMap.entrySet()) {
            UccMallUpdateSalesVolumeBO uccMallUpdateSalesVolumeBO = new UccMallUpdateSalesVolumeBO();
            uccMallUpdateSalesVolumeBO.setSupplierShopId(entry.getKey());
            uccMallUpdateSalesVolumeBO.setSaleNumBos(entry.getValue().stream().map(bo -> {
                UccMallUpdateSaleNumBo uccMallUpdateSaleNumBo = new UccMallUpdateSaleNumBo();
                uccMallUpdateSaleNumBo.setSkuId(bo.getSkuId());
                uccMallUpdateSaleNumBo.setSoldNumber(bo.getPurchaseCount());
                uccMallUpdateSaleNumBo.setIncOrDec(Integer.valueOf(reqBO.getOperType()));
                return uccMallUpdateSaleNumBo;
            }).collect(Collectors.toList()));
            uccUpdateSalesVolumeBOS.add(uccMallUpdateSalesVolumeBO);
        }
        uccMallUpdateSalesVolumeReqBO.setUccUpdateSalesVolumeBOS(uccUpdateSalesVolumeBOS);
        log.debug("\u8c03\u7528\u6263\u51cf\u5e93\u5b58\u5165\u53c2" + JSON.toJSONString((Object)uccMallUpdateSalesVolumeReqBO));
        UccMallUpdateSalesVolumeRspBO uccMallUpdateSalesVolumeRspBO = this.uccMallSalesVolumeAbilityService.updateSalesVolume(uccMallUpdateSalesVolumeReqBO);
        log.debug("\u8c03\u7528\u6263\u51cf\u5e93\u5b58\u51fa\u53c2" + JSON.toJSONString((Object)uccMallUpdateSalesVolumeRspBO));
        if ("0000".equals(uccMallUpdateSalesVolumeRspBO.getRespCode())) {
            DycUocDeductSkuNumFuncRspBO rspBO = new DycUocDeductSkuNumFuncRspBO();
            rspBO.setRespCode("0000");
            rspBO.setRespDesc("\u6210\u529f");
            return rspBO;
        }
        throw new BaseBusinessException(uccMallUpdateSalesVolumeRspBO.getRespCode(), "\u8c03\u7528\u5546\u54c1\u5e93\u5b58\u6263\u51cfAPI\u5931\u8d25\uff1a" + uccMallUpdateSalesVolumeRspBO.getRespDesc());
    }

    private void verifyParam(DycUocDeductSkuNumFuncReqBO reqBO) {
        if (null == reqBO) {
            throw new ZTBusinessException("\u5546\u54c1\u5e93\u5b58\u53d8\u66f4\u5931\u8d25\uff1a\u5165\u53c2\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty(reqBO.getSkuDetailBos())) {
            throw new ZTBusinessException("\u5546\u54c1\u5e93\u5b58\u53d8\u66f4\u5931\u8d25\uff1a\u5546\u54c1\u660e\u7ec6\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)reqBO.getOperType())) {
            throw new ZTBusinessException("\u5546\u54c1\u5e93\u5b58\u53d8\u66f4\u5931\u8d25\uff1a\u64cd\u4f5c\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

