/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.base.constant;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.file.FileClient;
import com.ohaotian.plugin.file.fastdfs.FastdfsFileInfo;
import com.tydic.commodity.base.constant.PesappCommonConstant;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class FileUpLoad {
    private static final Logger log = LoggerFactory.getLogger(FileUpLoad.class);
    @Autowired
    private FileClient fileClient;
    private static final String PATH = "dyc-common";
    @Value(value="${plugin.file.type}")
    private String fileType;
    @Value(value="${oss.fileUrl:}")
    private String ossFileUrl;
    @Value(value="${dyc.file.inst.data.path:dyc/file/instData}")
    private String instDataPath;
    @Value(value="${fastdfs.downloadUrl}")
    private String fastdfsDownloadUrl;

    public String upload(String fileNamePre, byte[] file, String fileType) {
        String fileUrl;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(file);
        String fileName = fileNamePre + fileType;
        String fileDir = UUID.randomUUID().toString().replaceAll("-", "");
        if (!this.instDataPath.endsWith("/")) {
            this.instDataPath = this.instDataPath + "/";
        }
        String path = this.fileClient.uploadFileByInputStream(this.instDataPath + fileDir, fileName, (InputStream)inputStream);
        if (PesappCommonConstant.FileService.FILE_TYPE_OSS.equals(this.fileType)) {
            fileUrl = "/" + path;
        } else if (PesappCommonConstant.FileService.FILE_TYPE_FASTDFS.equals(this.fileType)) {
            FastdfsFileInfo fastdfsFileInfo = FastdfsFileInfo.toFastdfsFileInfo((String)path);
            fileUrl = this.fastdfsDownloadUrl + "/" + fastdfsFileInfo.getGroupName() + "/" + fastdfsFileInfo.getFileName();
        } else if (PesappCommonConstant.FileService.FILE_TYPE_OBS.equals(fileType)) {
            fileUrl = "/" + path;
        } else {
            throw new ZTBusinessException("\u6682\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u670d\u52a1\u5668\u7c7b\u578b");
        }
        return fileUrl;
    }
}

