/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.commodity.base.bo.LadderPriceBO;
import com.tydic.commodity.base.constant.CommodityStatusConstants;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.constant.SkuStatusConstants;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.busibase.atom.api.UccAgrSkuMinimalismCreateAtomService;
import com.tydic.commodity.busibase.atom.bo.UccAgrSkuMinimalismCreateAtomReqBo;
import com.tydic.commodity.busibase.atom.bo.UccAgrSkuMinimalismCreateAtomRspBo;
import com.tydic.commodity.busibase.atom.bo.UccAgrSkuMinimalismCreateSupAtomBo;
import com.tydic.commodity.busibase.atom.bo.UccAgrSkuMinimalismInfoBo;
import com.tydic.commodity.dao.UccCommodityDetailMapper;
import com.tydic.commodity.dao.UccCommodityLogMapper;
import com.tydic.commodity.dao.UccCommodityMapper;
import com.tydic.commodity.dao.UccCommodityMeasureMapper;
import com.tydic.commodity.dao.UccCommodityPackageMapper;
import com.tydic.commodity.dao.UccCommodityPicMapper;
import com.tydic.commodity.dao.UccCommodityServiceMapper;
import com.tydic.commodity.dao.UccCommodityServiceReturnMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSaleNumMapper;
import com.tydic.commodity.dao.UccSkuDetailMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPicMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuPutCirMapper;
import com.tydic.commodity.po.UccCommodityDetailPO;
import com.tydic.commodity.po.UccCommodityLogPO;
import com.tydic.commodity.po.UccCommodityMeasurePo;
import com.tydic.commodity.po.UccCommodityPackagePo;
import com.tydic.commodity.po.UccCommodityPicPo;
import com.tydic.commodity.po.UccCommodityPo;
import com.tydic.commodity.po.UccCommodityServicePO;
import com.tydic.commodity.po.UccCommodityServiceReturnPO;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccSaleNumPo;
import com.tydic.commodity.po.UccSkuDetailPO;
import com.tydic.commodity.po.UccSkuExpandPo;
import com.tydic.commodity.po.UccSkuPicPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.po.UccSkuPutCirPo;
import com.tydic.commodity.utils.DateUtils;
import com.tydic.commodity.utils.MoneyUtils;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.smcsdk.api.SmcsdkOperateStockNumService;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumReqBO;
import com.tydic.smcsdk.api.bo.SmcsdkOperateStockNumRspBO;
import com.tydic.smcsdk.api.bo.SmcsdkStockNumInfoBO;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccAgrSkuMinimalismCreateAtomServiceImpl
implements UccAgrSkuMinimalismCreateAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccAgrSkuMinimalismCreateAtomServiceImpl.class);
    @Autowired
    private UccCommodityMapper uccCommodityMapper;
    @Autowired
    private UccCommodityPicMapper uccCommodityPicMapper;
    @Autowired
    private UccCommodityPackageMapper uccCommodityPackageMapper;
    @Autowired
    private UccCommodityServiceMapper uccCommodityServiceMapper;
    @Autowired
    private UccCommodityServiceReturnMapper uccCommodityServiceReturnMapper;
    @Autowired
    private UccCommodityDetailMapper uccCommodityDetailMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuPicMapper uccSkuPicMapper;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccSkuDetailMapper uccSkuDetailMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private UccCommodityLogMapper uccCommodityLogMapper;
    @Autowired
    private SmcsdkOperateStockNumService smcsdkOperateStockNumService;
    @Autowired
    private UccSkuPutCirMapper uccSkuPutCirMapper;
    @Autowired
    private UccSaleNumMapper uccSaleNumMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccCommodityMeasureMapper uccCommodityMeasureMapper;
    private Sequence sequence = Sequence.getInstance();

    @Override
    public UccAgrSkuMinimalismCreateAtomRspBo minimalismCreate(UccAgrSkuMinimalismCreateAtomReqBo reqBo) {
        List<UccAgrSkuMinimalismInfoBo> skuMinimalismInfoBoList = reqBo.getSkuMinimalismInfoBoList();
        List<UccSkuPo> uccSkuPos = this.minimalismCreateSku(skuMinimalismInfoBoList, reqBo);
        UccAgrSkuMinimalismCreateAtomRspBo rspBo = new UccAgrSkuMinimalismCreateAtomRspBo();
        rspBo.setUccAgrSkuMinimalismCreateSupAtomBos(JSON.parseArray((String)JSON.toJSONString(uccSkuPos), UccAgrSkuMinimalismCreateSupAtomBo.class));
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private List<UccSkuPo> minimalismCreateSku(List<UccAgrSkuMinimalismInfoBo> uccAgrSkuMinimalismInfoBos, UccAgrSkuMinimalismCreateAtomReqBo reqBo) {
        Date now = new Date();
        ArrayList<UccCommodityPo> uccCommodityPos = new ArrayList<UccCommodityPo>();
        ArrayList<UccCommodityPicPo> uccCommodityPicPos = new ArrayList<UccCommodityPicPo>();
        ArrayList<UccCommodityPackagePo> uccCommodityPackagePos = new ArrayList<UccCommodityPackagePo>();
        ArrayList<UccCommodityServicePO> uccCommodityServicePOS = new ArrayList<UccCommodityServicePO>();
        ArrayList<UccCommodityServiceReturnPO> uccCommodityServiceReturnPOS = new ArrayList<UccCommodityServiceReturnPO>();
        ArrayList<UccCommodityDetailPO> uccCommodityDetailPOS = new ArrayList<UccCommodityDetailPO>();
        ArrayList<UccSkuPo> uccSkuPos = new ArrayList<UccSkuPo>();
        ArrayList<UccSkuPicPo> uccSkuPicPos = new ArrayList<UccSkuPicPo>();
        ArrayList<UccSkuPricePo> uccSkuPricePos = new ArrayList<UccSkuPricePo>();
        ArrayList<UccSkuDetailPO> uccSkuDetailPOS = new ArrayList<UccSkuDetailPO>();
        ArrayList<UccLadderPricePO> uccLadderPricePOS = new ArrayList<UccLadderPricePO>();
        ArrayList<SmcsdkStockNumInfoBO> smcsdkStockNumInfoBOS = new ArrayList<SmcsdkStockNumInfoBO>();
        ArrayList<UccSaleNumPo> uccSaleNumPos = new ArrayList<UccSaleNumPo>();
        ArrayList<UccSkuPutCirPo> uccSkuPutCirPos = new ArrayList<UccSkuPutCirPo>();
        ArrayList<UccCommodityMeasurePo> insertMeasurePos = new ArrayList<UccCommodityMeasurePo>();
        Map<Object, Object> measureMap = new HashMap();
        List<String> measureNames = uccAgrSkuMinimalismInfoBos.stream().filter(a -> !ObjectUtil.isEmpty((Object)a.getMeasureName())).map(a -> a.getMeasureName()).distinct().collect(Collectors.toList());
        if (!ObjectUtil.isEmpty(measureNames)) {
            UccCommodityMeasurePo uccCommodityMeasurePo = new UccCommodityMeasurePo();
            uccCommodityMeasurePo.setMeasureNameList(measureNames);
            uccCommodityMeasurePo.setMeasureType(0);
            List<UccCommodityMeasurePo> uccCommodityMeasurePos = this.uccCommodityMeasureMapper.queryMeasureByPO(uccCommodityMeasurePo);
            if (!ObjectUtil.isEmpty(uccCommodityMeasurePos)) {
                measureMap = uccCommodityMeasurePos.stream().collect(Collectors.toMap(a -> a.getMeasureName(), a -> a.getMeasureId(), (first, secnd) -> first));
            }
        }
        for (UccAgrSkuMinimalismInfoBo uccAgrSkuMinimalismInfoBo : uccAgrSkuMinimalismInfoBos) {
            if (!ObjectUtil.isEmpty((Object)uccAgrSkuMinimalismInfoBo.getMeasureName()) && ObjectUtil.isEmpty((Object)uccAgrSkuMinimalismInfoBo.getMeasureId())) {
                if (measureMap.containsKey(uccAgrSkuMinimalismInfoBo.getMeasureName())) {
                    uccAgrSkuMinimalismInfoBo.setMeasureId((Long)measureMap.get(uccAgrSkuMinimalismInfoBo.getMeasureName()));
                    uccAgrSkuMinimalismInfoBo.setSalesUnitId(uccAgrSkuMinimalismInfoBo.getMeasureId());
                    uccAgrSkuMinimalismInfoBo.setSettlementUnitId(uccAgrSkuMinimalismInfoBo.getMeasureId());
                } else {
                    UccCommodityMeasurePo insertPO = new UccCommodityMeasurePo();
                    Long measureId = Sequence.getInstance().nextId();
                    insertPO.setMeasureId(measureId);
                    insertPO.setMeasureName(uccAgrSkuMinimalismInfoBo.getMeasureName());
                    insertPO.setCreateTime(now);
                    insertPO.setCreateLoginId(reqBo.getName());
                    insertPO.setStatus(1);
                    insertPO.setMeasureType(0);
                    insertPO.setDecimalLimit(6);
                    insertPO.setSource(1);
                    insertPO.setIsDelete(ModelRuleConstant.MEASURE_IS_DELETE_FALSE);
                    insertMeasurePos.add(insertPO);
                    measureMap.put(uccAgrSkuMinimalismInfoBo.getMeasureName(), measureId);
                    uccAgrSkuMinimalismInfoBo.setMeasureId(measureId);
                    uccAgrSkuMinimalismInfoBo.setSalesUnitId(measureId);
                    uccAgrSkuMinimalismInfoBo.setSettlementUnitId(measureId);
                }
            }
            UccCommodityPo uccCommodityPo = this.createSpuPo(uccCommodityPos, reqBo, now, uccAgrSkuMinimalismInfoBo);
            this.createCommodityPicPo(uccCommodityPicPos, reqBo, now, uccAgrSkuMinimalismInfoBo, uccCommodityPo);
            this.createCommodityPackagePo(uccCommodityPackagePos, reqBo, now, uccAgrSkuMinimalismInfoBo, uccCommodityPo);
            this.createCommodityServicePo(uccCommodityServicePOS, reqBo, now, uccAgrSkuMinimalismInfoBo, uccCommodityPo);
            this.createCommodityServiceReturnPo(uccCommodityServiceReturnPOS, uccAgrSkuMinimalismInfoBo, uccCommodityPo);
            this.createCommodityDetailPo(uccCommodityDetailPOS, uccAgrSkuMinimalismInfoBo, uccCommodityPo);
            UccSkuPo uccSkuPo = this.createSkuPo(uccSkuPos, uccAgrSkuMinimalismInfoBo, now, uccCommodityPo);
            this.createSkuPicPo(uccSkuPicPos, reqBo, now, uccAgrSkuMinimalismInfoBo, uccSkuPo);
            UccSkuPricePo skuPricePo = this.createSkuPricePo(uccSkuPricePos, reqBo, now, uccAgrSkuMinimalismInfoBo, uccSkuPo);
            this.createSkuDetailPo(uccSkuDetailPOS, uccAgrSkuMinimalismInfoBo, uccSkuPo);
            this.createPutCirDetail(uccSkuPutCirPos, uccAgrSkuMinimalismInfoBo, uccSkuPo);
            this.createLadderPricePo(uccLadderPricePOS, uccAgrSkuMinimalismInfoBo, uccSkuPo, skuPricePo);
            this.createStockBO(smcsdkStockNumInfoBOS, uccAgrSkuMinimalismInfoBo, uccSkuPo);
            this.createSaleNum(uccSaleNumPos, uccSkuPo);
        }
        this.insert(uccCommodityPos, uccCommodityPicPos, uccCommodityPackagePos, uccCommodityServicePOS, uccCommodityServiceReturnPOS, uccCommodityDetailPOS, uccSkuPos, uccSkuPicPos, uccSkuPricePos, uccSkuDetailPOS, uccLadderPricePOS, uccSaleNumPos, insertMeasurePos, uccSkuPutCirPos);
        this.createStock(smcsdkStockNumInfoBOS);
        return uccSkuPos;
    }

    private void createSaleNum(List<UccSaleNumPo> uccSaleNumPos, UccSkuPo uccSkuPo) {
        UccSaleNumPo saleNumPo = new UccSaleNumPo();
        saleNumPo.setSkuId(uccSkuPo.getSkuId());
        saleNumPo.setSupplierShopId(uccSkuPo.getSupplierShopId());
        saleNumPo.setSoldNumber(new BigDecimal(0));
        saleNumPo.setSaleId(this.sequence.nextId());
        uccSaleNumPos.add(saleNumPo);
    }

    private void insert(List<UccCommodityPo> uccCommodityPos, List<UccCommodityPicPo> uccCommodityPicPos, List<UccCommodityPackagePo> uccCommodityPackagePos, List<UccCommodityServicePO> uccCommodityServicePOS, List<UccCommodityServiceReturnPO> uccCommodityServiceReturnPOS, List<UccCommodityDetailPO> uccCommodityDetailPOS, List<UccSkuPo> uccSkuPos, List<UccSkuPicPo> uccSkuPicPos, List<UccSkuPricePo> uccSkuPricePos, List<UccSkuDetailPO> uccSkuDetailPOS, List<UccLadderPricePO> uccLadderPricePOS, List<UccSaleNumPo> uccSaleNumPos, List<UccCommodityMeasurePo> insertMeasurePos, List<UccSkuPutCirPo> uccSkuPutCirPos) {
        Date updateTime = new Date();
        if (!CollectionUtils.isEmpty(uccCommodityPos)) {
            this.uccCommodityMapper.insertBatch(uccCommodityPos);
            List uccCommodityLogPOS = JSON.parseArray((String)JSON.toJSONString(uccCommodityPos), UccCommodityLogPO.class);
            for (UccCommodityLogPO uccCommodityLogPO : uccCommodityLogPOS) {
                uccCommodityLogPO.setBatchId(uccCommodityLogPO.getCommodityId());
                uccCommodityLogPO.setUpdateTime(updateTime);
                uccCommodityLogPO.setOperType(UccConstants.CommodityPoolOperType.ADD);
            }
            this.uccCommodityLogMapper.batchInsert(uccCommodityLogPOS);
        }
        if (!CollectionUtils.isEmpty(uccCommodityPicPos)) {
            this.uccCommodityPicMapper.batchInsert(uccCommodityPicPos);
        }
        if (!CollectionUtils.isEmpty(uccCommodityPackagePos)) {
            this.uccCommodityPackageMapper.batchInsert(uccCommodityPackagePos);
        }
        if (!CollectionUtils.isEmpty(uccCommodityServicePOS)) {
            this.uccCommodityServiceMapper.insertBatch(uccCommodityServicePOS);
        }
        if (!CollectionUtils.isEmpty(uccCommodityServiceReturnPOS)) {
            this.uccCommodityServiceReturnMapper.insertBatch(uccCommodityServiceReturnPOS);
        }
        if (!CollectionUtils.isEmpty(uccCommodityDetailPOS)) {
            this.uccCommodityDetailMapper.insertBatch(uccCommodityDetailPOS);
        }
        if (!CollectionUtils.isEmpty(uccSkuPos)) {
            this.uccSkuMapper.insertBatch(uccSkuPos);
            ArrayList<UccSkuExpandPo> uccSkuExpandPos = new ArrayList<UccSkuExpandPo>();
            for (UccSkuPo uccSkuPo : uccSkuPos) {
                UccSkuExpandPo insertPO = (UccSkuExpandPo)JUtil.js((Object)uccSkuPo, UccSkuExpandPo.class);
                uccSkuExpandPos.add(insertPO);
            }
            this.uccSkuExpandMapper.insertBatch(uccSkuExpandPos);
        }
        if (!CollectionUtils.isEmpty(uccSkuPicPos)) {
            this.uccSkuPicMapper.batchInsert(uccSkuPicPos);
        }
        if (!CollectionUtils.isEmpty(uccSkuPricePos)) {
            this.uccSkuPriceMapper.batchInsert(uccSkuPricePos);
        }
        if (!CollectionUtils.isEmpty(uccSkuDetailPOS)) {
            this.uccSkuDetailMapper.insertBatch(uccSkuDetailPOS);
        }
        if (!CollectionUtils.isEmpty(uccLadderPricePOS)) {
            this.uccLadderPriceMapper.batchInsert(uccLadderPricePOS);
        }
        if (!CollectionUtils.isEmpty(uccSaleNumPos)) {
            this.uccSaleNumMapper.insertBatch(uccSaleNumPos);
        }
        if (!CollectionUtils.isEmpty(insertMeasurePos)) {
            this.uccCommodityMeasureMapper.batchInsertMeasure(insertMeasurePos);
        }
        if (!CollectionUtils.isEmpty(uccSkuPutCirPos)) {
            this.uccSkuPutCirMapper.batchInsert(uccSkuPutCirPos);
        }
    }

    private void createStock(List<SmcsdkStockNumInfoBO> smcsdkStockNumInfoBOS) {
        if (!CollectionUtils.isEmpty(smcsdkStockNumInfoBOS)) {
            SmcsdkOperateStockNumReqBO smcsdkOperateStockNumReqBO = new SmcsdkOperateStockNumReqBO();
            smcsdkOperateStockNumReqBO.setSmcsdkStockNumInfoBOs(smcsdkStockNumInfoBOS);
            smcsdkOperateStockNumReqBO.setOperateType("10");
            smcsdkOperateStockNumReqBO.setObjectId(Convert.toStr((Object)Sequence.getInstance().nextId()));
            smcsdkOperateStockNumReqBO.setObjectType("20");
            try {
                log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5165\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
                SmcsdkOperateStockNumRspBO smcsdkOperateStockNumRspBO = this.smcsdkOperateStockNumService.operateStockNum(smcsdkOperateStockNumReqBO);
                if (!"0000".equals(smcsdkOperateStockNumRspBO.getRespCode())) {
                    throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25\uff1a" + smcsdkOperateStockNumRspBO.getRespDesc());
                }
                log.info("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u51fa\u53c2" + JSONObject.toJSONString((Object)smcsdkOperateStockNumReqBO));
            }
            catch (Exception e) {
                log.error(e.getMessage());
                throw new ZTBusinessException("\u8c03\u7528\u5e93\u5b58\u7b80\u7248\u521b\u5efa\u5e93\u5b58\u5931\u8d25:" + e.getMessage());
            }
        }
    }

    private void createStockBO(List<SmcsdkStockNumInfoBO> smcsdkStockNumInfoBOS, UccAgrSkuMinimalismInfoBo uccAgrSkuMinimalismInfoBo, UccSkuPo uccSkuPo) {
        SmcsdkStockNumInfoBO smcsdkStockNumInfoBO = new SmcsdkStockNumInfoBO();
        smcsdkStockNumInfoBO.setOperateNum(Long.valueOf(MoneyUtils.yuanToHaoToLong(Convert.toBigDecimal((Object)uccAgrSkuMinimalismInfoBo.getBuyNumber()))));
        smcsdkStockNumInfoBO.setSkuId(Convert.toStr((Object)uccSkuPo.getSkuId()));
        smcsdkStockNumInfoBOS.add(smcsdkStockNumInfoBO);
    }

    private void createLadderPricePo(List<UccLadderPricePO> uccLadderPricePOS, UccAgrSkuMinimalismInfoBo uccAgrSkuMinimalismInfoBo, UccSkuPo uccSkuPo, UccSkuPricePo skuPricePo) {
        if (null != uccAgrSkuMinimalismInfoBo.getSwitchOn() && UccConstants.LadderSwitchOn.YES.equals(uccAgrSkuMinimalismInfoBo.getSwitchOn()) && !CollectionUtils.isEmpty(uccAgrSkuMinimalismInfoBo.getLadderPriceBOS())) {
            for (LadderPriceBO ladderPriceBO : uccAgrSkuMinimalismInfoBo.getLadderPriceBOS()) {
                UccLadderPricePO uccLadderPricePO = new UccLadderPricePO();
                uccLadderPricePO.setId(Sequence.getInstance().nextId());
                uccLadderPricePO.setSkuId(uccSkuPo.getSkuId());
                uccLadderPricePO.setSupplierShopId(uccSkuPo.getSupplierShopId());
                uccLadderPricePO.setStart(MoneyUtils.yuanToHaoToLong(ladderPriceBO.getStartPrice()));
                uccLadderPricePO.setStop(MoneyUtils.yuanToHaoToLong(ladderPriceBO.getStopPrice()));
                uccLadderPricePO.setPrice(MoneyUtils.yuanToHaoToLong(ladderPriceBO.getPrice()));
                uccLadderPricePO.setDiscount(ladderPriceBO.getDiscount());
                uccLadderPricePO.setSkuPriceId(skuPricePo.getSkuPriceId());
                uccLadderPricePOS.add(uccLadderPricePO);
            }
        }
    }

    private void createSkuDetailPo(List<UccSkuDetailPO> uccSkuDetailPOS, UccAgrSkuMinimalismInfoBo uccAgrSkuMinimalismInfoBo, UccSkuPo uccSkuPo) {
        UccSkuDetailPO uccSkuDetailPO = new UccSkuDetailPO();
        uccSkuDetailPO.setSkuId(uccSkuPo.getSkuId());
        uccSkuDetailPO.setCommodityId(uccSkuPo.getCommodityId());
        uccSkuDetailPO.setSupplierShopId(uccSkuPo.getSupplierShopId());
        uccSkuDetailPO.setSkuPcDetailUrl(uccAgrSkuMinimalismInfoBo.getCommodityPcDetailUrl());
        uccSkuDetailPO.setSkuPcDetailChar(uccAgrSkuMinimalismInfoBo.getCommodityPcDetailChar());
        uccSkuDetailPOS.add(uccSkuDetailPO);
    }

    private void createPutCirDetail(List<UccSkuPutCirPo> uccSkuPutCirPos, UccAgrSkuMinimalismInfoBo uccAgrSkuMinimalismInfoBo, UccSkuPo uccSkuPo) {
        if (uccAgrSkuMinimalismInfoBo.getOnShelveWay() != null) {
            UccSkuPutCirPo uccSkuPutCirPo = new UccSkuPutCirPo();
            uccSkuPutCirPo = new UccSkuPutCirPo();
            uccSkuPutCirPo.setSkuId(uccSkuPo.getSkuId());
            uccSkuPutCirPo.setSupplierShopId(uccAgrSkuMinimalismInfoBo.getSupplierShopId());
            uccSkuPutCirPo.setId(this.sequence.nextId());
            uccSkuPutCirPo.setState(1);
            if (0 == uccAgrSkuMinimalismInfoBo.getOnShelveWay()) {
                uccSkuPutCirPo.setUpType(1);
                uccSkuPutCirPo.setDownType(1);
            } else {
                uccSkuPutCirPo.setUpType(2);
                uccSkuPutCirPo.setDownType(2);
            }
            try {
                if (!StringUtils.isEmpty((Object)uccAgrSkuMinimalismInfoBo.getPreUpTime())) {
                    uccSkuPutCirPo.setPreUpTime(DateUtils.strToDate(uccAgrSkuMinimalismInfoBo.getPreUpTime()));
                }
                if (!StringUtils.isEmpty((Object)uccAgrSkuMinimalismInfoBo.getPreDownTime())) {
                    uccSkuPutCirPo.setPreDownTime(DateUtils.strToDate(uccAgrSkuMinimalismInfoBo.getPreDownTime()));
                }
            }
            catch (IllegalArgumentException e) {
                throw new ZTBusinessException(RspConstantEnums.TYPE_CONVERSION_FAILED.code() + e.getMessage());
            }
            uccSkuPutCirPos.add(uccSkuPutCirPo);
        }
    }

    private UccSkuPricePo createSkuPricePo(List<UccSkuPricePo> uccSkuPricePos, UccAgrSkuMinimalismCreateAtomReqBo reqBo, Date now, UccAgrSkuMinimalismInfoBo uccAgrSkuMinimalismInfoBo, UccSkuPo uccSkuPo) {
        UccSkuPricePo uccSkuPricePo = new UccSkuPricePo();
        uccSkuPricePo.setSkuPriceId(Sequence.getInstance().nextId());
        uccSkuPricePo.setSkuId(uccSkuPo.getSkuId());
        uccSkuPricePo.setSupplierShopId(uccSkuPo.getSupplierShopId());
        if (ObjectUtil.isNotEmpty((Object)uccAgrSkuMinimalismInfoBo.getMarketPrice())) {
            uccSkuPricePo.setMarketPrice(MoneyUtils.yuanToHaoToLong(uccAgrSkuMinimalismInfoBo.getMarketPrice()));
        }
        if (ObjectUtil.isNotEmpty((Object)uccAgrSkuMinimalismInfoBo.getAgreementPrice())) {
            uccSkuPricePo.setAgreementPrice(MoneyUtils.yuanToHaoToLong(uccAgrSkuMinimalismInfoBo.getAgreementPrice()));
        }
        if (ObjectUtil.isNotEmpty((Object)uccAgrSkuMinimalismInfoBo.getSalePrice())) {
            uccSkuPricePo.setSalePrice(MoneyUtils.yuanToHaoToLong(uccAgrSkuMinimalismInfoBo.getSalePrice()));
        }
        uccSkuPricePo.setSupplierShopId(uccSkuPo.getSupplierShopId());
        uccSkuPricePo.setCurrencyType(0);
        uccSkuPricePo.setSwitchOn(uccAgrSkuMinimalismInfoBo.getSwitchOn());
        uccSkuPricePo.setCreateOperId(Convert.toStr((Object)reqBo.getUserId()));
        uccSkuPricePo.setCreateTime(now);
        uccSkuPricePos.add(uccSkuPricePo);
        return uccSkuPricePo;
    }

    private void createCommodityDetailPo(List<UccCommodityDetailPO> uccCommodityDetailPOS, UccAgrSkuMinimalismInfoBo uccAgrSkuMinimalismInfoBo, UccCommodityPo uccCommodityPo) {
        UccCommodityDetailPO uccCommodityDetailPO = new UccCommodityDetailPO();
        uccCommodityDetailPO.setCommodityId(uccCommodityPo.getCommodityId());
        uccCommodityDetailPO.setSupplierShopId(uccCommodityPo.getSupplierShopId());
        uccCommodityDetailPO.setCommodityPcDetailUrl(uccAgrSkuMinimalismInfoBo.getCommodityPcDetailUrl());
        uccCommodityDetailPO.setCommodityPcDetailChar(uccAgrSkuMinimalismInfoBo.getCommodityPcDetailChar());
        uccCommodityDetailPOS.add(uccCommodityDetailPO);
    }

    private void createCommodityServiceReturnPo(List<UccCommodityServiceReturnPO> uccCommodityServiceReturnPOS, UccAgrSkuMinimalismInfoBo uccAgrSkuMinimalismInfoBo, UccCommodityPo uccCommodityPo) {
        if (!CollectionUtils.isEmpty(uccAgrSkuMinimalismInfoBo.getReturnType())) {
            for (Integer returnType : uccAgrSkuMinimalismInfoBo.getReturnType()) {
                UccCommodityServiceReturnPO uccCommodityServiceReturnPO = new UccCommodityServiceReturnPO();
                uccCommodityServiceReturnPO.setServiceId(Sequence.getInstance().nextId());
                uccCommodityServiceReturnPO.setSupplierShopId(uccCommodityPo.getSupplierShopId());
                uccCommodityServiceReturnPO.setCommodityId(uccCommodityPo.getCommodityId());
                uccCommodityServiceReturnPO.setReturnType(returnType);
                uccCommodityServiceReturnPOS.add(uccCommodityServiceReturnPO);
            }
        }
    }

    private void createCommodityServicePo(List<UccCommodityServicePO> uccCommodityServicePOS, UccAgrSkuMinimalismCreateAtomReqBo reqBo, Date now, UccAgrSkuMinimalismInfoBo uccAgrSkuMinimalismInfoBo, UccCommodityPo uccCommodityPo) {
        UccCommodityServicePO uccCommodityServicePO = new UccCommodityServicePO();
        uccCommodityServicePO.setServiceId(Sequence.getInstance().nextId());
        uccCommodityServicePO.setSupplierShopId(uccCommodityPo.getSupplierShopId());
        uccCommodityServicePO.setCommodityId(uccCommodityPo.getCommodityId());
        uccCommodityServicePO.setRejectAllow(uccAgrSkuMinimalismInfoBo.getRejectAllow());
        uccCommodityServicePO.setRejectAllowDate(uccAgrSkuMinimalismInfoBo.getRejectAllowDate());
        uccCommodityServicePO.setExchangeAllow(uccAgrSkuMinimalismInfoBo.getExchangeAllow());
        uccCommodityServicePO.setExchangeAllowDate(uccAgrSkuMinimalismInfoBo.getExchangeAllowDate());
        uccCommodityServicePO.setMaintainAllow(uccAgrSkuMinimalismInfoBo.getMaintainAllow());
        uccCommodityServicePO.setMaintainAllowDate(uccAgrSkuMinimalismInfoBo.getMaintainAllowDate());
        uccCommodityServicePO.setCreateOperId(Convert.toStr((Object)reqBo.getUserId()));
        uccCommodityServicePO.setCreateTime(now);
        uccCommodityServicePOS.add(uccCommodityServicePO);
    }

    private void createCommodityPackagePo(List<UccCommodityPackagePo> uccCommodityPackagePos, UccAgrSkuMinimalismCreateAtomReqBo reqBo, Date now, UccAgrSkuMinimalismInfoBo uccAgrSkuMinimalismInfoBo, UccCommodityPo uccCommodityPo) {
        UccCommodityPackagePo uccCommodityPackagePo = new UccCommodityPackagePo();
        uccCommodityPackagePo.setPackageId(Sequence.getInstance().nextId());
        uccCommodityPackagePo.setCommodityId(uccCommodityPo.getCommodityId());
        uccCommodityPackagePo.setSupplierShopId(uccCommodityPo.getSupplierShopId());
        uccCommodityPackagePo.setPackParam(uccAgrSkuMinimalismInfoBo.getPackParam());
        uccCommodityPackagePo.setAfterService(uccAgrSkuMinimalismInfoBo.getAfterService());
        uccCommodityPackagePo.setInvoiceType(1);
        uccCommodityPackagePo.setCreateOperId(Convert.toStr((Object)reqBo.getUserId()));
        uccCommodityPackagePo.setCreateTime(now);
        uccCommodityPackagePos.add(uccCommodityPackagePo);
    }

    private void createCommodityPicPo(List<UccCommodityPicPo> uccCommodityPicPos, UccAgrSkuMinimalismCreateAtomReqBo reqBo, Date now, UccAgrSkuMinimalismInfoBo uccAgrSkuMinimalismInfoBo, UccCommodityPo uccCommodityPo) {
        if (!CollectionUtils.isEmpty(uccAgrSkuMinimalismInfoBo.getCommodityPics())) {
            for (int i = 0; i < uccAgrSkuMinimalismInfoBo.getCommodityPics().size(); ++i) {
                UccCommodityPicPo uccCommodityPicPo = new UccCommodityPicPo();
                if (i == 0) {
                    uccCommodityPicPo.setCommodityPicType(UccConstants.CommodityPicType.MAIN);
                } else {
                    uccCommodityPicPo.setCommodityPicType(UccConstants.CommodityPicType.DETAIL);
                }
                uccCommodityPicPo.setCommodityPicId(Sequence.getInstance().nextId());
                uccCommodityPicPo.setSupplierShopId(uccCommodityPo.getSupplierShopId());
                uccCommodityPicPo.setCommodityId(uccCommodityPo.getCommodityId());
                uccCommodityPicPo.setCommodityPicUrl(uccAgrSkuMinimalismInfoBo.getCommodityPics().get(i));
                uccCommodityPicPo.setPicOrder(i);
                uccCommodityPicPo.setCreateOperId(Convert.toStr((Object)reqBo.getUserId()));
                uccCommodityPicPo.setCreateTime(now);
                uccCommodityPicPos.add(uccCommodityPicPo);
            }
        }
    }

    private void createSkuPicPo(List<UccSkuPicPo> uccSkuPicPos, UccAgrSkuMinimalismCreateAtomReqBo reqBo, Date now, UccAgrSkuMinimalismInfoBo uccAgrSkuMinimalismInfoBo, UccSkuPo uccSkuPo) {
        if (!CollectionUtils.isEmpty(uccAgrSkuMinimalismInfoBo.getCommodityPics())) {
            for (int i = 0; i < uccAgrSkuMinimalismInfoBo.getCommodityPics().size(); ++i) {
                UccSkuPicPo uccSkuPicPo = new UccSkuPicPo();
                if (i == 0) {
                    uccSkuPicPo.setCommodityPicType(UccConstants.CommodityPicType.MAIN);
                } else {
                    uccSkuPicPo.setCommodityPicType(UccConstants.CommodityPicType.DETAIL);
                }
                uccSkuPicPo.setSkuPicId(Sequence.getInstance().nextId());
                uccSkuPicPo.setSupplierShopId(uccSkuPo.getSupplierShopId());
                uccSkuPicPo.setSkuId(uccSkuPo.getSkuId());
                uccSkuPicPo.setSkuPicUrl(uccAgrSkuMinimalismInfoBo.getCommodityPics().get(i));
                uccSkuPicPo.setPicOrder(i);
                uccSkuPicPo.setCreateOperId(Convert.toStr((Object)reqBo.getUserId()));
                uccSkuPicPo.setCreateTime(now);
                uccSkuPicPos.add(uccSkuPicPo);
            }
        }
    }

    private UccSkuPo createSkuPo(List<UccSkuPo> uccSkuPos, UccAgrSkuMinimalismInfoBo uccAgrSkuMinimalismInfoBo, Date now, UccCommodityPo uccCommodityPo) {
        UccSkuPo uccSkuPo = new UccSkuPo();
        uccSkuPo.setSupplierType(uccAgrSkuMinimalismInfoBo.getSupplierType());
        if (null == uccAgrSkuMinimalismInfoBo.getSupplierType()) {
            uccSkuPo.setSupplierType(UccConstants.SUPPLIER_TYPE.ORG_PUR_ZONE);
        }
        uccSkuPo.setSkuId(Sequence.getInstance().nextId());
        uccSkuPo.setCommodityId(uccCommodityPo.getCommodityId());
        uccSkuPo.setSupplierShopId(uccCommodityPo.getSupplierShopId());
        uccSkuPo.setShopName(uccCommodityPo.getShopName());
        uccSkuPo.setCommodityTypeId(uccCommodityPo.getCommodityTypeId());
        uccSkuPo.setSkuPrice(MoneyUtils.yuanToHaoToLong(uccAgrSkuMinimalismInfoBo.getSalePrice()));
        uccSkuPo.setSkuCode(uccAgrSkuMinimalismInfoBo.getSkuCode());
        uccSkuPo.setSkuSource(uccCommodityPo.getCommoditySource());
        uccSkuPo.setSkuName(uccAgrSkuMinimalismInfoBo.getSkuName());
        uccSkuPo.setSkuStatus(uccAgrSkuMinimalismInfoBo.getSkuStatus());
        uccSkuPo.setOnShelveTime(uccAgrSkuMinimalismInfoBo.getOnShelveTime());
        if (null == uccAgrSkuMinimalismInfoBo.getSkuStatus() && uccAgrSkuMinimalismInfoBo.getOnShelveWay() != null) {
            if (uccAgrSkuMinimalismInfoBo.getOnShelveWay() == 0) {
                uccSkuPo.setSkuStatus(SkuStatusConstants.SKU_STATUS_WAIT_SHELF);
            }
            if (uccAgrSkuMinimalismInfoBo.getOnShelveWay() == 1) {
                uccSkuPo.setSkuStatus(SkuStatusConstants.SKU_STATUS_ON_SHELF);
                uccSkuPo.setOnShelveTime(new Date());
            }
        }
        uccSkuPo.setPreDeliverDay(uccAgrSkuMinimalismInfoBo.getPreDeliverDay());
        uccSkuPo.setBrandId(uccCommodityPo.getBrandId());
        uccSkuPo.setBrandName(uccCommodityPo.getBrandName());
        uccSkuPo.setAgreementId(uccAgrSkuMinimalismInfoBo.getAgreementId());
        uccSkuPo.setAgreementDetailsId(uccAgrSkuMinimalismInfoBo.getAgreementDetailsId());
        uccSkuPo.setMeasureId(uccAgrSkuMinimalismInfoBo.getMeasureId());
        uccSkuPo.setMeasureName(uccAgrSkuMinimalismInfoBo.getMeasureName());
        uccSkuPo.setMoq(uccAgrSkuMinimalismInfoBo.getMoq());
        uccSkuPo.setMfgsku(uccAgrSkuMinimalismInfoBo.getMfgsku());
        uccSkuPo.setMaterialId(uccAgrSkuMinimalismInfoBo.getMaterialId());
        uccSkuPo.setModel(uccAgrSkuMinimalismInfoBo.getModel());
        uccSkuPo.setSpec(uccAgrSkuMinimalismInfoBo.getSpec());
        uccSkuPo.setMaterialName(uccAgrSkuMinimalismInfoBo.getMaterialName());
        uccSkuPo.setSalesUnitId(uccAgrSkuMinimalismInfoBo.getSalesUnitId());
        uccSkuPo.setSalesUnitName(uccAgrSkuMinimalismInfoBo.getSalesUnitName());
        uccSkuPo.setSalesUnitRate(uccAgrSkuMinimalismInfoBo.getSalesUnitRate());
        uccSkuPo.setSettlementUnit(uccAgrSkuMinimalismInfoBo.getSettlementUnit());
        uccSkuPo.setPackageSpec(uccAgrSkuMinimalismInfoBo.getPackageSpec());
        uccSkuPo.setApprovalStatus(Convert.toStr((Object)uccAgrSkuMinimalismInfoBo.getSkuApprovalStatus()));
        uccSkuPo.setOrgId(Convert.toLong((Object)uccCommodityPo.getOrgId()));
        uccSkuPo.setOrgName(uccCommodityPo.getOrgName());
        uccSkuPo.setCreateOperId(uccCommodityPo.getCreateOperId());
        uccSkuPo.setCreateOperName(uccCommodityPo.getCreateOperName());
        uccSkuPo.setCreateTime(now);
        uccSkuPo.setMinimalismFlag(UccConstants.MinimalismFlag.YES);
        uccSkuPo.setSkuType(ModelRuleConstant.SKU_TYPE_NORMAL);
        uccSkuPo.setCreateType(0);
        uccSkuPo.setRelStatus(0);
        uccSkuPo.setProcessingSteps(0);
        uccSkuPo.setPricePassFlag(1);
        uccSkuPo.setStdSkuCode("0");
        uccSkuPo.setIsAddCoefficient(0);
        uccSkuPo.setOnShelveWay(uccAgrSkuMinimalismInfoBo.getOnShelveWay());
        uccSkuPo.setSettlementUnitId(uccAgrSkuMinimalismInfoBo.getSettlementUnitId());
        uccSkuPo.setMallShowFlag(1);
        uccSkuPo.setAgrType(uccAgrSkuMinimalismInfoBo.getAgrType());
        uccSkuPo.setLineNo(uccAgrSkuMinimalismInfoBo.getLineNo());
        uccSkuPo.setCommodityType(uccAgrSkuMinimalismInfoBo.getCommodityType());
        uccSkuPos.add(uccSkuPo);
        return uccSkuPo;
    }

    private UccCommodityPo createSpuPo(List<UccCommodityPo> uccCommodityPos, UccAgrSkuMinimalismCreateAtomReqBo reqBo, Date now, UccAgrSkuMinimalismInfoBo uccAgrSkuMinimalismInfoBo) {
        UccCommodityPo uccCommodityPo = new UccCommodityPo();
        uccCommodityPo.setCommodityId(Sequence.getInstance().nextId());
        uccCommodityPo.setCommodityCode(uccAgrSkuMinimalismInfoBo.getCommodityCode());
        uccCommodityPo.setCommodityName(uccAgrSkuMinimalismInfoBo.getSkuName());
        uccCommodityPo.setCommodityTypeId(uccAgrSkuMinimalismInfoBo.getCommodityTypeId());
        if (null == uccAgrSkuMinimalismInfoBo.getSkuSource()) {
            uccCommodityPo.setCommoditySource(UccConstants.CommoditySource.AGR);
        } else {
            uccCommodityPo.setCommoditySource(UccConstants.CommoditySource.UN_AGR);
        }
        uccCommodityPo.setCommodityStatus(uccAgrSkuMinimalismInfoBo.getCommodityStatus());
        if (null == uccAgrSkuMinimalismInfoBo.getCommodityStatus() && uccAgrSkuMinimalismInfoBo.getOnShelveWay() != null) {
            if (uccAgrSkuMinimalismInfoBo.getOnShelveWay() == 0) {
                uccCommodityPo.setCommodityStatus(CommodityStatusConstants.COMMD_STATUS_WAIT_SHELF);
            }
            if (uccAgrSkuMinimalismInfoBo.getOnShelveWay() == 1) {
                uccCommodityPo.setCommodityStatus(CommodityStatusConstants.COMMD_STATUS_ON_SHELF);
            }
        }
        uccCommodityPo.setSupplierShopId(uccAgrSkuMinimalismInfoBo.getSupplierShopId());
        uccCommodityPo.setShopName(uccAgrSkuMinimalismInfoBo.getShopName());
        uccCommodityPo.setBrandId(uccAgrSkuMinimalismInfoBo.getBrandId());
        uccCommodityPo.setBrandName(uccAgrSkuMinimalismInfoBo.getBrandName());
        uccCommodityPo.setAgreementDetailsId(Convert.toStr((Object)uccAgrSkuMinimalismInfoBo.getAgreementDetailsId()));
        uccCommodityPo.setAgreementId(Convert.toStr((Object)uccAgrSkuMinimalismInfoBo.getAgreementId()));
        uccCommodityPo.setStoreGetType(UccConstants.StoreGetType.OWN);
        uccCommodityPo.setCreateOperId(Convert.toStr((Object)reqBo.getUserId()));
        uccCommodityPo.setCreateOperName(reqBo.getName());
        uccCommodityPo.setCreateTime(now);
        uccCommodityPo.setApprovalStatus(uccAgrSkuMinimalismInfoBo.getSpuApprovalStatus());
        uccCommodityPo.setVendorId(uccAgrSkuMinimalismInfoBo.getVendorId());
        uccCommodityPo.setVendorShopId(uccAgrSkuMinimalismInfoBo.getVendorShopId());
        uccCommodityPo.setTaxCatCode(uccAgrSkuMinimalismInfoBo.getTaxCatCode());
        uccCommodityPo.setRate(uccAgrSkuMinimalismInfoBo.getRate());
        uccCommodityPo.setOtherSourceId(uccAgrSkuMinimalismInfoBo.getOtherSourceId());
        uccCommodityPo.setOtherSourceCode(uccAgrSkuMinimalismInfoBo.getOtherSourceCode());
        uccCommodityPo.setOtherSourceName(uccAgrSkuMinimalismInfoBo.getOtherSourceName());
        uccCommodityPo.setOrgId(uccAgrSkuMinimalismInfoBo.getOrgId());
        uccCommodityPo.setOrgName(uccAgrSkuMinimalismInfoBo.getOrgName());
        uccCommodityPo.setViewOrder(0);
        uccCommodityPo.setFreeShipping(0);
        uccCommodityPo.setOnShelveTime(uccAgrSkuMinimalismInfoBo.getOnShelveTime());
        uccCommodityPo.setOnShelveWay(uccAgrSkuMinimalismInfoBo.getOnShelveWay());
        uccCommodityPos.add(uccCommodityPo);
        return uccCommodityPo;
    }
}

