/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.atom.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.base.bo.UccDealPoolSyncESAtomReqBo;
import com.tydic.commodity.base.bo.UccDealPoolSyncESAtomRspBo;
import com.tydic.commodity.base.constant.SkuPoolRelTypeConstant;
import com.tydic.commodity.busibase.atom.api.UccDealPoolSyncESAtomService;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.UccChannelMapper;
import com.tydic.commodity.dao.UccCommodityPoolRangeMapper;
import com.tydic.commodity.dao.UccDicDictionaryMapper;
import com.tydic.commodity.dao.UccGuideCatalogExtMapper;
import com.tydic.commodity.dao.UccOrgSkuWhiteRestrictionMapper;
import com.tydic.commodity.dao.UccRelChannelPoolMapper;
import com.tydic.commodity.dao.UccRelPoolCommodityMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.po.ChannelPoolQryBo;
import com.tydic.commodity.po.CnncUccSkuPo;
import com.tydic.commodity.po.UccCommodityPoolRangePO;
import com.tydic.commodity.po.UccLabelPo;
import com.tydic.commodity.po.UccOrgSkuWhiteRestrictionPo;
import com.tydic.commodity.po.UccRelChannelPoolPo;
import com.tydic.commodity.po.UccRelPoolCommodityPo;
import com.tydic.dyc.base.utils.JUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class UccDealPoolSyncESAtomServiceImpl
implements UccDealPoolSyncESAtomService {
    private static final Logger log = LoggerFactory.getLogger(UccDealPoolSyncESAtomServiceImpl.class);
    private static final int pageSize = 10000;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccChannelMapper uccChannelMapper;
    @Autowired
    private UccRelPoolCommodityMapper uccRelPoolCommodityMapper;
    @Autowired
    private UccRelChannelPoolMapper uccRelChannelPoolMapper;
    @Autowired
    private UccGuideCatalogExtMapper uccGuideCatalogExtMapper;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private UccOrgSkuWhiteRestrictionMapper uccOrgSkuWhiteRestrictionMapper;
    @Autowired
    private UccCommodityPoolRangeMapper uccCommodityPoolRangeMapper;
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private UccDicDictionaryMapper uccDicDictionaryMapper;

    @Override
    public UccDealPoolSyncESAtomRspBo dealPoolSyncES(UccDealPoolSyncESAtomReqBo reqBo) {
        UccDealPoolSyncESAtomRspBo rspBo = new UccDealPoolSyncESAtomRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        switch (reqBo.getSyncType()) {
            case 0: {
                this.dealSkuIds(reqBo.getSkuIds());
                break;
            }
            case 1: {
                this.dealList(reqBo.getVendorIds(), null, null, null);
                break;
            }
            case 2: {
                this.dealList(null, null, reqBo.getTypeIds(), null);
                break;
            }
            case 3: {
                this.dealList(null, reqBo.getAgrIds(), null, null);
                break;
            }
            case 4: {
                this.dealByPoolIds(reqBo.getPoolIds());
                break;
            }
            case 5: {
                List<Long> typeIds = this.uccGuideCatalogExtMapper.getTypeIdByCat(reqBo.getGuideCatalogIds());
                this.dealList(null, null, typeIds, null);
                break;
            }
            case 6: {
                this.dealSpuIds(reqBo.getSpuIds());
            }
        }
        return rspBo;
    }

    private void dealList(List<Long> vendorIds, List<Long> argIds, List<Long> typeIds, List<Long> spus) {
        List<Long> skuList = this.uccSkuMapper.batchQrySkuList(vendorIds, argIds, typeIds, spus, 0, 0, new Page(-1, 10000));
        if (!CollectionUtils.isEmpty(skuList)) {
            this.dealSkuIds(skuList);
        }
    }

    private void dealSkuIds(List<Long> skuIds) {
        if (CollectionUtils.isEmpty(skuIds)) {
            return;
        }
        List<CnncUccSkuPo> uccSkuPos1 = this.uccSkuMapper.batchQrySkuForskuPool(null, skuIds);
        if (!CollectionUtils.isEmpty(uccSkuPos1)) {
            this.syncSkuPoolToES(uccSkuPos1);
            this.dealChannel2(uccSkuPos1);
            for (CnncUccSkuPo uccSkuPo : uccSkuPos1) {
                JSONObject object = new JSONObject();
                object.put("skuPoolIds", uccSkuPo.getSkuPoolIds());
                object.put("channel_Name", uccSkuPo.getChannelNames());
                object.put("channel_id", uccSkuPo.getChannelIds());
                object.put("labelNames", uccSkuPo.getLabelNames());
                object.put("labelIds", uccSkuPo.getLabelIds());
                object.put("showLabelNames", uccSkuPo.getShowLabelNames());
                object.put("showLabelIds", uccSkuPo.getShowLabelIds());
                object.put("labels", uccSkuPo.getLabels());
                this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), uccSkuPo.getSkuId().toString(), object);
            }
            log.info("\u540c\u6b65\u5546\u54c1\u6c60\u7ed3\u675f\uff01");
        }
    }

    private void dealSpuIds(List<Long> spuIds) {
        if (CollectionUtils.isEmpty(spuIds)) {
            return;
        }
        List<CnncUccSkuPo> uccSkuPos1 = this.uccSkuMapper.batchQrySkuForPoolBySpu(null, spuIds);
        if (!CollectionUtils.isEmpty(uccSkuPos1)) {
            this.syncSkuPoolToES(uccSkuPos1);
            this.dealChannel2(uccSkuPos1);
            for (CnncUccSkuPo uccSkuPo : uccSkuPos1) {
                JSONObject object = new JSONObject();
                object.put("skuPoolIds", uccSkuPo.getSkuPoolIds());
                object.put("channel_Name", uccSkuPo.getChannelNames());
                object.put("channel_id", uccSkuPo.getChannelIds());
                object.put("labelNames", uccSkuPo.getLabelNames());
                object.put("labelIds", uccSkuPo.getLabelIds());
                object.put("showLabelNames", uccSkuPo.getShowLabelNames());
                object.put("showLabelIds", uccSkuPo.getShowLabelIds());
                object.put("labels", uccSkuPo.getLabels());
                this.elasticsearchUtil.updateData(this.esConfig.getIndexName(), this.esConfig.getEsType(), uccSkuPo.getSkuId().toString(), object);
            }
            log.info("\u540c\u6b65\u5546\u54c1\u6c60\u7ed3\u675f\uff01");
        }
    }

    private void syncSkuPoolToES(List<CnncUccSkuPo> uccSkuPos) {
        ArrayList<Long> skuIds = new ArrayList<Long>();
        ArrayList<Long> agrIds = new ArrayList<Long>();
        ArrayList<Long> vendorIds = new ArrayList<Long>();
        ArrayList<Long> typeIds = new ArrayList<Long>();
        ArrayList<Long> spuIds = new ArrayList<Long>();
        uccSkuPos.forEach(each -> {
            if (!skuIds.contains(each.getSkuId())) {
                skuIds.add(each.getSkuId());
            }
            if (!agrIds.contains(each.getAgreementId())) {
                agrIds.add(each.getAgreementId());
            }
            if (!vendorIds.contains(each.getVendorId())) {
                vendorIds.add(each.getVendorId());
            }
            if (!typeIds.contains(each.getCommodityTypeId())) {
                typeIds.add(each.getCommodityTypeId());
            }
            if (!spuIds.contains(each.getCommodityId())) {
                spuIds.add(each.getCommodityId());
            }
        });
        List<Object> uccRelPoolCommodityPosBySku = new ArrayList();
        List<Object> uccRelPoolCommodityPosByType = new ArrayList();
        List<Object> uccRelPoolCommodityPosByVendor = new ArrayList();
        List<Object> uccRelPoolCommodityPosByAgr = new ArrayList();
        List<Object> uccRelPoolCommodityPosByspu = new ArrayList();
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(skuIds)) {
            uccRelPoolCommodityPosBySku = this.uccRelPoolCommodityMapper.queryPoolsAndChannels(skuIds, SkuPoolRelTypeConstant.REL_BY_SKU);
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(typeIds)) {
            uccRelPoolCommodityPosByType = this.uccRelPoolCommodityMapper.queryPoolsAndChannels(typeIds, SkuPoolRelTypeConstant.REL_BY_COMMODITY_TYPE);
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(vendorIds)) {
            uccRelPoolCommodityPosByVendor = this.uccRelPoolCommodityMapper.queryPoolsAndChannels(vendorIds, SkuPoolRelTypeConstant.REL_BY_VENDOR);
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(agrIds)) {
            uccRelPoolCommodityPosByAgr = this.uccRelPoolCommodityMapper.queryPoolsAndChannels(agrIds, SkuPoolRelTypeConstant.REL_BY_AGR);
        }
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(spuIds)) {
            uccRelPoolCommodityPosByspu = this.uccRelPoolCommodityMapper.queryPoolsAndChannels(spuIds, SkuPoolRelTypeConstant.REL_BY_SPU);
        }
        List<UccOrgSkuWhiteRestrictionPo> restrictionPoList = this.uccOrgSkuWhiteRestrictionMapper.batchQueryOrgWhiteWithAgr(skuIds, agrIds, null, 1);
        Map<Long, List<UccOrgSkuWhiteRestrictionPo>> agrWhitePOMap = restrictionPoList.stream().filter(a -> a.getSkuId() != null).collect(Collectors.groupingBy(UccOrgSkuWhiteRestrictionPo::getSkuId));
        ArrayList<Long> poolIds = new ArrayList();
        poolIds.addAll(uccRelPoolCommodityPosBySku.stream().map(ChannelPoolQryBo::getPoolId).collect(Collectors.toList()));
        poolIds.addAll(uccRelPoolCommodityPosByType.stream().map(ChannelPoolQryBo::getPoolId).collect(Collectors.toList()));
        poolIds.addAll(uccRelPoolCommodityPosByVendor.stream().map(ChannelPoolQryBo::getPoolId).collect(Collectors.toList()));
        poolIds.addAll(uccRelPoolCommodityPosByAgr.stream().map(ChannelPoolQryBo::getPoolId).collect(Collectors.toList()));
        poolIds.addAll(uccRelPoolCommodityPosByspu.stream().map(ChannelPoolQryBo::getPoolId).collect(Collectors.toList()));
        poolIds = poolIds.stream().distinct().collect(Collectors.toList());
        UccCommodityPoolRangePO uccCommodityPoolRangePO = new UccCommodityPoolRangePO();
        uccCommodityPoolRangePO.setPoolIds(poolIds);
        List<UccCommodityPoolRangePO> poolRangePOS = this.uccCommodityPoolRangeMapper.getList(uccCommodityPoolRangePO);
        Map<Long, List<UccCommodityPoolRangePO>> poolRangePOMap = poolRangePOS.stream().collect(Collectors.groupingBy(UccCommodityPoolRangePO::getPoolId));
        for (CnncUccSkuPo uccSkuPo : uccSkuPos) {
            UccLabelPo uccLabelPo;
            List labelIds;
            UccLabelPo uccLabelPo2;
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(uccRelPoolCommodityPosBySku)) {
                for (ChannelPoolQryBo channelPoolQryBo : uccRelPoolCommodityPosBySku) {
                    if (!channelPoolQryBo.getSource().equals(uccSkuPo.getSkuId())) continue;
                    if (org.apache.commons.collections.CollectionUtils.isEmpty(uccSkuPo.getSkuPoolIds())) {
                        uccSkuPo.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getPoolId()}));
                        if (channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getPoolState() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                            uccSkuPo.setChannelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getChannelId()}));
                            uccSkuPo.setChannelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getChannelName()}));
                        }
                        if (channelPoolQryBo.getLabelId() == null) continue;
                        uccSkuPo.setLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        if (channelPoolQryBo.getIsShow() != null && channelPoolQryBo.getIsShow() == 1) {
                            uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                            uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        }
                        uccLabelPo2 = new UccLabelPo();
                        uccLabelPo2.setLabelId(channelPoolQryBo.getLabelId());
                        uccLabelPo2.setLabelName(channelPoolQryBo.getLabelName());
                        uccLabelPo2.setIsShow(channelPoolQryBo.getIsShow());
                        uccLabelPo2.setLabelCode(channelPoolQryBo.getLabelCode());
                        uccLabelPo2.setLabelColor(channelPoolQryBo.getLabelColor());
                        uccLabelPo2.setLabelShortName(channelPoolQryBo.getLabelShortName());
                        uccLabelPo2.setLabelType(channelPoolQryBo.getLabelType());
                        uccLabelPo2.setPoolId(channelPoolQryBo.getPoolId());
                        uccSkuPo.setLabels(Lists.newArrayList((Object[])new UccLabelPo[]{uccLabelPo2}));
                        continue;
                    }
                    if (!uccSkuPo.getSkuPoolIds().contains(channelPoolQryBo.getPoolId())) {
                        uccSkuPo.getSkuPoolIds().add(channelPoolQryBo.getPoolId());
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getChannelIds()) && channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getPoolState() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                        uccSkuPo.setChannelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getChannelId()}));
                        uccSkuPo.setChannelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getChannelName()}));
                    } else if (!CollectionUtils.isEmpty(uccSkuPo.getChannelIds()) && !uccSkuPo.getChannelIds().contains(channelPoolQryBo.getChannelId()) && channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getPoolState() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                        uccSkuPo.getChannelIds().add(channelPoolQryBo.getChannelId());
                        uccSkuPo.getChannelNames().add(channelPoolQryBo.getChannelName());
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getLabelIds()) && channelPoolQryBo.getLabelId() != null) {
                        uccSkuPo.setLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        if (channelPoolQryBo.getIsShow() != null && channelPoolQryBo.getIsShow() == 1) {
                            uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                            uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        }
                    } else if (channelPoolQryBo.getLabelId() != null && !CollectionUtils.isEmpty(uccSkuPo.getLabelIds()) && !uccSkuPo.getLabelIds().contains(channelPoolQryBo.getLabelId())) {
                        uccSkuPo.getLabelIds().add(channelPoolQryBo.getLabelId());
                        uccSkuPo.getLabelNames().add(channelPoolQryBo.getLabelName());
                        if (channelPoolQryBo.getIsShow() != null && channelPoolQryBo.getIsShow() == 1) {
                            if (CollectionUtils.isEmpty(uccSkuPo.getShowLabelIds())) {
                                uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                                uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                            } else {
                                uccSkuPo.getShowLabelIds().add(channelPoolQryBo.getLabelId());
                                uccSkuPo.getShowLabelNames().add(channelPoolQryBo.getLabelName());
                            }
                        }
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getLabels())) {
                        if (null == channelPoolQryBo.getLabelId()) continue;
                        UccLabelPo uccLabelPo22 = new UccLabelPo();
                        uccLabelPo22.setLabelId(channelPoolQryBo.getLabelId());
                        uccLabelPo22.setLabelName(channelPoolQryBo.getLabelName());
                        uccLabelPo22.setIsShow(channelPoolQryBo.getIsShow());
                        uccLabelPo22.setLabelCode(channelPoolQryBo.getLabelCode());
                        uccLabelPo22.setLabelColor(channelPoolQryBo.getLabelColor());
                        uccLabelPo22.setLabelShortName(channelPoolQryBo.getLabelShortName());
                        uccLabelPo22.setLabelType(channelPoolQryBo.getLabelType());
                        uccLabelPo22.setPoolId(channelPoolQryBo.getPoolId());
                        uccSkuPo.setLabels(Lists.newArrayList((Object[])new UccLabelPo[]{uccLabelPo22}));
                        continue;
                    }
                    labelIds = uccSkuPo.getLabels().stream().map(UccLabelPo::getLabelId).collect(Collectors.toList());
                    if (channelPoolQryBo.getLabelId() == null || CollectionUtils.isEmpty(uccSkuPo.getLabels()) || labelIds.contains(channelPoolQryBo.getLabelId())) continue;
                    uccLabelPo = new UccLabelPo();
                    uccLabelPo.setLabelId(channelPoolQryBo.getLabelId());
                    uccLabelPo.setLabelName(channelPoolQryBo.getLabelName());
                    uccLabelPo.setIsShow(channelPoolQryBo.getIsShow());
                    uccLabelPo.setLabelCode(channelPoolQryBo.getLabelCode());
                    uccLabelPo.setLabelColor(channelPoolQryBo.getLabelColor());
                    uccLabelPo.setLabelShortName(channelPoolQryBo.getLabelShortName());
                    uccLabelPo.setLabelType(channelPoolQryBo.getLabelType());
                    uccLabelPo.setPoolId(channelPoolQryBo.getPoolId());
                    uccSkuPo.getLabels().add(uccLabelPo);
                }
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(uccRelPoolCommodityPosByType)) {
                for (ChannelPoolQryBo channelPoolQryBo : uccRelPoolCommodityPosByType) {
                    if (!channelPoolQryBo.getSource().equals(uccSkuPo.getCommodityTypeId())) continue;
                    if (org.apache.commons.collections.CollectionUtils.isEmpty(uccSkuPo.getSkuPoolIds())) {
                        uccSkuPo.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getPoolId()}));
                        if (channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getPoolState() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                            uccSkuPo.setChannelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getChannelId()}));
                            uccSkuPo.setChannelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getChannelName()}));
                        }
                        if (channelPoolQryBo.getLabelId() == null) continue;
                        uccSkuPo.setLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        if (channelPoolQryBo.getIsShow() != null && channelPoolQryBo.getIsShow() == 1) {
                            uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                            uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        }
                        uccLabelPo2 = new UccLabelPo();
                        uccLabelPo2.setLabelId(channelPoolQryBo.getLabelId());
                        uccLabelPo2.setLabelName(channelPoolQryBo.getLabelName());
                        uccLabelPo2.setIsShow(channelPoolQryBo.getIsShow());
                        uccLabelPo2.setLabelCode(channelPoolQryBo.getLabelCode());
                        uccLabelPo2.setLabelColor(channelPoolQryBo.getLabelColor());
                        uccLabelPo2.setLabelShortName(channelPoolQryBo.getLabelShortName());
                        uccLabelPo2.setLabelType(channelPoolQryBo.getLabelType());
                        uccLabelPo2.setPoolId(channelPoolQryBo.getPoolId());
                        uccSkuPo.setLabels(Lists.newArrayList((Object[])new UccLabelPo[]{uccLabelPo2}));
                        continue;
                    }
                    if (!uccSkuPo.getSkuPoolIds().contains(channelPoolQryBo.getPoolId())) {
                        uccSkuPo.getSkuPoolIds().add(channelPoolQryBo.getPoolId());
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getChannelIds()) && channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getPoolState() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                        uccSkuPo.setChannelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getChannelId()}));
                        uccSkuPo.setChannelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getChannelName()}));
                    } else if (!CollectionUtils.isEmpty(uccSkuPo.getChannelIds()) && !uccSkuPo.getChannelIds().contains(channelPoolQryBo.getChannelId()) && channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getPoolState() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                        uccSkuPo.getChannelIds().add(channelPoolQryBo.getChannelId());
                        uccSkuPo.getChannelNames().add(channelPoolQryBo.getChannelName());
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getLabelIds()) && channelPoolQryBo.getLabelId() != null) {
                        uccSkuPo.setLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        if (channelPoolQryBo.getIsShow() != null && channelPoolQryBo.getIsShow() == 1) {
                            uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                            uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        }
                    } else if (channelPoolQryBo.getLabelId() != null && !CollectionUtils.isEmpty(uccSkuPo.getLabelIds()) && !uccSkuPo.getLabelIds().contains(channelPoolQryBo.getLabelId())) {
                        uccSkuPo.getLabelIds().add(channelPoolQryBo.getLabelId());
                        uccSkuPo.getLabelNames().add(channelPoolQryBo.getLabelName());
                        if (channelPoolQryBo.getIsShow() != null && channelPoolQryBo.getIsShow() == 1) {
                            if (CollectionUtils.isEmpty(uccSkuPo.getShowLabelIds())) {
                                uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                                uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                            } else {
                                uccSkuPo.getShowLabelIds().add(channelPoolQryBo.getLabelId());
                                uccSkuPo.getShowLabelNames().add(channelPoolQryBo.getLabelName());
                            }
                        }
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getLabels())) {
                        if (null == channelPoolQryBo.getLabelId()) continue;
                        uccLabelPo2 = new UccLabelPo();
                        uccLabelPo2.setLabelId(channelPoolQryBo.getLabelId());
                        uccLabelPo2.setLabelName(channelPoolQryBo.getLabelName());
                        uccLabelPo2.setIsShow(channelPoolQryBo.getIsShow());
                        uccLabelPo2.setLabelCode(channelPoolQryBo.getLabelCode());
                        uccLabelPo2.setLabelColor(channelPoolQryBo.getLabelColor());
                        uccLabelPo2.setLabelShortName(channelPoolQryBo.getLabelShortName());
                        uccLabelPo2.setLabelType(channelPoolQryBo.getLabelType());
                        uccLabelPo2.setPoolId(channelPoolQryBo.getPoolId());
                        uccSkuPo.setLabels(Lists.newArrayList((Object[])new UccLabelPo[]{uccLabelPo2}));
                        continue;
                    }
                    labelIds = uccSkuPo.getLabels().stream().map(UccLabelPo::getLabelId).collect(Collectors.toList());
                    if (channelPoolQryBo.getLabelId() == null || CollectionUtils.isEmpty(uccSkuPo.getLabels()) || labelIds.contains(channelPoolQryBo.getLabelId())) continue;
                    uccLabelPo = new UccLabelPo();
                    uccLabelPo.setLabelId(channelPoolQryBo.getLabelId());
                    uccLabelPo.setLabelName(channelPoolQryBo.getLabelName());
                    uccLabelPo.setIsShow(channelPoolQryBo.getIsShow());
                    uccLabelPo.setLabelCode(channelPoolQryBo.getLabelCode());
                    uccLabelPo.setLabelColor(channelPoolQryBo.getLabelColor());
                    uccLabelPo.setLabelShortName(channelPoolQryBo.getLabelShortName());
                    uccLabelPo.setLabelType(channelPoolQryBo.getLabelType());
                    uccLabelPo.setPoolId(channelPoolQryBo.getPoolId());
                    uccSkuPo.getLabels().add(uccLabelPo);
                }
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(uccRelPoolCommodityPosByVendor)) {
                for (ChannelPoolQryBo channelPoolQryBo : uccRelPoolCommodityPosByVendor) {
                    if (!channelPoolQryBo.getSource().equals(uccSkuPo.getVendorId())) continue;
                    if (org.apache.commons.collections.CollectionUtils.isEmpty(uccSkuPo.getSkuPoolIds())) {
                        uccSkuPo.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getPoolId()}));
                        if (channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getPoolState() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                            uccSkuPo.setChannelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getChannelId()}));
                            uccSkuPo.setChannelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getChannelName()}));
                        }
                        if (channelPoolQryBo.getLabelId() == null) continue;
                        uccSkuPo.setLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        if (channelPoolQryBo.getIsShow() != null && channelPoolQryBo.getIsShow() == 1) {
                            uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                            uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        }
                        uccLabelPo2 = new UccLabelPo();
                        uccLabelPo2.setLabelId(channelPoolQryBo.getLabelId());
                        uccLabelPo2.setLabelName(channelPoolQryBo.getLabelName());
                        uccLabelPo2.setIsShow(channelPoolQryBo.getIsShow());
                        uccLabelPo2.setLabelCode(channelPoolQryBo.getLabelCode());
                        uccLabelPo2.setLabelColor(channelPoolQryBo.getLabelColor());
                        uccLabelPo2.setLabelShortName(channelPoolQryBo.getLabelShortName());
                        uccLabelPo2.setLabelType(channelPoolQryBo.getLabelType());
                        uccLabelPo2.setPoolId(channelPoolQryBo.getPoolId());
                        uccSkuPo.setLabels(Lists.newArrayList((Object[])new UccLabelPo[]{uccLabelPo2}));
                        continue;
                    }
                    if (!uccSkuPo.getSkuPoolIds().contains(channelPoolQryBo.getPoolId())) {
                        uccSkuPo.getSkuPoolIds().add(channelPoolQryBo.getPoolId());
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getChannelIds()) && channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getPoolState() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                        uccSkuPo.setChannelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getChannelId()}));
                        uccSkuPo.setChannelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getChannelName()}));
                    } else if (!CollectionUtils.isEmpty(uccSkuPo.getChannelIds()) && !uccSkuPo.getChannelIds().contains(channelPoolQryBo.getChannelId()) && channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getPoolState() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                        uccSkuPo.getChannelIds().add(channelPoolQryBo.getChannelId());
                        uccSkuPo.getChannelNames().add(channelPoolQryBo.getChannelName());
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getLabelIds()) && channelPoolQryBo.getLabelId() != null) {
                        uccSkuPo.setLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        if (channelPoolQryBo.getIsShow() != null && channelPoolQryBo.getIsShow() == 1) {
                            uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                            uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        }
                    } else if (channelPoolQryBo.getLabelId() != null && !CollectionUtils.isEmpty(uccSkuPo.getLabelIds()) && !uccSkuPo.getLabelIds().contains(channelPoolQryBo.getLabelId())) {
                        uccSkuPo.getLabelIds().add(channelPoolQryBo.getLabelId());
                        uccSkuPo.getLabelNames().add(channelPoolQryBo.getLabelName());
                        if (channelPoolQryBo.getIsShow() != null && channelPoolQryBo.getIsShow() == 1) {
                            if (CollectionUtils.isEmpty(uccSkuPo.getShowLabelIds())) {
                                uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                                uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                            } else {
                                uccSkuPo.getShowLabelIds().add(channelPoolQryBo.getLabelId());
                                uccSkuPo.getShowLabelNames().add(channelPoolQryBo.getLabelName());
                            }
                        }
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getLabels())) {
                        if (null == channelPoolQryBo.getLabelId()) continue;
                        uccLabelPo2 = new UccLabelPo();
                        uccLabelPo2.setLabelId(channelPoolQryBo.getLabelId());
                        uccLabelPo2.setLabelName(channelPoolQryBo.getLabelName());
                        uccLabelPo2.setIsShow(channelPoolQryBo.getIsShow());
                        uccLabelPo2.setLabelCode(channelPoolQryBo.getLabelCode());
                        uccLabelPo2.setLabelColor(channelPoolQryBo.getLabelColor());
                        uccLabelPo2.setLabelShortName(channelPoolQryBo.getLabelShortName());
                        uccLabelPo2.setLabelType(channelPoolQryBo.getLabelType());
                        uccLabelPo2.setPoolId(channelPoolQryBo.getPoolId());
                        uccSkuPo.setLabels(Lists.newArrayList((Object[])new UccLabelPo[]{uccLabelPo2}));
                        continue;
                    }
                    labelIds = uccSkuPo.getLabels().stream().map(UccLabelPo::getLabelId).collect(Collectors.toList());
                    if (channelPoolQryBo.getLabelId() == null || CollectionUtils.isEmpty(uccSkuPo.getLabels()) || labelIds.contains(channelPoolQryBo.getLabelId())) continue;
                    uccLabelPo = new UccLabelPo();
                    uccLabelPo.setLabelId(channelPoolQryBo.getLabelId());
                    uccLabelPo.setLabelName(channelPoolQryBo.getLabelName());
                    uccLabelPo.setIsShow(channelPoolQryBo.getIsShow());
                    uccLabelPo.setLabelCode(channelPoolQryBo.getLabelCode());
                    uccLabelPo.setLabelColor(channelPoolQryBo.getLabelColor());
                    uccLabelPo.setLabelShortName(channelPoolQryBo.getLabelShortName());
                    uccLabelPo.setLabelType(channelPoolQryBo.getLabelType());
                    uccLabelPo.setPoolId(channelPoolQryBo.getPoolId());
                    uccSkuPo.getLabels().add(uccLabelPo);
                }
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(uccRelPoolCommodityPosByAgr)) {
                for (ChannelPoolQryBo channelPoolQryBo : uccRelPoolCommodityPosByAgr) {
                    if (!channelPoolQryBo.getSource().equals(uccSkuPo.getAgreementId())) continue;
                    if (org.apache.commons.collections.CollectionUtils.isEmpty(uccSkuPo.getSkuPoolIds())) {
                        uccSkuPo.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getPoolId()}));
                        if (channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getPoolState() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                            uccSkuPo.setChannelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getChannelId()}));
                            uccSkuPo.setChannelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getChannelName()}));
                        }
                        if (channelPoolQryBo.getLabelId() == null) continue;
                        uccSkuPo.setLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        if (channelPoolQryBo.getIsShow() != null && channelPoolQryBo.getIsShow() == 1) {
                            uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                            uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        }
                        uccLabelPo2 = new UccLabelPo();
                        uccLabelPo2.setLabelId(channelPoolQryBo.getLabelId());
                        uccLabelPo2.setLabelName(channelPoolQryBo.getLabelName());
                        uccLabelPo2.setIsShow(channelPoolQryBo.getIsShow());
                        uccLabelPo2.setLabelCode(channelPoolQryBo.getLabelCode());
                        uccLabelPo2.setLabelColor(channelPoolQryBo.getLabelColor());
                        uccLabelPo2.setLabelShortName(channelPoolQryBo.getLabelShortName());
                        uccLabelPo2.setLabelType(channelPoolQryBo.getLabelType());
                        uccLabelPo2.setPoolId(channelPoolQryBo.getPoolId());
                        uccSkuPo.setLabels(Lists.newArrayList((Object[])new UccLabelPo[]{uccLabelPo2}));
                        continue;
                    }
                    if (!uccSkuPo.getSkuPoolIds().contains(channelPoolQryBo.getPoolId())) {
                        uccSkuPo.getSkuPoolIds().add(channelPoolQryBo.getPoolId());
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getChannelIds()) && channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getPoolState() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                        uccSkuPo.setChannelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getChannelId()}));
                        uccSkuPo.setChannelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getChannelName()}));
                    } else if (!CollectionUtils.isEmpty(uccSkuPo.getChannelIds()) && !uccSkuPo.getChannelIds().contains(channelPoolQryBo.getChannelId()) && channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getPoolState() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                        uccSkuPo.getChannelIds().add(channelPoolQryBo.getChannelId());
                        uccSkuPo.getChannelNames().add(channelPoolQryBo.getChannelName());
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getLabelIds()) && channelPoolQryBo.getLabelId() != null) {
                        uccSkuPo.setLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        if (channelPoolQryBo.getIsShow() != null && channelPoolQryBo.getIsShow() == 1) {
                            uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                            uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        }
                    } else if (channelPoolQryBo.getLabelId() != null && !CollectionUtils.isEmpty(uccSkuPo.getLabelIds()) && !uccSkuPo.getLabelIds().contains(channelPoolQryBo.getLabelId())) {
                        uccSkuPo.getLabelIds().add(channelPoolQryBo.getLabelId());
                        uccSkuPo.getLabelNames().add(channelPoolQryBo.getLabelName());
                        if (channelPoolQryBo.getIsShow() != null && channelPoolQryBo.getIsShow() == 1) {
                            if (CollectionUtils.isEmpty(uccSkuPo.getShowLabelIds())) {
                                uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                                uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                            } else {
                                uccSkuPo.getShowLabelIds().add(channelPoolQryBo.getLabelId());
                                uccSkuPo.getShowLabelNames().add(channelPoolQryBo.getLabelName());
                            }
                        }
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getLabels())) {
                        if (null == channelPoolQryBo.getLabelId()) continue;
                        uccLabelPo2 = new UccLabelPo();
                        uccLabelPo2.setLabelId(channelPoolQryBo.getLabelId());
                        uccLabelPo2.setLabelName(channelPoolQryBo.getLabelName());
                        uccLabelPo2.setIsShow(channelPoolQryBo.getIsShow());
                        uccLabelPo2.setLabelCode(channelPoolQryBo.getLabelCode());
                        uccLabelPo2.setLabelColor(channelPoolQryBo.getLabelColor());
                        uccLabelPo2.setLabelShortName(channelPoolQryBo.getLabelShortName());
                        uccLabelPo2.setLabelType(channelPoolQryBo.getLabelType());
                        uccLabelPo2.setPoolId(channelPoolQryBo.getPoolId());
                        uccSkuPo.setLabels(Lists.newArrayList((Object[])new UccLabelPo[]{uccLabelPo2}));
                        continue;
                    }
                    labelIds = uccSkuPo.getLabels().stream().map(UccLabelPo::getLabelId).collect(Collectors.toList());
                    if (channelPoolQryBo.getLabelId() == null || CollectionUtils.isEmpty(uccSkuPo.getLabels()) || labelIds.contains(channelPoolQryBo.getLabelId())) continue;
                    uccLabelPo = new UccLabelPo();
                    uccLabelPo.setLabelId(channelPoolQryBo.getLabelId());
                    uccLabelPo.setLabelName(channelPoolQryBo.getLabelName());
                    uccLabelPo.setIsShow(channelPoolQryBo.getIsShow());
                    uccLabelPo.setLabelCode(channelPoolQryBo.getLabelCode());
                    uccLabelPo.setLabelColor(channelPoolQryBo.getLabelColor());
                    uccLabelPo.setLabelShortName(channelPoolQryBo.getLabelShortName());
                    uccLabelPo.setLabelType(channelPoolQryBo.getLabelType());
                    uccLabelPo.setPoolId(channelPoolQryBo.getPoolId());
                    uccSkuPo.getLabels().add(uccLabelPo);
                }
            }
            if (!org.apache.commons.collections.CollectionUtils.isEmpty(uccRelPoolCommodityPosByspu)) {
                for (ChannelPoolQryBo channelPoolQryBo : uccRelPoolCommodityPosByspu) {
                    if (!channelPoolQryBo.getSource().equals(uccSkuPo.getCommodityId())) continue;
                    if (org.apache.commons.collections.CollectionUtils.isEmpty(uccSkuPo.getSkuPoolIds())) {
                        uccSkuPo.setSkuPoolIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getPoolId()}));
                        if (channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getPoolState() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                            uccSkuPo.setChannelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getChannelId()}));
                            uccSkuPo.setChannelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getChannelName()}));
                        }
                        if (channelPoolQryBo.getLabelId() == null) continue;
                        uccSkuPo.setLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        if (channelPoolQryBo.getIsShow() != null && channelPoolQryBo.getIsShow() == 1) {
                            uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                            uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        }
                        uccLabelPo2 = new UccLabelPo();
                        uccLabelPo2.setLabelId(channelPoolQryBo.getLabelId());
                        uccLabelPo2.setLabelName(channelPoolQryBo.getLabelName());
                        uccLabelPo2.setIsShow(channelPoolQryBo.getIsShow());
                        uccLabelPo2.setLabelCode(channelPoolQryBo.getLabelCode());
                        uccLabelPo2.setLabelColor(channelPoolQryBo.getLabelColor());
                        uccLabelPo2.setLabelShortName(channelPoolQryBo.getLabelShortName());
                        uccLabelPo2.setLabelType(channelPoolQryBo.getLabelType());
                        uccLabelPo2.setPoolId(channelPoolQryBo.getPoolId());
                        uccSkuPo.setLabels(Lists.newArrayList((Object[])new UccLabelPo[]{uccLabelPo2}));
                        continue;
                    }
                    if (!uccSkuPo.getSkuPoolIds().contains(channelPoolQryBo.getPoolId())) {
                        uccSkuPo.getSkuPoolIds().add(channelPoolQryBo.getPoolId());
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getChannelIds()) && channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getPoolState() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                        uccSkuPo.setChannelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getChannelId()}));
                        uccSkuPo.setChannelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getChannelName()}));
                    } else if (!CollectionUtils.isEmpty(uccSkuPo.getChannelIds()) && !uccSkuPo.getChannelIds().contains(channelPoolQryBo.getChannelId()) && channelPoolQryBo.getChannelId() != null && channelPoolQryBo.getChannelStatus() == 1 && channelPoolQryBo.getPoolState() == 1 && channelPoolQryBo.getChannelRelateType() == 1) {
                        uccSkuPo.getChannelIds().add(channelPoolQryBo.getChannelId());
                        uccSkuPo.getChannelNames().add(channelPoolQryBo.getChannelName());
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getLabelIds()) && channelPoolQryBo.getLabelId() != null) {
                        uccSkuPo.setLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                        uccSkuPo.setLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        if (channelPoolQryBo.getIsShow() != null && channelPoolQryBo.getIsShow() == 1) {
                            uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                            uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                        }
                    } else if (channelPoolQryBo.getLabelId() != null && !CollectionUtils.isEmpty(uccSkuPo.getLabelIds()) && !uccSkuPo.getLabelIds().contains(channelPoolQryBo.getLabelId())) {
                        uccSkuPo.getLabelIds().add(channelPoolQryBo.getLabelId());
                        uccSkuPo.getLabelNames().add(channelPoolQryBo.getLabelName());
                        if (channelPoolQryBo.getIsShow() != null && channelPoolQryBo.getIsShow() == 1) {
                            if (CollectionUtils.isEmpty(uccSkuPo.getShowLabelIds())) {
                                uccSkuPo.setShowLabelIds(Lists.newArrayList((Object[])new Long[]{channelPoolQryBo.getLabelId()}));
                                uccSkuPo.setShowLabelNames(Lists.newArrayList((Object[])new String[]{channelPoolQryBo.getLabelName()}));
                            } else {
                                uccSkuPo.getShowLabelIds().add(channelPoolQryBo.getLabelId());
                                uccSkuPo.getShowLabelNames().add(channelPoolQryBo.getLabelName());
                            }
                        }
                    }
                    if (CollectionUtils.isEmpty(uccSkuPo.getLabels())) {
                        if (null == channelPoolQryBo.getLabelId()) continue;
                        uccLabelPo2 = new UccLabelPo();
                        uccLabelPo2.setLabelId(channelPoolQryBo.getLabelId());
                        uccLabelPo2.setLabelName(channelPoolQryBo.getLabelName());
                        uccLabelPo2.setIsShow(channelPoolQryBo.getIsShow());
                        uccLabelPo2.setLabelCode(channelPoolQryBo.getLabelCode());
                        uccLabelPo2.setLabelColor(channelPoolQryBo.getLabelColor());
                        uccLabelPo2.setLabelShortName(channelPoolQryBo.getLabelShortName());
                        uccLabelPo2.setLabelType(channelPoolQryBo.getLabelType());
                        uccLabelPo2.setPoolId(channelPoolQryBo.getPoolId());
                        uccSkuPo.setLabels(Lists.newArrayList((Object[])new UccLabelPo[]{uccLabelPo2}));
                        continue;
                    }
                    labelIds = uccSkuPo.getLabels().stream().map(UccLabelPo::getLabelId).collect(Collectors.toList());
                    if (channelPoolQryBo.getLabelId() == null || CollectionUtils.isEmpty(uccSkuPo.getLabels()) || labelIds.contains(channelPoolQryBo.getLabelId())) continue;
                    uccLabelPo = new UccLabelPo();
                    uccLabelPo.setLabelId(channelPoolQryBo.getLabelId());
                    uccLabelPo.setLabelName(channelPoolQryBo.getLabelName());
                    uccLabelPo.setIsShow(channelPoolQryBo.getIsShow());
                    uccLabelPo.setLabelCode(channelPoolQryBo.getLabelCode());
                    uccLabelPo.setLabelColor(channelPoolQryBo.getLabelColor());
                    uccLabelPo.setLabelShortName(channelPoolQryBo.getLabelShortName());
                    uccLabelPo.setLabelType(channelPoolQryBo.getLabelType());
                    uccLabelPo.setPoolId(channelPoolQryBo.getPoolId());
                    uccSkuPo.getLabels().add(uccLabelPo);
                }
            }
            if (!CollectionUtils.isEmpty(uccSkuPo.getLabels())) {
                List<UccLabelPo> labels = uccSkuPo.getLabels();
                uccSkuPo.setLabels(labels.stream().sorted(Comparator.comparing(UccLabelPo::getPoolId).thenComparing(UccLabelPo::getLabelId)).collect(Collectors.toList()));
            }
            Long agreementId = uccSkuPo.getAgreementId();
            ArrayList arrayList = new ArrayList();
            if (null != uccSkuPo.getSkuId()) {
                HashSet<Long> agrWhiteList = new HashSet<Long>();
                List<UccOrgSkuWhiteRestrictionPo> uccOrgSkuWhiteRestrictionPos = agrWhitePOMap.get(uccSkuPo.getSkuId());
                if (!CollectionUtils.isEmpty(uccOrgSkuWhiteRestrictionPos)) {
                    for (UccOrgSkuWhiteRestrictionPo uccOrgSkuWhiteRestrictionPo : uccOrgSkuWhiteRestrictionPos) {
                        if (StringUtils.isBlank((CharSequence)uccOrgSkuWhiteRestrictionPo.getOrgTreePath())) continue;
                        List<Long> orgIdList = this.convertOrgIdList(uccOrgSkuWhiteRestrictionPo.getOrgTreePath());
                        agrWhiteList.addAll(orgIdList);
                    }
                }
                uccSkuPo.setWhitelist(Lists.newArrayList(agrWhiteList));
            }
            log.info("\u5355\u54c1:" + uccSkuPo.getSkuId() + "\u5408\u5e76\u540e\u767d\u540d\u5355\u4fe1\u606f\uff1a" + JSONObject.toJSONString(uccSkuPo.getWhitelist()));
        }
    }

    private List<Long> convertOrgIdList(String orgtreePath) {
        return Arrays.stream(orgtreePath.split("-")).filter(s -> !StringUtils.isBlank((CharSequence)s) && !"1".equals(s)).map(Convert::toLong).collect(Collectors.toList());
    }

    private void dealChannel2(List<CnncUccSkuPo> uccSkuPos) {
        List<UccRelChannelPoolPo> uccRelChannelPoolPos;
        if (uccSkuPos == null || uccSkuPos.isEmpty()) {
            return;
        }
        List<Long> skuIds = uccSkuPos.stream().map(CnncUccSkuPo::getSkuId).collect(Collectors.toList());
        List<CnncUccSkuPo> uccSkuChannelPos = this.uccChannelMapper.qrySkuChannel(skuIds);
        if (uccSkuChannelPos == null) {
            uccSkuChannelPos = new ArrayList<CnncUccSkuPo>();
        }
        HashSet<Long> poolIds = new HashSet<Long>();
        for (CnncUccSkuPo sku : uccSkuPos) {
            if (CollectionUtils.isEmpty(sku.getSkuPoolIds())) continue;
            poolIds.addAll(sku.getSkuPoolIds());
        }
        if (!CollectionUtils.isEmpty(poolIds) && !CollectionUtils.isEmpty(uccRelChannelPoolPos = this.uccRelChannelPoolMapper.getRelListByPools(new ArrayList<Long>(poolIds)))) {
            Map<Long, List<UccRelChannelPoolPo>> poolRelChannelMap = uccRelChannelPoolPos.stream().collect(Collectors.groupingBy(UccRelChannelPoolPo::getPoolId));
            for (CnncUccSkuPo sku : uccSkuPos) {
                for (Long poolId : sku.getSkuPoolIds()) {
                    if (!poolRelChannelMap.containsKey(poolId)) continue;
                    List skuChannelPOList = JUtil.jsl(poolRelChannelMap.get(poolId), CnncUccSkuPo.class);
                    skuChannelPOList.forEach(e -> e.setSkuId(sku.getSkuId()));
                    uccSkuChannelPos.addAll(skuChannelPOList);
                }
            }
        }
        log.debug("\u5546\u54c1\u6c60\u540c\u6b65es\u6700\u540e\u9891\u9053\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\u2014\uff1a" + JSON.toJSONString(uccSkuChannelPos));
        if (uccSkuChannelPos != null && !uccSkuChannelPos.isEmpty()) {
            HashMap<Long, List> skuAndChannelId = new HashMap<Long, List>();
            HashMap<Long, List> skuAndChannelName = new HashMap<Long, List>();
            for (CnncUccSkuPo uccSkuPo : uccSkuChannelPos) {
                skuAndChannelId.computeIfAbsent(uccSkuPo.getSkuId(), k -> new ArrayList()).add(uccSkuPo.getChannelId());
                skuAndChannelName.computeIfAbsent(uccSkuPo.getSkuId(), k -> new ArrayList()).add(uccSkuPo.getChannelName());
            }
            for (CnncUccSkuPo uccSkuPo : uccSkuPos) {
                Long skuId = uccSkuPo.getSkuId();
                List channelIds = (List)skuAndChannelId.get(skuId);
                List channelNames = (List)skuAndChannelName.get(skuId);
                if (channelIds != null && !channelIds.isEmpty()) {
                    if (uccSkuPo.getChannelIds() == null) {
                        uccSkuPo.setChannelIds(new ArrayList<Long>(channelIds));
                    } else {
                        for (Long channelId : channelIds) {
                            if (uccSkuPo.getChannelIds().contains(channelId)) continue;
                            uccSkuPo.getChannelIds().add(channelId);
                        }
                    }
                }
                if (channelNames == null || channelNames.isEmpty()) continue;
                if (uccSkuPo.getChannelNames() == null) {
                    uccSkuPo.setChannelNames(new ArrayList<String>(channelNames));
                    continue;
                }
                for (String channelName : channelNames) {
                    if (uccSkuPo.getChannelNames().contains(channelName)) continue;
                    uccSkuPo.getChannelNames().add(channelName);
                }
            }
        }
    }

    private void dealChannel(List<CnncUccSkuPo> uccSkuPos) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(uccSkuPos)) {
            return;
        }
        List<Long> skuIds = uccSkuPos.stream().map(a -> a.getSkuId()).collect(Collectors.toList());
        List<CnncUccSkuPo> uccSkuChanelPos = this.uccChannelMapper.qrySkuChannel(skuIds);
        if (!org.apache.commons.collections.CollectionUtils.isEmpty(uccSkuChanelPos)) {
            HashMap skuAndChannelId = new HashMap();
            HashMap skuAndChannelName = new HashMap();
            Map<Long, List<CnncUccSkuPo>> map = uccSkuChanelPos.stream().collect(Collectors.groupingBy(a -> a.getSkuId()));
            for (Map.Entry<Long, List<CnncUccSkuPo>> each2 : map.entrySet()) {
                List channelIds = each2.getValue().stream().map(a -> a.getChannelId()).collect(Collectors.toList());
                List channelNames = each2.getValue().stream().map(a -> a.getChannelName()).collect(Collectors.toList());
                skuAndChannelId.put(each2.getKey(), channelIds);
                skuAndChannelName.put(each2.getKey(), channelNames);
            }
            uccSkuPos.forEach(each -> {
                if (CollectionUtils.isEmpty(each.getChannelIds())) {
                    each.setChannelIds((List)skuAndChannelId.get(each.getSkuId()));
                    each.setChannelNames((List)skuAndChannelName.get(each.getSkuId()));
                } else {
                    ((List)skuAndChannelId.get(each.getSkuId())).forEach(next -> {
                        if (!each.getChannelIds().contains(next)) {
                            each.getChannelIds().add((Long)next);
                        }
                    });
                    ((List)skuAndChannelName.get(each.getSkuId())).forEach(next -> {
                        if (!each.getChannelNames().contains(next)) {
                            each.getChannelNames().add((String)next);
                        }
                    });
                }
            });
        }
    }

    private void dealByPoolIds(List<Long> poolIds) {
        for (Long poolId : poolIds) {
            List<UccRelPoolCommodityPo> uccRelPoolCommodityPOS = this.uccRelPoolCommodityMapper.qryListShard(poolId, 0, 0, new Page(-1, 10000));
            if (org.apache.commons.collections.CollectionUtils.isEmpty(uccRelPoolCommodityPOS)) continue;
            Map<Integer, List<UccRelPoolCommodityPo>> map = uccRelPoolCommodityPOS.stream().collect(Collectors.groupingBy(a -> a.getPoolRelated()));
            for (Map.Entry<Integer, List<UccRelPoolCommodityPo>> each : map.entrySet()) {
                List<Long> dealIds = each.getValue().stream().map(a -> a.getSource()).collect(Collectors.toList());
                switch (each.getKey()) {
                    case 1: {
                        this.dealList(null, null, dealIds, null);
                        break;
                    }
                    case 2: {
                        this.dealList(null, dealIds, null, null);
                        break;
                    }
                    case 3: {
                        this.dealList(dealIds, null, null, null);
                        break;
                    }
                    case 4: {
                        this.dealSkuIds(dealIds);
                        break;
                    }
                    case 5: {
                        this.dealList(null, null, null, dealIds);
                    }
                }
            }
        }
    }
}

