/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.busi.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.commodity.base.bo.UccBatchDealTaskReqJsonBO;
import com.tydic.commodity.base.constant.RspConstantEnums;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.exception.BusinessException;
import com.tydic.commodity.busibase.atom.api.UccDealTaskAtomService;
import com.tydic.commodity.busibase.atom.bo.UccDealTaskAtomReqBO;
import com.tydic.commodity.busibase.busi.api.UccAuditBusiService;
import com.tydic.commodity.busibase.busi.bo.ApproveTaskSyncBO;
import com.tydic.commodity.busibase.busi.bo.UccAuditBusiReqBO;
import com.tydic.commodity.busibase.busi.bo.UccAuditBusiRspBO;
import com.tydic.commodity.dao.ComBatchDealOrderMapper;
import com.tydic.commodity.dao.ComBatchDealRrecordMapper;
import com.tydic.commodity.dao.EacRuTaskMapper;
import com.tydic.commodity.po.ComBatchDealOrderPO;
import com.tydic.commodity.po.ComBatchDealRecordPO;
import com.tydic.commodity.po.EacRuTaskPO;
import com.tydic.dyc.base.utils.JUtil;
import com.tydic.osworkflow.approve.ability.EacJoinSignTaskAbilityService;
import com.tydic.osworkflow.approve.ability.EacQueryOperationRecordsListAbilityService;
import com.tydic.osworkflow.approve.ability.EacRuTaskAbilityService;
import com.tydic.osworkflow.approve.ability.EacTransferTaskAbilityService;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityReqInfoBO;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityRspBO;
import com.tydic.osworkflow.approve.ability.bo.EacApproveAbilityRspInfoBO;
import com.tydic.osworkflow.approve.ability.bo.EacApproveTaskInfoAbilityBO;
import com.tydic.osworkflow.approve.ability.bo.EacBackAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacBackAbilityReqInfoBO;
import com.tydic.osworkflow.approve.ability.bo.EacJoinSignTaskAbilityBO;
import com.tydic.osworkflow.approve.ability.bo.EacJoinSignTaskAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacJoinSignTaskAbilityRspBO;
import com.tydic.osworkflow.approve.ability.bo.EacOperLogAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacOperLogAbilityRspBO;
import com.tydic.osworkflow.approve.ability.bo.EacRuInstAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacRuInstAbilityRspBO;
import com.tydic.osworkflow.approve.ability.bo.EacTransferTaskAbilityBO;
import com.tydic.osworkflow.approve.ability.bo.EacTransferTaskAbilityReqBO;
import com.tydic.osworkflow.approve.ability.bo.EacTransferTaskAbilityRspBO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UccAuditBusiServiceImpl
implements UccAuditBusiService {
    private static final Logger log = LoggerFactory.getLogger(UccAuditBusiServiceImpl.class);
    @Autowired
    private EacRuTaskAbilityService eacRuTaskAbilityService;
    @Autowired
    private ComBatchDealOrderMapper comBatchDealOrderMapper;
    @Autowired
    private EacJoinSignTaskAbilityService eacJoinSignTaskAbilityService;
    @Autowired
    private EacTransferTaskAbilityService eacTransferTaskAbilityService;
    @Autowired
    private UccDealTaskAtomService uccDealTaskAtomService;
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private ComBatchDealRrecordMapper comBatchDealRrecordMapper;
    @Autowired
    private EacQueryOperationRecordsListAbilityService eacQueryOperationRecordsListAbilityService;

    @Override
    public UccAuditBusiRspBO dealUccTask(UccAuditBusiReqBO busiReqBO) {
        Boolean finishFlag = false;
        boolean auditStepFinish = false;
        if (busiReqBO.getDealType().equals(UccConstants.BatchDealType.BATCH_AUDIT)) {
            Map<String, Boolean> finishMap = this.dealAudit(busiReqBO);
            finishFlag = finishMap.get("finishFlag");
            auditStepFinish = finishMap.get("auditStepFinish");
        }
        if (busiReqBO.getDealType().equals(UccConstants.BatchDealType.BEFOR_TASK)) {
            this.dealPreJoin(busiReqBO);
        }
        if (busiReqBO.getDealType().equals(UccConstants.BatchDealType.TRANSFER_TASK)) {
            this.dealTransferTask(busiReqBO);
        }
        if (busiReqBO.getDealType().equals(UccConstants.BatchDealType.REVOKE_TASK)) {
            finishFlag = true;
            auditStepFinish = true;
            this.dealRevokeTask(busiReqBO);
        }
        if (finishFlag.booleanValue()) {
            ComBatchDealOrderPO set = new ComBatchDealOrderPO();
            set.setCurrentStatus(UccConstants.BatchDealOrderCurrentStatus.PROCESSING);
            set.setFinishTime(new Date());
            ComBatchDealOrderPO where = new ComBatchDealOrderPO();
            where.setOrderId(busiReqBO.getOrderId());
            this.comBatchDealOrderMapper.updateBy(set, where);
        } else {
            ComBatchDealOrderPO comBatchDealOrderPO = new ComBatchDealOrderPO();
            comBatchDealOrderPO.setOrderId(busiReqBO.getOrderId());
            this.comBatchDealOrderMapper.updateOldStatus(comBatchDealOrderPO);
        }
        ComBatchDealRecordPO comBatchDealRecordPO = new ComBatchDealRecordPO();
        comBatchDealRecordPO.setTaskId(busiReqBO.getTaskId());
        if (null != busiReqBO.getTaskId()) {
            this.comBatchDealRrecordMapper.deleteBy(comBatchDealRecordPO);
        }
        UccAuditBusiRspBO rspBO = new UccAuditBusiRspBO();
        rspBO.setFinishFlag(finishFlag);
        rspBO.setAuditStepFinish(auditStepFinish);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private void dealRevokeTask(UccAuditBusiReqBO busiReqBO) {
        EacRuTaskPO set = new EacRuTaskPO();
        set.setStatus("REVOKE");
        EacRuTaskPO where = new EacRuTaskPO();
        where.setBusinessId(busiReqBO.getOrderId().toString());
        this.eacRuTaskMapper.updateBy(set, where);
    }

    private Map<String, Boolean> dealAudit(UccAuditBusiReqBO busiReqBO) {
        EacApproveAbilityRspBO eacApproveAbilityRspBO;
        boolean finishFlag = false;
        boolean auditStepFinish = false;
        ArrayList<ApproveTaskSyncBO> nextTaskInfos = new ArrayList<ApproveTaskSyncBO>();
        UccBatchDealTaskReqJsonBO uccBatchDealTaskReqJsonBO = (UccBatchDealTaskReqJsonBO)JSON.parseObject((String)busiReqBO.getReqJson(), UccBatchDealTaskReqJsonBO.class);
        if (StringUtils.isNotBlank((CharSequence)uccBatchDealTaskReqJsonBO.getType())) {
            if (uccBatchDealTaskReqJsonBO.getType().equals("stop")) {
                this.dealProcessSuspension(busiReqBO, uccBatchDealTaskReqJsonBO);
                finishFlag = true;
                auditStepFinish = true;
            }
            if (uccBatchDealTaskReqJsonBO.getType().equals("start") || uccBatchDealTaskReqJsonBO.getType().equals("last") || uccBatchDealTaskReqJsonBO.getType().equals("history")) {
                eacApproveAbilityRspBO = this.dealProcessBack(busiReqBO);
                auditStepFinish = Boolean.valueOf(((EacApproveAbilityRspInfoBO)eacApproveAbilityRspBO.getData().get(0)).getLinkJudge());
                finishFlag = ((EacApproveAbilityRspInfoBO)eacApproveAbilityRspBO.getData().get(0)).getIsFinish();
                List taskList = ((EacApproveAbilityRspInfoBO)eacApproveAbilityRspBO.getData().get(0)).getTaskList();
                if (!CollectionUtils.isEmpty((Collection)taskList)) {
                    taskList.forEach(eacRuTaskAbilityBO -> {
                        ApproveTaskSyncBO approveTaskSyncBO = (ApproveTaskSyncBO)JUtil.js((Object)eacRuTaskAbilityBO, ApproveTaskSyncBO.class);
                        approveTaskSyncBO.setApproveTaskId(eacRuTaskAbilityBO.getTaskId());
                        nextTaskInfos.add(approveTaskSyncBO);
                    });
                }
            }
        } else {
            if (uccBatchDealTaskReqJsonBO.isJoin()) {
                this.dealProcessJoin(busiReqBO, "afterJoin");
            }
            eacApproveAbilityRspBO = this.dealProcessFlow(busiReqBO, uccBatchDealTaskReqJsonBO);
            auditStepFinish = Boolean.valueOf(((EacApproveAbilityRspInfoBO)eacApproveAbilityRspBO.getData().get(0)).getLinkJudge());
            finishFlag = ((EacApproveAbilityRspInfoBO)eacApproveAbilityRspBO.getData().get(0)).getIsFinish();
        }
        UccDealTaskAtomReqBO uccDealTaskAtomReqBO = new UccDealTaskAtomReqBO();
        ArrayList<ApproveTaskSyncBO> completeTaskInfos = new ArrayList<ApproveTaskSyncBO>();
        ApproveTaskSyncBO approveTaskSyncBO = new ApproveTaskSyncBO();
        approveTaskSyncBO.setUserId(uccBatchDealTaskReqJsonBO.getUserId().toString());
        approveTaskSyncBO.setUserName(uccBatchDealTaskReqJsonBO.getName());
        approveTaskSyncBO.setApproveTaskId(Long.parseLong(busiReqBO.getTaskId()));
        approveTaskSyncBO.setAuditResult(uccBatchDealTaskReqJsonBO.getAuditResult());
        approveTaskSyncBO.setAuditStepFinish(auditStepFinish);
        completeTaskInfos.add(approveTaskSyncBO);
        uccDealTaskAtomReqBO.setCompleteTaskInfos(completeTaskInfos);
        uccDealTaskAtomReqBO.setNextTaskInfos(nextTaskInfos);
        this.uccDealTaskAtomService.dealTask(uccDealTaskAtomReqBO);
        HashMap<String, Boolean> finishMap = new HashMap<String, Boolean>(4);
        finishMap.put("finishFlag", finishFlag);
        finishMap.put("auditStepFinish", auditStepFinish);
        return finishMap;
    }

    private void dealProcessSuspension(UccAuditBusiReqBO busiReqBO, UccBatchDealTaskReqJsonBO uccBatchDealTaskReqJsonBO) {
        EacRuTaskPO eacRuTaskPO = new EacRuTaskPO();
        eacRuTaskPO.setTaskId(Long.parseLong(busiReqBO.getTaskId()));
        EacRuTaskPO eacRuTaskPO1 = this.eacRuTaskMapper.getModelBy(eacRuTaskPO);
        EacRuInstAbilityReqBO eacRuInstAbilityReqBO = new EacRuInstAbilityReqBO();
        eacRuInstAbilityReqBO.setApproveInstId(eacRuTaskPO1.getApproveInstId());
        log.info("\u5ba1\u6279\u5355\u5ba1\u6279\u6d41\u7a0b\u7ec8\u6b62\u5165\u53c2eacRuInstAbilityReqBO:" + JSON.toJSON((Object)eacRuInstAbilityReqBO));
        EacRuInstAbilityRspBO eacRuInstAbilityRspBO = this.eacRuTaskAbilityService.suspensionApprove(eacRuInstAbilityReqBO);
        log.info("\u5ba1\u6279\u5355\u5ba1\u6279\u6d41\u7a0b\u7ec8\u6b62\u51fa\u53c2eacRuInstAbilityRspBO:" + JSON.toJSON((Object)eacRuInstAbilityRspBO));
        if (!"0000".equals(eacRuInstAbilityRspBO.getRespCode())) {
            throw new BusinessException(RspConstantEnums.COMMODITY_APPROVAL_PASS_FAIL.code(), eacRuInstAbilityRspBO.getRespDesc());
        }
        EacOperLogAbilityReqBO eacOperLogAbilityReqBO = new EacOperLogAbilityReqBO();
        eacOperLogAbilityReqBO.setTaskId(Long.valueOf(busiReqBO.getTaskId()));
        eacOperLogAbilityReqBO.setApproveInstId(eacRuTaskPO1.getApproveInstId());
        eacOperLogAbilityReqBO.setUserId(uccBatchDealTaskReqJsonBO.getUserId() + "");
        eacOperLogAbilityReqBO.setUserName(uccBatchDealTaskReqJsonBO.getName());
        eacOperLogAbilityReqBO.setOrgId(uccBatchDealTaskReqJsonBO.getOrgId() + "");
        eacOperLogAbilityReqBO.setOrgName(uccBatchDealTaskReqJsonBO.getOrgName());
        eacOperLogAbilityReqBO.setAction("reject");
        eacOperLogAbilityReqBO.setResult(uccBatchDealTaskReqJsonBO.getAuditAdvice());
        log.info("\u7ec8\u6b62\u6d41\u7a0b\u65f6\u65b0\u589e\u5ba1\u6279\u8bb0\u5f55\u5165\u53c2eacOperLogAbilityReqBO:" + JSON.toJSON((Object)eacOperLogAbilityReqBO));
        EacOperLogAbilityRspBO eacOperLogAbilityRspBO = this.eacQueryOperationRecordsListAbilityService.addOperationRecord(eacOperLogAbilityReqBO);
        log.info("\u7ec8\u6b62\u6d41\u7a0b\u65f6\u65b0\u589e\u5ba1\u6279\u8bb0\u5f55\u51fa\u53c2eacOperLogAbilityRspBO:" + JSON.toJSON((Object)eacOperLogAbilityRspBO));
        if (!"0000".equals(eacOperLogAbilityRspBO.getRespCode())) {
            throw new BusinessException(RspConstantEnums.COMMODITY_APPROVAL_PASS_FAIL.code(), eacOperLogAbilityRspBO.getRespDesc());
        }
    }

    private EacApproveAbilityRspBO dealProcessFlow(UccAuditBusiReqBO busiReqBO, UccBatchDealTaskReqJsonBO uccBatchDealTaskReqJsonBO) {
        EacApproveAbilityReqBO eacApproveAbilityReqBO = new EacApproveAbilityReqBO();
        ArrayList<EacApproveAbilityReqInfoBO> data = new ArrayList<EacApproveAbilityReqInfoBO>();
        EacApproveAbilityReqInfoBO eacApproveAbilityReqInfoBO = new EacApproveAbilityReqInfoBO();
        eacApproveAbilityReqInfoBO.setTaskId(Long.valueOf(Long.parseLong(busiReqBO.getTaskId())));
        eacApproveAbilityReqInfoBO.setApproveAdvice(uccBatchDealTaskReqJsonBO.getAuditAdvice());
        eacApproveAbilityReqInfoBO.setVariables(new HashMap());
        if (uccBatchDealTaskReqJsonBO.getAuditResult().equals(UccConstants.AuditResult.AUDIT_PASS)) {
            eacApproveAbilityReqInfoBO.setApproveResult("pass");
            eacApproveAbilityReqInfoBO.getVariables().put("auditOrderStatus", "0");
        } else {
            eacApproveAbilityReqInfoBO.setApproveResult("reject");
            eacApproveAbilityReqInfoBO.getVariables().put("auditOrderStatus", "1");
        }
        data.add(eacApproveAbilityReqInfoBO);
        eacApproveAbilityReqBO.setData(data);
        log.info("\u5ba1\u6279\u5355\u5ba1\u6279\u901a\u8fc7\u5165\u53c2eacApproveAbilityReqBO:" + JSON.toJSON((Object)eacApproveAbilityReqBO));
        EacApproveAbilityRspBO eacApproveAbilityRspBO = this.eacRuTaskAbilityService.approveByMq(eacApproveAbilityReqBO);
        log.info("\u5ba1\u6279\u5355\u5ba1\u6279\u901a\u8fc7\u51fa\u53c2eacApproveAbilityRspBO:" + JSON.toJSON((Object)eacApproveAbilityRspBO));
        if (!"0000".equals(eacApproveAbilityRspBO.getRespCode())) {
            throw new BusinessException(RspConstantEnums.COMMODITY_APPROVAL_PASS_FAIL.code(), eacApproveAbilityRspBO.getRespDesc());
        }
        return eacApproveAbilityRspBO;
    }

    private EacApproveAbilityRspBO dealProcessBack(UccAuditBusiReqBO busiReqBO) {
        UccBatchDealTaskReqJsonBO uccBatchDealTaskReqJsonBO = (UccBatchDealTaskReqJsonBO)JSON.parseObject((String)busiReqBO.getReqJson(), UccBatchDealTaskReqJsonBO.class);
        EacBackAbilityReqBO eacRuInstAbilityReqBO = new EacBackAbilityReqBO();
        ArrayList<EacBackAbilityReqInfoBO> backData = new ArrayList<EacBackAbilityReqInfoBO>();
        eacRuInstAbilityReqBO.setData(backData);
        EacBackAbilityReqInfoBO eacBackAbilityReqInfoBO = new EacBackAbilityReqInfoBO();
        eacBackAbilityReqInfoBO.setTaskId(Long.valueOf(Long.parseLong(busiReqBO.getTaskId())));
        eacBackAbilityReqInfoBO.setType(uccBatchDealTaskReqJsonBO.getType());
        eacBackAbilityReqInfoBO.setBackStepId(uccBatchDealTaskReqJsonBO.getBackStepId());
        eacBackAbilityReqInfoBO.setApproveAdvice(uccBatchDealTaskReqJsonBO.getAuditAdvice());
        backData.add(eacBackAbilityReqInfoBO);
        log.info("\u5ba1\u6279\u5355\u5ba1\u6279\u56de\u9000\u5165\u53c2eacRuInstAbilityReqBO:" + JSON.toJSON((Object)eacRuInstAbilityReqBO));
        EacApproveAbilityRspBO eacApproveAbilityRspBO = this.eacRuTaskAbilityService.back(eacRuInstAbilityReqBO);
        log.info("\u5ba1\u6279\u5355\u5ba1\u6279\u56de\u9000\u51fa\u53c2eacApproveAbilityRspBO:" + JSON.toJSON((Object)eacApproveAbilityRspBO));
        if (!"0000".equals(eacApproveAbilityRspBO.getRespCode())) {
            throw new BusinessException(RspConstantEnums.COMMODITY_APPROVAL_PASS_FAIL.code(), eacApproveAbilityRspBO.getRespDesc());
        }
        return eacApproveAbilityRspBO;
    }

    private void dealTransferTask(UccAuditBusiReqBO busiReqBO) {
        EacTransferTaskAbilityReqBO eacTransferTaskAbilityReqBO = new EacTransferTaskAbilityReqBO();
        eacTransferTaskAbilityReqBO.setData(new ArrayList());
        EacTransferTaskAbilityBO eacTransferTaskAbilityBO = (EacTransferTaskAbilityBO)JSON.parseObject((String)busiReqBO.getReqJson(), EacTransferTaskAbilityBO.class);
        eacTransferTaskAbilityBO.setTaskId(Long.valueOf(Long.parseLong(busiReqBO.getTaskId())));
        eacTransferTaskAbilityReqBO.getData().add(eacTransferTaskAbilityBO);
        log.info("\u5ba1\u6279\u8f6c\u7b7e\u5165\u53c2eacTransferTaskAbilityReqBO:{}", (Object)JSON.toJSONString((Object)eacTransferTaskAbilityReqBO));
        EacTransferTaskAbilityRspBO eacTransferTaskAbilityRspBO = this.eacTransferTaskAbilityService.transferTask(eacTransferTaskAbilityReqBO);
        log.info("\u5ba1\u6279\u8f6c\u7b7e\u51fa\u53c2eacJoinSignTaskAbilityRspBO:{}", (Object)JSON.toJSONString((Object)eacTransferTaskAbilityRspBO));
        if (!"0000".equals(eacTransferTaskAbilityRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u5ba1\u6279\u4e2d\u5fc3\u8f6c\u7b7e\u63a5\u53e3\u62a5\u9519\uff1a" + eacTransferTaskAbilityRspBO.getRespDesc());
        }
        UccDealTaskAtomReqBO uccDealTaskAtomReqBO = new UccDealTaskAtomReqBO();
        ApproveTaskSyncBO updateTaskCandidate = new ApproveTaskSyncBO();
        UccBatchDealTaskReqJsonBO uccBatchDealTaskReqJsonBO = (UccBatchDealTaskReqJsonBO)JSON.parseObject((String)busiReqBO.getReqJson(), UccBatchDealTaskReqJsonBO.class);
        updateTaskCandidate.setApproveTaskId(Long.parseLong(busiReqBO.getTaskId()));
        updateTaskCandidate.setUserId(uccBatchDealTaskReqJsonBO.getTransferUserId());
        updateTaskCandidate.setUserName(uccBatchDealTaskReqJsonBO.getTransferUserName());
        updateTaskCandidate.setOrgId(uccBatchDealTaskReqJsonBO.getTransferOrgId());
        updateTaskCandidate.setOrgName(uccBatchDealTaskReqJsonBO.getTransferOrgName());
        updateTaskCandidate.setRoleId(uccBatchDealTaskReqJsonBO.getTransferRoleId());
        updateTaskCandidate.setRoleName(uccBatchDealTaskReqJsonBO.getTransferRoleName());
        updateTaskCandidate.setStationCode(uccBatchDealTaskReqJsonBO.getTransferStationCode());
        updateTaskCandidate.setStationName(uccBatchDealTaskReqJsonBO.getTransferStationName());
        uccDealTaskAtomReqBO.setUpdateTaskCandidate(updateTaskCandidate);
        this.uccDealTaskAtomService.dealTask(uccDealTaskAtomReqBO);
    }

    private void dealPreJoin(UccAuditBusiReqBO busiReqBO) {
        List<ApproveTaskSyncBO> approveTaskSyncBOs = this.dealProcessJoin(busiReqBO, "beforeJoin");
        UccDealTaskAtomReqBO uccDealTaskAtomReqBO = new UccDealTaskAtomReqBO();
        if (CollectionUtils.isNotEmpty(approveTaskSyncBOs)) {
            uccDealTaskAtomReqBO.setNextTaskInfos(approveTaskSyncBOs);
        }
        uccDealTaskAtomReqBO.setPreTaskId(busiReqBO.getTaskId());
        this.uccDealTaskAtomService.dealTask(uccDealTaskAtomReqBO);
    }

    private List<ApproveTaskSyncBO> dealProcessJoin(UccAuditBusiReqBO busiReqBO, String joinType) {
        ArrayList<ApproveTaskSyncBO> taskSyncBOS = new ArrayList<ApproveTaskSyncBO>();
        EacJoinSignTaskAbilityReqBO eacJoinSignTaskAbilityReqBO = new EacJoinSignTaskAbilityReqBO();
        eacJoinSignTaskAbilityReqBO.setEacJoinSignTaskAbilityBOS(new ArrayList());
        EacJoinSignTaskAbilityBO eacJoinSignTaskAbilityBO = (EacJoinSignTaskAbilityBO)JSON.parseObject((String)busiReqBO.getReqJson(), EacJoinSignTaskAbilityBO.class);
        eacJoinSignTaskAbilityBO.setTaskId(Long.valueOf(Long.parseLong(busiReqBO.getTaskId())));
        eacJoinSignTaskAbilityBO.setJoinType(joinType);
        eacJoinSignTaskAbilityReqBO.getEacJoinSignTaskAbilityBOS().add(eacJoinSignTaskAbilityBO);
        log.info("\u5ba1\u6279\u52a0\u7b7e\u5165\u53c2eacJoinSignTaskAbilityReqBO:{}", (Object)JSON.toJSONString((Object)eacJoinSignTaskAbilityReqBO));
        EacJoinSignTaskAbilityRspBO eacJoinSignTaskAbilityRspBO = this.eacJoinSignTaskAbilityService.joinSignTask(eacJoinSignTaskAbilityReqBO);
        log.info("\u5ba1\u6279\u52a0\u7b7e\u51fa\u53c2eacJoinSignTaskAbilityRspBO:{}", (Object)JSON.toJSONString((Object)eacJoinSignTaskAbilityRspBO));
        if (CollectionUtils.isNotEmpty((Collection)eacJoinSignTaskAbilityRspBO.getTaskInfo())) {
            for (EacApproveTaskInfoAbilityBO eacApproveTaskInfoAbilityBO : eacJoinSignTaskAbilityRspBO.getTaskInfo()) {
                ApproveTaskSyncBO bo = (ApproveTaskSyncBO)JSON.parseObject((String)JSON.toJSONString((Object)eacApproveTaskInfoAbilityBO), ApproveTaskSyncBO.class);
                bo.setApproveTaskId(eacApproveTaskInfoAbilityBO.getTaskId());
                taskSyncBOS.add(bo);
            }
        }
        if (!"0000".equals(eacJoinSignTaskAbilityRspBO.getRespCode())) {
            throw new BusinessException("8888", "\u5ba1\u6279\u4e2d\u5fc3\u8f6c\u7b7e\u63a5\u53e3\u62a5\u9519\uff1a" + eacJoinSignTaskAbilityRspBO.getRespDesc());
        }
        return taskSyncBOS;
    }
}

