/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.busibase.comb.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.base.bo.UccEstoreLadderPriceBO;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.base.constant.SkuStatusConstants;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.base.enumType.AssignCodeEnum;
import com.tydic.commodity.base.enumType.CommodityEnum;
import com.tydic.commodity.base.enumType.PricessingStepsEnum;
import com.tydic.commodity.base.enumType.ProcessingStepsEnum;
import com.tydic.commodity.base.enumType.SkuEnum;
import com.tydic.commodity.base.enumType.SkuStatusEnum;
import com.tydic.commodity.base.enumType.YesNoEnum;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.busibase.comb.api.UccSkuListQryCombService;
import com.tydic.commodity.busibase.comb.bo.UccCombEsCommodityBo;
import com.tydic.commodity.busibase.comb.bo.UccSkuListCombQryBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuListQryCombReqBO;
import com.tydic.commodity.busibase.comb.bo.UccSkuListQryCombRspBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.config.UccIdGenerator;
import com.tydic.commodity.dao.EacRuTaskMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.innserBo.UccSkuListQryAbilityInnerCommodityTypeSkuIdBo;
import com.tydic.commodity.po.EacRuTaskPO;
import com.tydic.commodity.po.UccLadderPricePO;
import com.tydic.commodity.po.UccSkuExpandPo;
import com.tydic.commodity.po.UccSkuPo;
import com.tydic.commodity.po.UccSkuPricePo;
import com.tydic.commodity.utils.MoneyUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.ExistsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class UccSkuListQryCombServiceImpl
implements UccSkuListQryCombService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuListQryCombServiceImpl.class);
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccIdGenerator uccIdGenerator;
    @Autowired
    private CacheClient cacheClient;
    private static final String SKU_LIST_QUERY_SKU_ID_CACHE_KEY = "sku_list_query_sku_id_cache_key:";
    @Value(value="${ucc.skuIdCacheExpireTime:3600}")
    private int skuCacheExpireTime;
    @Value(value="${ucc.querySkuStatus:0,2,3,5}")
    private List<Integer> querySkuStatus;

    @Override
    public UccSkuListQryCombRspBO getSkuListQry(UccSkuListQryCombReqBO reqBO) {
        String result;
        String queryString;
        BoolQueryBuilder extBoolQueryBuilder;
        UccSkuListQryCombRspBO rspBo = new UccSkuListQryCombRspBO();
        if (!StringUtils.isEmpty((Object)reqBO.getStdSkuId())) {
            reqBO.setSkuType(0);
            extBoolQueryBuilder = this.buildEsSql(reqBO);
            queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder);
            result = this.searchInfo(queryString);
            ArrayList<UccSkuListCombQryBO> uccSkuManagementListCombQryBOS = new ArrayList<UccSkuListCombQryBO>();
            if (!StringUtils.isEmpty((Object)result)) {
                JSONObject resultObj = JSONObject.parseObject((String)result);
                JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
                JSONArray listObject = hitsObj.getJSONArray("hits");
                if (!listObject.isEmpty()) {
                    Map<String, String> commodityStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityEnum.COMMODITY_STATUS_NEW.toString());
                    Map<String, String> skuStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap("SKU_STATE_NEW");
                    Map<String, String> approveStateMap = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityEnum.SKU_APPROVAL_STATUS.toString());
                    Map<String, String> skuSourceMap = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_SOURCE.toString());
                    Map<String, String> downTypeMap = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuEnum.OFF_SHELF_METHOD_NEW.toString());
                    Map<String, String> supplierTypeMap = this.uccDictionaryAtomService.queryBypCodeBackMap("SUPPLIER_TYPE_DIC");
                    Map<String, String> isAnomalousPriceMap = this.uccDictionaryAtomService.queryBypCodeBackMap("IS_ANOMALOUS_PRICE_DIC");
                    Map<String, String> commodityTypeMap = this.uccDictionaryAtomService.queryBypCodeBackMap("COMMODITY_TYPE_DIC");
                    for (int i = 0; i < listObject.size(); ++i) {
                        UccSkuListCombQryBO uccSkuManagementListCombQryBO;
                        JSONObject hitObj = listObject.getJSONObject(i);
                        JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                        UccCombEsCommodityBo commodity = (UccCombEsCommodityBo)JSON.toJavaObject((JSON)data, UccCombEsCommodityBo.class);
                        if (StringUtils.isEmpty((Object)commodity) || ModelRuleConstant.PENDING_HANDLE_Status.equals((uccSkuManagementListCombQryBO = this.copyBean(commodity, reqBO, commodityStatusMap, skuStatusMap, approveStateMap, skuSourceMap, new ConcurrentHashMap<Long, UccSkuExpandPo>(), downTypeMap, supplierTypeMap, isAnomalousPriceMap, commodityTypeMap)).getProcessingSteps())) continue;
                        uccSkuManagementListCombQryBOS.add(uccSkuManagementListCombQryBO);
                    }
                }
                rspBo.setRows(uccSkuManagementListCombQryBOS);
                rspBo.setRespCode("0000");
                rspBo.setRespDesc("\u6210\u529f");
                return rspBo;
            }
        }
        if (StringUtils.isEmpty((Object)(result = this.searchInfo(queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder = this.buildEsSql(reqBO)))))) {
            rspBo.setTotal(0);
            rspBo.setRespCode("0000");
            rspBo.setRecordsTotal(0);
            rspBo.setRows(new ArrayList());
            return rspBo;
        }
        if (UccConstants.IsBatchDealQry.YES.equals(reqBO.getIsBatchDealQry())) {
            return this.qryBatchDealSkuId(reqBO, result);
        }
        if (UccConstants.IsQryNoPicSku.CODE.equals(reqBO.getIsQryNoPicSku()) || UccConstants.IsQryNoPicSku.NO_PIC.equals(reqBO.getIsQryNoPicSku())) {
            return this.qryCodeExport(reqBO, result);
        }
        if (reqBO.getQuerySkuIdOnly().booleanValue()) {
            return this.qrySkuIdList(rspBo, result);
        }
        rspBo = this.dealSearchData(result, reqBO);
        if (!CollectionUtils.isEmpty((Collection)rspBo.getRows())) {
            List<UccSkuPricePo> pricePos;
            List<UccLadderPricePO> ladderPricePOS;
            Map<Integer, List<UccSkuPricePo>> groupBySwitch;
            List<Long> skus = rspBo.getRows().stream().map(UccSkuListCombQryBO::getSkuId).collect(Collectors.toList());
            List<UccSkuPricePo> bathPrice = this.uccSkuPriceMapper.batchQryPriBySkuIds(skus, null);
            if (!CollectionUtils.isEmpty((Collection)rspBo.getRows()) && (groupBySwitch = bathPrice.stream().collect(Collectors.groupingBy(UccSkuPricePo::getSwitchOn))).containsKey(1) && !CollectionUtils.isEmpty(ladderPricePOS = this.uccLadderPriceMapper.selectListBySku(skus = (pricePos = groupBySwitch.get(1)).stream().map(UccSkuPricePo::getSkuId).collect(Collectors.toList())))) {
                Map<Long, List<UccLadderPricePO>> ladderMap = ladderPricePOS.stream().collect(Collectors.groupingBy(UccLadderPricePO::getSkuId));
                Iterator<Long> iterator = ladderMap.keySet().iterator();
                HashMap longListMap = new HashMap();
                while (iterator.hasNext()) {
                    Long key = iterator.next();
                    List<UccLadderPricePO> mapPos = ladderMap.get(key);
                    List eachBo = JSONObject.parseArray((String)JSONObject.toJSONString(mapPos), UccEstoreLadderPriceBO.class).stream().sorted((o1, o2) -> {
                        if (o2 == null || o1.getStart() == null || o2.getStart() == null) {
                            return 0;
                        }
                        return o2.getStart().compareTo(o1.getStart());
                    }).collect(Collectors.toList());
                    for (UccEstoreLadderPriceBO each : eachBo) {
                        if (each.getStart() != null) {
                            each.setStart(MoneyUtils.haoToYuan(each.getStart()));
                        }
                        if (each.getStop() != null) {
                            each.setStop(MoneyUtils.haoToYuan(each.getStop()));
                        }
                        if (each.getPrice() == null) continue;
                        each.setPrice(MoneyUtils.haoToYuan(each.getPrice()));
                    }
                    longListMap.put(key, eachBo);
                }
                if (!longListMap.isEmpty()) {
                    for (UccSkuListCombQryBO each : rspBo.getRows()) {
                        if (!longListMap.containsKey(each.getSkuId())) continue;
                        each.setLadderPriceInfo((List)longListMap.get(each.getSkuId()));
                    }
                }
            }
        }
        return rspBo;
    }

    private UccSkuListQryCombRspBO qrySkuIdList(UccSkuListQryCombRspBO rspBo, String result) {
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = resultObj.getJSONObject("hits");
        Integer total = 0;
        try {
            total = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = hitsObj.getJSONObject("total");
            total = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<Long> skuIdList = new ArrayList<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = hitObj.getJSONObject("_source");
                UccCombEsCommodityBo commodity = new UccCombEsCommodityBo();
                try {
                    commodity = (UccCombEsCommodityBo)JSON.toJavaObject((JSON)data, UccCombEsCommodityBo.class);
                    skuIdList.add(commodity.getSku_id());
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5" + e.getMessage());
                }
            }
        }
        String redisCacheKey = SKU_LIST_QUERY_SKU_ID_CACHE_KEY + this.uccIdGenerator.nextId();
        List<UccSkuPo> uccSkuPos = this.uccSkuMapper.qrySkuIdAndCommodityTypeBySkuIdList(skuIdList, this.querySkuStatus);
        ArrayList<UccSkuListQryAbilityInnerCommodityTypeSkuIdBo> idBoList = new ArrayList<UccSkuListQryAbilityInnerCommodityTypeSkuIdBo>();
        for (UccSkuPo uccSkuPo : uccSkuPos) {
            UccSkuListQryAbilityInnerCommodityTypeSkuIdBo tmpIdBo = new UccSkuListQryAbilityInnerCommodityTypeSkuIdBo();
            BeanUtils.copyProperties((Object)uccSkuPo, (Object)tmpIdBo);
            idBoList.add(tmpIdBo);
        }
        log.info("\u5355\u54c1\u6279\u91cf\u7f16\u8f91\u7f13\u5b58\u6570\u636e\u6761\u6570\uff1a" + idBoList.size());
        this.cacheClient.set(redisCacheKey, (Object)JSON.toJSONString(idBoList), this.skuCacheExpireTime);
        rspBo.setRedisCommodityIdCacheKey(redisCacheKey);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private UccSkuListQryCombRspBO qryBatchDealSkuId(UccSkuListQryCombReqBO reqBO, String result) {
        Integer records;
        UccSkuListQryCombRspBO rspBo = new UccSkuListQryCombRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = resultObj.getJSONObject("hits");
        try {
            records = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = hitsObj.getJSONObject("total");
            records = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject.size() > 0) {
            ArrayList<UccSkuListCombQryBO> uccSkuListCombQryBOList = new ArrayList<UccSkuListCombQryBO>();
            for (int i = 0; i < listObject.size(); ++i) {
                Object objSkuId;
                UccSkuListCombQryBO uccSkuListCombQryBO;
                Object objCommodityId;
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = hitObj.getJSONObject("_source");
                if (null == data) continue;
                if (UccConstants.QryObjType.SPU.equals(reqBO.getQryObjType()) && null != (objCommodityId = data.get((Object)"commodity_id"))) {
                    uccSkuListCombQryBO = new UccSkuListCombQryBO();
                    uccSkuListCombQryBO.setCommodityId(Convert.toLong((Object)objCommodityId));
                    uccSkuListCombQryBO.setAgreementId(Convert.toLong((Object)data.get((Object)"agreement_id")));
                    uccSkuListCombQryBO.setAgreementDetailsId(Convert.toLong((Object)data.get((Object)"agreement_details_id")));
                    uccSkuListCombQryBO.setContractId(Convert.toStr((Object)data.get((Object)"contractId")));
                    uccSkuListCombQryBO.setContractCode(Convert.toStr((Object)data.get((Object)"contractCode")));
                    uccSkuListCombQryBO.setContractName(Convert.toStr((Object)data.get((Object)"contractName")));
                    uccSkuListCombQryBO.setSupplierShopId(Convert.toLong((Object)data.get((Object)"supplier_shop_id")));
                    uccSkuListCombQryBOList.add(uccSkuListCombQryBO);
                }
                if (!UccConstants.QryObjType.SKU.equals(reqBO.getQryObjType()) || null == (objSkuId = data.get((Object)"sku_id"))) continue;
                uccSkuListCombQryBO = new UccSkuListCombQryBO();
                uccSkuListCombQryBO.setSkuId(Convert.toLong((Object)objSkuId));
                uccSkuListCombQryBO.setAgreementId(Convert.toLong((Object)data.get((Object)"agreement_id")));
                uccSkuListCombQryBO.setAgreementDetailsId(Convert.toLong((Object)data.get((Object)"agreement_details_id")));
                uccSkuListCombQryBO.setContractId(Convert.toStr((Object)data.get((Object)"contractId")));
                uccSkuListCombQryBO.setContractCode(Convert.toStr((Object)data.get((Object)"contractCode")));
                uccSkuListCombQryBO.setContractName(Convert.toStr((Object)data.get((Object)"contractName")));
                uccSkuListCombQryBO.setCommodityId(Convert.toLong((Object)data.get((Object)"commodity_id")));
                uccSkuListCombQryBO.setSupplierShopId(Convert.toLong((Object)data.get((Object)"supplier_shop_id")));
                uccSkuListCombQryBOList.add(uccSkuListCombQryBO);
            }
            rspBo.setRows(uccSkuListCombQryBOList);
        }
        if (null != records) {
            int totalPage = records / reqBO.getPageSize();
            int add = records % reqBO.getPageSize() == 0 ? 0 : 1;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(records);
            rspBo.setPageNo(reqBO.getPageNo());
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private UccSkuListQryCombRspBO qryCodeExport(UccSkuListQryCombReqBO reqBO, String result) {
        Integer records;
        UccSkuListQryCombRspBO rspBo = new UccSkuListQryCombRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = resultObj.getJSONObject("hits");
        try {
            records = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = hitsObj.getJSONObject("total");
            records = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (listObject.size() > 0) {
            ArrayList<UccSkuListCombQryBO> uccSkuListCombQryBOList = new ArrayList<UccSkuListCombQryBO>();
            for (int i = 0; i < listObject.size(); ++i) {
                Object skuName;
                Object skuCode;
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = hitObj.getJSONObject("_source");
                if (null == data) continue;
                UccSkuListCombQryBO uccSkuListCombQryBO = new UccSkuListCombQryBO();
                Object vendorName = data.get((Object)"vendor_name");
                if (null != vendorName) {
                    uccSkuListCombQryBO.setVendorName(vendorName.toString());
                }
                if (null != (skuCode = data.get((Object)"sku_code"))) {
                    uccSkuListCombQryBO.setSkuCode(skuCode.toString());
                }
                if (null != (skuName = data.get((Object)"sku_name"))) {
                    uccSkuListCombQryBO.setSkuName(skuName.toString());
                }
                uccSkuListCombQryBOList.add(uccSkuListCombQryBO);
            }
            rspBo.setRows(uccSkuListCombQryBOList);
        }
        if (null != records) {
            int totalPage = records / reqBO.getPageSize();
            int add = records % reqBO.getPageSize() == 0 ? 0 : 1;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(records);
            rspBo.setPageNo(reqBO.getPageNo());
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            RestClient restClient = this.elasticsearchUtil.getLowLevelClient();
            log.debug("restClient---->" + restClient);
            Response response = this.elasticsearchUtil.performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private BoolQueryBuilder buildEsSql(UccSkuListQryCombReqBO reqBo) {
        RangeQueryBuilder createTimeQb;
        WildcardQueryBuilder wildcardQuery;
        List<Integer> allApprovedStatus;
        ExistsQueryBuilder sexQueryBuilder;
        ExistsQueryBuilder sexQueryBuilder2;
        BoolQueryBuilder boolQueryBuilder2;
        BoolQueryBuilder boolQueryBuilder1;
        BoolQueryBuilder wideBool;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        ArrayList<Integer> notStatus = new ArrayList<Integer>();
        notStatus.add(SkuStatusConstants.SKU_WAIT_STRATEGY);
        notStatus.add(SkuStatusConstants.SKU_REJECT_STRATEGY);
        boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", notStatus));
        if (reqBo.getSupplierType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplierType", (Object)reqBo.getSupplierType()));
        }
        if (reqBo.getCommodityType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodityType", (Object)reqBo.getCommodityType()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getSupplierTypes())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"supplierType", reqBo.getSupplierTypes()));
        }
        if (reqBo.getCatalogIdLike() != null) {
            wideBool = QueryBuilders.boolQuery();
            boolQueryBuilder1 = QueryBuilders.boolQuery();
            boolQueryBuilder1.must((QueryBuilder)QueryBuilders.termQuery((String)"l1_category_id", (Object)reqBo.getCatalogIdLike()));
            boolQueryBuilder2 = QueryBuilders.boolQuery();
            boolQueryBuilder2.must((QueryBuilder)QueryBuilders.termQuery((String)"l2_category_id", (Object)reqBo.getCatalogIdLike()));
            BoolQueryBuilder boolQueryBuilder3 = QueryBuilders.boolQuery();
            boolQueryBuilder3.must((QueryBuilder)QueryBuilders.termQuery((String)"l3_category_id", (Object)reqBo.getCatalogIdLike()));
            wideBool.should((QueryBuilder)boolQueryBuilder1).should((QueryBuilder)boolQueryBuilder2).should((QueryBuilder)boolQueryBuilder3);
            boolQueryBuilder.must((QueryBuilder)wideBool);
        }
        if (reqBo.getInquirySkuFlag() != null && reqBo.getInquirySkuFlag() == 1) {
            sexQueryBuilder2 = QueryBuilders.existsQuery((String)"inquiryCode");
            boolQueryBuilder.must((QueryBuilder)sexQueryBuilder2);
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"inquiryCode", (String)""));
        } else if (reqBo.getInquirySkuFlag() != null && reqBo.getInquirySkuFlag() == 0) {
            wideBool = QueryBuilders.boolQuery();
            boolQueryBuilder1 = QueryBuilders.boolQuery();
            boolQueryBuilder2 = QueryBuilders.boolQuery();
            sexQueryBuilder = QueryBuilders.existsQuery((String)"inquiryCode");
            boolQueryBuilder1.mustNot((QueryBuilder)sexQueryBuilder);
            boolQueryBuilder2.must((QueryBuilder)QueryBuilders.termQuery((String)"sexQueryBuilder", (String)""));
            wideBool.should((QueryBuilder)boolQueryBuilder1).should((QueryBuilder)boolQueryBuilder2);
            boolQueryBuilder.must((QueryBuilder)wideBool);
        }
        if (reqBo.getEstorePcUrlFlag() != null && reqBo.getEstorePcUrlFlag() == 1) {
            sexQueryBuilder2 = QueryBuilders.existsQuery((String)"estorePcUrl");
            boolQueryBuilder.must((QueryBuilder)sexQueryBuilder2);
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"estorePcUrl", (String)""));
        } else if (reqBo.getEstorePcUrlFlag() != null && reqBo.getEstorePcUrlFlag() == 0) {
            wideBool = QueryBuilders.boolQuery();
            boolQueryBuilder1 = QueryBuilders.boolQuery();
            boolQueryBuilder2 = QueryBuilders.boolQuery();
            sexQueryBuilder = QueryBuilders.existsQuery((String)"estorePcUrl");
            boolQueryBuilder1.mustNot((QueryBuilder)sexQueryBuilder);
            boolQueryBuilder2.must((QueryBuilder)QueryBuilders.termQuery((String)"estorePcUrl", (String)""));
            wideBool.should((QueryBuilder)boolQueryBuilder1).should((QueryBuilder)boolQueryBuilder2);
            boolQueryBuilder.must((QueryBuilder)wideBool);
        }
        if (reqBo.getUpcCodeFlag() != null && reqBo.getUpcCodeFlag() == 1) {
            sexQueryBuilder2 = QueryBuilders.existsQuery((String)"upcCode");
            boolQueryBuilder.must((QueryBuilder)sexQueryBuilder2);
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termQuery((String)"upcCode", (String)""));
        } else if (reqBo.getUpcCodeFlag() != null && reqBo.getUpcCodeFlag() == 0) {
            wideBool = QueryBuilders.boolQuery();
            boolQueryBuilder1 = QueryBuilders.boolQuery();
            boolQueryBuilder2 = QueryBuilders.boolQuery();
            sexQueryBuilder = QueryBuilders.existsQuery((String)"upcCode");
            boolQueryBuilder1.mustNot((QueryBuilder)sexQueryBuilder);
            boolQueryBuilder2.must((QueryBuilder)QueryBuilders.termQuery((String)"upcCode", (String)""));
            wideBool.should((QueryBuilder)boolQueryBuilder1).should((QueryBuilder)boolQueryBuilder2);
            boolQueryBuilder.must((QueryBuilder)wideBool);
        }
        if (reqBo.getAbnormalPriceFlag() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"isAnomalousPrice", (Object)reqBo.getAbnormalPriceFlag()));
        }
        if (reqBo.getAnomalousPicFlag() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"isAnomalousPic", (Object)reqBo.getAnomalousPicFlag()));
        }
        if (reqBo.getAgrType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agrType", (Object)reqBo.getAgrType()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOoocClean())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"oooc_clean", (Object)reqBo.getOoocClean()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getPricePassFlag())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"price_pass_flag", (Object)reqBo.getPricePassFlag()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getProcessingSteps())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"processing_steps", (Object)reqBo.getProcessingSteps()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityClass())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodityClass", (Object)reqBo.getCommodityClass()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getExcludeSkuIds())) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", reqBo.getExcludeSkuIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getExportSkuIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", reqBo.getExportSkuIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getIgnoreSkuList())) {
            boolQueryBuilder.mustNot((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", reqBo.getIgnoreSkuList()));
        }
        if (reqBo.getSkuSource() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)reqBo.getSkuSource()));
        }
        if (reqBo.getSourceAssort() != null) {
            // empty if block
        }
        if (!CollectionUtils.isEmpty(reqBo.getApprovalStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_approval_status", reqBo.getApprovalStatus()));
        }
        if (reqBo.getBrandId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)reqBo.getBrandId()));
        }
        if (reqBo.getVendorId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)reqBo.getVendorId()));
        }
        if (reqBo.getSupplierId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (Object)reqBo.getSupplierId()));
        }
        if (reqBo.getSkuId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_id", (Object)reqBo.getSkuId()));
        }
        if (reqBo.getCommodityId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_id", (Object)reqBo.getCommodityId()));
        }
        if (reqBo.getL4mgCategoryId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l4mg_category_id", (Object)reqBo.getL4mgCategoryId()));
        }
        if (reqBo.getL3CategoryId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l3_category_id", (Object)reqBo.getL3CategoryId()));
        }
        if (reqBo.getCommodityTypeId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"type_id", (Object)reqBo.getCommodityTypeId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"create_oper_id", (String)reqBo.getCreateOperId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getApproveOrderId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"audit_no_list.orderId", (Object)reqBo.getApproveOrderId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSupplierOrgId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_org_id", (String)reqBo.getSupplierOrgId()));
        }
        if (reqBo.getSupplierShopId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_shop_id", (Object)reqBo.getSupplierShopId()));
        }
        if (null != reqBo.getMinimalismFlag()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"minimalism_flag", (Object)reqBo.getMinimalismFlag()));
        }
        if (null != reqBo.getIsAddCoefficient()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"is_add_coefficient", (Object)reqBo.getMinimalismFlag()));
        }
        if (null != reqBo.getDownType()) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"off_shelve_way", (Object)reqBo.getDownType()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getApprovalStatus()) && (allApprovedStatus = Arrays.asList(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_PUSH_PASS, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_PUSH_REJECT, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_SHELF_OVER, ModelRuleConstant.SKU_STATUS_WAIT_SHELF_ING, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_PASS, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_REJECT, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_OVER, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_REJECT, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_OVER, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_REJECT)).containsAll(reqBo.getApprovalStatus()) && null != reqBo.getUserId() && null != reqBo.getObjType()) {
            ArrayList<String> approvedQry = new ArrayList<String>();
            String approvedQryStrPass = reqBo.getUserId() + "_" + reqBo.getObjType() + "_0";
            String approvedQryStrRefuse = reqBo.getUserId() + "_" + reqBo.getObjType() + "_1";
            if (StringUtils.isEmpty((Object)reqBo.getAuditResult())) {
                approvedQry.add(approvedQryStrPass);
                approvedQry.add(approvedQryStrRefuse);
            } else if ("0".equals(reqBo.getAuditResult())) {
                approvedQry.add(approvedQryStrPass);
            } else if ("1".equals(reqBo.getAuditResult())) {
                approvedQry.add(approvedQryStrRefuse);
            }
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"approvedInfoStr", approvedQry));
            reqBo.setOperIds(null);
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operIds", reqBo.getOperIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperOrgIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operOrgIds", reqBo.getOperOrgIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getSkuIdList())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", reqBo.getSkuIdList()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperRoleIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operRoleIds", reqBo.getOperRoleIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getOperStationCodes())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operStationCodes", reqBo.getOperStationCodes()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getSkuStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", reqBo.getSkuStatus()));
        }
        ArrayList proNotExtOrgIdList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getProNotExtendOrgIds())) {
            proNotExtOrgIdList.addAll(reqBo.getProNotExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getPurNotExtendOrgIds())) {
            proNotExtOrgIdList.addAll(reqBo.getPurNotExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSupNotExtendOrgIds())) {
            proNotExtOrgIdList.addAll(reqBo.getSupNotExtendOrgIds());
        }
        ArrayList extOrgIdList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getProExtendOrgIds())) {
            extOrgIdList.addAll(reqBo.getProExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getPurExtendOrgIds())) {
            extOrgIdList.addAll(reqBo.getPurExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSupExtendOrgIds())) {
            extOrgIdList.addAll(reqBo.getSupExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty(proNotExtOrgIdList) || !CollectionUtils.isEmpty(extOrgIdList)) {
            BoolQueryBuilder orgQueryBuilder = QueryBuilders.boolQuery();
            if (!CollectionUtils.isEmpty(proNotExtOrgIdList)) {
                List collect = proNotExtOrgIdList.stream().distinct().collect(Collectors.toList());
                orgQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"supplier_org_id", collect));
            }
            boolQueryBuilder.must((QueryBuilder)orgQueryBuilder);
        }
        if (!CollectionUtils.isEmpty(reqBo.getCommodityStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_status", reqBo.getCommodityStatus()));
        }
        if (reqBo.getAgreementId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_id", (Object)reqBo.getAgreementId()));
        }
        if (reqBo.getAgreementDetailsId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_details_id", (Object)reqBo.getAgreementDetailsId()));
        }
        if (!ObjectUtil.isEmpty(reqBo.getAgreementDetailsIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"agreement_details_id", reqBo.getAgreementDetailsIds()));
        }
        if (reqBo.getStdSkuStatus() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"std_sku_status", (Object)reqBo.getStdSkuStatus()));
        }
        if (reqBo.getCreateType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"create_type", (Object)reqBo.getCreateType()));
        }
        if (reqBo.getStdSkuId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"std_sku_id", (Object)reqBo.getStdSkuId()));
        }
        if (reqBo.getBindStatus() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"bind_status", (Object)reqBo.getBindStatus()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSpuId())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"ext_spu_id.keyword", (String)("*" + reqBo.getExtSpuId() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getApplyNo())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"apply_no.keyword", (String)("*" + reqBo.getApplyNo() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getStdSkuCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"std_sku_code.keyword", (String)("*" + reqBo.getStdSkuCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSkuId())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"ext_sku_id.keyword", (String)("*" + reqBo.getExtSkuId() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBrandName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"brand_name.keyword", (String)("*" + reqBo.getBrandName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_name.keyword", (String)("*" + reqBo.getCommodityName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityExpand1())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_expand1.keyword", (String)("*" + reqBo.getCommodityExpand1() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getVendorName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"vendor_name.keyword", (String)("*" + reqBo.getVendorName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)("*" + reqBo.getSkuName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getUpcCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"upcCode.keyword", (String)("*" + reqBo.getUpcCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialCode())) {
            if (reqBo.getIsMaterCode() != null) {
                if (reqBo.getIsMaterCode() == 1) {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"material_code.keyword", (String[])new String[]{reqBo.getMaterialCode()}));
                }
            } else {
                wildcardQuery = QueryBuilders.wildcardQuery((String)"material_code.keyword", (String)("*" + reqBo.getMaterialCode() + "*"));
                boolQueryBuilder.must((QueryBuilder)wildcardQuery);
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_name.keyword", (String)("*" + reqBo.getOtherSourceName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getModel())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"model.keyword", (String)("*" + reqBo.getModel() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSpec())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"spec.keyword", (String)("*" + reqBo.getSpec() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"material_name.keyword", (String)("*" + reqBo.getMaterialName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_code.keyword", (String)("*" + reqBo.getCommodityCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_code.keyword", (String)("*" + reqBo.getSkuCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_code.keyword", (String)("*" + reqBo.getOtherSourceCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getContractCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"contractCode.keyword", (String)("*" + reqBo.getContractCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDiscountStar())) {
            RangeQueryBuilder discountQbStar = QueryBuilders.rangeQuery((String)"discounts").gte((Object)reqBo.getDiscountStar());
            boolQueryBuilder.must((QueryBuilder)discountQbStar);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDiscountEnd())) {
            RangeQueryBuilder discountQbEnd = QueryBuilders.rangeQuery((String)"discounts").lte((Object)reqBo.getDiscountEnd());
            boolQueryBuilder.must((QueryBuilder)discountQbEnd);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateTimeStar())) {
            createTimeQb = QueryBuilders.rangeQuery((String)"create_time").gte((Object)reqBo.getCreateTimeStar().getTime());
            boolQueryBuilder.must((QueryBuilder)createTimeQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateTimeEnd())) {
            createTimeQb = QueryBuilders.rangeQuery((String)"create_time").lte((Object)reqBo.getCreateTimeEnd().getTime());
            boolQueryBuilder.must((QueryBuilder)createTimeQb);
        }
        RangeQueryBuilder maerketQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getMarketPriceStar())) {
            maerketQb = QueryBuilders.rangeQuery((String)"market_price").gte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getMarketPriceStar()));
            boolQueryBuilder.must((QueryBuilder)maerketQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMarketPriceEnd())) {
            maerketQb = QueryBuilders.rangeQuery((String)"market_price").lte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getMarketPriceEnd()));
            boolQueryBuilder.must((QueryBuilder)maerketQb);
        }
        RangeQueryBuilder saleQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getSalePriceStar())) {
            saleQb = QueryBuilders.rangeQuery((String)"sale_price").gte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getSalePriceStar()));
            boolQueryBuilder.must((QueryBuilder)saleQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSalePriceEnd())) {
            saleQb = QueryBuilders.rangeQuery((String)"sale_price").lte((Object)MoneyUtils.yuanToHaoToLong(reqBo.getSalePriceEnd()));
            boolQueryBuilder.must((QueryBuilder)saleQb);
        }
        if (!CollectionUtils.isEmpty(reqBo.getCommodityIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_id", reqBo.getCommodityIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getL1CategoryIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l1_category_id.keyword", reqBo.getL1CategoryIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getL2CategoryIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l2_category_id.keyword", reqBo.getL2CategoryIds()));
        }
        if (!CollectionUtils.isEmpty(reqBo.getL3CategoryIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"l3_category_id.keyword", reqBo.getL3CategoryIds()));
        }
        log.debug("\u67e5\u8be2\u6761\u4ef6" + boolQueryBuilder.toString());
        return boolQueryBuilder;
    }

    private String excuteEsSql(UccSkuListQryCombReqBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        ArrayList<String> sourceList;
        JSONObject queryJson = new JSONObject();
        queryJson.put("track_total_hits", (Object)true);
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        if (ObjectUtil.isNotEmpty((Object)reqBo.getQuerySkuIdOnly()) && reqBo.getQuerySkuIdOnly().booleanValue()) {
            sourceList = new ArrayList<String>();
            sourceList.add("sku_id");
            queryJson.put("_source", sourceList);
        }
        if (UccConstants.IsBatchDealQry.YES.equals(reqBo.getIsBatchDealQry())) {
            sourceList = new ArrayList();
            if (UccConstants.QryObjType.SPU.equals(reqBo.getQryObjType())) {
                sourceList.add("agreement_details_id");
                sourceList.add("agreement_id");
                sourceList.add("commodity_id");
                sourceList.add("contractId");
                sourceList.add("contractCode");
                sourceList.add("contractName");
                sourceList.add("supplier_shop_id");
            } else {
                sourceList.add("sku_id");
                sourceList.add("agreement_details_id");
                sourceList.add("agreement_id");
                sourceList.add("commodity_id");
                sourceList.add("contractId");
                sourceList.add("contractCode");
                sourceList.add("contractName");
                sourceList.add("supplier_shop_id");
            }
            queryJson.put("_source", sourceList);
        }
        if (UccConstants.IsQryNoPicSku.NO_PIC.equals(reqBo.getIsQryNoPicSku())) {
            extBoolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_pic_count", (int)0));
            sourceList = new ArrayList();
            sourceList.add("sku_code");
            sourceList.add("sku_name");
            sourceList.add("vendor_name");
            queryJson.put("_source", sourceList);
        }
        if (UccConstants.IsQryNoPicSku.CODE.equals(reqBo.getIsQryNoPicSku())) {
            sourceList = new ArrayList();
            sourceList.add("sku_code");
            sourceList.add("sku_name");
            sourceList.add("vendor_name");
            queryJson.put("_source", sourceList);
        }
        String queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        SortOrder orderType = SortOrder.DESC;
        if (reqBo.getOrderType() != null && reqBo.getOrderType() == 1) {
            orderType = SortOrder.ASC;
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSortName()) && "asc".equals(reqBo.getSortOrder())) {
            orderType = SortOrder.ASC;
        }
        String sortField = "";
        if (reqBo.getOrderByColumn() != null) {
            if (reqBo.getOrderByColumn() == 0) {
                sortField = "update_time";
            } else if (reqBo.getOrderByColumn() == 1) {
                sortField = "sold_number";
            } else if (reqBo.getOrderByColumn() == 2) {
                sortField = "on_shelve_time";
            } else if (reqBo.getOrderByColumn() == 3) {
                sortField = "sale_price";
            } else if (reqBo.getOrderByColumn() == 4) {
                sortField = "discounts";
            } else if (reqBo.getOrderByColumn() == 5) {
                sortField = "comment_number";
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSortName())) {
            if (reqBo.getSortName().equals("skuCode")) {
                sortField = "sku_code.keyword";
            } else if (reqBo.getSortName().equals("extSkuId")) {
                sortField = "ext_sku_id.keyword";
            } else if (reqBo.getSortName().equals("skuName")) {
                sortField = "sku_name.keyword";
            } else if (reqBo.getSortName().equals("commodityCode")) {
                sortField = "commodity_code.keyword";
            } else if (reqBo.getSortName().equals("extSpuId")) {
                sortField = "ext_spu_id.keyword";
            } else if (reqBo.getSortName().equals("createTime")) {
                sortField = "sku_id";
            } else if (reqBo.getSortName().equals("downTime")) {
                sortField = "down_time";
            } else if (reqBo.getSortName().equals("upTime")) {
                sortField = "up_time";
            }
        }
        if (!StringUtils.isEmpty((Object)sortField)) {
            FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(orderType);
            queryJson.put("sort", (Object)JSONObject.parseObject((String)sortQuery.toString()));
        }
        return queryJson.toString();
    }

    private UccSkuListQryCombRspBO dealSearchData(String result, UccSkuListQryCombReqBO reqBo) {
        UccSkuListQryCombRspBO rspBo = new UccSkuListQryCombRspBO();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        Integer total = 0;
        try {
            total = hitsObj.getInteger("total");
        }
        catch (Exception e) {
            JSONObject totalObj = (JSONObject)hitsObj.get((Object)"total");
            total = totalObj.getInteger("value");
        }
        JSONArray listObject = hitsObj.getJSONArray("hits");
        if (log.isDebugEnabled()) {
            log.debug("\u603b\u8bb0\u5f55\u6570:" + total + " \u8fd4\u56de\u8bb0\u5f55\u6570\u636e" + listObject.size());
        }
        ArrayList<UccCombEsCommodityBo> commodityModels = new ArrayList<UccCombEsCommodityBo>();
        HashSet<Long> skuIdSet = new HashSet<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                UccCombEsCommodityBo commodity = new UccCombEsCommodityBo();
                try {
                    commodity = (UccCombEsCommodityBo)JSON.toJavaObject((JSON)data, UccCombEsCommodityBo.class);
                    commodityModels.add(commodity);
                    continue;
                }
                catch (Exception e) {
                    log.info("\u641c\u7d22es\u6570\u636e\u662f\u5355\u4e2a\u7684\u60c5\u51b5{}, skuId:{}", (Object)e.getMessage(), data.get((Object)"sku_id"));
                    if (!skuIdSet.contains(commodity.getSku_id())) {
                        commodityModels.add(commodity);
                    }
                    skuIdSet.add(commodity.getSku_id());
                }
            }
        }
        rspBo = this.copyData(commodityModels, total, reqBo.getPageNo(), reqBo.getPageSize(), reqBo);
        return rspBo;
    }

    private UccSkuListQryCombRspBO copyData(List<UccCombEsCommodityBo> commodityModels, Integer totalNum, int pageNo, int pageSize, UccSkuListQryCombReqBO reqBo) {
        UccSkuListQryCombRspBO rspBo = new UccSkuListQryCombRspBO();
        ArrayList<UccSkuListCombQryBO> uccSkuManagementListQryBOs = new ArrayList<UccSkuListCombQryBO>();
        if (totalNum != null) {
            rspBo.setPageNo(pageNo);
            int totalPage = 0;
            int add = 0;
            int total = 0;
            totalPage = totalNum / pageSize;
            add = totalNum % pageSize == 0 ? 0 : 1;
            total = totalNum;
            rspBo.setTotal(totalPage + add);
            rspBo.setRecordsTotal(total);
            Object dicDictionaryPo = null;
            if (!CollectionUtils.isEmpty(commodityModels)) {
                Map<String, String> commodityStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityEnum.COMMODITY_STATUS_NEW.toString());
                Map<String, String> skuStatusMap = this.uccDictionaryAtomService.queryBypCodeBackMap("SKU_STATE_NEW");
                Map<String, String> approveStateMap = this.uccDictionaryAtomService.queryBypCodeBackMap(CommodityEnum.SKU_APPROVAL_STATUS.toString());
                Map<String, String> skuSourceMap = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuEnum.SKU_SOURCE.toString());
                Map<String, String> downTypeMap = this.uccDictionaryAtomService.queryBypCodeBackMap(SkuEnum.OFF_SHELF_METHOD_NEW.toString());
                Map<String, String> supplierTypeMap = this.uccDictionaryAtomService.queryBypCodeBackMap("SUPPLIER_TYPE_DIC");
                Map<String, String> isAnomalousPriceMap = this.uccDictionaryAtomService.queryBypCodeBackMap("IS_ANOMALOUS_PRICE_DIC");
                Map<String, String> commodityTypeMap = this.uccDictionaryAtomService.queryBypCodeBackMap("COMMODITY_TYPE_DIC");
                ConcurrentHashMap<Long, UccSkuExpandPo> skuExpandMap = new ConcurrentHashMap();
                UccSkuExpandPo eacRuTaskPO = new UccSkuExpandPo();
                eacRuTaskPO.setSkuIds(commodityModels.stream().map(UccCombEsCommodityBo::getSku_id).distinct().collect(Collectors.toList()));
                List<UccSkuExpandPo> uccSkuExpandPos = this.uccSkuExpandMapper.querySkuExpand(eacRuTaskPO);
                if (!CollectionUtils.isEmpty(uccSkuExpandPos)) {
                    skuExpandMap = uccSkuExpandPos.stream().collect(Collectors.toConcurrentMap(UccSkuExpandPo::getSkuId, o -> o, (o1, o2) -> o1));
                }
                for (UccCombEsCommodityBo cnncEsCommodityBo : commodityModels) {
                    UccSkuListCombQryBO uccSkuManagementListQryBO = this.copyBean(cnncEsCommodityBo, reqBo, commodityStatusMap, skuStatusMap, approveStateMap, skuSourceMap, skuExpandMap, downTypeMap, supplierTypeMap, isAnomalousPriceMap, commodityTypeMap);
                    if (ObjectUtil.isNotEmpty((Object)uccSkuManagementListQryBO.getProcessingSteps()) && ObjectUtil.isNotEmpty((Object)uccSkuManagementListQryBO.getSkuStatus()) && uccSkuManagementListQryBO.getProcessingSteps() == 4 && uccSkuManagementListQryBO.getSkuStatus() == 16) {
                        uccSkuManagementListQryBO.setSkuStatus(1);
                        uccSkuManagementListQryBO.setSkuStatusDesc("\u5f85\u5173\u8054");
                    }
                    uccSkuManagementListQryBOs.add(uccSkuManagementListQryBO);
                }
            }
            rspBo.setRows(uccSkuManagementListQryBOs);
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private UccSkuListCombQryBO copyBean(UccCombEsCommodityBo cnncEsCommodityBo, UccSkuListQryCombReqBO reqBO, Map<String, String> commodityStatusMap, Map<String, String> skuStatusMap, Map<String, String> approveStateMap, Map<String, String> skuSourceMap, ConcurrentMap<Long, UccSkuExpandPo> skuExpandMap, Map<String, String> downTypeMap, Map<String, String> supplierTypeMap, Map<String, String> isAnomalousPriceMap, Map<String, String> commodityTypeMap) {
        UccSkuListCombQryBO uccSkuManagementListQryBO = new UccSkuListCombQryBO();
        uccSkuManagementListQryBO.setRelStatus(cnncEsCommodityBo.getRel_status());
        uccSkuManagementListQryBO.setCommodityCode(cnncEsCommodityBo.getCommodity_code());
        uccSkuManagementListQryBO.setCommodityId(cnncEsCommodityBo.getCommodity_id());
        uccSkuManagementListQryBO.setCommodityName(cnncEsCommodityBo.getCommodity_name());
        uccSkuManagementListQryBO.setSkuId(cnncEsCommodityBo.getSku_id());
        uccSkuManagementListQryBO.setSkuCode(cnncEsCommodityBo.getSku_code());
        uccSkuManagementListQryBO.setSkuName(cnncEsCommodityBo.getSku_name());
        uccSkuManagementListQryBO.setSkuSource(cnncEsCommodityBo.getSku_source());
        uccSkuManagementListQryBO.setSourceAssort(cnncEsCommodityBo.getSourceAssort());
        uccSkuManagementListQryBO.setCommodityTypeId(cnncEsCommodityBo.getType_id());
        uccSkuManagementListQryBO.setCommodityTypeName(cnncEsCommodityBo.getType_name());
        uccSkuManagementListQryBO.setCatalogId(cnncEsCommodityBo.getL4mg_category_id());
        uccSkuManagementListQryBO.setCatalogName(cnncEsCommodityBo.getL4mg_category_name());
        uccSkuManagementListQryBO.setProcessingSteps(cnncEsCommodityBo.getProcessing_steps());
        uccSkuManagementListQryBO.setSkuType(cnncEsCommodityBo.getSku_type());
        uccSkuManagementListQryBO.setPricePassFlag(cnncEsCommodityBo.getPrice_pass_flag());
        uccSkuManagementListQryBO.setApplyId(cnncEsCommodityBo.getApply_id());
        uccSkuManagementListQryBO.setApplyNo(cnncEsCommodityBo.getApply_no());
        uccSkuManagementListQryBO.setStdSkuId(cnncEsCommodityBo.getStd_sku_id());
        uccSkuManagementListQryBO.setStdSkuCode(cnncEsCommodityBo.getStd_sku_code());
        uccSkuManagementListQryBO.setMaterialId(cnncEsCommodityBo.getMaterial_id());
        uccSkuManagementListQryBO.setLongDesc(cnncEsCommodityBo.getLong_desc());
        uccSkuManagementListQryBO.setChannelIds(cnncEsCommodityBo.getChannel_id());
        uccSkuManagementListQryBO.setChannelNames(cnncEsCommodityBo.getChannel_Name());
        uccSkuManagementListQryBO.setOffShelveWay(cnncEsCommodityBo.getOff_shelve_way());
        uccSkuManagementListQryBO.setCategoryList(cnncEsCommodityBo.getCategoryList());
        uccSkuManagementListQryBO.setSubmitTime(cnncEsCommodityBo.getSubmitTime());
        uccSkuManagementListQryBO.setAgrType(cnncEsCommodityBo.getAgrType());
        uccSkuManagementListQryBO.setCommodityClass(cnncEsCommodityBo.getCommodityClass());
        uccSkuManagementListQryBO.setCommodityExpand(cnncEsCommodityBo.getCommodityExpand());
        uccSkuManagementListQryBO.setContractId(cnncEsCommodityBo.getContractId());
        uccSkuManagementListQryBO.setContractCode(cnncEsCommodityBo.getContractCode());
        uccSkuManagementListQryBO.setContractName(cnncEsCommodityBo.getContractName());
        if (ObjectUtil.isNotEmpty((Object)cnncEsCommodityBo.getBind_status())) {
            uccSkuManagementListQryBO.setBindStatus(cnncEsCommodityBo.getBind_status());
        }
        uccSkuManagementListQryBO.setEstorePcUrl(cnncEsCommodityBo.getEstorePcUrl());
        uccSkuManagementListQryBO.setIsAnomalousPrice(cnncEsCommodityBo.getIsAnomalousPrice());
        uccSkuManagementListQryBO.setCommodityType(cnncEsCommodityBo.getCommodityType());
        if (!ObjectUtil.isEmpty((Object)cnncEsCommodityBo.getCommodityType())) {
            uccSkuManagementListQryBO.setCommodityTypeStr(commodityTypeMap.get(cnncEsCommodityBo.getCommodityType() + ""));
        }
        if (!ObjectUtil.isEmpty((Object)cnncEsCommodityBo.getIsAnomalousPrice())) {
            uccSkuManagementListQryBO.setIsAnomalousPriceStr(isAnomalousPriceMap.get(cnncEsCommodityBo.getIsAnomalousPrice() + ""));
        }
        uccSkuManagementListQryBO.setSupplierType(cnncEsCommodityBo.getSupplierType());
        if (!ObjectUtil.isEmpty((Object)cnncEsCommodityBo.getSupplierType())) {
            uccSkuManagementListQryBO.setSupplierTypeStr(supplierTypeMap.get(cnncEsCommodityBo.getSupplierType() + ""));
        }
        uccSkuManagementListQryBO.setInquiryCode(cnncEsCommodityBo.getInquiryCode());
        if (!CollectionUtils.isEmpty(cnncEsCommodityBo.getCategoryList())) {
            StringBuilder guideCatalogNameTree = new StringBuilder();
            cnncEsCommodityBo.getCategoryList().forEach(e -> {
                if (!ObjectUtil.isEmpty((Object)guideCatalogNameTree)) {
                    guideCatalogNameTree.append(";");
                }
                if (!ObjectUtil.isEmpty((Object)e.getL1CatalogName())) {
                    guideCatalogNameTree.append(e.getL1CatalogName());
                }
                if (!ObjectUtil.isEmpty((Object)e.getL2CatalogName())) {
                    guideCatalogNameTree.append(">").append(e.getL2CatalogName());
                }
                if (!ObjectUtil.isEmpty((Object)e.getL3CatalogName())) {
                    guideCatalogNameTree.append(">").append(e.getL3CatalogName());
                }
            });
            uccSkuManagementListQryBO.setGuideCatalogNameTree(guideCatalogNameTree.toString());
        }
        uccSkuManagementListQryBO.setProcessingStepsDesc(ProcessingStepsEnum.getTypeDesc((Integer)cnncEsCommodityBo.getProcessing_steps()));
        uccSkuManagementListQryBO.setPricePassFlagDesc(PricessingStepsEnum.getTypeDesc((Integer)cnncEsCommodityBo.getPrice_pass_flag()));
        uccSkuManagementListQryBO.setOoocCleanDesc(YesNoEnum.getTypeDesc((Integer)cnncEsCommodityBo.getOooc_clean()));
        SkuStatusEnum statusDesc = SkuStatusEnum.getStatusDesc((Integer)cnncEsCommodityBo.getSku_status());
        if (null != statusDesc) {
            uccSkuManagementListQryBO.setSkuStatusDesc(statusDesc.getStatusDesc());
        }
        if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getRel_status())) {
            uccSkuManagementListQryBO.setMatStatus(cnncEsCommodityBo.getRel_status());
            uccSkuManagementListQryBO.setMatStatusDesc(AssignCodeEnum.getTypeDesc((Integer)cnncEsCommodityBo.getRel_status()));
        }
        if (null != cnncEsCommodityBo.getCommodity_status()) {
            uccSkuManagementListQryBO.setCommodityStatusDesc(commodityStatusMap.get(cnncEsCommodityBo.getCommodity_status().toString()));
        }
        uccSkuManagementListQryBO.setSkuStatusDesc(skuStatusMap.get(Convert.toStr((Object)cnncEsCommodityBo.getSku_status())));
        if (SkuStatusConstants.SKU_STATUS_DOWN_SHELF.equals(cnncEsCommodityBo.getSku_status())) {
            UccSkuExpandPo uccSkuExpandPo;
            if (null != cnncEsCommodityBo.getOff_shelve_way()) {
                uccSkuManagementListQryBO.setDownTypeDesc(downTypeMap.get(Convert.toStr((Object)cnncEsCommodityBo.getOff_shelve_way())));
            }
            if (null != (uccSkuExpandPo = (UccSkuExpandPo)skuExpandMap.get(uccSkuManagementListQryBO.getSkuId()))) {
                try {
                    JSONObject object = JSONObject.parseObject((String)uccSkuExpandPo.getExpand15());
                    String reason = (String)object.get((Object)"reason");
                    uccSkuManagementListQryBO.setDownReason(reason);
                }
                catch (Exception e2) {
                    log.error("\u83b7\u53d6\u4e0b\u67b6\u539f\u56e0\u5931\u8d25\uff1a" + e2.getMessage());
                }
            }
        }
        if (cnncEsCommodityBo.getSku_approval_status() != null) {
            uccSkuManagementListQryBO.setApprovalStatusDesc(approveStateMap.get(Convert.toStr((Object)cnncEsCommodityBo.getSku_approval_status())));
        }
        uccSkuManagementListQryBO.setBusiType(cnncEsCommodityBo.getSku_busi_type());
        uccSkuManagementListQryBO.setOrderStatus(cnncEsCommodityBo.getSku_order_status());
        uccSkuManagementListQryBO.setSkuSourceDesc(skuSourceMap.get(Convert.toStr((Object)cnncEsCommodityBo.getSku_source())));
        uccSkuManagementListQryBO.setApprovalStatus(cnncEsCommodityBo.getSku_approval_status());
        uccSkuManagementListQryBO.setBrandId(cnncEsCommodityBo.getOrigin_brand_id());
        uccSkuManagementListQryBO.setBrandName(cnncEsCommodityBo.getOrigin_brand_name());
        uccSkuManagementListQryBO.setVendorId(cnncEsCommodityBo.getVendor_id());
        uccSkuManagementListQryBO.setMaterialCode(cnncEsCommodityBo.getMaterial_code());
        uccSkuManagementListQryBO.setMaterialName(cnncEsCommodityBo.getMaterial_name());
        uccSkuManagementListQryBO.setCommodityStatus(cnncEsCommodityBo.getCommodity_status());
        uccSkuManagementListQryBO.setSkuStatus(cnncEsCommodityBo.getSku_status());
        uccSkuManagementListQryBO.setMeasureId(cnncEsCommodityBo.getMeasure_id());
        uccSkuManagementListQryBO.setMeasureName(cnncEsCommodityBo.getMeasure_name());
        uccSkuManagementListQryBO.setSettlementUnit(cnncEsCommodityBo.getSettlement_unit());
        if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getDiscounts())) {
            uccSkuManagementListQryBO.setDiscount(new BigDecimal(cnncEsCommodityBo.getDiscounts()));
        }
        if (cnncEsCommodityBo.getDown_time() != null) {
            uccSkuManagementListQryBO.setDownTime(new Date(cnncEsCommodityBo.getDown_time()));
        }
        if (cnncEsCommodityBo.getUp_time() != null) {
            uccSkuManagementListQryBO.setUpTime(new Date(cnncEsCommodityBo.getUp_time()));
        }
        if (cnncEsCommodityBo.getOn_shelve_time() != 0L) {
            uccSkuManagementListQryBO.setOnShelveTime(new Date(cnncEsCommodityBo.getOn_shelve_time()));
        }
        uccSkuManagementListQryBO.setL4mgCategoryId(cnncEsCommodityBo.getL4mg_category_id());
        uccSkuManagementListQryBO.setL4mgCategoryName(cnncEsCommodityBo.getL4mg_category_name());
        uccSkuManagementListQryBO.setSalePrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getSale_price()));
        uccSkuManagementListQryBO.setAgreementPrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getAgreement_price()));
        uccSkuManagementListQryBO.setMarketPrice(MoneyUtils.haoToYuan(cnncEsCommodityBo.getMarket_price()));
        uccSkuManagementListQryBO.setSupplierShopId(cnncEsCommodityBo.getSupplier_shop_id());
        uccSkuManagementListQryBO.setSell(cnncEsCommodityBo.getSell());
        uccSkuManagementListQryBO.setSpec(cnncEsCommodityBo.getSpec());
        uccSkuManagementListQryBO.setModel(cnncEsCommodityBo.getModel());
        if (!StringUtils.isEmpty((Object)cnncEsCommodityBo.getPicture_url())) {
            uccSkuManagementListQryBO.setPicUrl(cnncEsCommodityBo.getPicture_url());
        } else {
            uccSkuManagementListQryBO.setPicUrl(cnncEsCommodityBo.getCommd_pic_url());
        }
        uccSkuManagementListQryBO.setRate(cnncEsCommodityBo.getTaxRate());
        uccSkuManagementListQryBO.setPreDeliverDay(cnncEsCommodityBo.getPre_deliver_day());
        uccSkuManagementListQryBO.setMoq(cnncEsCommodityBo.getMoq());
        uccSkuManagementListQryBO.setSalesUnitId(cnncEsCommodityBo.getSales_unit_id());
        uccSkuManagementListQryBO.setSalesUnitName(cnncEsCommodityBo.getSales_unit_name());
        uccSkuManagementListQryBO.setSwitchOn(cnncEsCommodityBo.getSwitch_on());
        uccSkuManagementListQryBO.setOtherSourceCode(cnncEsCommodityBo.getOther_source_code());
        uccSkuManagementListQryBO.setOtherSourceName(cnncEsCommodityBo.getOther_source_name());
        uccSkuManagementListQryBO.setCommodityExpand1(cnncEsCommodityBo.getCommodity_expand1());
        uccSkuManagementListQryBO.setAgreementDetailsId(cnncEsCommodityBo.getAgreement_details_id());
        uccSkuManagementListQryBO.setAgreementId(cnncEsCommodityBo.getAgreement_id());
        uccSkuManagementListQryBO.setMinimalismFlag(cnncEsCommodityBo.getMinimalismFlag());
        uccSkuManagementListQryBO.setVendorName(cnncEsCommodityBo.getVendor_name());
        if (cnncEsCommodityBo.getComment_number() != null) {
            uccSkuManagementListQryBO.setTotalNum(MoneyUtils.haoToYuan(cnncEsCommodityBo.getComment_number()));
            log.info("uccSkuManagementListQryBO.getTotalNum:{}", (Object)uccSkuManagementListQryBO.getTotalNum());
        } else {
            uccSkuManagementListQryBO.setTotalNum(new BigDecimal("0"));
        }
        if (cnncEsCommodityBo.getSupplier_id() != null) {
            uccSkuManagementListQryBO.setSupplierId(cnncEsCommodityBo.getSupplier_id());
        }
        if (cnncEsCommodityBo.getSupplier_name() != null) {
            uccSkuManagementListQryBO.setSupplierName(cnncEsCommodityBo.getSupplier_name());
        }
        if (cnncEsCommodityBo.getExt_spu_id() != null) {
            uccSkuManagementListQryBO.setExtSpuId(cnncEsCommodityBo.getExt_spu_id());
        }
        if (cnncEsCommodityBo.getExt_sku_id() != null) {
            uccSkuManagementListQryBO.setExtSkuId(cnncEsCommodityBo.getExt_sku_id());
        }
        if (cnncEsCommodityBo.getCreate_time() != null) {
            uccSkuManagementListQryBO.setCreateTime(new Date(cnncEsCommodityBo.getCreate_time()));
        }
        if (cnncEsCommodityBo.getSkuExpand() != null) {
            uccSkuManagementListQryBO.setSkuExpand(cnncEsCommodityBo.getSkuExpand());
        }
        if (cnncEsCommodityBo.getUpcCode() != null) {
            uccSkuManagementListQryBO.setUpcCode(cnncEsCommodityBo.getUpcCode());
        }
        if (cnncEsCommodityBo.getCompareUrl() != null) {
            uccSkuManagementListQryBO.setCompareUrl(cnncEsCommodityBo.getCompareUrl());
        }
        if (uccSkuManagementListQryBO.getApprovalStatus() != null && uccSkuManagementListQryBO.getApprovalStatus() != 0) {
            EacRuTaskPO eacRuTaskPO = new EacRuTaskPO();
            eacRuTaskPO.setBusinessId(uccSkuManagementListQryBO.getSkuId().toString());
            eacRuTaskPO.setStatus("ACTIVE");
            eacRuTaskPO.setTacheCode(cnncEsCommodityBo.getTache_code());
            eacRuTaskPO.setOrderBy("CREATE_TIME");
            eacRuTaskPO.setUserId(Convert.toStr((Object)reqBO.getUserId()));
            List<EacRuTaskPO> list = this.eacRuTaskMapper.getList(eacRuTaskPO);
            if (!CollectionUtils.isEmpty(list)) {
                uccSkuManagementListQryBO.setTaskId(list.get(0).getTaskId());
                uccSkuManagementListQryBO.setIsJoinTransfer(list.get(0).getIsJoinTransfer());
            }
        }
        if (cnncEsCommodityBo.getAudit_time() != null) {
            uccSkuManagementListQryBO.setAuditTime(new Date(cnncEsCommodityBo.getAudit_time()));
        }
        uccSkuManagementListQryBO.setLabels(cnncEsCommodityBo.getLabels());
        uccSkuManagementListQryBO.setL1CategoryId(cnncEsCommodityBo.getL1_category_id());
        uccSkuManagementListQryBO.setL1CategoryName(cnncEsCommodityBo.getL1_category_name());
        uccSkuManagementListQryBO.setL2CategoryId(cnncEsCommodityBo.getL2_category_id());
        uccSkuManagementListQryBO.setL2CategoryName(cnncEsCommodityBo.getL2_category_name());
        uccSkuManagementListQryBO.setL3CategoryId(cnncEsCommodityBo.getL3_category_id());
        uccSkuManagementListQryBO.setL3CategoryName(cnncEsCommodityBo.getL3_category_name());
        return uccSkuManagementListQryBO;
    }
}

