/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.common.ability.api.CnncQrySyncProgressService;
import com.tydic.commodity.common.ability.bo.CnncQrySyncProgressReqBo;
import com.tydic.commodity.common.ability.bo.CnncQrySyncProgressRspBo;
import java.math.BigDecimal;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.CnncQrySyncProgressService"})
public class CnncQrySyncProgressServiceImpl
implements CnncQrySyncProgressService {
    private static final Logger log = LoggerFactory.getLogger(CnncQrySyncProgressServiceImpl.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${es.cluster.address}")
    private String esUrl;

    @PostMapping(value={"getSyncProgress"})
    public CnncQrySyncProgressRspBo getSyncProgress(@RequestBody CnncQrySyncProgressReqBo reqBo) {
        CnncQrySyncProgressRspBo rspBo = new CnncQrySyncProgressRspBo();
        log.error("\u8c03\u7528\u5730\u5740\uff1a" + this.esUrl + "/_tasks?detailed=true&actions=*reindex");
        ResponseEntity postForEntity = this.restTemplate.getForEntity("http://" + this.esUrl + "/_tasks?detailed=true&actions=*reindex", String.class, new Object[0]);
        String resultInfo = (String)postForEntity.getBody();
        log.error("\u8fd4\u56de\u7ed3\u679c\uff1a" + resultInfo);
        if (StringUtils.isEmpty((Object)resultInfo)) {
            rspBo.setRate(new BigDecimal("100"));
            rspBo.setSyncAll(true);
        } else {
            JSONObject jsonObject = JSONObject.parseObject((String)resultInfo);
            String nodes = jsonObject.getString("nodes");
            if (StringUtils.isEmpty((Object)nodes)) {
                rspBo.setRate(new BigDecimal("100"));
                rspBo.setSyncAll(true);
            } else {
                JSONObject jsonNodes = JSON.parseObject((String)nodes);
                Iterator sIterator = jsonNodes.keySet().iterator();
                while (sIterator.hasNext()) {
                    String key = sIterator.next().toString();
                    String result = jsonNodes.getString(key);
                    if (StringUtils.isEmpty((Object)result)) {
                        rspBo.setRate(new BigDecimal("100"));
                        rspBo.setSyncAll(true);
                        continue;
                    }
                    JSONObject resJson = JSON.parseObject((String)result);
                    String tasks = resJson.getString("tasks");
                    if (StringUtils.isEmpty((Object)tasks)) {
                        rspBo.setRate(new BigDecimal("100"));
                        rspBo.setSyncAll(true);
                        continue;
                    }
                    JSONObject tasksJson = JSON.parseObject((String)tasks);
                    Iterator taskIt = tasksJson.keySet().iterator();
                    while (taskIt.hasNext()) {
                        String taskkey = taskIt.next().toString();
                        String taskRes = tasksJson.getString(taskkey);
                        if (StringUtils.isEmpty((Object)taskRes)) {
                            rspBo.setRate(new BigDecimal("100"));
                            rspBo.setSyncAll(true);
                            continue;
                        }
                        JSONObject taskResJson = JSON.parseObject((String)taskRes);
                        String status = taskResJson.getString("status");
                        if (StringUtils.isEmpty((Object)status)) {
                            rspBo.setRate(new BigDecimal("100"));
                            rspBo.setSyncAll(true);
                            continue;
                        }
                        rspBo.setSyncAll(false);
                        JSONObject statusJson = JSON.parseObject((String)status);
                        BigDecimal total = statusJson.getBigDecimal("total");
                        BigDecimal updated = statusJson.getBigDecimal("updated");
                        BigDecimal created = statusJson.getBigDecimal("created");
                        BigDecimal deleted = statusJson.getBigDecimal("deleted");
                        BigDecimal allUpdate = updated.add(created).add(deleted);
                        log.error(allUpdate.toString());
                        log.error(total.toString());
                        BigDecimal rate = allUpdate.divide(total, 2, 4).multiply(new BigDecimal("100"));
                        rspBo.setRate(rate);
                    }
                }
            }
        }
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

