/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.convert.Convert;
import com.alibaba.fastjson.JSON;
import com.tydic.commodity.base.bo.UccEstoreSkuListQryBO;
import com.tydic.commodity.base.constant.UccConstants;
import com.tydic.commodity.common.ability.api.UccBigDataSubmitQryAbilityService;
import com.tydic.commodity.common.ability.api.UccEcommerceSkuListQryAbilityService;
import com.tydic.commodity.common.ability.api.UccSkuListQryAbilityService;
import com.tydic.commodity.common.ability.api.UccSpuListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccBigDataSubmitQryAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccBigDataSubmitQryAbilityRspBo;
import com.tydic.commodity.common.ability.bo.UccBigDataSubmitQryRspBo;
import com.tydic.commodity.common.ability.bo.UccEcommerceSkuListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccEcommerceSkuListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSkuListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSkuListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSkuListQryBO;
import com.tydic.commodity.common.ability.bo.UccSpuListQryAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccSpuListQryAbilityRspBO;
import com.tydic.commodity.common.ability.bo.UccSpuListQryBO;
import com.tydic.dyc.authority.service.user.AuthUserRoleDataPowerQryService;
import com.tydic.dyc.authority.service.user.bo.AuthUserRoleDataPowerQryReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthUserRoleDataPowerQryRspBo;
import com.tydic.dyc.base.exception.BaseBusinessException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccBigDataSubmitQryAbilityService"})
public class UccBigDataSubmitQryAbilityServiceImpl
implements UccBigDataSubmitQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccBigDataSubmitQryAbilityServiceImpl.class);
    @Autowired
    private AuthUserRoleDataPowerQryService authUserRoleDataPowerQryService;
    @Autowired
    private UccEcommerceSkuListQryAbilityService uccEcommerceSkuListQryAbilityService;
    @Autowired
    private UccSkuListQryAbilityService uccSkuListQryAbilityService;
    @Autowired
    private UccSpuListQryAbilityService uccSpuListQryAbilityService;
    @Value(value="${ucc.qry.submit.ecommerce.page.size:100}")
    private int ecommercePageSize;
    @Value(value="${ucc.qry.submit.ecommerce.total.records:1000}")
    private int ecommerceTotalRecords;
    @Value(value="${ucc.qry.submit.not.ecommerce.page.size:1}")
    private int notEcommercePageSize;
    @Value(value="${ucc.qry.submit.not.ecommerce.total.records:10}")
    private int notEcommerceTotalRecords;

    @PostMapping(value={"bigDataSubmitQry"})
    public UccBigDataSubmitQryAbilityRspBo bigDataSubmitQry(@RequestBody UccBigDataSubmitQryAbilityReqBo abilityReqBO) {
        if (StringUtils.isBlank((CharSequence)abilityReqBO.getQryJson())) {
            throw new BaseBusinessException("0001", "\u6279\u5904\u7406\u6a21\u5f0f\u67e5\u8be2\u6761\u4ef6JSON\u5fc5\u586b");
        }
        AuthUserRoleDataPowerQryRspBo authUserRoleDataPowerQryRspBo = this.getReqAuth(abilityReqBO);
        ArrayList<UccBigDataSubmitQryRspBo> rows = new ArrayList<UccBigDataSubmitQryRspBo>();
        if (UccConstants.Source.ECOM.equals(abilityReqBO.getSource())) {
            this.setEcomSkuRecordData(abilityReqBO, authUserRoleDataPowerQryRspBo, rows);
        }
        if (UccConstants.Source.AGR.equals(abilityReqBO.getSource()) || UccConstants.Source.NOT_AGR.equals(abilityReqBO.getSource())) {
            if (UccConstants.BatchObjType.SKU.equals(abilityReqBO.getObjType()) || UccConstants.BatchObjType.COMMODITY.equals(abilityReqBO.getObjType()) && UccConstants.IsSameLevelCommodity.YES.equals(abilityReqBO.getSameLevel())) {
                this.setNotEcomSkuData(abilityReqBO, authUserRoleDataPowerQryRspBo, rows);
            }
            if (UccConstants.BatchObjType.COMMODITY.equals(abilityReqBO.getObjType()) && UccConstants.IsSameLevelCommodity.NO.equals(abilityReqBO.getSameLevel())) {
                this.setNotEcomCommodityData(abilityReqBO, authUserRoleDataPowerQryRspBo, rows);
            }
        }
        UccBigDataSubmitQryAbilityRspBo rspBo = new UccBigDataSubmitQryAbilityRspBo();
        rspBo.setRows(rows);
        return rspBo;
    }

    private void setSpuParam(UccBigDataSubmitQryAbilityReqBo abilityReqBO, AuthUserRoleDataPowerQryRspBo authUserRoleDataPowerQryRspBo, UccSpuListQryAbilityReqBO uccSpuListQryAbilityReqBO) {
        uccSpuListQryAbilityReqBO.setUserId(abilityReqBO.getUserId());
        uccSpuListQryAbilityReqBO.setName(abilityReqBO.getName());
        uccSpuListQryAbilityReqBO.setOrgId(abilityReqBO.getOrgId());
        uccSpuListQryAbilityReqBO.setOrgName(abilityReqBO.getOrgName());
        uccSpuListQryAbilityReqBO.setCompanyId(abilityReqBO.getCompanyId());
        uccSpuListQryAbilityReqBO.setCompanyName(abilityReqBO.getCompanyName());
        uccSpuListQryAbilityReqBO.setIsBatchDealQry(Integer.valueOf(1));
        uccSpuListQryAbilityReqBO.setPageNo(1);
        uccSpuListQryAbilityReqBO.setPageSize(this.notEcommercePageSize);
        if (abilityReqBO.getLoginTagIn().equals("0")) {
            uccSpuListQryAbilityReqBO.setProExtendOrgIds(authUserRoleDataPowerQryRspBo.getProExtendOrgIds());
            uccSpuListQryAbilityReqBO.setProNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getProNotExtendOrgIds());
            uccSpuListQryAbilityReqBO.setPurExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurExtendOrgIds());
            uccSpuListQryAbilityReqBO.setPurNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurNotExtendOrgIds());
            uccSpuListQryAbilityReqBO.setSupExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupExtendOrgIds());
            uccSpuListQryAbilityReqBO.setSupNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupNotExtendOrgIds());
        }
        if (null != authUserRoleDataPowerQryRspBo.getSeflFlag() && authUserRoleDataPowerQryRspBo.getSeflFlag().booleanValue()) {
            uccSpuListQryAbilityReqBO.setCreateOperId(Convert.toStr((Object)abilityReqBO.getUserId()));
        }
    }

    private void setNotEcomCommodityData(UccBigDataSubmitQryAbilityReqBo abilityReqBO, AuthUserRoleDataPowerQryRspBo authUserRoleDataPowerQryRspBo, List<UccBigDataSubmitQryRspBo> rows) {
        UccSpuListQryAbilityReqBO uccSpuListQryAbilityReqBO = (UccSpuListQryAbilityReqBO)JSON.parseObject((String)abilityReqBO.getQryJson(), UccSpuListQryAbilityReqBO.class);
        this.setSpuParam(abilityReqBO, authUserRoleDataPowerQryRspBo, uccSpuListQryAbilityReqBO);
        UccSpuListQryAbilityRspBO uccSpuListQryAbilityRspBO = this.uccSpuListQryAbilityService.getSpuListQry(uccSpuListQryAbilityReqBO);
        if (!"0000".equals(uccSpuListQryAbilityRspBO.getRespCode())) {
            throw new BaseBusinessException(uccSpuListQryAbilityRspBO.getRespCode(), uccSpuListQryAbilityRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)uccSpuListQryAbilityRspBO.getRows())) {
            throw new BaseBusinessException("8888", "\u65e0\u6ee1\u8db3\u6761\u4ef6\u6570\u636e");
        }
        for (UccSpuListQryBO row : uccSpuListQryAbilityRspBO.getRows()) {
            UccBigDataSubmitQryRspBo uccSkuBatchAddRecordBO = new UccBigDataSubmitQryRspBo();
            uccSkuBatchAddRecordBO.setAgrId(row.getAgreementId());
            uccSkuBatchAddRecordBO.setAgrItemId(row.getAgreementDetailsId());
            uccSkuBatchAddRecordBO.setContractId(row.getContractId());
            uccSkuBatchAddRecordBO.setContractCode(row.getContractCode());
            uccSkuBatchAddRecordBO.setContractName(row.getContractName());
            uccSkuBatchAddRecordBO.setCommodityId(row.getCommodityId());
            uccSkuBatchAddRecordBO.setSupplierShopId(row.getSupplierShopId());
            rows.add(uccSkuBatchAddRecordBO);
        }
        if (uccSpuListQryAbilityRspBO.getTotal() > 1 && this.notEcommercePageSize != this.notEcommerceTotalRecords) {
            for (int pageNo = 2; pageNo < uccSpuListQryAbilityRspBO.getTotal(); ++pageNo) {
                uccSpuListQryAbilityReqBO.setPageNo(pageNo);
                UccSpuListQryAbilityRspBO pageRspData = this.uccSpuListQryAbilityService.getSpuListQry(uccSpuListQryAbilityReqBO);
                if (!"0000".equals(pageRspData.getRespCode())) {
                    throw new BaseBusinessException(pageRspData.getRespCode(), pageRspData.getRespDesc());
                }
                if (CollectionUtils.isEmpty((Collection)pageRspData.getRows())) {
                    throw new BaseBusinessException("8888", "\u65e0\u6ee1\u8db3\u6761\u4ef6\u6570\u636e");
                }
                for (UccSpuListQryBO row : pageRspData.getRows()) {
                    UccBigDataSubmitQryRspBo uccSkuBatchAddRecordBO = new UccBigDataSubmitQryRspBo();
                    uccSkuBatchAddRecordBO.setAgrId(row.getAgreementId());
                    uccSkuBatchAddRecordBO.setAgrItemId(row.getAgreementDetailsId());
                    uccSkuBatchAddRecordBO.setContractId(row.getContractId());
                    uccSkuBatchAddRecordBO.setContractCode(row.getContractCode());
                    uccSkuBatchAddRecordBO.setContractName(row.getContractName());
                    uccSkuBatchAddRecordBO.setCommodityId(row.getCommodityId());
                    uccSkuBatchAddRecordBO.setSupplierShopId(row.getSupplierShopId());
                    rows.add(uccSkuBatchAddRecordBO);
                }
                if (pageNo * this.notEcommercePageSize >= this.notEcommerceTotalRecords) break;
            }
        }
    }

    private void setNotEcomSkuData(UccBigDataSubmitQryAbilityReqBo abilityReqBO, AuthUserRoleDataPowerQryRspBo authUserRoleDataPowerQryRspBo, UccSkuListQryAbilityReqBO uccSkuListQryAbilityReqBO) {
        uccSkuListQryAbilityReqBO.setUserId(abilityReqBO.getUserId());
        uccSkuListQryAbilityReqBO.setName(abilityReqBO.getName());
        uccSkuListQryAbilityReqBO.setOrgId(abilityReqBO.getOrgId());
        uccSkuListQryAbilityReqBO.setOrgName(abilityReqBO.getOrgName());
        uccSkuListQryAbilityReqBO.setCompanyId(abilityReqBO.getCompanyId());
        uccSkuListQryAbilityReqBO.setCompanyName(abilityReqBO.getCompanyName());
        uccSkuListQryAbilityReqBO.setPageNo(1);
        uccSkuListQryAbilityReqBO.setPageSize(this.notEcommercePageSize);
        uccSkuListQryAbilityReqBO.setIsBatchDealQry(Integer.valueOf(1));
        if (UccConstants.IsSameLevelCommodity.YES.equals(abilityReqBO.getSameLevel())) {
            uccSkuListQryAbilityReqBO.setQryObjType(UccConstants.QryObjType.SPU);
        } else {
            uccSkuListQryAbilityReqBO.setQryObjType(UccConstants.QryObjType.SKU);
        }
        if (abilityReqBO.getLoginTagIn().equals("0")) {
            uccSkuListQryAbilityReqBO.setProExtendOrgIds(authUserRoleDataPowerQryRspBo.getProExtendOrgIds());
            uccSkuListQryAbilityReqBO.setProNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getProNotExtendOrgIds());
            uccSkuListQryAbilityReqBO.setPurExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurExtendOrgIds());
            uccSkuListQryAbilityReqBO.setPurNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurNotExtendOrgIds());
            uccSkuListQryAbilityReqBO.setSupExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupExtendOrgIds());
            uccSkuListQryAbilityReqBO.setSupNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupNotExtendOrgIds());
        }
        if (null != authUserRoleDataPowerQryRspBo.getSeflFlag() && authUserRoleDataPowerQryRspBo.getSeflFlag().booleanValue()) {
            uccSkuListQryAbilityReqBO.setCreateOperId(Convert.toStr((Object)abilityReqBO.getUserId()));
        }
    }

    private void setNotEcomSkuData(UccBigDataSubmitQryAbilityReqBo abilityReqBO, AuthUserRoleDataPowerQryRspBo authUserRoleDataPowerQryRspBo, List<UccBigDataSubmitQryRspBo> rows) {
        UccSkuListQryAbilityReqBO uccSkuListQryAbilityReqBO = (UccSkuListQryAbilityReqBO)JSON.parseObject((String)abilityReqBO.getQryJson(), UccSkuListQryAbilityReqBO.class);
        this.setNotEcomSkuData(abilityReqBO, authUserRoleDataPowerQryRspBo, uccSkuListQryAbilityReqBO);
        UccSkuListQryAbilityRspBO uccSkuListQryAbilityRspBO = this.uccSkuListQryAbilityService.getSkuListQry(uccSkuListQryAbilityReqBO);
        if (!"0000".equals(uccSkuListQryAbilityRspBO.getRespCode())) {
            throw new BaseBusinessException(uccSkuListQryAbilityRspBO.getRespCode(), uccSkuListQryAbilityRspBO.getRespDesc());
        }
        if (CollectionUtils.isEmpty((Collection)uccSkuListQryAbilityRspBO.getRows())) {
            throw new BaseBusinessException("8888", "\u65e0\u6ee1\u8db3\u6761\u4ef6\u6570\u636e");
        }
        if (UccConstants.IsSameLevelCommodity.YES.equals(abilityReqBO.getSameLevel())) {
            rows = uccSkuListQryAbilityRspBO.getRows().stream().map(uccSkuListQryBO -> {
                UccBigDataSubmitQryRspBo uccSkuBatchAddRecordBO = new UccBigDataSubmitQryRspBo();
                uccSkuBatchAddRecordBO.setAgrId(uccSkuListQryBO.getAgreementId());
                uccSkuBatchAddRecordBO.setAgrItemId(uccSkuListQryBO.getAgreementDetailsId());
                uccSkuBatchAddRecordBO.setContractId(uccSkuListQryBO.getContractId());
                uccSkuBatchAddRecordBO.setContractCode(uccSkuListQryBO.getContractCode());
                uccSkuBatchAddRecordBO.setContractName(uccSkuListQryBO.getContractName());
                uccSkuBatchAddRecordBO.setSkuId(uccSkuListQryBO.getSkuId());
                uccSkuBatchAddRecordBO.setCommodityId(uccSkuListQryBO.getCommodityId());
                uccSkuBatchAddRecordBO.setSupplierShopId(uccSkuListQryBO.getSupplierShopId());
                return uccSkuBatchAddRecordBO;
            }).distinct().collect(Collectors.toList());
        } else {
            for (UccSkuListQryBO row : uccSkuListQryAbilityRspBO.getRows()) {
                UccBigDataSubmitQryRspBo uccSkuBatchAddRecordBO = new UccBigDataSubmitQryRspBo();
                uccSkuBatchAddRecordBO.setAgrId(row.getAgreementId());
                uccSkuBatchAddRecordBO.setAgrItemId(row.getAgreementDetailsId());
                uccSkuBatchAddRecordBO.setContractId(row.getContractId());
                uccSkuBatchAddRecordBO.setContractCode(row.getContractCode());
                uccSkuBatchAddRecordBO.setContractName(row.getContractName());
                uccSkuBatchAddRecordBO.setSkuId(row.getSkuId());
                uccSkuBatchAddRecordBO.setCommodityId(row.getCommodityId());
                uccSkuBatchAddRecordBO.setSupplierShopId(row.getSupplierShopId());
                rows.add(uccSkuBatchAddRecordBO);
            }
        }
        if (uccSkuListQryAbilityRspBO.getTotal() > 1 && this.notEcommercePageSize != this.notEcommerceTotalRecords) {
            for (int pageNo = 2; pageNo < uccSkuListQryAbilityRspBO.getTotal(); ++pageNo) {
                uccSkuListQryAbilityReqBO.setPageNo(pageNo);
                UccSkuListQryAbilityRspBO pageRspData = this.uccSkuListQryAbilityService.getSkuListQry(uccSkuListQryAbilityReqBO);
                if (!"0000".equals(pageRspData.getRespCode())) {
                    throw new BaseBusinessException(pageRspData.getRespCode(), pageRspData.getRespDesc());
                }
                if (CollectionUtils.isEmpty((Collection)pageRspData.getRows())) {
                    throw new BaseBusinessException("8888", "\u65e0\u6ee1\u8db3\u6761\u4ef6\u6570\u636e");
                }
                for (UccSkuListQryBO row : pageRspData.getRows()) {
                    UccBigDataSubmitQryRspBo uccSkuBatchAddRecordBO = new UccBigDataSubmitQryRspBo();
                    uccSkuBatchAddRecordBO.setAgrId(row.getAgreementId());
                    uccSkuBatchAddRecordBO.setAgrItemId(row.getAgreementDetailsId());
                    uccSkuBatchAddRecordBO.setContractId(row.getContractId());
                    uccSkuBatchAddRecordBO.setContractCode(row.getContractCode());
                    uccSkuBatchAddRecordBO.setContractName(row.getContractName());
                    uccSkuBatchAddRecordBO.setSkuId(row.getSkuId());
                    uccSkuBatchAddRecordBO.setCommodityId(row.getCommodityId());
                    uccSkuBatchAddRecordBO.setSupplierShopId(row.getSupplierShopId());
                    rows.add(uccSkuBatchAddRecordBO);
                }
                if (pageNo * this.notEcommercePageSize >= this.notEcommerceTotalRecords) break;
            }
        }
    }

    private void setEcomSkuRecordData(UccBigDataSubmitQryAbilityReqBo abilityReqBO, AuthUserRoleDataPowerQryRspBo authUserRoleDataPowerQryRspBo, List<UccBigDataSubmitQryRspBo> rows) {
        UccEcommerceSkuListQryAbilityRspBO uccEcommerceSkuListQryAbilityRspBO = this.getUccEcommerceSkuListQryAbilityRspBO(abilityReqBO, 1, authUserRoleDataPowerQryRspBo);
        if (CollectionUtils.isEmpty((Collection)uccEcommerceSkuListQryAbilityRspBO.getRows())) {
            throw new BaseBusinessException("8888", "\u65e0\u6ee1\u8db3\u6761\u4ef6\u6570\u636e");
        }
        if (UccConstants.IsSameLevelCommodity.YES.equals(abilityReqBO.getSameLevel())) {
            rows = uccEcommerceSkuListQryAbilityRspBO.getRows().stream().map(uccSkuListQryBO -> {
                UccBigDataSubmitQryRspBo uccSkuBatchAddRecordBO = new UccBigDataSubmitQryRspBo();
                uccSkuBatchAddRecordBO.setSkuId(uccSkuListQryBO.getCommodityId());
                uccSkuBatchAddRecordBO.setCommodityId(uccSkuListQryBO.getCommodityId());
                uccSkuBatchAddRecordBO.setSupplierShopId(uccSkuListQryBO.getCommodityId());
                return uccSkuBatchAddRecordBO;
            }).distinct().collect(Collectors.toList());
        } else {
            for (UccEstoreSkuListQryBO row : uccEcommerceSkuListQryAbilityRspBO.getRows()) {
                UccBigDataSubmitQryRspBo uccSkuBatchAddRecordBO = new UccBigDataSubmitQryRspBo();
                uccSkuBatchAddRecordBO.setSkuId(row.getCommodityId());
                uccSkuBatchAddRecordBO.setCommodityId(row.getCommodityId());
                uccSkuBatchAddRecordBO.setSupplierShopId(row.getCommodityId());
                rows.add(uccSkuBatchAddRecordBO);
            }
        }
        if (uccEcommerceSkuListQryAbilityRspBO.getTotal() > 1 && this.ecommercePageSize != this.ecommerceTotalRecords) {
            for (int pageNo = 2; pageNo < uccEcommerceSkuListQryAbilityRspBO.getTotal(); ++pageNo) {
                UccEcommerceSkuListQryAbilityRspBO uccEcommerceSkuListQry = this.getUccEcommerceSkuListQryAbilityRspBO(abilityReqBO, pageNo, authUserRoleDataPowerQryRspBo);
                if (CollectionUtils.isEmpty((Collection)uccEcommerceSkuListQry.getRows())) {
                    throw new BaseBusinessException("8888", "\u65e0\u6ee1\u8db3\u6761\u4ef6\u6570\u636e");
                }
                for (UccEstoreSkuListQryBO row : uccEcommerceSkuListQry.getRows()) {
                    UccBigDataSubmitQryRspBo uccSkuBatchAddRecordBO = new UccBigDataSubmitQryRspBo();
                    uccSkuBatchAddRecordBO.setSkuId(row.getCommodityId());
                    uccSkuBatchAddRecordBO.setCommodityId(row.getCommodityId());
                    uccSkuBatchAddRecordBO.setSupplierShopId(row.getCommodityId());
                    rows.add(uccSkuBatchAddRecordBO);
                }
                if (pageNo * this.ecommercePageSize >= this.ecommerceTotalRecords) break;
            }
        }
    }

    private UccEcommerceSkuListQryAbilityRspBO getUccEcommerceSkuListQryAbilityRspBO(UccBigDataSubmitQryAbilityReqBo abilityReqBO, int PageNo, AuthUserRoleDataPowerQryRspBo authUserRoleDataPowerQryRspBo) {
        UccEcommerceSkuListQryAbilityReqBO uccEcommerceSkuListQryAbilityReqBO = (UccEcommerceSkuListQryAbilityReqBO)JSON.parseObject((String)abilityReqBO.getQryJson(), UccEcommerceSkuListQryAbilityReqBO.class);
        uccEcommerceSkuListQryAbilityReqBO.setUserId(abilityReqBO.getUserId());
        uccEcommerceSkuListQryAbilityReqBO.setName(abilityReqBO.getName());
        uccEcommerceSkuListQryAbilityReqBO.setOrgId(abilityReqBO.getOrgId());
        uccEcommerceSkuListQryAbilityReqBO.setOrgName(abilityReqBO.getOrgName());
        uccEcommerceSkuListQryAbilityReqBO.setCompanyId(abilityReqBO.getCompanyId());
        uccEcommerceSkuListQryAbilityReqBO.setCompanyName(abilityReqBO.getCompanyName());
        uccEcommerceSkuListQryAbilityReqBO.setPageNo(PageNo);
        uccEcommerceSkuListQryAbilityReqBO.setPageSize(this.ecommercePageSize);
        uccEcommerceSkuListQryAbilityReqBO.setProExtendOrgIds(authUserRoleDataPowerQryRspBo.getProExtendOrgIds());
        uccEcommerceSkuListQryAbilityReqBO.setProNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getProNotExtendOrgIds());
        uccEcommerceSkuListQryAbilityReqBO.setPurExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurExtendOrgIds());
        uccEcommerceSkuListQryAbilityReqBO.setPurNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getPurNotExtendOrgIds());
        uccEcommerceSkuListQryAbilityReqBO.setSupExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupExtendOrgIds());
        uccEcommerceSkuListQryAbilityReqBO.setSupNotExtendOrgIds(authUserRoleDataPowerQryRspBo.getSupNotExtendOrgIds());
        uccEcommerceSkuListQryAbilityReqBO.setIsBatchDealQry(Integer.valueOf(1));
        if (UccConstants.IsSameLevelCommodity.YES.equals(abilityReqBO.getSameLevel())) {
            uccEcommerceSkuListQryAbilityReqBO.setQryObjType(UccConstants.QryObjType.SPU);
        } else {
            uccEcommerceSkuListQryAbilityReqBO.setQryObjType(UccConstants.QryObjType.SKU);
        }
        UccEcommerceSkuListQryAbilityRspBO uccEcommerceSkuListQryAbilityRspBO = this.uccEcommerceSkuListQryAbilityService.getEstoreSkuListQry(uccEcommerceSkuListQryAbilityReqBO);
        if (!"0000".equals(uccEcommerceSkuListQryAbilityRspBO.getRespCode())) {
            throw new BaseBusinessException(uccEcommerceSkuListQryAbilityRspBO.getRespCode(), uccEcommerceSkuListQryAbilityRspBO.getRespDesc());
        }
        return uccEcommerceSkuListQryAbilityRspBO;
    }

    private AuthUserRoleDataPowerQryRspBo getReqAuth(UccBigDataSubmitQryAbilityReqBo reqBO) {
        AuthUserRoleDataPowerQryReqBo authUserRoleDataPowerQryReqBo = new AuthUserRoleDataPowerQryReqBo();
        authUserRoleDataPowerQryReqBo.setUserId(reqBO.getUserId());
        authUserRoleDataPowerQryReqBo.setLoginTagIn(reqBO.getLoginTagIn());
        authUserRoleDataPowerQryReqBo.setMenuId(reqBO.getMenuId());
        authUserRoleDataPowerQryReqBo.setOrgTreePathIn(reqBO.getOrgPath());
        log.debug("\u67e5\u8be2\u6570\u636e\u6743\u9650\u5165\u53c2:{}", (Object)JSON.toJSONString((Object)authUserRoleDataPowerQryReqBo));
        AuthUserRoleDataPowerQryRspBo authUserRoleDataPowerQryRspBo = this.authUserRoleDataPowerQryService.qryUserRoleDataPower(authUserRoleDataPowerQryReqBo);
        log.debug("\u67e5\u8be2\u6570\u636e\u6743\u9650\u51fa\u53c2:{}", (Object)JSON.toJSONString((Object)authUserRoleDataPowerQryRspBo));
        if (!"0000".equals(authUserRoleDataPowerQryRspBo.getRespCode())) {
            log.error(authUserRoleDataPowerQryRspBo.getRespDesc());
        }
        return authUserRoleDataPowerQryRspBo;
    }
}

