/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.mq.proxy.ProxyMessage;
import com.ohaotian.plugin.mq.proxy.ProxyMessageProducer;
import com.tydic.commodity.common.ability.api.UccCatalogAddAbilityService;
import com.tydic.commodity.common.ability.bo.UccCatalogAddReqBO;
import com.tydic.commodity.common.ability.bo.UccCatalogAddRspBO;
import com.tydic.commodity.common.busi.api.UccCatalogAddBusiService;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccCatalogAddAbilityService"})
public class UccCatalogAddAbilityServiceImpl
implements UccCatalogAddAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccCatalogAddAbilityServiceImpl.class);
    @Autowired
    private UccCatalogAddBusiService uccCatalogAddBusiService;
    @Value(value="${MONITOR_PRICE_SYNC_TOPIC}")
    private String monitorPriceSyncTopic;
    @Value(value="${MONITOR_PRICE_SYNC_TAG}")
    private String monitorPriceSyncTag;
    @Resource(name="monitorPriceServiceProvider")
    private ProxyMessageProducer monitorPriceServiceProvider;
    private static final int CATEGORY_CHANGE_TYPE = 8;

    @PostMapping(value={"addCatalog"})
    public UccCatalogAddRspBO addCatalog(@RequestBody UccCatalogAddReqBO reqBO) {
        UccCatalogAddRspBO uccCatalogAddRspBO = this.uccCatalogAddBusiService.addCatalog(reqBO);
        try {
            this.syncCatalogByMq();
        }
        catch (Exception e) {
            log.error("\u524d\u53f0\u7c7b\u76ee\u5168\u91cf\u540c\u6b65\u51fa\u9519\uff1a", (Throwable)e);
        }
        return uccCatalogAddRspBO;
    }

    private void syncCatalogByMq() {
        JSONObject object = new JSONObject();
        object.put("syncType", (Object)8);
        object.put("poolName", (Object)"supermarket");
        log.info("\u63a8\u9001\u524d\u53f0\u7c7b\u76ee\u5168\u91cf\u540c\u6b65\u6d88\u606f\uff1a{}", (Object)JSON.toJSONString((Object)object));
        this.monitorPriceServiceProvider.send(new ProxyMessage(this.monitorPriceSyncTopic, this.monitorPriceSyncTag, JSON.toJSONString((Object)object)));
    }
}

