/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.cache.CacheClient;
import com.tydic.commodity.common.ability.api.UccCommodityTypeCountQryAllService;
import com.tydic.commodity.common.ability.api.UccCommodityTypeCountQryService;
import com.tydic.commodity.common.ability.bo.UccCommodityTypeCountQryAllServiceReqBo;
import com.tydic.commodity.common.ability.bo.UccCommodityTypeCountQryAllServiceRspBo;
import com.tydic.commodity.common.ability.bo.UccCommodityTypeCountQryServiceReqBo;
import com.tydic.commodity.common.ability.bo.UccCommodityTypeCountQryServiceRspBo;
import com.tydic.commodity.common.innserbo.UccSpuListQryAbilityInnerCommodityTypeIdBo;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccCommodityTypeCountQryAllService"})
public class UccCommodityTypeCountQryAllServiceImpl
implements UccCommodityTypeCountQryAllService {
    private static final Logger log = LoggerFactory.getLogger(UccCommodityTypeCountQryAllServiceImpl.class);
    @Autowired
    private UccCommodityTypeCountQryService uccCommodityTypeCountQryService;
    @Autowired
    private CacheClient cacheClient;

    @PostMapping(value={"queryAllCommodityBatchEdit"})
    public UccCommodityTypeCountQryAllServiceRspBo queryAllCommodityBatchEdit(@RequestBody UccCommodityTypeCountQryAllServiceReqBo reqBo) {
        this.validateArg(reqBo);
        UccCommodityTypeCountQryAllServiceRspBo rspBo = new UccCommodityTypeCountQryAllServiceRspBo();
        String cacheDataStr = (String)this.cacheClient.get(reqBo.getRedisCommodityIdCacheKey());
        if (ObjectUtil.isEmpty((Object)cacheDataStr)) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc("\u9875\u9762\u505c\u7559\u8fc7\u4e45\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u91cd\u65b0\u63d0\u4ea4\uff01");
            return rspBo;
        }
        List commodityTypeIdBoList = JSON.parseArray((String)cacheDataStr, UccSpuListQryAbilityInnerCommodityTypeIdBo.class);
        log.info("\u5546\u54c1\u6279\u91cf\u7f16\u8f91\u5546\u54c1\u7c7b\u578b\u7ffb\u9875\u67e5\u8be2redis\u7f13\u5b58\u603b\u6761\u6570\uff1a" + commodityTypeIdBoList.size());
        UccCommodityTypeCountQryServiceReqBo queryCommodityTypeReqBo = new UccCommodityTypeCountQryServiceReqBo();
        BeanUtils.copyProperties((Object)reqBo, (Object)queryCommodityTypeReqBo);
        queryCommodityTypeReqBo.setCommodityIdList(commodityTypeIdBoList.stream().map(UccSpuListQryAbilityInnerCommodityTypeIdBo::getCommodityId).collect(Collectors.toList()));
        queryCommodityTypeReqBo.setNeedReturnCommodityIdList(Boolean.valueOf(false));
        UccCommodityTypeCountQryServiceRspBo queryCommodityTypeRspBo = this.uccCommodityTypeCountQryService.qryCommodityTypeCount(queryCommodityTypeReqBo);
        if (!"0000".equals(queryCommodityTypeRspBo.getRespCode())) {
            rspBo.setRespCode("8888");
            rspBo.setRespDesc(queryCommodityTypeRspBo.getRespDesc());
            return rspBo;
        }
        rspBo = (UccCommodityTypeCountQryAllServiceRspBo)JSON.parseObject((String)JSON.toJSONString((Object)queryCommodityTypeRspBo), UccCommodityTypeCountQryAllServiceRspBo.class);
        rspBo.setDatasCount(Integer.valueOf(commodityTypeIdBoList.size()));
        return rspBo;
    }

    private void validateArg(UccCommodityTypeCountQryAllServiceReqBo reqBo) {
        if (ObjectUtil.isEmpty((Object)reqBo)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtil.isEmpty((Object)reqBo.getRedisCommodityIdCacheKey())) {
            throw new ZTBusinessException("\u5165\u53c2\u5bf9\u8c61[redisCommodityIdCacheKey]\u4e0d\u80fd\u4e3a\u7a7a");
        }
    }
}

