/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.common.ability.api.UccEcomPriceChangeNotificationAbilityService;
import com.tydic.commodity.common.ability.bo.UccEcomPriceChangeNotificationAbilityReqBo;
import com.tydic.commodity.common.ability.bo.UccEcomPriceChangeNotificationAbilityRspBo;
import com.tydic.commodity.dao.UccPricePreventMapper;
import com.tydic.dyc.authority.service.user.AuthGetUserByRoleAndOrgService;
import com.tydic.dyc.authority.service.user.bo.AuthByRoleAndOrgQryUserInfoBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserByRoleAndOrgReqBo;
import com.tydic.dyc.authority.service.user.bo.AuthGetUserByRoleAndOrgRspBo;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccEcomPriceChangeNotificationAbilityService"})
public class UccEcomPriceChangeNotificationAbilityServiceImpl
implements UccEcomPriceChangeNotificationAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccEcomPriceChangeNotificationAbilityServiceImpl.class);
    @Autowired
    private UccPricePreventMapper uccPricePreventMapper;
    @Autowired
    private AuthGetUserByRoleAndOrgService selectUserByRoleAndOrgWebService;
    @Value(value="${priceChangeDownShelfNotification.defaultDate:16:00}")
    private String defaultDate;
    @Value(value="${priceChangeDownShelfNotification.defaultTaskCode:ucc_price_change_notification}")
    private String defaultTaskCode;
    @Value(value="#{'${priceChangeDownShelfNotification.defaultRoles:business:null:jiaoxingyunyingshangpinguanliyuan}'.split(',')}")
    private List<String> defaultRoles;
    @Value(value="${UCC_SEND_MESSAGE_AND_NOTE_URL}")
    private String UCC_SEND_MESSAGE_AND_NOTE_URL;

    @PostMapping(value={"priceChangeDownShelfNotification"})
    public UccEcomPriceChangeNotificationAbilityRspBo priceChangeDownShelfNotification(@RequestBody UccEcomPriceChangeNotificationAbilityReqBo reqBo) {
        List<AuthByRoleAndOrgQryUserInfoBo> recipientList;
        long startTime = this.getStartTime();
        long twentyFourHoursAgo = startTime - 86400000L;
        int count = this.uccPricePreventMapper.qryTimeRange(DateUtil.formatDateTime((Date)DateUtil.date((long)twentyFourHoursAgo)), DateUtil.formatDateTime((Date)DateUtil.date((long)startTime)));
        if (count > 0 && CollectionUtils.isNotEmpty(recipientList = this.getRecipient())) {
            String noticeCenterReqParam = this.buildParam(count, recipientList);
            this.callNotice(noticeCenterReqParam);
        }
        UccEcomPriceChangeNotificationAbilityRspBo rspBo = new UccEcomPriceChangeNotificationAbilityRspBo();
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private void callNotice(String noticeCenterReqParam) {
        log.info("\u7535\u5546\u4ef7\u683c\u53d8\u52a8\u89e6\u53d1\u4e0b\u67b6\u901a\u77e5\uff0c\u8c03\u7528\u67e5\u8be2\u4e2d\u5fc3\u5165\u53c2\uff1a{}", (Object)noticeCenterReqParam);
        String rspStr = HttpUtil.post((String)this.UCC_SEND_MESSAGE_AND_NOTE_URL, (String)noticeCenterReqParam);
        JSONObject parse = JSON.parseObject((String)rspStr);
        log.info("\u7535\u5546\u4ef7\u683c\u53d8\u52a8\u89e6\u53d1\u4e0b\u67b6\u901a\u77e5\uff0c\u8c03\u7528\u67e5\u8be2\u4e2d\u5fc3\u51fa\u53c2\uff1a{}", (Object)parse.toJSONString());
        if (!"0000".equals(parse.getString("respCode"))) {
            log.error("\u7535\u5546\u4ef7\u683c\u53d8\u52a8\u89e6\u53d1\u4e0b\u67b6\u901a\u77e5\uff0c\u8c03\u7528\u67e5\u8be2\u4e2d\u5fc3\u5f02\u5e38\uff1a{}", (Object)parse.getString("respDesc"));
        }
    }

    private String buildParam(int count, List<AuthByRoleAndOrgQryUserInfoBo> recipientList) {
        JSONObject noticeCenterReqParam = new JSONObject();
        noticeCenterReqParam.put("taskCode", (Object)this.defaultTaskCode);
        JSONObject data = new JSONObject();
        data.put("uccPriceChangeDownCount", (Object)count);
        data.put("uccPriceChangeDownTime", (Object)DateUtil.format((Date)DateUtil.date(), (String)"yyyy\u5e74MM\u6708dd\u65e5"));
        noticeCenterReqParam.put("data", (Object)data);
        noticeCenterReqParam.put("sendId", (Object)1);
        noticeCenterReqParam.put("sendName", (Object)"\u7cfb\u7edf\u7ba1\u7406\u5458");
        JSONArray jsonArray = new JSONArray();
        recipientList.forEach(e -> {
            JSONObject receiver = new JSONObject();
            receiver.put("receiverId", (Object)e.getUserId());
            receiver.put("receiverName", (Object)e.getCustName());
            jsonArray.add((Object)receiver);
        });
        noticeCenterReqParam.put("receivers", (Object)jsonArray);
        return noticeCenterReqParam.toJSONString();
    }

    private List<AuthByRoleAndOrgQryUserInfoBo> getRecipient() {
        AuthGetUserByRoleAndOrgReqBo authGetUserByRoleAndOrgReqBo = new AuthGetUserByRoleAndOrgReqBo();
        authGetUserByRoleAndOrgReqBo.setPageNo(-1);
        authGetUserByRoleAndOrgReqBo.setPageSize(-1);
        authGetUserByRoleAndOrgReqBo.setLevelFlag(Integer.valueOf(1));
        authGetUserByRoleAndOrgReqBo.setRoleCodes(this.defaultRoles);
        log.info("\u7535\u5546\u4ef7\u683c\u53d8\u52a8\u89e6\u53d1\u4e0b\u67b6\u901a\u77e5\uff0c\u67e5\u8be2\u5f85\u901a\u77e5\u4eba\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)authGetUserByRoleAndOrgReqBo));
        AuthGetUserByRoleAndOrgRspBo userByRoleAndOrg = this.selectUserByRoleAndOrgWebService.getUserByRoleAndOrg(authGetUserByRoleAndOrgReqBo);
        log.info("\u7535\u5546\u4ef7\u683c\u53d8\u52a8\u89e6\u53d1\u4e0b\u67b6\u901a\u77e5\uff0c\u67e5\u8be2\u5f85\u901a\u77e5\u4eba\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)userByRoleAndOrg));
        if (!"0000".equals(userByRoleAndOrg.getRespCode())) {
            log.error("\u7535\u5546\u4ef7\u683c\u53d8\u52a8\u89e6\u53d1\u4e0b\u67b6\u901a\u77e5\uff0c\u67e5\u8be2\u5f85\u901a\u77e5\u4eba\u5f02\u5e38\uff1a{}", (Object)userByRoleAndOrg.getRespDesc());
        }
        return userByRoleAndOrg.getRows();
    }

    private long getStartTime() {
        long startTime = StringUtils.isNotBlank((CharSequence)this.defaultDate) ? DateUtil.parse((CharSequence)this.defaultDate).getTime() : System.currentTimeMillis();
        return startTime;
    }
}

