/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.ohaotian.plugin.db.Page;
import com.tydic.commodity.common.ability.api.UccQryGuideCatalogRelCatalogAbilityService;
import com.tydic.commodity.common.ability.bo.UccMdmCatalogsearchBO;
import com.tydic.commodity.common.ability.bo.UccQryGuideCatalogRelCatalogAbilityReqBO;
import com.tydic.commodity.common.ability.bo.UccQryGuideCatalogRelCatalogAbilityRspBO;
import com.tydic.commodity.common.atom.api.UccDictionaryAtomService;
import com.tydic.commodity.dao.UccCatRCommdTypeMapper;
import com.tydic.commodity.dao.UccCommodityTypeMapper;
import com.tydic.commodity.dao.UccEMdmCatalogMapper;
import com.tydic.commodity.po.UccCommodityTypePo;
import com.tydic.commodity.po.UccEMdmCatalogPO;
import com.tydic.dyc.base.exception.BaseBusinessException;
import com.tydic.dyc.base.utils.JUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccQryGuideCatalogRelCatalogAbilityService"})
public class UccQryGuideCatalogRelCatalogAbilityServiceImpl
implements UccQryGuideCatalogRelCatalogAbilityService {
    @Autowired
    private UccCatRCommdTypeMapper uccCatRCommdTypeMapper;
    @Autowired
    private UccCommodityTypeMapper uccCommodityTypeMapper;
    @Autowired
    private UccEMdmCatalogMapper uccEMdmCatalogMapper;
    @Autowired
    private UccDictionaryAtomService uccDictionaryAtomService;

    @PostMapping(value={"qryGuideCatalogRelCatalog"})
    public UccQryGuideCatalogRelCatalogAbilityRspBO qryGuideCatalogRelCatalog(@RequestBody UccQryGuideCatalogRelCatalogAbilityReqBO reqBO) {
        Long commodityTypeId = this.validateParam(reqBO);
        UccQryGuideCatalogRelCatalogAbilityRspBO rspBO = new UccQryGuideCatalogRelCatalogAbilityRspBO();
        if (reqBO.getOperType() == 1) {
            this.relSearch(reqBO, rspBO, commodityTypeId);
        } else if (reqBO.getOperType() == 2) {
            this.notRelSearch(reqBO, rspBO, commodityTypeId);
        } else {
            throw new BaseBusinessException("8888", "\u672a\u77e5\u7684\u67e5\u8be2\u65b9\u5f0f");
        }
        if (!CollectionUtils.isEmpty((Collection)rspBO.getRows())) {
            Map<String, String> freezeFlagMap = this.uccDictionaryAtomService.queryBypCodeBackMap("FREEZR_FLAG");
            for (UccMdmCatalogsearchBO each : rspBO.getRows()) {
                if (each.getFreezeFlag() == null || freezeFlagMap == null || !freezeFlagMap.containsKey(each.getFreezeFlag().toString())) continue;
                each.setFreezeFlagDesc(freezeFlagMap.get(each.getFreezeFlag().toString()));
            }
        }
        rspBO.setCommodityTypeId(commodityTypeId);
        rspBO.setRespCode("0000");
        rspBO.setRespDesc("\u6210\u529f");
        return rspBO;
    }

    private Long validateParam(UccQryGuideCatalogRelCatalogAbilityReqBO reqBO) {
        if (reqBO.getOperType() == null) {
            throw new BaseBusinessException("8888", "\u3010\u67e5\u8be2\u65b9\u5f0f\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (reqBO.getGuideCatalogId() == null) {
            throw new BaseBusinessException("8888", "\u3010\u524d\u53f0\u7c7b\u76eeid\u3011\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List commodityTypeIds = this.uccCatRCommdTypeMapper.qryCommodityTypeIds(reqBO.getGuideCatalogId());
        if (CollectionUtils.isEmpty((Collection)commodityTypeIds)) {
            throw new BaseBusinessException("8888", "\u5185\u7f6e\u914d\u7f6e\u6570\u636e\u51fa\u9519\uff0c\u5546\u54c1\u7c7b\u578b\u5173\u8054\u4e0d\u5b58\u5728");
        }
        HashSet commodityTypeIdSet = new HashSet(commodityTypeIds);
        if (commodityTypeIdSet.size() != 1) {
            throw new BaseBusinessException("8888", "\u5185\u7f6e\u914d\u7f6e\u6570\u636e\u51fa\u9519\uff0c\u524d\u53f0\u7c7b\u76ee\u548c\u5546\u54c1\u7c7b\u578b\u4e0d\u662f1\u5bf91\u5173\u7cfb");
        }
        return (Long)commodityTypeIds.get(0);
    }

    private void relSearch(UccQryGuideCatalogRelCatalogAbilityReqBO reqBO, UccQryGuideCatalogRelCatalogAbilityRspBO rspBO, Long commodityTypeId) {
        List uccCommodityTypePos = this.uccCommodityTypeMapper.batchQryInType(Arrays.asList(commodityTypeId));
        if (CollectionUtils.isEmpty((Collection)uccCommodityTypePos)) {
            throw new BaseBusinessException("8888", "\u5185\u7f6e\u914d\u7f6e\u6570\u636e\u51fa\u9519\uff0c\u5546\u54c1\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        if (((UccCommodityTypePo)uccCommodityTypePos.get(0)).getCatalogId() != null) {
            UccEMdmCatalogPO qryPO = (UccEMdmCatalogPO)JUtil.js((Object)reqBO, UccEMdmCatalogPO.class);
            qryPO.setCatalogId(((UccCommodityTypePo)uccCommodityTypePos.get(0)).getCatalogId());
            Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
            List emdmCatalogDatailPOS = this.uccEMdmCatalogMapper.queryEmdCatalogByPage(qryPO, page);
            if (!CollectionUtils.isEmpty((Collection)emdmCatalogDatailPOS)) {
                rspBO.setRows(JUtil.jsl((List)emdmCatalogDatailPOS, UccMdmCatalogsearchBO.class));
            }
            rspBO.setPageNo(page.getPageNo());
            rspBO.setTotal(page.getTotalPages());
            rspBO.setRecordsTotal(page.getTotalCount());
        } else {
            rspBO.setPageNo(reqBO.getPageNo());
            rspBO.setTotal(1);
            rspBO.setRecordsTotal(0);
        }
    }

    private void notRelSearch(UccQryGuideCatalogRelCatalogAbilityReqBO reqBO, UccQryGuideCatalogRelCatalogAbilityRspBO rspBO, Long commodityTypeId) {
        List uccCommodityTypePos = this.uccCommodityTypeMapper.batchQryInType(Arrays.asList(commodityTypeId));
        if (CollectionUtils.isEmpty((Collection)uccCommodityTypePos)) {
            throw new BaseBusinessException("8888", "\u5185\u7f6e\u914d\u7f6e\u6570\u636e\u51fa\u9519\uff0c\u5546\u54c1\u7c7b\u578b\u4e0d\u5b58\u5728");
        }
        UccEMdmCatalogPO qryPO = (UccEMdmCatalogPO)JUtil.js((Object)reqBO, UccEMdmCatalogPO.class);
        qryPO.setIgnoreRelCatalogFlag(Integer.valueOf(1));
        Page page = new Page(reqBO.getPageNo(), reqBO.getPageSize());
        List emdmCatalogDatailPOS = this.uccEMdmCatalogMapper.queryEmdCatalogByPage(qryPO, page);
        if (!CollectionUtils.isEmpty((Collection)emdmCatalogDatailPOS)) {
            rspBO.setRows(JUtil.jsl((List)emdmCatalogDatailPOS, UccMdmCatalogsearchBO.class));
        }
        rspBO.setPageNo(page.getPageNo());
        rspBO.setTotal(page.getTotalPages());
        rspBO.setRecordsTotal(page.getTotalCount());
    }
}

