/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.commodity.common.ability.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.tydic.commodity.base.constant.ModelRuleConstant;
import com.tydic.commodity.busibase.atom.api.UccBaseDictionaryAtomService;
import com.tydic.commodity.common.ability.api.UccSkuIdListQryAbilityService;
import com.tydic.commodity.common.ability.bo.UccSkuIdListQryAbilityServiceRspBo;
import com.tydic.commodity.common.ability.bo.UccSkuManagementListQryAbilityReqBO;
import com.tydic.commodity.config.ElasticsearchUtil;
import com.tydic.commodity.config.EsConfig;
import com.tydic.commodity.dao.EacRuTaskMapper;
import com.tydic.commodity.dao.UccAssignCodeMapper;
import com.tydic.commodity.dao.UccEMdmMaterialMapper;
import com.tydic.commodity.dao.UccLadderPriceMapper;
import com.tydic.commodity.dao.UccSkuExpandMapper;
import com.tydic.commodity.dao.UccSkuMapper;
import com.tydic.commodity.dao.UccSkuPriceMapper;
import com.tydic.commodity.dao.UccSkuStandardRelationMapper;
import com.tydic.commodity.utils.MoneyUtils;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.elasticsearch.index.query.WildcardQueryBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilders;
import org.elasticsearch.search.sort.SortOrder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"UCC_GROUP_DEV/2.0.0/com.tydic.commodity.common.ability.api.UccSkuIdListQryAbilityService"})
public class UccSkuIdListQryAbilityServiceImpl
implements UccSkuIdListQryAbilityService {
    private static final Logger log = LoggerFactory.getLogger(UccSkuIdListQryAbilityServiceImpl.class);
    @Autowired
    private EsConfig esConfig;
    @Autowired
    private ElasticsearchUtil elasticsearchUtil;
    @Autowired
    private UccBaseDictionaryAtomService uccDictionaryAtomService;
    @Autowired
    private UccSkuPriceMapper uccSkuPriceMapper;
    @Autowired
    private UccLadderPriceMapper uccLadderPriceMapper;
    @Autowired
    private EacRuTaskMapper eacRuTaskMapper;
    @Autowired
    private UccSkuExpandMapper uccSkuExpandMapper;
    @Autowired
    private UccAssignCodeMapper uccAssignCodeMapper;
    @Autowired
    private UccEMdmMaterialMapper uccEMdmMaterialMapper;
    private Long userId;
    @Autowired
    private UccSkuMapper uccSkuMapper;
    @Autowired
    private UccSkuStandardRelationMapper uccSkuStandardRelationMapper;

    @PostMapping(value={"getSkuManagementListQry"})
    public UccSkuIdListQryAbilityServiceRspBo getSkuManagementListQry(@RequestBody UccSkuManagementListQryAbilityReqBO reqBO) {
        String result;
        String queryString;
        BoolQueryBuilder extBoolQueryBuilder;
        this.userId = reqBO.getUserId();
        UccSkuIdListQryAbilityServiceRspBo rspBo = new UccSkuIdListQryAbilityServiceRspBo();
        if (!StringUtils.isEmpty((Object)reqBO.getStdSkuId())) {
            reqBO.setSkuType(Integer.valueOf(0));
            extBoolQueryBuilder = this.buildEsSql(reqBO);
            queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder);
            result = this.searchInfo(queryString);
            if (!StringUtils.isEmpty((Object)result)) {
                JSONObject resultObj = JSONObject.parseObject((String)result);
                JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
                JSONArray listObject = hitsObj.getJSONArray("hits");
                ArrayList<Long> skuIds = new ArrayList<Long>();
                if (!listObject.isEmpty()) {
                    for (int i = 0; i < listObject.size(); ++i) {
                        JSONObject hitObj = listObject.getJSONObject(i);
                        JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                        skuIds.add(data.getLong("sku_id"));
                    }
                }
                rspBo.setSkuIds(skuIds);
                rspBo.setRespCode("0000");
                rspBo.setRespDesc("\u6210\u529f");
                return rspBo;
            }
        }
        if (StringUtils.isEmpty((Object)(result = this.searchInfo(queryString = this.excuteEsSql(reqBO, extBoolQueryBuilder = this.buildEsSql(reqBO)))))) {
            rspBo.setRespCode("0000");
            return rspBo;
        }
        rspBo = this.dealSearchData(result, reqBO);
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    private UccSkuIdListQryAbilityServiceRspBo dealSearchData(String result, UccSkuManagementListQryAbilityReqBO reqBo) {
        UccSkuIdListQryAbilityServiceRspBo rspBo = new UccSkuIdListQryAbilityServiceRspBo();
        JSONObject resultObj = JSONObject.parseObject((String)result);
        JSONObject hitsObj = (JSONObject)resultObj.get((Object)"hits");
        JSONArray listObject = hitsObj.getJSONArray("hits");
        ArrayList<Long> skuIds = new ArrayList<Long>();
        if (listObject.size() > 0) {
            for (int i = 0; i < listObject.size(); ++i) {
                JSONObject hitObj = listObject.getJSONObject(i);
                JSONObject data = (JSONObject)hitObj.get((Object)"_source");
                skuIds.add(data.getLong("sku_id"));
            }
        }
        rspBo.setSkuIds(skuIds);
        return rspBo;
    }

    private String searchInfo(String queryString) {
        String endPoint = "/" + this.esConfig.getIndexName() + "/" + this.esConfig.getEsType() + "/_search";
        log.info("source---->" + queryString);
        NStringEntity entity = new NStringEntity(queryString, ContentType.APPLICATION_JSON);
        Request request = new Request("POST", endPoint);
        request.setEntity((HttpEntity)entity);
        try {
            Response response = this.elasticsearchUtil.performRequest(request);
            String result = EntityUtils.toString((HttpEntity)response.getEntity());
            if (log.isDebugEnabled()) {
                log.debug("result---->" + result);
            }
            return result;
        }
        catch (IOException e) {
            log.error("ioException", (Throwable)e);
            return null;
        }
    }

    private String excuteEsSql(UccSkuManagementListQryAbilityReqBO reqBo, BoolQueryBuilder extBoolQueryBuilder) {
        JSONObject queryJson = new JSONObject();
        queryJson.put("_source", (Object)"sku_id");
        queryJson.put("track_total_hits", (Object)true);
        queryJson.put("size", (Object)reqBo.getPageSize());
        queryJson.put("from", (Object)(reqBo.getPageSize() * (reqBo.getPageNo() - 1)));
        String queryString = null;
        queryString = extBoolQueryBuilder.toString();
        queryJson.put("query", (Object)JSON.parseObject((String)queryString));
        SortOrder orderType = SortOrder.DESC;
        if (reqBo.getOrderType() != null && reqBo.getOrderType() == 1) {
            orderType = SortOrder.ASC;
        }
        String sortField = "";
        if (reqBo.getOrderByColumn() != null) {
            if (reqBo.getOrderByColumn() == 0) {
                sortField = "create_time";
            } else if (reqBo.getOrderByColumn() == 1) {
                sortField = "sold_number";
            } else if (reqBo.getOrderByColumn() == 2) {
                sortField = "on_shelve_time";
            } else if (reqBo.getOrderByColumn() == 3) {
                sortField = "sale_price";
            } else if (reqBo.getOrderByColumn() == 4) {
                sortField = "discounts";
            } else if (reqBo.getOrderByColumn() == 5) {
                sortField = "comment_number";
            }
        }
        if (!StringUtils.isEmpty((Object)sortField)) {
            FieldSortBuilder sortQuery = (FieldSortBuilder)SortBuilders.fieldSort((String)sortField).order(orderType);
            queryJson.put("sort", (Object)JSONObject.parseObject((String)sortQuery.toString()));
        }
        return queryJson.toString();
    }

    private BoolQueryBuilder buildEsSql(UccSkuManagementListQryAbilityReqBO reqBo) {
        WildcardQueryBuilder wildcardQuery;
        List<Integer> allApprovedStatus;
        BoolQueryBuilder boolQueryBuilder = QueryBuilders.boolQuery();
        if (StringUtils.isEmpty((Object)reqBo.getSkuType())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_type", (int)0));
        } else {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_type", (Object)reqBo.getSkuType()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOoocClean())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"oooc_clean", (Object)reqBo.getOoocClean()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getPricePassFlag())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"price_pass_flag", (Object)reqBo.getPricePassFlag()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getExportSkuIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_id", (Collection)reqBo.getExportSkuIds()));
        }
        if (reqBo.getSkuSource() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_source", (Object)reqBo.getSkuSource()));
        }
        if (reqBo.getSourceAssort() != null) {
            // empty if block
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getApprovalStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_approval_status", (Collection)reqBo.getApprovalStatus()));
        }
        if (reqBo.getBrandId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"brand_id", (Object)reqBo.getBrandId()));
        }
        if (reqBo.getVendorId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"vendor_id", (Object)reqBo.getVendorId()));
        }
        if (reqBo.getSupplierId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_id", (Object)reqBo.getSupplierId()));
        }
        if (reqBo.getSkuId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"sku_id", (Object)reqBo.getSkuId()));
        }
        if (reqBo.getCommodityId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"commodity_id", (Object)reqBo.getCommodityId()));
        }
        if (reqBo.getL4mgCategoryId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"l4mg_category_id", (Object)reqBo.getL4mgCategoryId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCreateOperId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"create_oper_id", (String)reqBo.getCreateOperId()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSupplierOrgId())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_org_id", (String)reqBo.getSupplierOrgId()));
        }
        if (reqBo.getSupplierShopId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"supplier_shop_id", (Object)reqBo.getSupplierShopId()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getApprovalStatus()) && (allApprovedStatus = Arrays.asList(ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_PUSH_PASS, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_PUSH_REJECT, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_SHELF_OVER, ModelRuleConstant.SKU_STATUS_WAIT_SHELF_ING, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_PASS, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_EDIT_REJECT, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_OVER, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_DOWN_REJECT, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_OVER, ModelRuleConstant.UCC_SKU_APPROVAL_STATUS_RECOVER_REJECT)).containsAll(reqBo.getApprovalStatus()) && null != reqBo.getUserId() && null != reqBo.getObjType()) {
            ArrayList<String> approvedQry = new ArrayList<String>();
            String approvedQryStrPass = reqBo.getUserId() + "_" + reqBo.getObjType() + "_0";
            String approvedQryStrRefuse = reqBo.getUserId() + "_" + reqBo.getObjType() + "_1";
            if (StringUtils.isEmpty((Object)reqBo.getAuditResult())) {
                approvedQry.add(approvedQryStrPass);
                approvedQry.add(approvedQryStrRefuse);
            } else if ("0".equals(reqBo.getAuditResult())) {
                approvedQry.add(approvedQryStrPass);
            } else if ("1".equals(reqBo.getAuditResult())) {
                approvedQry.add(approvedQryStrRefuse);
            }
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"approvedInfoStr", approvedQry));
            reqBo.setOperIds(null);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getOperIds())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"operIds", (Collection)reqBo.getOperIds()));
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSkuStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"sku_status", (Collection)reqBo.getSkuStatus()));
        }
        ArrayList proNotExtOrgIdList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getProNotExtendOrgIds())) {
            proNotExtOrgIdList.addAll(reqBo.getProNotExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getPurNotExtendOrgIds())) {
            proNotExtOrgIdList.addAll(reqBo.getPurNotExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSupNotExtendOrgIds())) {
            proNotExtOrgIdList.addAll(reqBo.getSupNotExtendOrgIds());
        }
        ArrayList extOrgIdList = new ArrayList();
        if (!CollectionUtils.isEmpty((Collection)reqBo.getProExtendOrgIds())) {
            extOrgIdList.addAll(reqBo.getProExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getPurExtendOrgIds())) {
            extOrgIdList.addAll(reqBo.getPurExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getSupExtendOrgIds())) {
            extOrgIdList.addAll(reqBo.getSupExtendOrgIds());
        }
        if (!CollectionUtils.isEmpty(proNotExtOrgIdList) || !CollectionUtils.isEmpty(extOrgIdList)) {
            BoolQueryBuilder orgQueryBuilder = QueryBuilders.boolQuery();
            if (!CollectionUtils.isEmpty(proNotExtOrgIdList)) {
                List collect = proNotExtOrgIdList.stream().distinct().collect(Collectors.toList());
                orgQueryBuilder.should((QueryBuilder)QueryBuilders.termsQuery((String)"supplier_org_id", collect));
            }
            if (!CollectionUtils.isEmpty(extOrgIdList)) {
                List extOrgIds = extOrgIdList.stream().distinct().collect(Collectors.toList());
                for (Long extOrgId : extOrgIds) {
                    orgQueryBuilder.should((QueryBuilder)QueryBuilders.wildcardQuery((String)"supplier_org_path.keyword", (String)("*" + extOrgId + "*")));
                }
            }
            boolQueryBuilder.must((QueryBuilder)orgQueryBuilder);
        }
        if (!CollectionUtils.isEmpty((Collection)reqBo.getCommodityStatus())) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"commodity_status", (Collection)reqBo.getCommodityStatus()));
        }
        if (reqBo.getAgreementId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_id", (Object)reqBo.getAgreementId()));
        }
        if (reqBo.getAgreementDetailsId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"agreement_details_id", (Object)reqBo.getAgreementDetailsId()));
        }
        if (reqBo.getStdSkuStatus() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"std_sku_status", (Object)reqBo.getStdSkuStatus()));
        }
        if (reqBo.getCreateType() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"create_type", (Object)reqBo.getCreateType()));
        }
        if (reqBo.getStdSkuId() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"std_sku_id", (Object)reqBo.getStdSkuId()));
        }
        if (reqBo.getBindStatus() != null) {
            boolQueryBuilder.must((QueryBuilder)QueryBuilders.termQuery((String)"bind_status", (Object)reqBo.getBindStatus()));
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSpuId())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"ext_spu_id.keyword", (String)("*" + reqBo.getExtSpuId() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getApplyNo())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"apply_no.keyword", (String)("*" + reqBo.getApplyNo() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getStdSkuCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"std_sku_code.keyword", (String)("*" + reqBo.getStdSkuCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getExtSkuId())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"ext_sku_id.keyword", (String)("*" + reqBo.getExtSkuId() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getBrandName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"brand_name.keyword", (String)("*" + reqBo.getBrandName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_name.keyword", (String)("*" + reqBo.getCommodityName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityExpand1())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_expand1.keyword", (String)("*" + reqBo.getCommodityExpand1() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getVendorName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"vendor_name.keyword", (String)("*" + reqBo.getVendorName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_name.keyword", (String)("*" + reqBo.getSkuName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialCode())) {
            if (reqBo.getIsMaterCode() != null) {
                if (reqBo.getIsMaterCode() == 1) {
                    boolQueryBuilder.must((QueryBuilder)QueryBuilders.termsQuery((String)"material_code.keyword", (String[])new String[]{reqBo.getMaterialCode()}));
                }
            } else {
                wildcardQuery = QueryBuilders.wildcardQuery((String)"material_code.keyword", (String)("*" + reqBo.getMaterialCode() + "*"));
                boolQueryBuilder.must((QueryBuilder)wildcardQuery);
            }
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_name.keyword", (String)("*" + reqBo.getOtherSourceName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getModel())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"model.keyword", (String)("*" + reqBo.getModel() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSpec())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"spec.keyword", (String)("*" + reqBo.getSpec() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMaterialName())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"material_name.keyword", (String)("*" + reqBo.getMaterialName() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getCommodityCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"commodity_code.keyword", (String)("*" + reqBo.getCommodityCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSkuCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"sku_code.keyword", (String)("*" + reqBo.getSkuCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getOtherSourceCode())) {
            wildcardQuery = QueryBuilders.wildcardQuery((String)"other_source_code.keyword", (String)("*" + reqBo.getOtherSourceCode() + "*"));
            boolQueryBuilder.must((QueryBuilder)wildcardQuery);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDiscountStar())) {
            RangeQueryBuilder discountQbStar = QueryBuilders.rangeQuery((String)"discount").gte((Object)reqBo.getDiscountStar());
            boolQueryBuilder.must((QueryBuilder)discountQbStar);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getDiscountEnd())) {
            RangeQueryBuilder discountQbEnd = QueryBuilders.rangeQuery((String)"discount").lte((Object)reqBo.getDiscountEnd());
            boolQueryBuilder.must((QueryBuilder)discountQbEnd);
        }
        RangeQueryBuilder maerketQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getMarketPriceStar())) {
            maerketQb = QueryBuilders.rangeQuery((String)"market_price").gte((Object)MoneyUtils.yuanToHaoToLong((BigDecimal)reqBo.getMarketPriceStar()));
            boolQueryBuilder.must((QueryBuilder)maerketQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getMarketPriceEnd())) {
            maerketQb = QueryBuilders.rangeQuery((String)"market_price").lte((Object)MoneyUtils.yuanToHaoToLong((BigDecimal)reqBo.getMarketPriceEnd()));
            boolQueryBuilder.must((QueryBuilder)maerketQb);
        }
        RangeQueryBuilder saleQb = null;
        if (!StringUtils.isEmpty((Object)reqBo.getSalePriceStar())) {
            saleQb = QueryBuilders.rangeQuery((String)"sale_price").gte((Object)MoneyUtils.yuanToHaoToLong((BigDecimal)reqBo.getSalePriceStar()));
            boolQueryBuilder.must((QueryBuilder)saleQb);
        }
        if (!StringUtils.isEmpty((Object)reqBo.getSalePriceEnd())) {
            saleQb = QueryBuilders.rangeQuery((String)"sale_price").lte((Object)MoneyUtils.yuanToHaoToLong((BigDecimal)reqBo.getSalePriceEnd()));
            boolQueryBuilder.must((QueryBuilder)saleQb);
        }
        log.debug("\u67e5\u8be2\u6761\u4ef6" + boolQueryBuilder.toString());
        return boolQueryBuilder;
    }
}

